/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;

public class ConnectionPoolAndLoaderDUnitTest
extends CacheTestCase {
    private static int bridgeServerPort;
    protected boolean useLocator;

    public ConnectionPoolAndLoaderDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() {
        ConnectionPoolAndLoaderDUnitTest.disconnectAllFromDS();
    }

    public void testPoolAndLoader() {
        final String regionName = this.getName();
        final Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        final int serverPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(server);
        server.invoke(new SerializableCallable(){

            public Object call() throws IOException {
                Cache cache = ConnectionPoolAndLoaderDUnitTest.this.getCache();
                AttributesFactory af = new AttributesFactory();
                RegionAttributes attrs = af.create();
                cache.createRegion(regionName, attrs);
                ConnectionPoolAndLoaderDUnitTest.this.startBridgeServer(serverPort, true);
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() {
                Cache cache = ConnectionPoolAndLoaderDUnitTest.this.getCache();
                PoolFactory factory = PoolManager.createFactory();
                factory.addServer(DistributedTestCase.getServerHostName(host), serverPort);
                factory.create("pool1");
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.DEFAULT);
                af.setScope(Scope.LOCAL);
                af.setPoolName("pool1");
                af.setCacheLoader((CacheLoader)new MyCacheLoader("loaded"));
                RegionAttributes attrs = af.create();
                cache.createRegion(regionName, attrs);
                return null;
            }
        });
        client.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = ConnectionPoolAndLoaderDUnitTest.this.getRootRegion(regionName);
                region.put((Object)"a", (Object)"put-a");
                region.put((Object)"b", (Object)"put-b");
                Assert.assertEquals((Object)"loaded-c", (Object)region.get((Object)"c"));
                Assert.assertEquals((Object)"loaded-d", (Object)region.get((Object)"d"));
            }
        });
        server.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = ConnectionPoolAndLoaderDUnitTest.this.getRootRegion(regionName);
                Assert.assertEquals((Object)"put-a", (Object)region.get((Object)"a"));
                Assert.assertEquals((Object)"put-b", (Object)region.get((Object)"b"));
                Assert.assertEquals((Object)"loaded-c", (Object)region.get((Object)"c"));
                Assert.assertEquals((Object)"loaded-d", (Object)region.get((Object)"d"));
                region.put((Object)"e", (Object)"server-e");
            }
        });
        client.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = ConnectionPoolAndLoaderDUnitTest.this.getRootRegion(regionName);
                Assert.assertEquals((Object)"put-a", (Object)region.get((Object)"a"));
                Assert.assertEquals((Object)"put-b", (Object)region.get((Object)"b"));
                Assert.assertEquals((Object)"loaded-c", (Object)region.get((Object)"c"));
                Assert.assertEquals((Object)"loaded-d", (Object)region.get((Object)"d"));
                Assert.assertEquals((Object)"server-e", (Object)region.get((Object)"e"));
            }
        });
    }

    public void testPoolAndWriter() {
        final String regionName = this.getName();
        final Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        final int serverPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(server);
        server.invoke(new SerializableCallable(){

            public Object call() throws IOException {
                Cache cache = ConnectionPoolAndLoaderDUnitTest.this.getCache();
                AttributesFactory af = new AttributesFactory();
                RegionAttributes attrs = af.create();
                cache.createRegion(regionName, attrs);
                ConnectionPoolAndLoaderDUnitTest.this.startBridgeServer(serverPort, true);
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() {
                Cache cache = ConnectionPoolAndLoaderDUnitTest.this.getCache();
                PoolFactory factory = PoolManager.createFactory();
                factory.addServer(DistributedTestCase.getServerHostName(host), serverPort);
                factory.create("pool1");
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.DEFAULT);
                af.setScope(Scope.LOCAL);
                af.setPoolName("pool1");
                af.setCacheWriter((CacheWriter)new MyCacheWriter());
                RegionAttributes attrs = af.create();
                cache.createRegion(regionName, attrs);
                return null;
            }
        });
        client.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = ConnectionPoolAndLoaderDUnitTest.this.getRootRegion(regionName);
                MyCacheWriter writer = (MyCacheWriter)region.getAttributes().getCacheWriter();
                region.put((Object)"a", (Object)"a");
                region.put((Object)"b", (Object)"b");
                region.put((Object)"c", (Object)"c");
                region.destroy((Object)"c");
                writer.throwException = true;
                try {
                    region.put((Object)"a", (Object)"new-a");
                    TestCase.fail((String)"Should have gotten a cache writer exception");
                }
                catch (CacheWriterException e) {
                    Assert.assertEquals((String)"beforeUpdate", (String)e.getMessage());
                }
                try {
                    region.destroy((Object)"b");
                    TestCase.fail((String)"Should have gotten a cache writer exception");
                }
                catch (CacheWriterException e) {
                    Assert.assertEquals((String)"beforeDestroy", (String)e.getMessage());
                }
                try {
                    region.put((Object)"d", (Object)"d");
                    TestCase.fail((String)"Should have gotten a cache writer exception");
                }
                catch (CacheWriterException e) {
                    Assert.assertEquals((String)"beforeCreate", (String)e.getMessage());
                }
                try {
                    region.clear();
                    TestCase.fail((String)"Should have gotten a cache writer exception");
                }
                catch (CacheWriterException e) {
                    Assert.assertEquals((String)"beforeRegionClear", (String)e.getMessage());
                }
                try {
                    region.destroyRegion();
                    TestCase.fail((String)"Should have gotten a cache writer exception");
                }
                catch (CacheWriterException e) {
                    Assert.assertEquals((String)"beforeRegionDestroy", (String)e.getMessage());
                }
            }
        });
        server.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = ConnectionPoolAndLoaderDUnitTest.this.getRootRegion(regionName);
                Assert.assertEquals((Object)"a", (Object)region.get((Object)"a"));
                Assert.assertEquals((Object)"b", (Object)region.get((Object)"b"));
                Assert.assertEquals(null, (Object)region.get((Object)"c"));
                Assert.assertEquals(null, (Object)region.get((Object)"d"));
            }
        });
    }

    public void testPoolLoadAndPeer() {
        final String regionName = this.getName();
        final Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client1 = host.getVM(1);
        VM client2 = host.getVM(2);
        final int serverPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(server);
        server.invoke(new SerializableCallable(){

            public Object call() throws IOException {
                Cache cache = ConnectionPoolAndLoaderDUnitTest.this.getCache();
                AttributesFactory af = new AttributesFactory();
                RegionAttributes attrs = af.create();
                cache.createRegion(regionName, attrs);
                ConnectionPoolAndLoaderDUnitTest.this.startBridgeServer(serverPort, true);
                return null;
            }
        });
        SerializableCallable createClient1 = new SerializableCallable(){

            public Object call() {
                ConnectionPoolAndLoaderDUnitTest.this.useLocator = true;
                Cache cache = ConnectionPoolAndLoaderDUnitTest.this.getCache();
                ConnectionPoolAndLoaderDUnitTest.this.useLocator = false;
                PoolFactory factory = PoolManager.createFactory();
                factory.addServer(DistributedTestCase.getServerHostName(host), serverPort);
                factory.create("pool1");
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.NORMAL);
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setPoolName("pool1");
                af.setCacheLoader((CacheLoader)new MyCacheLoader("loaded1"));
                RegionAttributes attrs = af.create();
                cache.createRegion(regionName, attrs);
                return null;
            }
        };
        client1.invoke(createClient1);
        SerializableCallable createClient2 = new SerializableCallable(){

            public Object call() {
                ConnectionPoolAndLoaderDUnitTest.this.useLocator = true;
                Cache cache = ConnectionPoolAndLoaderDUnitTest.this.getCache();
                ConnectionPoolAndLoaderDUnitTest.this.useLocator = false;
                PoolFactory factory = PoolManager.createFactory();
                factory.addServer(DistributedTestCase.getServerHostName(host), serverPort);
                factory.create("pool1");
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.NORMAL);
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setCacheLoader((CacheLoader)new MyCacheLoader("loaded2"));
                af.setPoolName("pool1");
                RegionAttributes attrs = af.create();
                cache.createRegion(regionName, attrs);
                return null;
            }
        };
        client2.invoke(createClient2);
        client1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = ConnectionPoolAndLoaderDUnitTest.this.getRootRegion(regionName);
                region.put((Object)"b", (Object)"client1-b");
                region.put((Object)"c", (Object)"client1-c");
                region.put((Object)"e", (Object)"client1-e");
                region.put((Object)"f", (Object)"client1-f");
            }
        });
        client2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = ConnectionPoolAndLoaderDUnitTest.this.getRootRegion(regionName);
                Assert.assertEquals((Object)"client1-c", (Object)region.get((Object)"c"));
                region.put((Object)"d", (Object)"client2-d");
                Assert.assertEquals((Object)"client1-f", (Object)region.get((Object)"f"));
                region.put((Object)"g", (Object)"client2-g");
            }
        });
        server.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = ConnectionPoolAndLoaderDUnitTest.this.getRootRegion(regionName);
                region.put((Object)"a", (Object)"server-a");
                region.localDestroy((Object)"e");
                region.localDestroy((Object)"f");
                region.localDestroy((Object)"g");
            }
        });
        client1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = ConnectionPoolAndLoaderDUnitTest.this.getRootRegion(regionName);
                Assert.assertEquals((Object)"server-a", (Object)region.get((Object)"a"));
                Assert.assertEquals((Object)"client1-b", (Object)region.get((Object)"b"));
                Assert.assertEquals((Object)"client1-c", (Object)region.get((Object)"c"));
                Assert.assertEquals((Object)"client2-d", (Object)region.get((Object)"d"));
                Assert.assertEquals((Object)"client1-e", (Object)region.get((Object)"e"));
                Assert.assertEquals((Object)"client1-f", (Object)region.get((Object)"f"));
                Assert.assertEquals((Object)"client2-g", (Object)region.get((Object)"g"));
                Assert.assertEquals((Object)"loaded1-h", (Object)region.get((Object)"h"));
            }
        });
        server.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = ConnectionPoolAndLoaderDUnitTest.this.getRootRegion(regionName);
                Assert.assertEquals((Object)"server-a", (Object)region.get((Object)"a"));
                Assert.assertEquals((Object)"client1-b", (Object)region.get((Object)"b"));
                Assert.assertEquals((Object)"client1-c", (Object)region.get((Object)"c"));
                Assert.assertEquals((Object)"client2-d", (Object)region.get((Object)"d"));
                Assert.assertEquals(null, (Object)region.get((Object)"e"));
                Assert.assertEquals(null, (Object)region.get((Object)"f"));
                Assert.assertEquals(null, (Object)region.get((Object)"g"));
                Assert.assertEquals((Object)"loaded1-h", (Object)region.get((Object)"h"));
            }
        });
    }

    protected void startBridgeServer(int port, boolean notifyBySubscription) throws IOException {
        Cache cache = this.getCache();
        BridgeServer bridge = cache.addBridgeServer();
        bridge.setPort(port);
        bridge.setNotifyBySubscription(notifyBySubscription);
        bridge.start();
        bridgeServerPort = bridge.getPort();
    }

    @Override
    public Properties getDistributedSystemProperties() {
        Properties p = new Properties();
        if (!this.useLocator) {
            p.setProperty("locators", "");
            p.setProperty("mcast-port", "0");
        }
        return p;
    }

    public static class MyCacheLoader
    implements CacheLoader {
        private String message;

        public MyCacheLoader(String message) {
            this.message = message;
        }

        public Object load(LoaderHelper helper) throws CacheLoaderException {
            if (helper.getRegion().getAttributes().getScope().equals(Scope.DISTRIBUTED_ACK)) {
                System.err.println("Doing a net search for " + helper.getKey());
                Object result = helper.netSearch(false);
                System.err.println("Net search found " + result);
                if (result != null) {
                    return result;
                }
            }
            Object key = helper.getKey();
            return this.message + "-" + key;
        }

        public void close() {
        }
    }

    public static class MyCacheWriter
    extends CacheWriterAdapter {
        protected boolean throwException = false;

        public void beforeCreate(EntryEvent event) throws CacheWriterException {
            if (this.throwException) {
                throw new CacheWriterException("beforeCreate");
            }
        }

        public void beforeDestroy(EntryEvent event) throws CacheWriterException {
            if (this.throwException) {
                throw new CacheWriterException("beforeDestroy");
            }
        }

        public void beforeRegionClear(RegionEvent event) throws CacheWriterException {
            if (this.throwException) {
                throw new CacheWriterException("beforeRegionClear");
            }
        }

        public void beforeRegionDestroy(RegionEvent event) throws CacheWriterException {
            if (this.throwException) {
                throw new CacheWriterException("beforeRegionDestroy");
            }
        }

        public void beforeUpdate(EntryEvent event) throws CacheWriterException {
            if (this.throwException) {
                throw new CacheWriterException("beforeUpdate");
            }
        }
    }
}

