/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache;

import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.ServerRegionProxy;
import com.gemstone.gemfire.cache.util.BridgeWriter;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import hydra.PoolHelper;
import hydra.RegionDescription;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class ClientHelper {
    public static PoolImpl getPool(Region region) {
        ServerRegionProxy proxy = ((LocalRegion)region).getServerProxy();
        if (proxy == null) {
            return null;
        }
        return (PoolImpl)proxy.getPool();
    }

    public static Set getActiveServers(Region region) {
        return new HashSet(ClientHelper.getPool(region).getCurrentServers());
    }

    private ClientHelper() {
    }

    public static int getRetryInterval(Region region) {
        return (int)ClientHelper.getPool(region).getPingInterval();
    }

    public static void release(Region region) {
        PoolImpl pool = ClientHelper.getPool(region);
        if (pool != null) {
            pool.releaseThreadLocalConnection();
        }
    }

    public static DynamicRegionFactory.Config getDynamicRegionConfig(File diskDir, RegionDescription regionDescription, boolean persistBackup, boolean registerInterest) {
        if (regionDescription.getPoolDescription() != null) {
            String poolName = regionDescription.getPoolDescription().getName();
            PoolHelper.createPool(poolName);
            return new DynamicRegionFactory.Config(diskDir, poolName, persistBackup, registerInterest);
        }
        BridgeWriter writer = (BridgeWriter)regionDescription.getCacheWriterInstance(true);
        return new DynamicRegionFactory.Config(diskDir, writer, persistBackup, registerInterest);
    }
}

