/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.admin.ManagedEntityConfig;
import com.gemstone.gemfire.admin.jmx.JMXAdminImpl;
import com.gemstone.gemfire.internal.Assert;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public abstract class JMXManagedEntityConfig
extends JMXAdminImpl
implements ManagedEntityConfig {
    protected JMXManagedEntityConfig(MBeanServerConnection mbs, ObjectName objectName) {
        super(mbs, objectName);
        Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
    }

    protected RuntimeException handleException(Exception ex) {
        for (Throwable thr = ex; thr != null; thr = thr.getCause()) {
            if (thr instanceof MBeanException || !(thr instanceof RuntimeException)) continue;
            return (RuntimeException)thr;
        }
        String s = "While invoking a JMX operation";
        return new InternalGemFireException(s, (Throwable)ex);
    }

    public String getHost() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "host");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public void setHost(String host) {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("host", host));
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public String getWorkingDirectory() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "workingDirectory");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public void setWorkingDirectory(String dir) {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("workingDirectory", dir));
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public String getProductDirectory() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "productDirectory");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public void setProductDirectory(String dir) {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("productDirectory", dir));
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public String getRemoteCommand() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "remoteCommand");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public void setRemoteCommand(String remoteCommand) {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("remoteCommand", remoteCommand));
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public void validate() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Object clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

