/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin;

import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberBridgeServer;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.SystemMemberCacheServer;
import com.gemstone.gemfire.admin.SystemMemberRegion;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.server.ServerLoad;
import com.gemstone.gemfire.cache.server.ServerLoadProbe;
import com.gemstone.gemfire.cache.server.ServerLoadProbeAdapter;
import com.gemstone.gemfire.cache.server.ServerMetrics;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.TestCase;

public class SystemMemberCacheDUnitTest
extends AdminDUnitTestCase {
    public SystemMemberCacheDUnitTest(String name) {
        super(name);
    }

    public void testCacheAttributes() throws Exception {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        final String testName = this.getName();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties props = SystemMemberCacheDUnitTest.this.getDistributedSystemProperties();
                props.setProperty("name", testName);
                SystemMemberCacheDUnitTest.this.getSystem(props);
            }
        });
        SystemMemberCacheDUnitTest.pause(2000);
        AdminDistributedSystem system = this.tcSystem;
        SystemMember[] members = system.getSystemMemberApplications();
        if (members.length != 1) {
            StringBuffer sb = new StringBuffer();
            sb.append("Expected 1 member, got " + members.length + ": ");
            for (int i = 0; i < members.length; ++i) {
                SystemMember member = members[i];
                sb.append(member.getName());
                sb.append(" ");
            }
            SystemMemberCacheDUnitTest.fail((String)sb.toString());
        }
        SystemMemberCache cache = members[0].getCache();
        SystemMemberCacheDUnitTest.assertNull((Object)cache);
        int oldLockLease = 27;
        int oldLockTimeout = 28;
        int oldSearchTimeout = 29;
        vm.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                System.setProperty("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE", "true");
                try {
                    Cache cache2 = CacheFactory.create((DistributedSystem)SystemMemberCacheDUnitTest.this.getSystem());
                    cache2.setLockLease(27);
                    cache2.setLockTimeout(28);
                    cache2.setSearchTimeout(29);
                }
                finally {
                    System.clearProperty("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE");
                }
            }
        });
        cache = members[0].getCache();
        SystemMemberCacheDUnitTest.assertNotNull((Object)cache);
        SystemMemberCacheDUnitTest.assertEquals((String)testName, (String)cache.getName());
        SystemMemberCacheDUnitTest.assertEquals((int)27, (int)cache.getLockLease());
        SystemMemberCacheDUnitTest.assertEquals((int)28, (int)cache.getLockTimeout());
        SystemMemberCacheDUnitTest.assertEquals((int)29, (int)cache.getSearchTimeout());
        int newLockLease = 27;
        int newLockTimeout = 28;
        int newSearchTimeout = 29;
        cache.setLockLease(27);
        cache.setLockTimeout(28);
        cache.setSearchTimeout(29);
        vm.invoke(new CacheSerializableRunnable("Verify cache config"){

            @Override
            public void run2() throws CacheException {
                Cache cache2 = CacheFactory.getAnyInstance();
                TestCase.assertEquals((int)27, (int)cache2.getLockLease());
                TestCase.assertEquals((int)28, (int)cache2.getLockTimeout());
                TestCase.assertEquals((int)29, (int)cache2.getSearchTimeout());
                cache2.close();
            }
        });
        cache.refresh();
        SystemMemberCacheDUnitTest.assertTrue((boolean)cache.isClosed());
    }

    public void testRootRegions() throws Exception {
        VM vm = Host.getHost(0).getVM(0);
        AdminDistributedSystem system = this.tcSystem;
        vm.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                System.setProperty("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE", "true");
                try {
                    CacheFactory.create((DistributedSystem)SystemMemberCacheDUnitTest.this.getSystem());
                }
                finally {
                    System.clearProperty("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE");
                }
            }
        });
        SystemMemberCacheDUnitTest.pause(250);
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(100L);
            SystemMember[] members = system.getSystemMemberApplications();
            if (members.length > 0) break;
        }
        SystemMemberCacheDUnitTest.assertTrue((system.getSystemMemberApplications().length > 0 ? 1 : 0) != 0);
        SystemMemberCache cache = system.getSystemMemberApplications()[0].getCache();
        SystemMemberCacheDUnitTest.assertNotNull((Object)cache);
        SystemMemberCacheDUnitTest.assertTrue((boolean)cache.getRootRegionNames().isEmpty());
        String root1 = "root1";
        String root2 = "root2";
        String root3 = "root3";
        vm.invoke(new CacheSerializableRunnable("Create roots"){

            @Override
            public void run2() throws CacheException {
                Cache cache2 = CacheFactory.getAnyInstance();
                RegionAttributes attrs = new AttributesFactory().create();
                cache2.createRegion("root1", attrs);
                cache2.createRegion("root2", attrs);
                cache2.createRegion("root3", attrs);
            }
        });
        cache.refresh();
        TreeSet roots = new TreeSet(cache.getRootRegionNames());
        SystemMemberCacheDUnitTest.assertEquals((int)3, (int)roots.size());
        for (String name : roots) {
            SystemMemberCacheDUnitTest.assertNotNull((Object)cache.getRegion(name));
        }
        cache.refresh();
        int oldUpTime = cache.getUpTime();
        SystemMemberCacheDUnitTest.pause(1000);
        cache.refresh();
        SystemMemberCacheDUnitTest.assertTrue((cache.getUpTime() > oldUpTime ? 1 : 0) != 0);
        vm.invoke(new CacheSerializableRunnable("Verify cache config"){

            @Override
            public void run2() throws CacheException {
                Cache cache2 = CacheFactory.getAnyInstance();
                cache2.close();
            }
        });
        cache.refresh();
        SystemMemberCacheDUnitTest.assertTrue((boolean)cache.isClosed());
    }

    public void testAddBridgeServer() throws Exception {
        VM vm = Host.getHost(0).getVM(0);
        final AdminDistributedSystem system = this.tcSystem;
        vm.invoke(new CacheSerializableRunnable("Create Cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache = SystemMemberCacheDUnitTest.this.getCache();
                TestCase.assertEquals((int)0, (int)cache.getBridgeServers().size());
            }
        });
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    return system.getSystemMemberApplications().length != 0;
                }
                catch (AdminException e) {
                    DistributedTestCase.fail("unexpected exception", e);
                    return false;
                }
            }

            @Override
            public String description() {
                return "system member applications remained empty";
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
        SystemMemberCache cache = system.getSystemMemberApplications()[0].getCache();
        SystemMemberCacheDUnitTest.assertNotNull((Object)cache);
        SystemMemberCacheDUnitTest.assertEquals((int)0, (int)cache.getBridgeServers().length);
        SystemMemberBridgeServer bridge = cache.addBridgeServer();
        SystemMemberCacheDUnitTest.assertNotNull((Object)bridge);
        SystemMemberCacheDUnitTest.assertFalse((boolean)bridge.isRunning());
        SystemMemberCacheDUnitTest.assertEquals((int)40404, (int)bridge.getPort());
        SystemMemberCacheDUnitTest.assertEquals((String)"", (String)bridge.getBindAddress());
        SystemMemberCacheDUnitTest.assertEquals((String)"", (String)bridge.getHostnameForClients());
        SystemMemberCacheDUnitTest.assertEquals((boolean)true, (boolean)bridge.getNotifyBySubscription());
        SystemMemberCacheDUnitTest.assertEquals((int)32768, (int)bridge.getSocketBufferSize());
        SystemMemberCacheDUnitTest.assertEquals((int)60000, (int)bridge.getMaximumTimeBetweenPings());
        SystemMemberCacheDUnitTest.assertEquals((int)800, (int)bridge.getMaxConnections());
        SystemMemberCacheDUnitTest.assertEquals((int)0, (int)bridge.getMaxThreads());
        SystemMemberCacheDUnitTest.assertEquals((int)230000, (int)bridge.getMaximumMessageCount());
        SystemMemberCacheDUnitTest.assertEquals((int)180, (int)bridge.getMessageTimeToLive());
        SystemMemberCacheDUnitTest.assertEquals(Arrays.asList(BridgeServer.DEFAULT_GROUPS), Arrays.asList(bridge.getGroups()));
        SystemMemberCacheDUnitTest.assertEquals((long)5000L, (long)bridge.getLoadPollInterval());
        SystemMemberCacheDUnitTest.assertEquals((String)BridgeServer.DEFAULT_LOAD_PROBE.toString(), (String)bridge.getLoadProbe());
        cache.refresh();
        SystemMemberCacheDUnitTest.assertEquals((int)1, (int)cache.getBridgeServers().length);
        vm.invoke(new CacheSerializableRunnable("Add another bridge server"){

            @Override
            public void run2() throws CacheException {
                Cache cache2 = SystemMemberCacheDUnitTest.this.getCache();
                cache2.addBridgeServer();
                TestCase.assertEquals((int)2, (int)cache2.getBridgeServers().size());
            }
        });
        cache.refresh();
        SystemMemberCacheDUnitTest.assertEquals((int)2, (int)cache.getBridgeServers().length);
        vm.invoke(new CacheSerializableRunnable("Close Cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache2 = SystemMemberCacheDUnitTest.this.getCache();
                cache2.close();
            }
        });
    }

    public void testAddCacheServer() throws Exception {
        VM vm = Host.getHost(0).getVM(0);
        AdminDistributedSystem system = this.tcSystem;
        vm.invoke(new CacheSerializableRunnable("Create Cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache = SystemMemberCacheDUnitTest.this.getCache();
                TestCase.assertEquals((int)0, (int)cache.getCacheServers().size());
            }
        });
        for (int waits = 0; waits < 20 && system.getSystemMemberApplications().length == 0; ++waits) {
            SystemMemberCacheDUnitTest.pause(100);
        }
        SystemMemberCache cache = system.getSystemMemberApplications()[0].getCache();
        SystemMemberCacheDUnitTest.assertNotNull((Object)cache);
        SystemMemberCacheDUnitTest.assertEquals((int)0, (int)cache.getCacheServers().length);
        SystemMemberCacheServer bridge = cache.addCacheServer();
        SystemMemberCacheDUnitTest.assertNotNull((Object)bridge);
        SystemMemberCacheDUnitTest.assertFalse((boolean)bridge.isRunning());
        SystemMemberCacheDUnitTest.assertEquals((int)40404, (int)bridge.getPort());
        SystemMemberCacheDUnitTest.assertEquals((String)"", (String)bridge.getBindAddress());
        SystemMemberCacheDUnitTest.assertEquals((String)"", (String)bridge.getHostnameForClients());
        SystemMemberCacheDUnitTest.assertEquals((int)32768, (int)bridge.getSocketBufferSize());
        SystemMemberCacheDUnitTest.assertEquals((int)60000, (int)bridge.getMaximumTimeBetweenPings());
        SystemMemberCacheDUnitTest.assertEquals((int)800, (int)bridge.getMaxConnections());
        SystemMemberCacheDUnitTest.assertEquals((int)0, (int)bridge.getMaxThreads());
        SystemMemberCacheDUnitTest.assertEquals((int)230000, (int)bridge.getMaximumMessageCount());
        SystemMemberCacheDUnitTest.assertEquals((int)180, (int)bridge.getMessageTimeToLive());
        SystemMemberCacheDUnitTest.assertEquals(Arrays.asList(CacheServer.DEFAULT_GROUPS), Arrays.asList(bridge.getGroups()));
        SystemMemberCacheDUnitTest.assertEquals((long)5000L, (long)bridge.getLoadPollInterval());
        SystemMemberCacheDUnitTest.assertEquals((String)CacheServer.DEFAULT_LOAD_PROBE.toString(), (String)bridge.getLoadProbe());
        cache.refresh();
        SystemMemberCacheDUnitTest.assertEquals((int)1, (int)cache.getCacheServers().length);
        vm.invoke(new CacheSerializableRunnable("Add another bridge server"){

            @Override
            public void run2() throws CacheException {
                Cache cache2 = SystemMemberCacheDUnitTest.this.getCache();
                cache2.addCacheServer();
                TestCase.assertEquals((int)2, (int)cache2.getCacheServers().size());
            }
        });
        cache.refresh();
        SystemMemberCacheDUnitTest.assertEquals((int)2, (int)cache.getCacheServers().length);
        vm.invoke(new CacheSerializableRunnable("Close Cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache2 = SystemMemberCacheDUnitTest.this.getCache();
                cache2.close();
            }
        });
    }

    public void testStartStopBridgeServer() throws Exception {
        VM vm = Host.getHost(0).getVM(0);
        AdminDistributedSystem system = this.tcSystem;
        vm.invoke(new CacheSerializableRunnable("Create Cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache = SystemMemberCacheDUnitTest.this.getCache();
                TestCase.assertEquals((int)0, (int)cache.getBridgeServers().size());
            }
        });
        SystemMemberCacheDUnitTest.pause(5000);
        SystemMemberCache cache = system.getSystemMemberApplications()[0].getCache();
        final SystemMemberBridgeServer bridge = cache.addBridgeServer();
        final int port = AvailablePort.getRandomAvailablePort((int)0);
        bridge.setPort(port);
        bridge.setBindAddress(InetAddress.getLocalHost().getHostName());
        bridge.setHostnameForClients("bogusClientHostName");
        bridge.setNotifyBySubscription(true);
        bridge.setSocketBufferSize(7777);
        bridge.setMaximumTimeBetweenPings(666);
        bridge.setMaxConnections(555);
        bridge.setMaxThreads(444);
        bridge.setMaximumMessageCount(333);
        bridge.setMessageTimeToLive(222);
        bridge.setGroups(new String[]{"myServerGroup1", "myServerGroup2"});
        bridge.setLoadPollInterval(8888L);
        if (!this.isJMX()) {
            bridge.setLoadProbe((ServerLoadProbe)new MyLoadProbe("myLoadProbe"));
        }
        bridge.start();
        bridge.refresh();
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                if (bridge.isRunning()) {
                    return true;
                }
                bridge.refresh();
                return false;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
        SystemMemberCacheDUnitTest.assertTrue((boolean)bridge.isRunning());
        SystemMemberCacheDUnitTest.assertEquals((int)port, (int)bridge.getPort());
        SystemMemberCacheDUnitTest.assertEquals((String)InetAddress.getLocalHost().getHostName(), (String)bridge.getBindAddress());
        SystemMemberCacheDUnitTest.assertEquals((String)"bogusClientHostName", (String)bridge.getHostnameForClients());
        SystemMemberCacheDUnitTest.assertEquals((boolean)true, (boolean)bridge.getNotifyBySubscription());
        SystemMemberCacheDUnitTest.assertEquals((int)7777, (int)bridge.getSocketBufferSize());
        SystemMemberCacheDUnitTest.assertEquals((int)666, (int)bridge.getMaximumTimeBetweenPings());
        SystemMemberCacheDUnitTest.assertEquals((int)555, (int)bridge.getMaxConnections());
        SystemMemberCacheDUnitTest.assertEquals((int)444, (int)bridge.getMaxThreads());
        SystemMemberCacheDUnitTest.assertEquals((int)333, (int)bridge.getMaximumMessageCount());
        SystemMemberCacheDUnitTest.assertEquals((int)222, (int)bridge.getMessageTimeToLive());
        SystemMemberCacheDUnitTest.assertEquals(Arrays.asList("myServerGroup1", "myServerGroup2"), Arrays.asList(bridge.getGroups()));
        SystemMemberCacheDUnitTest.assertEquals((long)8888L, (long)bridge.getLoadPollInterval());
        if (!this.isJMX()) {
            SystemMemberCacheDUnitTest.assertEquals((String)"myLoadProbe", (String)bridge.getLoadProbe());
        }
        try {
            bridge.setPort(23);
            SystemMemberCacheDUnitTest.fail((String)"expected AdminException");
        }
        catch (AdminException adminException) {
            // empty catch block
        }
        vm.invoke(new CacheSerializableRunnable("Check Bridge Started"){

            @Override
            public void run2() throws CacheException {
                Cache cache2 = SystemMemberCacheDUnitTest.this.getCache();
                List bridges = cache2.getBridgeServers();
                TestCase.assertEquals((int)1, (int)bridges.size());
                BridgeServer bridge2 = (BridgeServer)bridges.iterator().next();
                TestCase.assertTrue((boolean)bridge2.isRunning());
                TestCase.assertEquals((int)port, (int)bridge2.getPort());
            }
        });
        bridge.stop();
        bridge.refresh();
        ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                if (!bridge.isRunning()) {
                    return true;
                }
                bridge.refresh();
                return false;
            }

            @Override
            public String description() {
                return "bridge never started running: " + bridge;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
        SystemMemberCacheDUnitTest.assertFalse((boolean)bridge.isRunning());
        vm.invoke(new CacheSerializableRunnable("Check Bridge Stopped"){

            @Override
            public void run2() throws CacheException {
                Cache cache2 = SystemMemberCacheDUnitTest.this.getCache();
                List bridges = cache2.getBridgeServers();
                TestCase.assertEquals((int)1, (int)bridges.size());
                BridgeServer bridge2 = (BridgeServer)bridges.iterator().next();
                TestCase.assertFalse((boolean)bridge2.isRunning());
                cache2.close();
            }
        });
    }

    public void testIsCacheServer() throws Exception {
        VM vm = Host.getHost(0).getVM(0);
        AdminDistributedSystem system = this.tcSystem;
        vm.invoke(new CacheSerializableRunnable("Create Cache"){

            @Override
            public void run2() throws CacheException {
                SystemMemberCacheDUnitTest.this.getCache();
            }
        });
        SystemMemberCacheDUnitTest.pause(250);
        SystemMemberCache cache = system.getSystemMemberApplications()[0].getCache();
        SystemMemberCacheDUnitTest.assertFalse((boolean)cache.isServer());
        vm.invoke(new CacheSerializableRunnable("Mark as Cache Server"){

            @Override
            public void run2() throws CacheException {
                Cache cache2 = SystemMemberCacheDUnitTest.this.getCache();
                cache2.setIsServer(true);
                TestCase.assertTrue((boolean)cache2.isServer());
            }
        });
        SystemMemberCacheDUnitTest.assertFalse((boolean)cache.isServer());
        cache.refresh();
        SystemMemberCacheDUnitTest.assertTrue((boolean)cache.isServer());
        vm.invoke(new CacheSerializableRunnable("Unmark as Cache Server"){

            @Override
            public void run2() throws CacheException {
                Cache cache2 = SystemMemberCacheDUnitTest.this.getCache();
                cache2.setIsServer(false);
                TestCase.assertFalse((boolean)cache2.isServer());
            }
        });
        vm.invoke(new CacheSerializableRunnable("Test getAdminMembers in Cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache2 = SystemMemberCacheDUnitTest.this.getCache();
                TestCase.assertEquals((int)1, (int)cache2.getAdminMembers().size());
            }
        });
        SystemMemberCacheDUnitTest.assertTrue((boolean)cache.isServer());
        cache.refresh();
        SystemMemberCacheDUnitTest.assertFalse((boolean)cache.isServer());
    }

    public void testCreateRootRegion() throws Exception {
        if (this.isJMX()) {
            return;
        }
        VM vm = Host.getHost(0).getVM(0);
        AdminDistributedSystem system = this.tcSystem;
        vm.invoke(new CacheSerializableRunnable("Create Cache"){

            @Override
            public void run2() throws CacheException {
                SystemMemberCacheDUnitTest.this.getCache();
            }
        });
        SystemMemberCacheDUnitTest.pause(250);
        SystemMemberCache cache = system.getSystemMemberApplications()[0].getCache();
        SystemMemberCacheDUnitTest.assertEquals((int)0, (int)cache.getRootRegionNames().size());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setKeyConstraint(String.class);
        RegionAttributes attrs = factory.create();
        final String name = this.getUniqueName();
        SystemMemberRegion region = cache.createRegion(name, attrs);
        SystemMemberCacheDUnitTest.assertEquals((String)name, (String)region.getName());
        SystemMemberCacheDUnitTest.assertEquals((Object)Scope.LOCAL, (Object)region.getScope());
        SystemMemberCacheDUnitTest.assertEquals((String)String.class.getName(), (String)region.getKeyConstraint());
        vm.invoke(new CacheSerializableRunnable("Verify region"){

            @Override
            public void run2() throws CacheException {
                Cache cache2 = SystemMemberCacheDUnitTest.this.getCache();
                Region region2 = cache2.getRegion(name);
                TestCase.assertNotNull((Object)region2);
                RegionAttributes attrs2 = region2.getAttributes();
                TestCase.assertEquals((String)name, (String)region2.getName());
                TestCase.assertEquals((Object)Scope.LOCAL, (Object)attrs2.getScope());
                TestCase.assertEquals(String.class, (Object)attrs2.getKeyConstraint());
            }
        });
    }

    public void testCreateRegion() throws Exception {
        if (this.isJMX()) {
            return;
        }
        VM vm = Host.getHost(0).getVM(0);
        AdminDistributedSystem system = this.tcSystem;
        final String rootName = this.getUniqueName() + "-ROOT";
        vm.invoke(new CacheSerializableRunnable("Create Cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache = SystemMemberCacheDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                cache.createRegion(rootName, factory.create());
            }
        });
        SystemMemberCacheDUnitTest.pause(250);
        SystemMemberCache cache = system.getSystemMemberApplications()[0].getCache();
        Set rootNames = cache.getRootRegionNames();
        SystemMemberCacheDUnitTest.assertEquals((int)1, (int)rootNames.size());
        SystemMemberCacheDUnitTest.assertEquals((Object)rootName, rootNames.iterator().next());
        SystemMemberRegion root = cache.getRegion(rootName);
        SystemMemberCacheDUnitTest.assertNotNull((Object)root);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setCacheLoader((CacheLoader)new MyCacheLoader());
        factory.setKeyConstraint(String.class);
        RegionAttributes attrs = factory.create();
        final String name = this.getUniqueName() + "-Subregion";
        SystemMemberRegion region = root.createSubregion(name, attrs);
        SystemMemberCacheDUnitTest.assertEquals((String)name, (String)region.getName());
        SystemMemberCacheDUnitTest.assertEquals((Object)Scope.LOCAL, (Object)region.getScope());
        SystemMemberCacheDUnitTest.assertEquals((String)String.class.getName(), (String)region.getKeyConstraint());
        vm.invoke(new CacheSerializableRunnable("Verify region"){

            @Override
            public void run2() throws CacheException {
                Cache cache2 = SystemMemberCacheDUnitTest.this.getCache();
                Region root2 = cache2.getRegion(rootName);
                TestCase.assertNotNull((Object)root2);
                Region region2 = root2.getSubregion(name);
                TestCase.assertNotNull((Object)region2);
                RegionAttributes attrs2 = region2.getAttributes();
                TestCase.assertEquals((String)name, (String)region2.getName());
                TestCase.assertEquals((Object)Scope.LOCAL, (Object)attrs2.getScope());
                TestCase.assertEquals(String.class, (Object)attrs2.getKeyConstraint());
            }
        });
    }

    public void testCreateRegionBadConfiguration() throws Exception {
        if (this.isJMX()) {
            return;
        }
        VM vm = Host.getHost(0).getVM(0);
        AdminDistributedSystem system = this.tcSystem;
        final String rootName = this.getUniqueName() + "-ROOT";
        vm.invoke(new CacheSerializableRunnable("Create Cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache = SystemMemberCacheDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                cache.createRegion(rootName, factory.create());
            }
        });
        SystemMemberCacheDUnitTest.pause(250);
        SystemMemberCache cache = system.getSystemMemberApplications()[0].getCache();
        Set rootNames = cache.getRootRegionNames();
        SystemMemberCacheDUnitTest.assertEquals((int)1, (int)rootNames.size());
        SystemMemberCacheDUnitTest.assertEquals((Object)rootName, rootNames.iterator().next());
        SystemMemberRegion root = cache.getRegion(rootName);
        SystemMemberCacheDUnitTest.assertNotNull((Object)root);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_NO_ACK);
        RegionAttributes attrs = factory.create();
        String name = this.getUniqueName() + "-Subregion";
        try {
            root.createSubregion(name, attrs);
            SystemMemberCacheDUnitTest.fail((String)"Should have thrown an AdminException");
        }
        catch (AdminException ex) {
            SystemMemberCacheDUnitTest.assertTrue((boolean)(ex.getCause() instanceof IllegalStateException));
        }
    }

    public static class MyLoadProbe
    extends ServerLoadProbeAdapter
    implements Serializable {
        private String string;

        public MyLoadProbe(String string) {
            this.string = string;
        }

        public ServerLoad getLoad(ServerMetrics metrics) {
            return new ServerLoad();
        }

        public String toString() {
            return this.string;
        }
    }

    public static class MyCacheLoader
    implements CacheLoader {
        public Object load(LoaderHelper helper) throws CacheLoaderException {
            return null;
        }

        public void close() {
        }
    }
}

