/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin;

import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.DistributedSystemHealthConfig;
import com.gemstone.gemfire.admin.GemFireHealth;
import com.gemstone.gemfire.admin.GemFireHealthConfig;
import com.gemstone.gemfire.admin.OperationCancelledException;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.admin.internal.DistributedSystemConfigImpl;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionConfigImpl;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.LocalLogWriter;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.Properties;

public class GemFireHealthMonitor {
    private static final PrintStream out = System.out;
    private static final PrintStream err = System.err;

    public static void main(String[] args) throws Throwable {
        Properties props = new Properties();
        if (args.length > 0) {
            props.load(new FileInputStream(args[0]));
        }
        DistributionConfigImpl dc = new DistributionConfigImpl(props);
        DistributedSystemConfigImpl dsc = new DistributedSystemConfigImpl((DistributionConfig)dc, "rsh -n {HOST} {CMD}");
        AdminDistributedSystemImpl system = (AdminDistributedSystemImpl)AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)dsc);
        system.connect((LogWriterI18n)new LocalLogWriter(Integer.MIN_VALUE, System.out));
        GemFireHealth health = system.getGemFireHealth();
        GemFireHealthConfig config = health.getDefaultGemFireHealthConfig();
        config.setMaxLoadTime(100L);
        config.setHealthEvaluationInterval(1);
        health.setDefaultGemFireHealthConfig(config);
        DistributedSystemHealthConfig dsHealthConfig = health.getDistributedSystemHealthConfig();
        dsHealthConfig.setMaxDepartedApplications(0L);
        health.setDistributedSystemHealthConfig(dsHealthConfig);
        while (true) {
            try {
                while (true) {
                    int c;
                    GemFireHealth.Health code;
                    if ((code = health.getHealth()) == GemFireHealth.GOOD_HEALTH) {
                        c = 71;
                    } else if (code == GemFireHealth.OKAY_HEALTH) {
                        c = 79;
                        System.out.println(health.getDiagnosis());
                    } else if (code == GemFireHealth.POOR_HEALTH) {
                        c = 80;
                        System.out.println(health.getDiagnosis());
                    } else {
                        String s = "Unknown code: " + code;
                        throw new IllegalStateException(s);
                    }
                    out.print((char)c);
                    out.flush();
                    Thread.sleep(500L);
                }
            }
            catch (OperationCancelledException ex) {
                ex.printStackTrace(System.out);
                continue;
            }
            break;
        }
    }
}

