/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.DistributionLocator;
import com.gemstone.gemfire.admin.DistributionLocatorConfig;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.internal.ManagedEntityControllerFactory;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.AvailablePort;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import hydra.HostHelper;
import java.io.File;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.Properties;
import junit.framework.TestCase;

public class DistributionLocatorDUnitTest
extends DistributedTestCase {
    private static final String TIMEOUT_MS_NAME = "DistributionLocatorDUnitTest.TIMEOUT_MS";
    private static final int TIMEOUT_MS_DEFAULT = 60000;
    private static final int TIMEOUT_MS = Integer.getInteger("DistributionLocatorDUnitTest.TIMEOUT_MS", 60000);

    public DistributionLocatorDUnitTest(String name) {
        super(name);
    }

    private boolean waitToStart(DistributionLocator locator, long duration) {
        long start = System.currentTimeMillis();
        while (!locator.isRunning() && System.currentTimeMillis() - start < duration) {
            DistributionLocatorDUnitTest.pause(500);
        }
        return locator.isRunning();
    }

    public void testStartAndStopLocator() throws Exception {
        if (!ManagedEntityControllerFactory.isEnabledManagedEntityController()) {
            return;
        }
        if (HostHelper.isWindows()) {
            return;
        }
        DistributionLocatorDUnitTest.disconnectAllFromDS();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        File dir = new File(this.getUniqueName() + "-locator");
        dir.mkdirs();
        DistributionLocatorDUnitTest.assertTrue((boolean)dir.exists());
        DistributedSystemConfig adminConfig = AdminDistributedSystemFactory.defineDistributedSystem();
        adminConfig.setMcastPort(0);
        adminConfig.setLogFile(this.getUniqueName() + ".log");
        adminConfig.setLogLevel(DistributionLocatorDUnitTest.getDUnitLogLevel());
        DistributionLocatorDUnitTest.getLogWriter().info("adminConfig=" + adminConfig);
        DistributionLocatorConfig locatorConfig = adminConfig.createDistributionLocatorConfig();
        DistributionLocatorDUnitTest.assertEquals((int)1, (int)adminConfig.getDistributionLocatorConfigs().length);
        locatorConfig.setPort(port);
        locatorConfig.setWorkingDirectory(dir.getAbsolutePath());
        locatorConfig.setHost(DistributionLocatorDUnitTest.getServerHostName(Host.getHost(0)));
        AdminDistributedSystem admin = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)adminConfig);
        DistributionLocator[] locators = admin.getDistributionLocators();
        DistributionLocatorDUnitTest.assertEquals((int)1, (int)locators.length);
        DistributionLocatorDUnitTest.assertFalse((boolean)locators[0].isRunning());
        admin.start();
        locators = admin.getDistributionLocators();
        DistributionLocatorDUnitTest.assertEquals((int)1, (int)locators.length);
        DistributionLocator locator = locators[0];
        DistributionLocatorDUnitTest.assertTrue((boolean)this.waitToStart(locator, TIMEOUT_MS));
        DistributionLocatorDUnitTest.pause(500);
        locator.stop();
        this.deleteStateFile(port);
        DistributionLocatorDUnitTest.assertTrue((boolean)locator.waitToStop(60000L));
    }

    private void deleteStateFile(int port) {
        File stateFile = new File("locator" + port + "state.dat");
        if (stateFile.exists()) {
            stateFile.delete();
        }
    }

    public void testOneDistributionLocator() throws Exception {
        if (!ManagedEntityControllerFactory.isEnabledManagedEntityController()) {
            return;
        }
        if (HostHelper.isWindows()) {
            return;
        }
        DistributionLocatorDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        File dir = new File(this.getUniqueName() + "-locator");
        dir.mkdirs();
        DistributionLocatorDUnitTest.assertTrue((boolean)dir.exists());
        DistributedSystemConfig adminConfig = AdminDistributedSystemFactory.defineDistributedSystem();
        adminConfig.setMcastPort(0);
        adminConfig.setLogFile(this.getUniqueName() + ".log");
        adminConfig.setLogLevel(DistributionLocatorDUnitTest.getDUnitLogLevel());
        DistributionLocatorConfig locatorConfig = adminConfig.createDistributionLocatorConfig();
        locatorConfig.setHost(DistributionLocatorDUnitTest.getServerHostName(host));
        locatorConfig.setPort(port);
        locatorConfig.setWorkingDirectory(dir.getAbsolutePath());
        locatorConfig.setBindAddress(DistributionLocatorDUnitTest.getServerHostName(host));
        DistributionLocatorDUnitTest.getLogWriter().info("locatorConfig=" + locatorConfig);
        DistributionLocatorDUnitTest.getLogWriter().info("adminConfig=" + adminConfig);
        AdminDistributedSystem admin = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)adminConfig);
        admin.start();
        DistributionLocator locator = admin.getDistributionLocators()[0];
        DistributionLocatorDUnitTest.assertTrue((boolean)this.waitToStart(locator, 10000L));
        DistributionLocatorDUnitTest.pause(5000);
        final Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        String loc = this.adjustLocators(adminConfig.getLocators(), host);
        props.setProperty("locators", loc);
        props.setProperty("bind-address", DistributionLocatorDUnitTest.getServerHostName(Host.getHost(0)));
        vm.invoke(new SerializableRunnable("Connect to DS"){

            @Override
            public void run() {
                DistributedSystem.connect((Properties)props);
            }
        });
        admin.connect();
        boolean connected = admin.waitToBeConnected((long)TIMEOUT_MS);
        DistributionLocatorDUnitTest.assertTrue((boolean)connected);
        DistributionLocatorDUnitTest.assertEquals((int)2, (int)admin.getSystemMemberApplications().length);
        vm.invoke(new SerializableRunnable("Disconnect from DS"){

            @Override
            public void run() {
                DistributedSystem.connect((Properties)props).disconnect();
            }
        });
        admin.disconnect();
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        while (ds != null) {
            ds.disconnect();
            ds = InternalDistributedSystem.getAnyInstance();
        }
        locator.stop();
        this.deleteStateFile(port);
        DistributionLocatorDUnitTest.assertTrue((boolean)locator.waitToStop((long)TIMEOUT_MS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOneMcastDistributionLocator() throws Exception {
        DistributionLocator locator;
        int port;
        block9: {
            if (!ManagedEntityControllerFactory.isEnabledManagedEntityController()) {
                return;
            }
            if (HostHelper.isWindows() || Boolean.getBoolean("java.net.preferIPv6Addresses")) {
                return;
            }
            DistributionLocatorDUnitTest.disconnectAllFromDS();
            Host host = Host.getHost(0);
            VM vm = host.getVM(0);
            port = AvailablePort.getRandomAvailablePort((int)0);
            int mcastport = AvailablePort.getRandomAvailablePort((int)1);
            File dir = new File(this.getUniqueName() + "-locator");
            dir.mkdirs();
            DistributionLocatorDUnitTest.assertTrue((boolean)dir.exists());
            DistributedSystemConfig adminConfig = AdminDistributedSystemFactory.defineDistributedSystem();
            adminConfig.setMcastPort(mcastport);
            adminConfig.setLogFile(this.getUniqueName() + ".log");
            adminConfig.setLogLevel(DistributionLocatorDUnitTest.getDUnitLogLevel());
            DistributionLocatorDUnitTest.getLogWriter().info("adminConfig=" + adminConfig);
            DistributionLocatorConfig locatorConfig = adminConfig.createDistributionLocatorConfig();
            locatorConfig.setPort(port);
            locatorConfig.setWorkingDirectory(dir.getAbsolutePath());
            Properties dsProperties = new Properties();
            dsProperties.setProperty("mcast-port", String.valueOf(mcastport));
            locatorConfig.setDistributedSystemProperties(dsProperties);
            AdminDistributedSystem admin = null;
            locator = null;
            final Properties props = new Properties();
            try {
                admin = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)adminConfig);
                admin.start();
                props.setProperty("mcast-port", String.valueOf(mcastport));
                props.setProperty("locators", adminConfig.getLocators());
                locator = admin.getDistributionLocators()[0];
                DistributionLocatorDUnitTest.assertTrue((boolean)this.waitToStart(locator, TIMEOUT_MS));
                DistributionLocatorDUnitTest.pause(5000);
                vm.invoke(new SerializableRunnable("Connect to DS"){

                    @Override
                    public void run() {
                        DistributedSystem.connect((Properties)props);
                    }
                });
                admin.connect();
                DistributionLocatorDUnitTest.assertTrue((boolean)admin.waitToBeConnected((long)TIMEOUT_MS));
                final AdminDistributedSystem wadmin = admin;
                DistributionLocatorDUnitTest.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "waiting for system member applications to become 2";
                    }

                    @Override
                    public boolean done() {
                        try {
                            return wadmin.getSystemMemberApplications().length == 2;
                        }
                        catch (AdminException e) {
                            return true;
                        }
                    }
                }, 20000L, 100L, false);
                if (admin.getSystemMemberApplications().length != 2) {
                    DistributionLocatorDUnitTest.getLogWriter().info("dump of getSystemMemberApplications:");
                    for (SystemMember sm : admin.getSystemMemberApplications()) {
                        DistributionLocatorDUnitTest.getLogWriter().info("  " + sm);
                    }
                }
                DistributionLocatorDUnitTest.assertEquals((int)2, (int)admin.getSystemMemberApplications().length);
                vm.invoke(new SerializableRunnable("Disconnect from DS", props){
                    final /* synthetic */ Properties val$props;
                    {
                        this.val$props = properties;
                        super(name);
                    }

                    @Override
                    public void run() {
                        DistributedSystem.connect((Properties)this.val$props).disconnect();
                    }
                });
                if (admin == null) break block9;
            }
            catch (Throwable throwable) {
                vm.invoke(new /* invalid duplicate definition of identical inner class */);
                if (admin != null) {
                    admin.disconnect();
                }
                InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
                while (ds != null) {
                    ds.disconnect();
                    ds = InternalDistributedSystem.getAnyInstance();
                }
                throw throwable;
            }
            admin.disconnect();
        }
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        while (ds != null) {
            ds.disconnect();
            ds = InternalDistributedSystem.getAnyInstance();
        }
        locator.stop();
        this.deleteStateFile(port);
        DistributionLocatorDUnitTest.assertTrue((boolean)locator.waitToStop((long)TIMEOUT_MS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributionLocatorUnderDS() throws Exception {
        if (HostHelper.isWindows()) {
            return;
        }
        DistributionLocatorDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        Properties props = new Properties();
        props.put("start-locator", DistributionLocatorDUnitTest.getServerHostName(host) + "[" + port + "],peer=true,server=false");
        props.put("mcast-port", "0");
        props.put("bind-address", DistributionLocatorDUnitTest.getServerHostName(Host.getHost(0)));
        DistributedSystem ds = null;
        try {
            ds = DistributedSystem.connect((Properties)props);
            HashSet locs = new HashSet(Locator.getLocators());
            Assert.assertTrue((locs.size() == 1 ? 1 : 0) != 0, (Object)("Incorrect number of locators found: " + locs.size()));
            final String locatorString = DistributionLocatorDUnitTest.getServerHostName(host) + "[" + port + "]";
            vm1.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    Properties p = new Properties();
                    p.put("locators", locatorString);
                    p.put("mcast-port", "0");
                    DistributedSystem ds1 = null;
                    try {
                        ds1 = DistributedSystem.connect((Properties)p);
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("exception trying to connect distributed system", e);
                    }
                    if (!ds1.isConnected()) {
                        TestCase.fail((String)"distributed system not connected after connect()");
                    }
                    try {
                        ds1.disconnect();
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("unable to disconnect distributed system", e);
                    }
                }
            });
            ds.disconnect();
            ServerSocket sock = null;
            try {
                sock = new ServerSocket(port);
                sock.close();
            }
            catch (Exception e) {
                DistributionLocatorDUnitTest.fail((String)"DistributedSystem.disconnect did not stop the hosted locator");
            }
        }
        catch (Exception e) {
            if (ds != null && ds.isConnected()) {
                try {
                    ds.disconnect();
                }
                catch (Exception e2) {
                    DistributionLocatorDUnitTest.getLogWriter().severe("Unable to disconnect distributed system", (Throwable)e2);
                }
            }
            DistributionLocatorDUnitTest.fail("test failed", e);
        }
        finally {
            this.deleteStateFile(port);
        }
    }

    private String adjustLocators(String loc_orig, Host host) {
        String loc = loc_orig;
        if (loc.indexOf(58) < 0) {
            int idx = loc.indexOf(91);
            String addr = null;
            try {
                String hostname = DistributionLocatorDUnitTest.getServerHostName(host);
                addr = InetAddress.getByName(hostname).getHostAddress();
            }
            catch (Exception e) {
                DistributionLocatorDUnitTest.fail("Unable to get host address", e);
            }
            loc = loc.substring(0, idx) + '@' + addr + loc.substring(idx);
        }
        return loc;
    }
}

