/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.RootDoc;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.BreakIterator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeSet;
import junit.framework.TestCase;
import perffmwk.Formatter;

public class UnitTestDoclet {
    public static int optionLength(String option) {
        if (option.equals("-output")) {
            return 2;
        }
        return 0;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        boolean sawOutput = false;
        for (int i = 0; i < options.length; ++i) {
            String[] option = options[i];
            if (!option[0].equals("-output")) continue;
            File output = new File(option[1]);
            if (output.exists() && output.isDirectory()) {
                reporter.printError("Output file " + output + " is a directory");
                return false;
            }
            sawOutput = true;
        }
        if (!sawOutput) {
            reporter.printError("Missing -output");
            return false;
        }
        return true;
    }

    public static boolean start(RootDoc root) {
        String[][] options = root.options();
        File outputFile = null;
        for (int i = 0; i < options.length; ++i) {
            String[] option = options[i];
            if (!option[0].equals("-output")) continue;
            outputFile = new File(option[1]);
        }
        if (outputFile == null) {
            root.printError("Internal Error: No output file");
            return false;
        }
        root.printNotice("Generating " + outputFile);
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(outputFile));
            Formatter.center("GemFire Unit Test Summary", pw);
            Formatter.center(new Date().toString(), pw);
            pw.println("");
            ClassDoc[] classes = root.classes();
            Arrays.sort(classes, new Comparator(){

                public int compare(Object o1, Object o2) {
                    ClassDoc c1 = (ClassDoc)o1;
                    ClassDoc c2 = (ClassDoc)o2;
                    return c1.qualifiedName().compareTo(c2.qualifiedName());
                }
            });
            for (int i = 0; i < classes.length; ++i) {
                ClassDoc c = classes[i];
                if (c.isAbstract() || !UnitTestDoclet.isUnitTest(c)) continue;
                UnitTestDoclet.document(c, pw);
            }
            pw.flush();
            pw.close();
        }
        catch (IOException ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter((Writer)sw, true));
            root.printError(sw.toString());
            return false;
        }
        return true;
    }

    private static boolean isUnitTest(ClassDoc c) {
        if (c == null) {
            return false;
        }
        if (c.qualifiedName().equals(TestCase.class.getName())) {
            return true;
        }
        return UnitTestDoclet.isUnitTest(c.superclass());
    }

    public static void document(ClassDoc c, PrintWriter pw) throws IOException {
        pw.println(c.qualifiedName());
        String comment = c.commentText();
        if (comment != null && !comment.equals("")) {
            pw.println("");
            UnitTestDoclet.indent(comment, 4, pw);
            pw.println("");
        }
        MethodDoc[] methods = UnitTestDoclet.getTestMethods(c);
        for (int i = 0; i < methods.length; ++i) {
            MethodDoc method = methods[i];
            pw.print("  ");
            pw.println(method.name());
            String comment2 = method.commentText();
            if (comment2 == null || comment2.equals("")) continue;
            pw.println("");
            UnitTestDoclet.indent(comment2, 6, pw);
            pw.println("");
        }
        pw.println("");
    }

    private static MethodDoc[] getTestMethods(ClassDoc c) {
        TreeSet<MethodDoc> set = new TreeSet<MethodDoc>();
        while (c != null) {
            MethodDoc[] methods = c.methods();
            for (int i = 0; i < methods.length; ++i) {
                MethodDoc method = methods[i];
                if (!method.isPublic() || method.parameters().length != 0 || !method.name().startsWith("test")) continue;
                set.add(method);
            }
            c = c.superclass();
        }
        return set.toArray(new MethodDoc[0]);
    }

    private static void indent(String text, int indent, PrintWriter pw) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        String spaces = sb.toString();
        pw.print(spaces);
        int printed = indent;
        boolean firstWord = true;
        BreakIterator boundary = BreakIterator.getWordInstance();
        boundary.setText(text);
        int start = boundary.first();
        int end = boundary.next();
        while (end != -1) {
            String word = text.substring(start, end);
            if (printed + word.length() > 72) {
                pw.println("");
                pw.print(spaces);
                printed = indent;
                firstWord = true;
            }
            if (word.charAt(word.length() - 1) == '\n') {
                pw.write(word, 0, word.length() - 1);
            } else if (firstWord && Character.isWhitespace(word.charAt(0))) {
                pw.write(word, 1, word.length() - 1);
            } else {
                pw.print(word);
            }
            printed += end - start;
            firstWord = false;
            start = end;
            end = boundary.next();
        }
        pw.println("");
    }
}

