/*
 * Decompiled with CFR 0.152.
 */
package capCon;

import capCon.CapConBB;
import capCon.CapConPrms;
import capCon.LRUListener;
import capCon.LRUTest;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EvictionAttributesMutator;
import com.gemstone.gemfire.cache.Region;
import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;
import util.Bounds;
import util.BoundsPrms;
import util.CacheUtil;
import util.EventCountersBB;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;

public class LRUDynamicTest
extends LRUTest {
    private int boundsMultiplier = -1;
    private Bounds regionBounds = null;
    private boolean randomCapacityChanges = false;
    final long NUM_EVICTIONS_BEFORE_CHANGE = 200L;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new LRUDynamicTest();
            testInstance.initialize();
            ((LRUDynamicTest)testInstance).initFields();
            Log.getLogWriter().info(testInstance.toString());
        }
    }

    @Override
    protected void initFields() {
        this.boundsMultiplier = TestConfig.tab().intAt(CapConPrms.boundsMultiplier);
        int targetLowPoint = TestConfig.tab().intAt(BoundsPrms.targetLowPoint);
        int targetHighPoint = TestConfig.tab().intAt(BoundsPrms.targetHighPoint);
        this.regionBounds = new Bounds(targetLowPoint, targetHighPoint, true, CapConBB.class, CapConBB.CAPCON_BB_NAME, CapConBB.CAPCON_BB_TYPE);
        CapConBB.getBB().getSharedMap().put(CapConBB.CURRENT_POINT, new Integer(1));
        this.lowestAllowableEntries = this.boundsMultiplier;
        this.highestAllowableEntries = this.boundsMultiplier;
        this.randomCapacityChanges = (Boolean)CapConBB.getBB().getSharedMap().get(CapConBB.RANDOM_CAPACITY_CHANGES);
        Log.getLogWriter().info("Setting TEST_SETTINGS to " + this.boundsMultiplier);
        CapConBB.getBB().getSharedMap().put(CapConBB.TEST_SETTINGS, new Integer(this.boundsMultiplier));
        Log.getLogWriter().info("Mutating maximumEntries to " + this.boundsMultiplier);
        EvictionAttributesMutator mutator = CacheUtil.getRegion("capConRegion").getAttributesMutator().getEvictionAttributesMutator();
        mutator.setMaximum(this.boundsMultiplier);
        Log.getLogWriter().info("After mutating, region is now " + TestHelper.regionToString(CacheUtil.getRegion("capConRegion"), true));
        CapConBB.getBB().getSharedCounters().setIfLarger(CapConBB.NUM_LRU_EVICTIONS_TO_TRIGGER_CAPACITY_CHANGE, 200L);
        Log.getLogWriter().info(this.toString());
    }

    public static void HydraTask_serialTest() {
        ((LRUDynamicTest)testInstance).doDynamicTest(true);
    }

    public static void HydraTask_serialTxTest() {
        ((LRUDynamicTest)testInstance).doSerialDynamicTxTest();
    }

    public static void HydraTask_concTxTest() {
        ((LRUDynamicTest)testInstance).doDynamicTest(false);
    }

    public static void HydraTask_concTest() {
        ((LRUDynamicTest)testInstance).doDynamicTest(false);
    }

    public static void HydraTask_endTask() {
        LRUDynamicTest.checkForEventError();
        long numCapacityChanges = CapConBB.getBB().getSharedCounters().read(CapConBB.NUM_CAPACITY_CHANGES);
        Log.getLogWriter().info("Number of capacity changes: " + numCapacityChanges);
    }

    private void doDynamicTest(boolean isSerialExecution) {
        if (isSerialExecution) {
            long exeNum = CapConBB.getBB().getSharedCounters().incrementAndRead(CapConBB.EXECUTION_NUMBER);
            Log.getLogWriter().info("Beginning task with execution number " + exeNum);
        }
        long numEvictionsBeforeChange = 100L;
        long checkForCapacityChangeInterval = 10000L;
        Region workRegion = this.getWorkRegion();
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In LRUDynamicTest.doDynamicTest, adding for " + timeToRunSec + " seconds");
        int count = 0;
        long startTime = System.currentTimeMillis();
        this.maximumEntries = (Integer)CapConBB.getBB().getSharedMap().get(CapConBB.TEST_SETTINGS);
        super.initFields();
        long lastCapacityChangeCheck = 0L;
        do {
            LRUDynamicTest.checkForEventError();
            boolean newCapacity = false;
            boolean newCapacityIsLower = false;
            if (System.currentTimeMillis() - lastCapacityChangeCheck >= 10000L) {
                lastCapacityChangeCheck = System.currentTimeMillis();
                double currentNumLRUEvictions = TestHelper.getNumLRUEvictions();
                long numLRUEvictionsToTriggerCapacityChange = CapConBB.getBB().getSharedCounters().read(CapConBB.NUM_LRU_EVICTIONS_TO_TRIGGER_CAPACITY_CHANGE);
                Log.getLogWriter().info("Checking for capacity change, currentNumLRUEvictions = " + currentNumLRUEvictions + ", numLRUEvictionsToTriggerCapacityChange " + numLRUEvictionsToTriggerCapacityChange);
                if (currentNumLRUEvictions >= (double)numLRUEvictionsToTriggerCapacityChange) {
                    CapConBB.getBB().getSharedCounters().setIfLarger(CapConBB.NUM_LRU_EVICTIONS_TO_TRIGGER_CAPACITY_CHANGE, (long)currentNumLRUEvictions + 100L);
                    int currentPoint = (Integer)CapConBB.getBB().getSharedMap().get(CapConBB.CURRENT_POINT);
                    int newMaximumEntries = -1;
                    int oldCurrentPoint = currentPoint;
                    currentPoint = this.randomCapacityChanges ? TestConfig.tab().getRandGen().nextInt(this.regionBounds.getTargetLowPoint(), this.regionBounds.getTargetHighPoint()) : (this.regionBounds.getDirection(currentPoint) == 0 ? ++currentPoint : --currentPoint);
                    newMaximumEntries = currentPoint * this.boundsMultiplier;
                    Region aRegion = CacheUtil.getRegion("capConRegion");
                    Log.getLogWriter().info("Setting new capacity (maximumEntries) " + newMaximumEntries + " on " + CacheUtil.getRegion("capConRegion").getFullPath());
                    EvictionAttributesMutator mutator = aRegion.getAttributesMutator().getEvictionAttributesMutator();
                    mutator.setMaximum(newMaximumEntries);
                    CapConBB.getBB().getSharedMap().put(CapConBB.CURRENT_POINT, new Integer(currentPoint));
                    CapConBB.getBB().getSharedCounters().increment(CapConBB.NUM_CAPACITY_CHANGES);
                    this.maximumEntries = newMaximumEntries;
                    super.initFields();
                    CapConBB.getBB().getSharedMap().put(CapConBB.TEST_SETTINGS, new Integer(this.maximumEntries));
                    newCapacity = true;
                    newCapacityIsLower = currentPoint < oldCurrentPoint;
                }
            }
            long beforeDestroyNotExp = EventCountersBB.getBB().getSharedCounters().read(EventCountersBB.numAfterDestroyEvents_isNotExp);
            int beforeNumKeys = workRegion.keys().size();
            int afterNumKeys = 0;
            if (this.useTransactions) {
                TxHelper.begin();
            }
            testInstance.addEntry();
            if (TxHelper.exists()) {
                TxHelper.commitExpectSuccess();
            }
            ++count;
            afterNumKeys = workRegion.keys().size();
            CapConBB.getBB().getSharedCounters().setIfLarger(CapConBB.MAX_NUM_KEYS, afterNumKeys);
            Log.getLogWriter().info("After adding an entry: beforeNumKeys = " + beforeNumKeys + ", afterNumKeys = " + afterNumKeys);
            if (newCapacity) {
                double currentNumLRUEvictions = TestHelper.getNumLRUEvictions();
                CapConBB.getBB().getSharedCounters().setIfLarger(CapConBB.NUM_LRU_EVICTIONS_TO_TRIGGER_CAPACITY_CHANGE, (long)currentNumLRUEvictions + 200L);
            }
            if (!isSerialExecution) continue;
            int numEvicted = beforeNumKeys - afterNumKeys + 1;
            if (numEvicted < 0) {
                numEvicted = 0;
            }
            Log.getLogWriter().info("Adding to the region evicted " + numEvicted + " entries");
            if (numEvicted > 0) {
                long expectedDestroys = beforeDestroyNotExp + (long)numEvicted;
                TestHelper.waitForCounter(EventCountersBB.getBB(), "EventCountersBB.numAfterDestroyEvents_isNotExp", EventCountersBB.numAfterDestroyEvents_isNotExp, expectedDestroys, true, 60000L);
            }
            if (newCapacity && newCapacityIsLower) {
                if (afterNumKeys <= this.highestAllowableEntries) continue;
                throw new TestException("After adding to " + TestHelper.regionToString(workRegion, false) + " num keys is " + afterNumKeys + "; expected num keys to <= highestAllowableEntries " + this.highestAllowableEntries + ", " + this.toString());
            }
            if (beforeNumKeys < this.lowestAllowableEntries) {
                if (beforeNumKeys + 1 == afterNumKeys) continue;
                throw new TestException("Before adding to " + TestHelper.regionToString(workRegion, false) + ", num keys was " + beforeNumKeys + ", but after adding  num keys was " + afterNumKeys + "; expected num keys to be " + (beforeNumKeys + 1) + ", " + this.toString());
            }
            if (afterNumKeys <= this.highestAllowableEntries) continue;
            throw new TestException("Before adding to " + TestHelper.regionToString(workRegion, false) + ", num keys was " + beforeNumKeys + ", but after adding  num keys was " + afterNumKeys + "; expected num keys to <= highestAllowableEntries " + this.highestAllowableEntries + ", " + this.toString());
        } while (System.currentTimeMillis() - startTime < timeToRunMS);
        Log.getLogWriter().info("In doDynamicTest, done running for " + timeToRunSec + " seconds, added " + count + " objects to " + TestHelper.regionToString(workRegion, false) + "; " + TestHelper.regionToString(workRegion, false) + " has " + workRegion.keys().size() + " entries");
    }

    private void doSerialDynamicTxTest() {
        long exeNum = CapConBB.getBB().getSharedCounters().incrementAndRead(CapConBB.EXECUTION_NUMBER);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
        Region workRegion = this.getWorkRegion();
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In LRUDynamicTest.doDynamicTxTest, adding for " + timeToRunSec + " seconds");
        int count = 0;
        long startTime = System.currentTimeMillis();
        this.maximumEntries = (Integer)CapConBB.getBB().getSharedMap().get(CapConBB.TEST_SETTINGS);
        super.initFields();
        int currentNumEntries = workRegion.keys().size();
        int numEntriesToChangeCapacity = TestConfig.tab().getRandGen().nextInt(currentNumEntries + 1, this.maximumEntries + 100);
        int numEntriesToEndTx = TestConfig.tab().getRandGen().nextInt(currentNumEntries + 1, this.maximumEntries + 100);
        Log.getLogWriter().info("Setting numEntriesToChangeCapacity to " + numEntriesToChangeCapacity + " numEntriesToEndTx to " + numEntriesToEndTx + " current num entries is " + currentNumEntries);
        TxHelper.begin();
        int numEntriesWhenTxBegan = currentNumEntries;
        boolean done = false;
        do {
            LRUDynamicTest.checkForEventError();
            testInstance.addEntry();
            currentNumEntries = workRegion.keys().size();
            Log.getLogWriter().info("Current number of entries is " + currentNumEntries + ", numEntriesToChangeCapacity is " + numEntriesToChangeCapacity + " numEntriesToEndTx is " + numEntriesToEndTx + " current LRU maximum entries is " + this.maximumEntries);
            if (currentNumEntries == numEntriesToChangeCapacity) {
                int currentPoint = (Integer)CapConBB.getBB().getSharedMap().get(CapConBB.CURRENT_POINT);
                currentPoint = this.randomCapacityChanges ? TestConfig.tab().getRandGen().nextInt(this.regionBounds.getTargetLowPoint(), this.regionBounds.getTargetHighPoint()) : (this.regionBounds.getDirection(currentPoint) == 0 ? ++currentPoint : --currentPoint);
                CapConBB.getBB().getSharedMap().put(CapConBB.CURRENT_POINT, new Integer(currentPoint));
                Region aRegion = CacheUtil.getRegion("capConRegion");
                this.maximumEntries = currentPoint * this.boundsMultiplier;
                super.initFields();
                Log.getLogWriter().info("Setting new capacity (maximumEntries) " + this.maximumEntries + " on " + aRegion.getFullPath() + ", current num entries is " + currentNumEntries);
                EvictionAttributesMutator mutator = aRegion.getAttributesMutator().getEvictionAttributesMutator();
                mutator.setMaximum(this.maximumEntries);
                CapConBB.getBB().getSharedCounters().increment(CapConBB.NUM_CAPACITY_CHANGES);
                int regSizeAfterChangingCap = workRegion.keys().size();
                CapConBB.getBB().getSharedMap().put(CapConBB.TEST_SETTINGS, new Integer(this.maximumEntries));
                if (currentNumEntries != regSizeAfterChangingCap) {
                    throw new TestException("Expected number of entries before changing capacity " + currentNumEntries + " to be equal to num entries after changing capacity " + regSizeAfterChangingCap);
                }
            }
            boolean bl = done = System.currentTimeMillis() - startTime > timeToRunMS;
            if (!done && currentNumEntries != numEntriesToEndTx) continue;
            if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 75) {
                int beforeCommitNumEntries = currentNumEntries;
                Log.getLogWriter().info("Before commit, num entries is " + beforeCommitNumEntries);
                TxHelper.commitExpectSuccess();
                int afterCommitNumEntries = workRegion.keys().size();
                if (beforeCommitNumEntries <= this.maximumEntries) {
                    if (beforeCommitNumEntries != afterCommitNumEntries) {
                        throw new TestException("Before commit, num entries was " + beforeCommitNumEntries + ", after commit num entries was " + afterCommitNumEntries);
                    }
                } else if (afterCommitNumEntries > this.maximumEntries) {
                    throw new TestException("After committing, num entries is " + afterCommitNumEntries + ", but currentCapacity maximumEntries is " + this.maximumEntries);
                }
            } else {
                int numEntriesBeforeRollback = currentNumEntries;
                TxHelper.rollback();
                int numEntriesAfterRollback = workRegion.keys().size();
                if (numEntriesAfterRollback != numEntriesWhenTxBegan) {
                    throw new TestException("When transaction began num entries was " + numEntriesWhenTxBegan + ", before rollback num entries was " + numEntriesBeforeRollback + ", after rollback num entries was " + numEntriesAfterRollback);
                }
            }
            currentNumEntries = workRegion.keys().size();
            numEntriesToChangeCapacity = TestConfig.tab().getRandGen().nextInt(currentNumEntries + 1, this.maximumEntries + 100);
            numEntriesToEndTx = TestConfig.tab().getRandGen().nextInt(currentNumEntries + 1, this.maximumEntries + 100);
            Log.getLogWriter().info("Setting numEntriesToChangeCapacity to " + numEntriesToChangeCapacity + " numEntriesToEndTx to " + numEntriesToEndTx + " current num entries is " + currentNumEntries);
            if (!done) {
                TxHelper.begin();
            }
            numEntriesWhenTxBegan = currentNumEntries;
        } while (!done);
        Log.getLogWriter().info("In doDynamicTxTest, done running for " + timeToRunSec + " seconds, added " + count + " objects to " + TestHelper.regionToString(workRegion, false) + "; " + TestHelper.regionToString(workRegion, false) + " has " + workRegion.keys().size() + " entries");
    }

    @Override
    public CacheListener getEventListener() {
        if (TestConfig.tab().booleanAt(Prms.serialExecution)) {
            return new LRUListener();
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuffer aStr = new StringBuffer();
        aStr.append(super.toString() + "\n");
        aStr.append("   Region bounds:\n");
        aStr.append("      boundsMultiplier: " + this.boundsMultiplier + "\n");
        aStr.append("      regionBounds: " + this.regionBounds + "\n");
        aStr.append("      randomCapacityChanges: " + this.randomCapacityChanges + "\n");
        return aStr.toString();
    }
}

