/*
 * Decompiled with CFR 0.152.
 */
package capCon;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import hydra.ClientDescription;
import hydra.Log;
import hydra.TestConfig;
import util.CacheUtil;
import util.NameFactory;
import util.RegionDefinition;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;

public class DocExamples {
    private static Region rootRegion = null;
    private static final String REGION_NAME = "root";

    public static synchronized void HydraTask_initialize() {
        Cache myCache = CacheUtil.createCache();
        if (rootRegion == null) {
            RegionDefinition regDef = RegionDefinition.createRegionDefinition();
            rootRegion = regDef.createRootRegion(myCache, REGION_NAME, null, null, null);
            DocExamples.createExampleForLRUCapCon();
            DocExamples.createExampleForMemLRUCapCon();
        }
    }

    public static void HydraTask_exerciseControllers() {
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In HydraTask_exerciseControllers, running for " + timeToRunSec + " seconds");
        long startTime = System.currentTimeMillis();
        Region LRURegion = CacheUtil.getCache().getRegion(REGION_NAME).getSubregion("LRU_region");
        Region MemLRURegion = CacheUtil.getCache().getRegion(REGION_NAME).getSubregion("MemLRU_region");
        String clientName = System.getProperty("clientName");
        ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
        do {
            String unique = NameFactory.getNextPositiveObjectName();
            try {
                LRURegion.put((Object)unique, (Object)unique);
                byte[] value = new byte[100];
                MemLRURegion.put((Object)unique, (Object)value);
            }
            catch (Exception e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        } while (System.currentTimeMillis() - startTime < timeToRunMS);
    }

    private static void createExampleForLRUCapCon() {
        AttributesFactory factory = new AttributesFactory();
        EvictionAttributes evAttr = EvictionAttributes.createLRUEntryAttributes((int)100000);
        factory.setEvictionAttributes(evAttr);
        RegionAttributes regAttr = factory.createRegionAttributes();
        try {
            rootRegion.createSubregion("LRU_region", regAttr);
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        Region aRegion = rootRegion.getSubregion("LRU_region");
        Log.getLogWriter().info("Created new region " + aRegion.getFullPath() + " with region attributes " + regAttr);
    }

    private static void createExampleForMemLRUCapCon() {
        AttributesFactory factory = new AttributesFactory();
        EvictionAttributes evAttr = EvictionAttributes.createLRUMemoryAttributes((int)8);
        factory.setEvictionAttributes(evAttr);
        RegionAttributes regAttr = factory.createRegionAttributes();
        try {
            rootRegion.createSubregion("MemLRU_region", regAttr);
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        Region aRegion = rootRegion.getSubregion("MemLRU_region");
        Log.getLogWriter().info("Created new region " + aRegion.getFullPath() + " with region attributes " + regAttr);
    }
}

