/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.gemfire.query;

import cacheperf.CachePerfPrms;
import hydra.HydraConfigException;
import hydra.HydraVector;
import java.util.Iterator;

public class QueryPerfPrms
extends CachePerfPrms {
    private static final String QUERY_PERF_NONE = "none";
    public static Long query;
    public static Long queryRangeMin;
    public static Long queryRangeMax;
    public static Long queryRangeSize;

    public static String getQuery() {
        Long key = query;
        return QueryPerfPrms.getPlusEqualsString(key);
    }

    private static String getPlusEqualsString(Long key) {
        HydraVector v = QueryPerfPrms.tab().vecAt(key, null);
        if (v == null) {
            return null;
        }
        String s = "";
        Iterator i = v.iterator();
        while (i.hasNext()) {
            s = s + (String)i.next();
        }
        return s;
    }

    public static long getQueryRangeMin() {
        Long key = queryRangeMin;
        long val = QueryPerfPrms.tasktab().longAt(key, QueryPerfPrms.tab().longAt(key, 0L));
        if ((double)val < 0.0) {
            String s = "Illegal value for " + QueryPerfPrms.nameForKey(key) + ": " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static long getQueryRangeMax() {
        Long key = queryRangeMax;
        long val = QueryPerfPrms.tasktab().longAt(key, QueryPerfPrms.tab().longAt(key, 0L));
        if ((double)val < 0.0) {
            String s = "Illegal value for " + QueryPerfPrms.nameForKey(key) + ": " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static long getQueryRangeSize() {
        Long key = queryRangeSize;
        long val = QueryPerfPrms.tasktab().longAt(key, QueryPerfPrms.tab().longAt(key, 0L));
        if ((double)val < 0.0) {
            String s = "Illegal value for " + QueryPerfPrms.nameForKey(key) + ": " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static void main(String[] args) {
        QueryPerfPrms.dumpKeys();
    }

    static {
        QueryPerfPrms.setValues(QueryPerfPrms.class);
    }
}

