/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.gemfire.morgan;

import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.NanoTimer;
import hydra.FileUtil;
import hydra.GemFireDescription;
import hydra.Log;
import hydra.TestConfig;
import java.util.Properties;

public class MemberClient {
    public static void bounceConnectionTask() {
        MemberClient c = new MemberClient();
        c.bounceConnection();
    }

    private void bounceConnection() {
        boolean fine = Log.getLogWriter().fineEnabled();
        DistributedSystem ds = null;
        Properties p = this.getDistributedSystemProperties();
        if (fine) {
            Log.getLogWriter().fine("Using connection properties " + p);
        }
        NanoTimer timer = new NanoTimer();
        long connectTime = 0L;
        long disconnectTime = 0L;
        int ops = 50;
        for (int i = 0; i < ops; ++i) {
            if (fine) {
                Log.getLogWriter().fine("Connecting");
            }
            timer.reset();
            ds = DistributedSystem.connect((Properties)p);
            connectTime += timer.reset();
            if (fine) {
                Log.getLogWriter().fine("Disconnecting");
            }
            timer.reset();
            ds.disconnect();
            disconnectTime += timer.reset();
        }
        String report = "Total operations: " + ops + "\nAverage connect time: " + this.averageMs(connectTime, ops) + " ms\nAverage disconnect time: " + this.averageMs(disconnectTime, ops) + " ms\n";
        Log.getLogWriter().info(report);
        FileUtil.writeToFile("perfreport.txt", report);
    }

    private double averageMs(long ns, long i) {
        return (double)ns / (double)(i * 1000000L);
    }

    private Properties getDistributedSystemProperties() {
        String gemfireName = System.getProperty("gemfireName");
        GemFireDescription gfd = TestConfig.getInstance().getGemFireDescription(gemfireName);
        Properties p = gfd.getDistributedSystemProperties();
        p.setProperty("statistic-archive-file", "");
        return p;
    }
}

