/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.serverLocator;

import cacheperf.CachePerfClient;
import cacheperf.CachePerfPrms;
import cacheperf.comparisons.serverLocator.GridPerfPrms;
import com.gemstone.gemfire.cache.client.internal.locator.ClientConnectionRequest;
import com.gemstone.gemfire.distributed.internal.tcpserver.TcpClient;
import hydra.DistributedSystemHelper;
import hydra.HydraThreadLocal;
import hydra.MasterController;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;

public class GridPerfClient
extends CachePerfClient {
    private static final HydraThreadLocal threadLocalInstance = new HydraThreadLocal();
    private String[] groups = GridPerfPrms.getServerGroups();
    private int timeout = GridPerfPrms.getRequestTimeout();
    private int batchCount;
    private int count;
    private int keyCount;
    private int iterationsSinceTxEnd;

    public static GridPerfClient getInstance() throws IOException {
        GridPerfClient instance = (GridPerfClient)threadLocalInstance.get();
        if (instance == null) {
            instance = new GridPerfClient();
            threadLocalInstance.set(instance);
        }
        instance.initialize(14);
        return instance;
    }

    public static void requestServerLocationTask() throws IOException, ClassNotFoundException {
        GridPerfClient.getInstance().requestLocation();
    }

    private void requestLocation() throws IOException, ClassNotFoundException {
        List contacts = DistributedSystemHelper.getContacts();
        DistributedSystemHelper.Endpoint endpoint = (DistributedSystemHelper.Endpoint)contacts.get(this.ttgid % contacts.size());
        InetAddress host = InetAddress.getByName(endpoint.getHost());
        int port = endpoint.getPort();
        boolean batchDone = false;
        do {
            int n = 1;
            if (this.sleepBeforeOp) {
                MasterController.sleepForMs(CachePerfPrms.getSleepMs());
                n = CachePerfPrms.getSleepOpCount();
            }
            for (int j = 0; j < n; ++j) {
                this.executeTaskTerminator();
                this.executeWarmupTerminator();
                this.requestLocation(host, port, j);
                ++this.batchCount;
                ++this.count;
                ++this.keyCount;
                ++this.iterationsSinceTxEnd;
                batchDone = this.executeBatchTerminator();
            }
        } while (!batchDone);
    }

    private void requestLocation(InetAddress host, int port, int i) throws IOException, ClassNotFoundException {
        String group = this.groups == null ? null : this.groups[(this.groups.length + this.ttgid) % i];
        long start = this.statistics.startConnect();
        ClientConnectionRequest request = new ClientConnectionRequest(Collections.EMPTY_SET, group);
        TcpClient.requestToServer((InetAddress)host, (int)port, (Object)request, (int)this.timeout);
        this.statistics.endConnect(start, true, this.histogram);
    }
}

