/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.replicated.execute;

import com.gemstone.gemfire.cache.CacheStatistics;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import java.io.Serializable;

public class RegionEntryHelper {
    protected static Serializable getValue(Region region, Serializable key) {
        Serializable value = null;
        if (RegionEntryHelper.isValid(region, key)) {
            value = (Serializable)region.get((Object)key);
        }
        return value;
    }

    private static boolean isValid(Region region, Serializable key) {
        boolean valid = true;
        Region.Entry entry = region.getEntry((Object)key);
        if (entry != null) {
            long timeout;
            CacheStatistics statistics = entry.getStatistics();
            GemFireCacheImpl cache = (GemFireCacheImpl)region.getCache();
            long msSinceLastAccessed = cache.cacheTimeMillis() - statistics.getLastAccessedTime();
            if (msSinceLastAccessed > (timeout = (long)(region.getAttributes().getEntryIdleTimeout().getTimeout() * 1000))) {
                StringBuilder builder = new StringBuilder();
                builder.append("It has been ").append(msSinceLastAccessed).append(" ms since entry at key=").append(key).append(" was accessed. It should be expired but isn't.");
                region.getCache().getLogger().warning(builder.toString());
                valid = false;
            }
        }
        return valid;
    }
}

