/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.putAll;

import cacheperf.CachePerfClient;
import cacheperf.CachePerfException;
import cacheperf.CachePerfPrms;
import cacheperf.comparisons.putAll.PutAllPerfPrms;
import cacheperf.comparisons.putAll.PutAllPerfStats;
import com.gemstone.gemfire.cache.Region;
import distcache.gemfire.GemFireCacheTestImpl;
import hydra.HydraThreadLocal;
import hydra.MasterController;
import java.util.HashMap;
import java.util.Map;
import objects.ObjectHelper;

public class PutAllPerfClient
extends CachePerfClient {
    protected static final int PUTALL_ENTRIES = 200;
    protected static final String PUTALL_NAME = "putAllEntries";
    protected static final int mapSize = PutAllPerfPrms.getMapSize();
    protected static HashMap[] maps = null;
    protected static int whichMap;
    protected static int numOfMaps;
    public PutAllPerfStats putallstats;
    private static HydraThreadLocal localputallstats;

    public static void putAllTask() {
        PutAllPerfClient c = new PutAllPerfClient();
        c.initialize(200);
        c.executePutAllOperation();
    }

    public static synchronized void initPutAllTask() {
        PutAllPerfClient c = new PutAllPerfClient();
        c.initialize();
        c.initHydraThreadLocals();
        c.generateMapsForPutAll();
    }

    protected void generateMapsForPutAll() {
        if (maps != null) {
            return;
        }
        int count = 0;
        int size = numOfMaps;
        maps = new HashMap[size];
        do {
            HashMap<Object, Object> aMap = new HashMap<Object, Object>();
            int aKey = 1;
            do {
                Object key = ObjectHelper.createName(this.keyType, aKey);
                String objectType = CachePerfPrms.getObjectType();
                Object value = ObjectHelper.createObject(objectType, aKey);
                aMap.put(key, value);
                if (PutAllPerfClient.log().finerEnabled()) {
                    PutAllPerfClient.log().finer("put into putAll map for key = " + key + ", value = " + value);
                }
                ++aKey;
            } while (aMap.size() < mapSize);
            PutAllPerfClient.maps[count] = aMap;
        } while (++count < size);
    }

    protected synchronized HashMap getMap() {
        int i = whichMap % numOfMaps;
        ++whichMap;
        return maps[i];
    }

    private void executePutAllOperation() {
        if (PutAllPerfClient.log().fineEnabled()) {
            PutAllPerfClient.log().fine("executing putAll operation");
        }
        do {
            HashMap aMap = this.getMap();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.putAll(aMap);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
        if (PutAllPerfClient.log().fineEnabled()) {
            PutAllPerfClient.log().fine("finishing executing putAll opeation");
        }
    }

    private void putAll(HashMap aMap) {
        int size = aMap.size();
        Region theRegion = ((GemFireCacheTestImpl)this.cache).getRegion();
        long start = this.putallstats.startPutAll();
        try {
            theRegion.putAll((Map)aMap);
        }
        catch (Exception e) {
            throw new CachePerfException("Could not execute putAll operation ", e);
        }
        this.putallstats.endPutAll(start, size);
        if (PutAllPerfClient.log().finerEnabled()) {
            PutAllPerfClient.log().finer("finished putAll operation for mapSize = " + size);
        }
    }

    public static void openStatisticsTask() {
        PutAllPerfClient c = new PutAllPerfClient();
        c.initHydraThreadLocals();
        c.openStatistics();
        c.updateHydraThreadLocals();
    }

    private void openStatistics() {
        if (this.putallstats == null) {
            PutAllPerfClient.log().info("Opening per-thread putAll performance statistics");
            this.putallstats = PutAllPerfStats.getInstance();
            PutAllPerfClient.log().info("Opened per-thread putAll performance statistics");
        }
    }

    public static void closeStatisticsTask() {
        PutAllPerfClient c = new PutAllPerfClient();
        c.initHydraThreadLocals();
        c.closeStatistics();
        c.updateHydraThreadLocals();
    }

    @Override
    protected void closeStatistics() {
        MasterController.sleepForMs(2000);
        if (this.putallstats != null) {
            PutAllPerfClient.log().info("Closing per-thread putAll performance statistics");
            this.putallstats.close();
            PutAllPerfClient.log().info("Closed per-thread putAll performance statistics");
        }
    }

    @Override
    protected void initHydraThreadLocals() {
        super.initHydraThreadLocals();
        this.putallstats = this.getPutAllStats();
    }

    @Override
    protected void updateHydraThreadLocals() {
        super.updateHydraThreadLocals();
        this.setPutAllStats(this.putallstats);
    }

    protected PutAllPerfStats getPutAllStats() {
        PutAllPerfStats currputallstats = (PutAllPerfStats)localputallstats.get();
        return currputallstats;
    }

    protected void setPutAllStats(PutAllPerfStats putallstats) {
        localputallstats.set(putallstats);
    }

    @Override
    protected String nameFor(int name) {
        switch (name) {
            case 200: {
                return PUTALL_NAME;
            }
        }
        return super.nameFor(name);
    }

    static {
        numOfMaps = 3;
        localputallstats = new HydraThreadLocal();
    }
}

