/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.connection.preload;

import com.gemstone.gemfire.internal.NanoTimer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

public class TimingClassLoader
extends ClassLoader {
    private static final int BUFFER_SIZE = 8192;
    private PrintWriter writer;
    private boolean verbose;
    long bytesTime = 0L;
    long defineTime = 0L;
    long resolveTime = 0L;
    long parentTime = 0L;

    public TimingClassLoader(PrintWriter pw, boolean verbose) {
        super(TimingClassLoader.class.getClassLoader());
        this.writer = pw;
        this.verbose = verbose;
    }

    protected synchronized Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> cls;
        block10: {
            if (this.verbose) {
                this.writer.println(className + "...loading");
            }
            if ((cls = this.findLoadedClass(className)) != null) {
                if (this.verbose) {
                    this.writer.println(className + "...already loaded");
                }
                return cls;
            }
            String clsFile = className.replace('.', '/') + ".class";
            long start = NanoTimer.getTime();
            byte[] classBytes = null;
            try {
                InputStream in = this.getResourceAsStream(clsFile);
                byte[] buffer = new byte[8192];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                int n = -1;
                while ((n = in.read(buffer, 0, 8192)) != -1) {
                    out.write(buffer, 0, n);
                }
                classBytes = out.toByteArray();
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Cannot load class: " + className + e.getMessage());
            }
            if (classBytes == null) {
                throw new ClassNotFoundException("Cannot load class: " + className);
            }
            this.bytesTime += NanoTimer.getTime() - start;
            try {
                start = NanoTimer.getTime();
                cls = this.defineClass(className, classBytes, 0, classBytes.length);
                this.defineTime += NanoTimer.getTime() - start;
                if (resolve) {
                    start = NanoTimer.getTime();
                    this.resolveClass(cls);
                    this.resolveTime += NanoTimer.getTime() - start;
                }
            }
            catch (SecurityException e) {
                start = NanoTimer.getTime();
                cls = super.loadClass(className, resolve);
                this.parentTime += NanoTimer.getTime() - start;
                if (!this.verbose) break block10;
                this.writer.println(className + " loaded by parent class loader");
            }
        }
        return cls;
    }

    public void printBreakdown() {
        this.writer.println("TOTAL TIME: bytesTime = " + this.bytesTime);
        this.writer.println("TOTAL TIME: defineTime = " + this.defineTime);
        this.writer.println("TOTAL TIME: resolveTime = " + this.resolveTime);
        this.writer.println("TOTAL TIME: parentTime = " + this.parentTime);
    }
}

