/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.connection;

import cacheperf.CachePerfClient;
import cacheperf.CachePerfPrms;
import cacheperf.TaskSyncBlackboard;
import cacheperf.comparisons.connection.ConnectionPrms;
import cacheperf.comparisons.connection.preload.Preload;
import cacheperf.comparisons.connection.preload.PreloadPrms;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.NanoTimer;
import hydra.CacheDescription;
import hydra.CacheHelper;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.FileUtil;
import hydra.GemFireDescription;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.PoolDescription;
import hydra.RegionDescription;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class ConnectionClient
extends CachePerfClient {
    public static void preloadResourceTask() throws IOException {
        Preload p = new Preload(PreloadPrms.getResourceFile(), PreloadPrms.useTimingClassLoader(), PreloadPrms.initializeClasses(), PreloadPrms.getOutputFile(), PreloadPrms.verbose());
        p.preloadResource();
    }

    public static void cycleConnectionOnceTask() throws CacheException {
        ConnectionClient cc = new ConnectionClient();
        cc.initialize(14);
        cc.cycleConnectionOnce();
    }

    private void cycleConnectionOnce() throws CacheException {
        String xml = null;
        if (ConnectionPrms.createCacheAndRegion() && ConnectionPrms.useCacheXml() && !FileUtil.exists(xml = this.getCacheXmlFileName())) {
            this.generateCacheXmlFile(xml);
            this.bounceVm();
        }
        String gemfireConfig = System.getProperty("gemfireName");
        GemFireDescription gfd = TestConfig.getInstance().getGemFireDescription(gemfireConfig);
        Properties p = gfd.getDistributedSystemProperties();
        if (xml != null) {
            p.setProperty("cache-xml-file", xml);
        }
        SharedCounters counters = TaskSyncBlackboard.getInstance().getSharedCounters();
        this.cycleDistributedSystemConnection(p, counters);
        if (ConnectionPrms.bounceVm()) {
            if (ConnectionPrms.deleteSystemFiles()) {
                this.deleteSystemDirectory(p);
            }
            this.bounceVm();
        } else if (ConnectionPrms.deleteSystemFiles()) {
            this.deleteSystemFiles(p);
        }
    }

    private void cycleDistributedSystemConnection(Properties p, SharedCounters counters) throws CacheException {
        long start;
        boolean acquireConnection = ConnectionPrms.acquireConnection();
        long start1 = start = NanoTimer.getTime();
        DistributedSystem ds = DistributedSystem.connect((Properties)p);
        long start2 = NanoTimer.getTime();
        long elapsed1 = start2 - start1;
        if (ConnectionPrms.createCacheAndRegion()) {
            PoolImpl thePool = null;
            Cache theCache = null;
            Region theRegion = null;
            if (ConnectionPrms.useCacheXml()) {
                theCache = CacheFactory.create((DistributedSystem)ds);
                String poolConfig = ConfigPrms.getPoolConfig();
                if (poolConfig != null) {
                    thePool = (PoolImpl)PoolManager.find((String)poolConfig);
                    if (acquireConnection) {
                        thePool.acquireConnection();
                    }
                }
            } else {
                String poolConfig = ConfigPrms.getPoolConfig();
                if (poolConfig != null) {
                    PoolDescription pd = TestConfig.getInstance().getPoolDescription(poolConfig);
                    PoolFactory poolFactory = PoolManager.createFactory();
                    pd.configure(poolFactory);
                    thePool = (PoolImpl)poolFactory.create(poolConfig);
                    if (acquireConnection) {
                        thePool.acquireConnection();
                    }
                }
                String cacheConfig = ConfigPrms.getCacheConfig();
                CacheDescription cd = TestConfig.getInstance().getCacheDescription(cacheConfig);
                theCache = CacheFactory.create((DistributedSystem)ds);
                cd.configure(theCache);
                String regionConfig = ConfigPrms.getRegionConfig();
                RegionDescription rd = TestConfig.getInstance().getRegionDescription(regionConfig);
                AttributesFactory regionFactory = new AttributesFactory();
                rd.configure(regionFactory, true);
                RegionAttributes ratts = regionFactory.create();
                theRegion = theCache.createRegion("RecycledRegion", ratts);
            }
            if (theRegion != null) {
                theRegion.close();
            }
            if (theCache != null) {
                theCache.close();
            }
            if (thePool != null) {
                thePool.destroy();
            }
        }
        long start3 = NanoTimer.getTime();
        long elapsed2 = start3 - start2;
        ds.disconnect();
        long end = NanoTimer.getTime();
        long elapsed3 = end - start3;
        long elapsed = end - start;
        counters.increment(TaskSyncBlackboard.ops);
        counters.add(TaskSyncBlackboard.opTime, elapsed);
        counters.add(TaskSyncBlackboard.opTime1, elapsed1);
        counters.add(TaskSyncBlackboard.opTime2, elapsed2);
        counters.add(TaskSyncBlackboard.opTime3, elapsed3);
        if (ConnectionPrms.logTimes()) {
            String s = "Total: " + elapsed + " Connect: " + elapsed1 + " Cache/Region: " + elapsed2 + " Disconnect: " + elapsed3;
            Log.getLogWriter().info(s);
        }
    }

    private void generateCacheXmlFile(String fn) {
        DistributedSystemHelper.connect();
        CacheHelper.generateCacheXmlFile(ConfigPrms.getCacheConfig(), ConfigPrms.getRegionConfig(), ConfigPrms.getBridgeConfig(), ConfigPrms.getPoolConfig(), fn);
        DistributedSystemHelper.disconnect();
    }

    private String getCacheXmlFileName() {
        return System.getProperty("user.dir") + "/" + System.getProperty("clientName") + ".xml";
    }

    private void bounceVm() {
        try {
            ClientVmMgr.stop("Bouncing myself", -20, CachePerfPrms.getSleepMs());
        }
        catch (ClientVmNotFoundException e) {
            throw new HydraRuntimeException("Unable to bounce myself", e);
        }
    }

    private void deleteSystemDirectory(Properties p) {
        String dir = this.getSystemDirectory(p);
        if (dir != null) {
            FileUtil.rmdir(dir, true);
        }
    }

    private void deleteSystemFiles(Properties p) {
        String dir = this.getSystemDirectory(p);
        if (dir != null) {
            FileUtil.deleteFilesFromDir(dir);
        }
    }

    private String getSystemDirectory(Properties p) {
        String dir = null;
        String fn = p.getProperty("log-file");
        if (fn != null) {
            File f = new File(fn);
            dir = f.getParent().toString();
        }
        return dir;
    }
}

