/*
 * Decompiled with CFR 0.152.
 */
package cacheperf;

import cacheperf.CachePerfClient;
import cacheperf.CachePerfException;
import cacheperf.CachePerfPrms;
import cacheperf.TaskSyncBlackboard;
import getInitialImage.InitImageBB;
import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.Log;
import java.util.List;
import perffmwk.PerfStatException;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;

public class Terminators {
    private static long lruEvictionsMinTime = 0L;
    private static long lruEvictionsMaxTime = 0L;
    private static long numDestroysMinTime = 0L;
    private static long numDestroysMaxTime = 0L;

    public static boolean terminateOnBatchSeconds(CachePerfClient c) {
        if (c.batchSeconds == -1) {
            String s = BasePrms.nameForKey(CachePerfPrms.batchSeconds) + " is not set";
            throw new HydraConfigException(s);
        }
        if (System.currentTimeMillis() >= c.batchStartTime + (long)(c.batchSeconds * 1000)) {
            if (CachePerfClient.log().fineEnabled()) {
                Log.getLogWriter().fine("Completed " + c.batchSeconds + " batch seconds");
            }
            return true;
        }
        return false;
    }

    public static boolean terminateOnBatchSize(CachePerfClient c) {
        if (c.batchSize == -1) {
            throw new HydraConfigException(BasePrms.nameForKey(CachePerfPrms.batchSize) + " is not set");
        }
        if (c.batchCount >= c.batchSize) {
            if (CachePerfClient.log().fineEnabled()) {
                Log.getLogWriter().fine("Completed " + c.batchCount + " batch iterations");
            }
            return true;
        }
        return false;
    }

    public static boolean terminateOnTrimSeconds(CachePerfClient c) {
        if (c.trimSeconds == -1) {
            String s = BasePrms.nameForKey(CachePerfPrms.trimSeconds) + " is not set";
            throw new HydraConfigException(s);
        }
        long elapsed = System.currentTimeMillis() - c.startTime;
        if (elapsed >= (long)(c.trimSeconds * 1000)) {
            Log.getLogWriter().info("Completed " + elapsed / 1000L + " trim seconds");
            return true;
        }
        return false;
    }

    public static boolean terminateAndSignalOnTrimSeconds(CachePerfClient c) {
        boolean terminate = Terminators.terminateOnTrimSeconds(c);
        if (terminate) {
            TaskSyncBlackboard.getInstance().getSharedCounters().increment(TaskSyncBlackboard.trimSignal);
        }
        return terminate;
    }

    public static boolean terminateOnWorkSeconds(CachePerfClient c) {
        long elapsed;
        if (c.workSeconds == -1) {
            String s = BasePrms.nameForKey(CachePerfPrms.workSeconds) + " is not set";
            throw new HydraConfigException(s);
        }
        if (c.warmupTime != -1L && (elapsed = System.currentTimeMillis() - c.startTime - c.warmupTime) >= (long)(c.workSeconds * 1000)) {
            String s = "Completed " + elapsed / 1000L + " work seconds after " + c.warmupTime / 1000L + " warmup seconds";
            if (c.syncSleepMs > 0) {
                s = s + " (including syncSleepMs=" + c.syncSleepMs + ")";
            }
            Log.getLogWriter().info(s);
            return true;
        }
        return false;
    }

    public static boolean terminateOnTotalSeconds(CachePerfClient c) {
        if (c.trimSeconds == -1) {
            String s = BasePrms.nameForKey(CachePerfPrms.trimSeconds) + " is not set";
            throw new HydraConfigException(s);
        }
        if (c.workSeconds == -1) {
            String s = BasePrms.nameForKey(CachePerfPrms.workSeconds) + " is not set";
            throw new HydraConfigException(s);
        }
        long elapsed = System.currentTimeMillis() - c.startTime;
        if (elapsed >= (long)((c.trimSeconds + c.workSeconds) * 1000)) {
            String s = "Completed " + elapsed / 1000L + " total seconds";
            if (c.syncSleepMs > 0) {
                s = s + " (including syncSleepMs=" + c.syncSleepMs + ")";
            }
            Log.getLogWriter().info(s);
            return true;
        }
        return false;
    }

    public static boolean terminateOnTrimIterations(CachePerfClient c) {
        if (c.trimIterations == -1) {
            throw new HydraConfigException(BasePrms.nameForKey(CachePerfPrms.trimIterations) + " is not set");
        }
        if (c.count >= c.trimIterations) {
            Log.getLogWriter().info("Completed " + c.count + " trim iterations");
            return true;
        }
        return false;
    }

    public static boolean terminateOnWorkIterations(CachePerfClient c) {
        if (c.workIterations == -1) {
            throw new HydraConfigException(BasePrms.nameForKey(CachePerfPrms.workIterations) + " is not set");
        }
        if (c.warmupCount != -1 && c.count >= c.workIterations + c.warmupCount) {
            Log.getLogWriter().info("Completed " + c.workIterations + " work iterations after " + c.warmupCount + " warmup iterations");
            return true;
        }
        return false;
    }

    public static boolean terminateOnTotalIterations(CachePerfClient c) {
        if (c.trimIterations == -1) {
            throw new HydraConfigException(BasePrms.nameForKey(CachePerfPrms.trimIterations) + " is not set");
        }
        if (c.workIterations == -1) {
            throw new HydraConfigException(BasePrms.nameForKey(CachePerfPrms.workIterations) + " is not set");
        }
        if (c.count >= c.trimIterations + c.workIterations) {
            Log.getLogWriter().info("Completed " + c.count + " total iterations");
            return true;
        }
        return false;
    }

    public static boolean terminateOnMaxKey(CachePerfClient c) {
        if (c.currentKey >= c.maxKeys) {
            Log.getLogWriter().info("Completed " + c.currentKey + " keys, surpasses max key");
            return true;
        }
        return false;
    }

    public static boolean terminateOnNumOperations(CachePerfClient c) {
        if (c.numOperations == -1) {
            throw new HydraConfigException(BasePrms.nameForKey(CachePerfPrms.numOperations) + " is not set");
        }
        if (c.count >= c.numOperations) {
            Log.getLogWriter().info("Completed " + c.count + " operations");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean terminateOnLRUEvictions(CachePerfClient c) {
        if (CachePerfClient.log().fineEnabled()) {
            CachePerfClient.log().fine("Checking termination on LRU evictions");
        }
        int lruEvictions = CachePerfPrms.LRUEvictions();
        int lruEvictionsMinWaitSec = CachePerfPrms.LRUEvictionsMinWaitSec();
        int lruEvictionsMaxWaitSec = CachePerfPrms.LRUEvictionsMaxWaitSec();
        if (lruEvictionsMaxWaitSec > 0 && lruEvictionsMaxWaitSec <= lruEvictionsMinWaitSec) {
            String s = BasePrms.nameForKey(CachePerfPrms.LRUEvictionsMaxWaitSec) + "(" + lruEvictionsMaxWaitSec + ") is less than " + BasePrms.nameForKey(CachePerfPrms.LRUEvictionsMinWaitSec) + "(" + lruEvictionsMinWaitSec + ")";
            throw new HydraConfigException(s);
        }
        boolean result = Terminators.checkStat("LRUStatistics", "lruEvictions", lruEvictions, false);
        long now = System.currentTimeMillis();
        if (result && lruEvictionsMinWaitSec != 0) {
            if (lruEvictionsMinTime == 0L) {
                Class<Terminators> clazz = Terminators.class;
                // MONITORENTER : cacheperf.Terminators.class
                if (lruEvictionsMinTime == 0L) {
                    lruEvictionsMinTime = now + (long)(lruEvictionsMinWaitSec * 1000);
                }
                // MONITOREXIT : clazz
            }
            if (now >= lruEvictionsMinTime) return result;
            return false;
        }
        if (result) return result;
        if (lruEvictionsMaxWaitSec == 0) return result;
        if (lruEvictionsMaxTime == 0L) {
            Class<Terminators> clazz = Terminators.class;
            // MONITORENTER : cacheperf.Terminators.class
            if (lruEvictionsMaxTime == 0L) {
                lruEvictionsMaxTime = now + (long)(lruEvictionsMaxWaitSec * 1000);
            }
            // MONITOREXIT : clazz
        }
        if (now <= lruEvictionsMaxTime) return result;
        String s = "Failed to evict " + BasePrms.nameForKey(CachePerfPrms.LRUEvictions) + "(" + lruEvictions + ") entries within " + BasePrms.nameForKey(CachePerfPrms.LRUEvictionsMaxWaitSec) + "(" + lruEvictionsMaxWaitSec + ") seconds";
        throw new CachePerfException(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean terminateOnNumDestroys(CachePerfClient c) {
        if (CachePerfClient.log().fineEnabled()) {
            CachePerfClient.log().fine("Checking termination on num destroys");
        }
        int numDestroys = CachePerfPrms.numDestroys();
        int numDestroysMinWaitSec = CachePerfPrms.numDestroysMinWaitSec();
        int numDestroysMaxWaitSec = CachePerfPrms.numDestroysMaxWaitSec();
        if (numDestroysMaxWaitSec > 0 && numDestroysMaxWaitSec <= numDestroysMinWaitSec) {
            String s = BasePrms.nameForKey(CachePerfPrms.numDestroysMaxWaitSec) + "(" + numDestroysMaxWaitSec + ") is less than " + BasePrms.nameForKey(CachePerfPrms.numDestroysMinWaitSec) + "(" + numDestroysMinWaitSec + ")";
            throw new HydraConfigException(s);
        }
        boolean result = Terminators.checkStat("CachePerfStats", "destroys", numDestroys, true);
        long now = System.currentTimeMillis();
        if (result && numDestroysMinWaitSec != 0) {
            if (numDestroysMinTime == 0L) {
                Class<Terminators> clazz = Terminators.class;
                // MONITORENTER : cacheperf.Terminators.class
                if (numDestroysMinTime == 0L) {
                    numDestroysMinTime = now + (long)(numDestroysMinWaitSec * 1000);
                }
                // MONITOREXIT : clazz
            }
            if (now >= numDestroysMinTime) return result;
            return false;
        }
        if (result) return result;
        if (numDestroysMaxWaitSec == 0) return result;
        if (numDestroysMaxTime == 0L) {
            Class<Terminators> clazz = Terminators.class;
            // MONITORENTER : cacheperf.Terminators.class
            if (numDestroysMaxTime == 0L) {
                numDestroysMaxTime = now + (long)(numDestroysMaxWaitSec * 1000);
            }
            // MONITOREXIT : clazz
        }
        if (now <= numDestroysMaxTime) return result;
        String s = "Failed to evict " + BasePrms.nameForKey(CachePerfPrms.numDestroys) + "(" + numDestroys + ") entries within " + BasePrms.nameForKey(CachePerfPrms.numDestroysMaxWaitSec) + "(" + numDestroysMaxWaitSec + ") seconds";
        throw new CachePerfException(s);
    }

    private static boolean checkStat(String statType, String statName, int minAcceptable, boolean exactMatch) {
        String spec = "* " + statType + " * " + statName + " " + "filter" + "=" + "none" + " " + "combine" + "=" + "combine" + " " + "ops" + "=" + "max";
        int maxTries = 500;
        String errStr = null;
        for (int tryCount = 1; tryCount <= 500; ++tryCount) {
            List aList = null;
            try {
                aList = PerfStatMgr.getInstance().readStatistics(spec, exactMatch);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                errStr = e.toString();
                continue;
            }
            if (aList == null) {
                throw new PerfStatException("Statistics not found: " + spec);
            }
            boolean allArchivesMeetCriteria = true;
            StringBuffer aStr = new StringBuffer();
            for (int i = 0; i < aList.size(); ++i) {
                PerfStatValue stat = (PerfStatValue)aList.get(i);
                double currValue = stat.getMax();
                aStr.append(statName + ": " + stat + "\n");
                if (!(currValue < (double)minAcceptable)) continue;
                allArchivesMeetCriteria = false;
                break;
            }
            if (allArchivesMeetCriteria && Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().fine("Warmup criteria has been met in " + tryCount + " stat reads; minimum acceptable value of the max is " + minAcceptable + ": " + aStr);
            }
            return allArchivesMeetCriteria;
        }
        throw new CachePerfException("Could not get stats in 500 attempts; " + errStr);
    }

    public static boolean terminateOnSignal(CachePerfClient c) {
        return TaskSyncBlackboard.getInstance().getSharedCounters().read(TaskSyncBlackboard.signal) != 0L;
    }

    public static boolean terminateOnGetInitialImageInProgress(CachePerfClient c) {
        return InitImageBB.getBB().getSharedCounters().read(InitImageBB.getInitialImageInProgress) != 0L;
    }

    public static boolean terminateOnGetInitialImageComplete(CachePerfClient c) {
        return InitImageBB.getBB().getSharedCounters().read(InitImageBB.getInitialImageComplete) != 0L;
    }
}

