/*
 * Decompiled with CFR 0.152.
 */
package cacheperf;

import cacheperf.CachePerfStatsVersion;
import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.NanoTimer;
import distcache.DistCache;
import perffmwk.HistogramStats;
import perffmwk.PerformanceStatistics;

public class CachePerfStats
extends PerformanceStatistics {
    private static final int SCOPE = 0;
    public static final String VM_COUNT = "vmCount";
    public static final String OPS = "operations";
    public static final String OP_TIME = "operationTime";
    public static final String OP_TIME1 = "operationTime1";
    public static final String OP_TIME2 = "operationTime2";
    public static final String OP_TIME3 = "operationTime3";
    public static final String CACHEOPENS = "cacheOpens";
    public static final String CACHEOPEN_TIME = "cacheOpenTime";
    public static final String CACHECLOSES = "cacheCloses";
    public static final String CACHECLOSE_TIME = "cacheCloseTime";
    public static final String REGISTERINTERESTS = "registerInterests";
    public static final String REGISTERINTEREST_TIME = "registerInterestTime";
    public static final String CREATES = "creates";
    public static final String CREATE_TIME = "createTime";
    public static final String CREATEKEYS = "createKeys";
    public static final String CREATEKEY_TIME = "createKeyTime";
    public static final String PUTALLS = "putAlls";
    public static final String PUTS = "puts";
    public static final String PUT_TIME = "putTime";
    public static final String GETALLS = "getAlls";
    public static final String GETS = "gets";
    public static final String GET_TIME = "getTime";
    public static final String UPDATES = "updates";
    public static final String UPDATE_TIME = "updateTime";
    public static final String COMBINEDPUTGETS = "combinedPutGets";
    public static final String COMBINEDPUTGET_TIME = "combinedPutGetTime";
    public static final String PUTCOMPARISONS = "putComparisons";
    public static final String PUTCOMPARISON_TIME = "putComparisonTime";
    public static final String GETCOMPARISONS = "getComparisons";
    public static final String GETCOMPARISON_TIME = "getComparisonTime";
    public static final String DESTROYS = "destroys";
    public static final String DESTROY_TIME = "destroyTime";
    public static final String CREATE_EVENTS = "createEvents";
    public static final String DESTROY_EVENTS = "destroyEvents";
    public static final String UPDATE_EVENTS = "updateEvents";
    public static final String UPDATE_LATENCY = "updateLatency";
    public static final String NULLS = "nulls";
    public static final String LATENCY_SPIKES = "latencySpikes";
    public static final String NEGATIVE_LATENCIES = "negativeLatencies";
    public static final String USECASE12_UPDATES = "useCase12Updates";
    public static final String USECASE12_UPDATE_TIME = "useCase12UpdatesTime";
    public static final String CONNECTS = "connects";
    public static final String CONNECT_TIME = "connectTime";
    public static final String DISCONNECTS = "disconnects";
    public static final String DISCONNECT_TIME = "disconnectTime";
    public static final String QUERIES = "queries";
    public static final String QUERY_RESULTS = "querieResults";
    public static final String QUERY_TIME = "queryTime";
    public static final String REBALANCES = "rebalances";
    public static final String REBALANCE_TIME = "rebalanceTime";
    public static final String RECOVERIES = "recoveries";
    public static final String RECOVERY_TIME = "recoveryTime";
    public static final String LOCKS = "locks";
    public static final String LOCK_TIME = "lockTime";
    public static final String GATEWAY_QUEUE_DRAINS = "gatewayQueueDrains";
    public static final String GATEWAY_QUEUE_DRAIN_TIME = "gatewayQueueDrainTime";
    public static final String LOCALRECOVERY_TIME = "localRecoveryTime";
    public static final String REMOTERECOVERY_TIME = "remoteRecoveryTime";
    private static boolean VMCounted = false;

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean largerIsBetter = true;
        return new StatisticDescriptor[]{CachePerfStats.factory().createIntGauge(VM_COUNT, "When aggregated, the number of VMs using this statistics object.", "VMs"), CachePerfStats.factory().createIntCounter(OPS, "Number of operations completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(OP_TIME, "Total time spent doing operations.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createLongCounter(OP_TIME1, "Total time spent connecting DS.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createLongCounter(OP_TIME2, "Total time spent creating cache and closing it.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createLongCounter(OP_TIME3, "Total time spent disconnecting DS.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(CACHEOPENS, "Number of cache opens completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(CACHEOPEN_TIME, "Total time spent opening caches.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(CACHECLOSES, "Number of cache closes completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(CACHECLOSE_TIME, "Total time spent closing caches.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(REGISTERINTERESTS, "Number of register interests completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(REGISTERINTEREST_TIME, "Total time spent registering interest.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(CREATES, "Number of creates completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(CREATE_TIME, "Total time spent doing creates.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(CREATEKEYS, "Number of createKeys completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(CREATEKEY_TIME, "Total time spent doing createKeys.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(PUTALLS, "Number of putAlls completed.", OPS, largerIsBetter), CachePerfStats.factory().createIntCounter(PUTS, "Number of puts completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(PUT_TIME, "Total time spent doing puts.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(COMBINEDPUTGETS, "Number of combined put and get operations completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(COMBINEDPUTGET_TIME, "Total time spent doing combined put and gets.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(GETALLS, "Number of getAlls completed.", OPS, largerIsBetter), CachePerfStats.factory().createIntCounter(GETS, "Number of gets completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(GET_TIME, "Total time spent doing gets.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(UPDATES, "Number of updates completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(UPDATE_TIME, "Total time spent doing updates.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(PUTCOMPARISONS, "Number of put comparisons completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(PUTCOMPARISON_TIME, "Total time spent doing put comparisons.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(GETCOMPARISONS, "Number of get comparisons completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(GETCOMPARISON_TIME, "Total time spent doing get comparisons.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(DESTROYS, "Number of destroys completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(DESTROY_TIME, "Total time spent doing destroys.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(CREATE_EVENTS, "Number of create events.", "events", largerIsBetter), CachePerfStats.factory().createIntCounter(DESTROY_EVENTS, "Number of destroy events.", "events", largerIsBetter), CachePerfStats.factory().createIntCounter(UPDATE_EVENTS, "Number of update events.", "events", largerIsBetter), CachePerfStats.factory().createLongCounter(UPDATE_LATENCY, "Latency of update operations.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(NULLS, "Number of null objects received.", NULLS, !largerIsBetter), CachePerfStats.factory().createIntCounter(LATENCY_SPIKES, "Number of latency spikes.", "spikes", !largerIsBetter), CachePerfStats.factory().createIntCounter(NEGATIVE_LATENCIES, "Number of negative latencies (caused by insufficient clock skew correction).", "negatives", !largerIsBetter), CachePerfStats.factory().createIntCounter(USECASE12_UPDATES, "Number of UseCase12 updates completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(USECASE12_UPDATE_TIME, "Total time spent doing UseCase12 updates", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(CONNECTS, "Number of connects completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(CONNECT_TIME, "Total time spent doing connects.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(DISCONNECTS, "Number of disconnects completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(DISCONNECT_TIME, "Total time spent doing disconnects.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(QUERIES, "Number of queries completed.", OPS, largerIsBetter), CachePerfStats.factory().createIntCounter(QUERY_RESULTS, "Size of query result set.", "entries", largerIsBetter), CachePerfStats.factory().createLongCounter(QUERY_TIME, "Total time spent doing queries.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(REBALANCES, "Number of rebalances completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(REBALANCE_TIME, "Total time spent doing rebalances.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(RECOVERIES, "Number of recoveries completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(RECOVERY_TIME, "Total time spent doing recoveries.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(LOCKS, "Number of locks completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(LOCK_TIME, "Total time spent doing locks.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createIntCounter(GATEWAY_QUEUE_DRAINS, "Number of gateway queue drains completed.", OPS, largerIsBetter), CachePerfStats.factory().createLongCounter(GATEWAY_QUEUE_DRAIN_TIME, "Total time spent waiting for gateway queues to drain.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createLongCounter(LOCALRECOVERY_TIME, "Total time spent recovering from disk.", "nanoseconds", !largerIsBetter), CachePerfStats.factory().createLongCounter(REMOTERECOVERY_TIME, "Total time spent recovering from a remote VM (disk recovery with gii correlation).", "nanoseconds", !largerIsBetter)};
    }

    public static CachePerfStats getInstance() {
        CachePerfStats cps = (CachePerfStats)CachePerfStats.getInstance(CachePerfStats.class, 0);
        cps.incVMCount();
        return cps;
    }

    public static CachePerfStats getInstance(int scope) {
        CachePerfStats cps = (CachePerfStats)CachePerfStats.getInstance(CachePerfStats.class, scope);
        cps.incVMCount();
        return cps;
    }

    public static CachePerfStats getInstance(String name) {
        CachePerfStats cps = (CachePerfStats)CachePerfStats.getInstance(CachePerfStats.class, 0, name);
        cps.incVMCount();
        return cps;
    }

    public static CachePerfStats getInstance(String name, String trimspecName) {
        CachePerfStats cps = (CachePerfStats)CachePerfStats.getInstance(CachePerfStats.class, 0, name, trimspecName);
        cps.incVMCount();
        return cps;
    }

    public CachePerfStats(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    public int getOps() {
        return this.statistics().getInt(OPS);
    }

    public long getOpTime() {
        return this.statistics().getLong(OP_TIME);
    }

    public int getCacheOpens() {
        return this.statistics().getInt(CACHEOPENS);
    }

    public long getCacheOpenTime() {
        return this.statistics().getLong(CACHEOPEN_TIME);
    }

    public int getCacheCloses() {
        return this.statistics().getInt(CACHECLOSES);
    }

    public long getCacheCloseTime() {
        return this.statistics().getLong(CACHECLOSE_TIME);
    }

    public int getRegisterInterests() {
        return this.statistics().getInt(REGISTERINTERESTS);
    }

    public long getRegisterInterestTime() {
        return this.statistics().getLong(REGISTERINTEREST_TIME);
    }

    public int getCreates() {
        return this.statistics().getInt(CREATES);
    }

    public long getCreateTime() {
        return this.statistics().getLong(CREATE_TIME);
    }

    public int getCreateKeys() {
        return this.statistics().getInt(CREATEKEYS);
    }

    public long getCreateKeyTime() {
        return this.statistics().getLong(CREATEKEY_TIME);
    }

    public int getPuts() {
        return this.statistics().getInt(PUTS);
    }

    public long getPutTime() {
        return this.statistics().getLong(PUT_TIME);
    }

    public int getCombinedPutGets() {
        return this.statistics().getInt(COMBINEDPUTGETS);
    }

    public long getCombinedPutGetTime() {
        return this.statistics().getLong(COMBINEDPUTGET_TIME);
    }

    public int getGets() {
        return this.statistics().getInt(GETS);
    }

    public long getGetTime() {
        return this.statistics().getLong(GET_TIME);
    }

    public int getUpdates() {
        return this.statistics().getInt(UPDATES);
    }

    public long getUpdateTime() {
        return this.statistics().getLong(UPDATE_TIME);
    }

    public int getPutComparisons() {
        return this.statistics().getInt(PUTCOMPARISONS);
    }

    public long getPutComparisonTime() {
        return this.statistics().getLong(PUTCOMPARISON_TIME);
    }

    public int getGetComparisons() {
        return this.statistics().getInt(GETCOMPARISONS);
    }

    public long getGetComparisonTime() {
        return this.statistics().getLong(GETCOMPARISON_TIME);
    }

    public int getDestroys() {
        return this.statistics().getInt(DESTROYS);
    }

    public long getDestroyTime() {
        return this.statistics().getLong(DESTROY_TIME);
    }

    public int getNulls() {
        return this.statistics().getInt(NULLS);
    }

    public int getLatencySpikes() {
        return this.statistics().getInt(LATENCY_SPIKES);
    }

    public int getNegativeLatencies() {
        return this.statistics().getInt(NEGATIVE_LATENCIES);
    }

    public int getUseCase12Updates() {
        return this.statistics().getInt(USECASE12_UPDATES);
    }

    public long getUseCase12UpdateTime() {
        return this.statistics().getLong(USECASE12_UPDATE_TIME);
    }

    public int getConnects() {
        return this.statistics().getInt(CONNECTS);
    }

    public long getConnectTime() {
        return this.statistics().getLong(CONNECT_TIME);
    }

    public int getDisConnects() {
        return this.statistics().getInt(DISCONNECTS);
    }

    public long getDisConnectTime() {
        return this.statistics().getLong(DISCONNECT_TIME);
    }

    public int getQueries() {
        return this.statistics().getInt(QUERIES);
    }

    public int getQueryResults() {
        return this.statistics().getInt(QUERY_RESULTS);
    }

    public long getQueryTime() {
        return this.statistics().getLong(QUERY_TIME);
    }

    public int getRebalances() {
        return this.statistics().getInt(REBALANCES);
    }

    public long getRebalanceTime() {
        return this.statistics().getLong(REBALANCE_TIME);
    }

    public int getRecoveries() {
        return this.statistics().getInt(RECOVERIES);
    }

    public long getRecoveryTime() {
        return this.statistics().getLong(RECOVERY_TIME);
    }

    public int getLocks() {
        return this.statistics().getInt(LOCKS);
    }

    public long getLockTime() {
        return this.statistics().getLong(LOCK_TIME);
    }

    public int getGatewayQueueDrains() {
        return this.statistics().getInt(GATEWAY_QUEUE_DRAINS);
    }

    public long getGatewayQueueDrainTime() {
        return this.statistics().getLong(GATEWAY_QUEUE_DRAIN_TIME);
    }

    public void incHistogram(HistogramStats histogram, long amount) {
        if (histogram != null) {
            histogram.incBin(amount);
        }
    }

    private synchronized void incVMCount() {
        if (!VMCounted) {
            this.statistics().incInt(VM_COUNT, 1);
            VMCounted = true;
        }
    }

    protected void setOps(int amount) {
        this.statistics().setInt(OPS, amount);
    }

    protected void setOpTime(long amount) {
        this.statistics().setLong(OP_TIME, amount);
    }

    protected void setOpTime1(long amount) {
        this.statistics().setLong(OP_TIME1, amount);
    }

    protected void setOpTime2(long amount) {
        this.statistics().setLong(OP_TIME2, amount);
    }

    protected void setOpTime3(long amount) {
        this.statistics().setLong(OP_TIME3, amount);
    }

    public void incCacheOpens(boolean isMainWorkload) {
        this.incCacheOpens(1, isMainWorkload);
    }

    public void incCacheOpens(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(CACHEOPENS, amount);
    }

    public void incCacheOpenTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(CACHEOPEN_TIME, amount);
    }

    public long startCacheOpen() {
        return NanoTimer.getTime();
    }

    public void endCacheOpen(long start, boolean isMainWorkload, DistCache theCache, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incCacheOpens(1, isMainWorkload);
        this.incCacheOpenTime(elapsed, isMainWorkload);
        CachePerfStatsVersion.endDiskRecovery(elapsed, theCache, this.statistics());
        this.incHistogram(histogram, elapsed);
    }

    public void incCacheCloses(boolean isMainWorkload) {
        this.incCacheCloses(1, isMainWorkload);
    }

    public void incCacheCloses(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(CACHECLOSES, amount);
    }

    public void incCacheCloseTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(CACHECLOSE_TIME, amount);
    }

    public long startCacheClose() {
        return NanoTimer.getTime();
    }

    public void endCacheClose(long start, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incCacheCloses(1, isMainWorkload);
        this.incCacheCloseTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void incRegisterInterests(boolean isMainWorkload) {
        this.incRegisterInterests(1, isMainWorkload);
    }

    public void incRegisterInterests(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(REGISTERINTERESTS, amount);
    }

    public void incRegisterInterestTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(REGISTERINTEREST_TIME, amount);
    }

    public long startRegisterInterest() {
        return NanoTimer.getTime();
    }

    public void endRegisterInterest(long start, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incRegisterInterests(1, isMainWorkload);
        this.incRegisterInterestTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void incCreates(boolean isMainWorkload) {
        this.incCreates(1, isMainWorkload);
    }

    public void incCreates(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(CREATES, amount);
    }

    public void incCreateTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(CREATE_TIME, amount);
    }

    public long startCreate() {
        return NanoTimer.getTime();
    }

    public void endCreate(long start, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incCreates(1, isMainWorkload);
        this.incCreateTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void endCreate(long start, int amount, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incCreates(amount, isMainWorkload);
        this.incCreateTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void incCreateKeys(boolean isMainWorkload) {
        this.incCreateKeys(1, isMainWorkload);
    }

    public void incCreateKeys(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(CREATEKEYS, amount);
    }

    public void incCreateKeyTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(CREATEKEY_TIME, amount);
    }

    public long startCreateKey() {
        return NanoTimer.getTime();
    }

    public void endCreateKey(long start, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incCreateKeys(1, isMainWorkload);
        this.incCreateKeyTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void incPutAlls() {
        this.statistics().incInt(PUTALLS, 1);
    }

    public void incPuts(boolean isMainWorkload) {
        this.incPuts(1, isMainWorkload);
    }

    public void incPuts(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(PUTS, amount);
    }

    public void incPutTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(PUT_TIME, amount);
    }

    public long startPut() {
        return NanoTimer.getTime();
    }

    public void endPut(long start, boolean isMainWorkload, HistogramStats histogram) {
        this.endPut(start, 1, isMainWorkload, histogram);
    }

    public void endPut(long start, int amount, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incPuts(amount, isMainWorkload);
        this.incPutTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void endPutAll(long start, int amount, boolean isMainWorkload, HistogramStats histogram) {
        this.incPutAlls();
        this.endPut(start, amount, isMainWorkload, histogram);
    }

    public void incCombinedPutGets(boolean isMainWorkload) {
        this.incCombinedPutGets(1, isMainWorkload);
    }

    public void incCombinedPutGets(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(COMBINEDPUTGETS, amount);
    }

    public void incCombinedPutGetTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(COMBINEDPUTGET_TIME, amount);
    }

    public long startCombinedPutGet() {
        return NanoTimer.getTime();
    }

    public void endCombinedPutGet(long start, boolean isMainWorkload, HistogramStats histogram) {
        this.endCombinedPutGet(start, 1, isMainWorkload, histogram);
    }

    public void endCombinedPutGet(long start, int amount, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incCombinedPutGets(amount, isMainWorkload);
        this.incCombinedPutGetTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void incGetAlls() {
        this.statistics().incInt(GETALLS, 1);
    }

    public void incGets(boolean isMainWorkload) {
        this.incGets(1, isMainWorkload);
    }

    public void incGets(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(GETS, amount);
    }

    public void incGetTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(GET_TIME, amount);
    }

    public long startGet() {
        return NanoTimer.getTime();
    }

    public void endGet(long start, boolean isMainWorkload, HistogramStats histogram) {
        this.endGet(start, 1, isMainWorkload, histogram);
    }

    public void endGet(long start, int amount, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incGets(amount, isMainWorkload);
        this.incGetTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void endGetAll(long start, int amount, boolean isMainWorkload, HistogramStats histogram) {
        this.incGetAlls();
        this.endGet(start, amount, isMainWorkload, histogram);
    }

    public void incUpdates(boolean isMainWorkload) {
        this.incUpdates(1, isMainWorkload);
    }

    public void incUpdates(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(UPDATES, amount);
    }

    public void incUpdateTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(UPDATE_TIME, amount);
    }

    public long startUpdate() {
        return NanoTimer.getTime();
    }

    public void endUpdate(long start, boolean isMainWorkload, HistogramStats histogram) {
        this.endUpdate(start, 1, isMainWorkload, histogram);
    }

    public void endUpdate(long start, int amount, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incUpdates(amount, isMainWorkload);
        this.incUpdateTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void incPutComparisons(boolean isMainWorkload) {
        this.incPutComparisons(1, isMainWorkload);
    }

    public void incPutComparisons(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(PUTCOMPARISONS, amount);
    }

    public void incPutComparisonTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(PUTCOMPARISON_TIME, amount);
    }

    public long startPutComparisons() {
        return NanoTimer.getTime();
    }

    public void endPutComparison(long start, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incPutComparisons(1, isMainWorkload);
        this.incPutComparisonTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void incGetComparisons(boolean isMainWorkload) {
        this.incGetComparisons(1, isMainWorkload);
    }

    public void incGetComparisons(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(GETCOMPARISONS, amount);
    }

    public void incGetComparisonTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(GETCOMPARISON_TIME, amount);
    }

    public long startGetComparisons() {
        return NanoTimer.getTime();
    }

    public void endGetComparisons(long start, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incGetComparisons(1, isMainWorkload);
        this.incGetComparisonTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void incDestroys(boolean isMainWorkload) {
        this.incDestroys(1, isMainWorkload);
    }

    public void incDestroys(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(DESTROYS, amount);
    }

    public void incDestroyTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(DESTROY_TIME, amount);
    }

    public long startDestroy() {
        return NanoTimer.getTime();
    }

    public void endDestroy(long start, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incDestroys(1, isMainWorkload);
        this.incDestroyTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void incCreateEvents(int amount) {
        this.statistics().incInt(CREATE_EVENTS, amount);
    }

    public void incDestroyEvents(int amount) {
        this.statistics().incInt(DESTROY_EVENTS, amount);
    }

    public void incUpdateEvents(int amount) {
        this.statistics().incInt(UPDATE_EVENTS, amount);
    }

    public void incUpdateLatency(long amount) {
        long nonZeroAmount = amount;
        if (nonZeroAmount == 0L) {
            nonZeroAmount = 1L;
        }
        this.statistics().incInt(UPDATE_EVENTS, 1);
        this.statistics().incLong(UPDATE_LATENCY, nonZeroAmount);
    }

    public void incLatencySpikes(int amount) {
        this.statistics().incInt(LATENCY_SPIKES, amount);
    }

    public void incNegativeLatencies(int amount) {
        this.statistics().incInt(NEGATIVE_LATENCIES, amount);
    }

    public void incNulls() {
        this.incNulls(1);
    }

    public void incNulls(int amount) {
        this.statistics().incInt(NULLS, amount);
    }

    public void incUseCase12Updates(boolean isMainWorkload) {
        this.incUseCase12Updates(1, isMainWorkload);
    }

    public void incUseCase12Updates(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(USECASE12_UPDATES, amount);
    }

    public void incUseCase12UpdateTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(USECASE12_UPDATE_TIME, amount);
    }

    public long startUseCase12Update() {
        return NanoTimer.getTime();
    }

    public void endUseCase12Update(long start, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incUseCase12Updates(1, isMainWorkload);
        this.incUseCase12UpdateTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void incConnects(boolean isMainWorkload) {
        this.incConnects(1, isMainWorkload);
    }

    public void incConnects(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(CONNECTS, amount);
    }

    public void incConnectTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(CONNECT_TIME, amount);
    }

    public long startConnect() {
        return NanoTimer.getTime();
    }

    public void endConnect(long start, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incConnects(1, isMainWorkload);
        this.incConnectTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void incDisconnects(boolean isMainWorkload) {
        this.incDisconnects(1, isMainWorkload);
    }

    public void incDisconnects(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(DISCONNECTS, amount);
    }

    public void incDisconnectTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(DISCONNECT_TIME, amount);
    }

    public long startDisconnect() {
        return NanoTimer.getTime();
    }

    public void endDisconnect(long start, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incDisconnects(1, isMainWorkload);
        this.incDisconnectTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void incQueries(boolean isMainWorkload) {
        this.incQueries(1, isMainWorkload);
    }

    public void incQueries(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(QUERIES, amount);
    }

    public void incQueryResults(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(QUERY_RESULTS, amount);
    }

    public void incQueryTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(QUERY_TIME, amount);
    }

    public long startQuery() {
        return NanoTimer.getTime();
    }

    public void endQuery(long start, int results, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incQueries(1, isMainWorkload);
        this.incQueryResults(results, false);
        this.incQueryTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void incRebalances(boolean isMainWorkload) {
        this.incRebalances(1, isMainWorkload);
    }

    public void incRebalances(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(REBALANCES, amount);
    }

    public void incRebalanceTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(REBALANCE_TIME, amount);
    }

    public long startRebalance() {
        return NanoTimer.getTime();
    }

    public void endRebalance(long start, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incRebalances(1, isMainWorkload);
        this.incRebalanceTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void incRecoveries(boolean isMainWorkload) {
        this.incRecoveries(1, isMainWorkload);
    }

    public void incRecoveries(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(RECOVERIES, amount);
    }

    public void incRecoveryTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(RECOVERY_TIME, amount);
    }

    public void endRecovery(long elapsed, boolean isMainWorkload, HistogramStats histogram) {
        this.incRecoveries(1, isMainWorkload);
        this.incRecoveryTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void incLocks(boolean isMainWorkload) {
        this.incLocks(1, isMainWorkload);
    }

    public void incLocks(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(LOCKS, amount);
    }

    public void incLockTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(LOCK_TIME, amount);
    }

    public long startLock() {
        return NanoTimer.getTime();
    }

    public void endLock(long start, boolean isMainWorkload, HistogramStats histogram) {
        this.endLock(start, 1, isMainWorkload, histogram);
    }

    public void endLock(long start, int amount, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incLocks(amount, isMainWorkload);
        this.incLockTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }

    public void incGatewayQueueDrains(boolean isMainWorkload) {
        this.incGatewayQueueDrains(1, isMainWorkload);
    }

    public void incGatewayQueueDrains(int amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incInt(OPS, amount);
        }
        this.statistics().incInt(GATEWAY_QUEUE_DRAINS, amount);
    }

    public void incGatewayQueueDrainTime(long amount, boolean isMainWorkload) {
        if (isMainWorkload) {
            this.statistics().incLong(OP_TIME, amount);
        }
        this.statistics().incLong(GATEWAY_QUEUE_DRAIN_TIME, amount);
    }

    public long startGatewayQueueDrain() {
        return NanoTimer.getTime();
    }

    public void endGatewayQueueDrain(long start, boolean isMainWorkload, HistogramStats histogram) {
        this.endGatewayQueueDrain(start, 1, isMainWorkload, histogram);
    }

    public void endGatewayQueueDrain(long start, int amount, boolean isMainWorkload, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incGatewayQueueDrains(amount, isMainWorkload);
        this.incGatewayQueueDrainTime(elapsed, isMainWorkload);
        this.incHistogram(histogram, elapsed);
    }
}

