/*
 * Decompiled with CFR 0.152.
 */
package cacheServer;

import cacheServer.CacheServerPrms;
import hydra.CacheServerHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.TestConfig;
import java.util.Random;
import regions.validate.CacheXmlPrms;

public class CacheServerMgr {
    private static final String CACHE_SERVER_NAME = "cacheserver";

    public static void startCacheServers() {
        String xml = TestConfig.tab().stringAt(CacheXmlPrms.cacheXmlFile);
        int n = TestConfig.tab().intAt(CacheServerPrms.nServers);
        for (int i = 0; i < n; ++i) {
            String cacheserver = CACHE_SERVER_NAME + i;
            CacheServerHelper.startCacheServer(cacheserver, xml);
        }
    }

    public static synchronized void bounceCacheServer() {
        int n = TestConfig.tab().intAt(CacheServerPrms.nServers);
        int i = new Random().nextInt(n);
        String cacheserver = CACHE_SERVER_NAME + i;
        Log.getLogWriter().info("Bouncing " + cacheserver);
        String xml = TestConfig.tab().stringAt(CacheXmlPrms.cacheXmlFile);
        CacheServerHelper.killCacheServer(cacheserver);
        int seconds = 60;
        Log.getLogWriter().info("Sleeping " + seconds + " seconds");
        MasterController.sleepForMs(seconds * 1000);
        CacheServerHelper.startCacheServer(cacheserver, xml);
        Log.getLogWriter().info("Bounced " + cacheserver);
    }

    public static void stopCacheServers() {
        int n = TestConfig.tab().intAt(CacheServerPrms.nServers);
        for (int i = 0; i < n; ++i) {
            String cacheserver = CACHE_SERVER_NAME + i;
            CacheServerHelper.stopCacheServer(cacheserver);
        }
    }
}

