/*
 * Decompiled with CFR 0.152.
 */
package cacheLoader.smoke;

import cacheLoader.smoke.BB;
import cacheLoader.smoke.TestParms;
import cacheLoader.smoke.Util;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.blackboard.SharedCounters;

public class Loader
extends Util
implements CacheLoader {
    public Object load(LoaderHelper helper) {
        Integer masterValue;
        Log.getLogWriter().info("--Executing CacheLoader");
        Region region = helper.getRegion();
        SharedCounters counters = BB.getInstance().getSharedCounters();
        counters.increment(BB.NUM_LOAD_CALLS);
        Region master = region.getParentRegion().getSubregion("MasterData");
        try {
            masterValue = (Integer)master.get((Object)"Data");
        }
        catch (Exception ex) {
            String s = "Unable to read MasterData/Data";
            throw new HydraRuntimeException(s, ex);
        }
        if (masterValue == null) {
            String s = "MasterData/Data value is null";
            throw new HydraRuntimeException(s);
        }
        if (TestParms.getLogDetails()) {
            Log.getLogWriter().info("Loading " + Util.log(region, "Data") + " from " + Util.log(master, "Data", masterValue));
        }
        return new Integer(masterValue);
    }

    public void close() {
    }
}

