/*
 * Decompiled with CFR 0.152.
 */
package batterytest;

import batterytest.BatteryTestConfig;
import com.gemstone.gemfire.LogWriter;
import hydra.FileUtil;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.Log;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class NativeClientConfigParser {
    private NativeClientConfigParser() {
    }

    private String parse(String fn, Vector p) throws FileNotFoundException {
        NativeClientConfigParser.log().info("PASS 1a: getText: " + fn);
        String pass1 = this.getText(fn);
        NativeClientConfigParser.log().info("PASS 2: expandSystemProperties: " + fn);
        String pass2 = this.expandSystemProperties(pass1, p);
        return pass2;
    }

    private String getText(String fn) throws FileNotFoundException {
        try {
            return FileUtil.getText(fn);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            String s = "Error reading hydra configuration file " + fn;
            throw new HydraRuntimeException(s);
        }
    }

    private String expandSystemProperties(String text, Vector vp) {
        String tmp = text;
        if (vp != null) {
            for (BatteryTestConfig.Property p : vp) {
                tmp = tmp.replace("${" + p.getKey() + "}", (String)p.getVal());
            }
            if (tmp.indexOf("${") != -1) {
                String s = "Missing properties for configuration variables:\n" + tmp;
                throw new HydraConfigException(s);
            }
        }
        return tmp;
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }

    protected static String parseFile(String fn, Vector p) throws FileNotFoundException {
        NativeClientConfigParser.log().info("Parsing configuration file: " + fn);
        NativeClientConfigParser parser = new NativeClientConfigParser();
        String testxml = parser.parse(fn, p);
        NativeClientConfigParser.log().info("Parsed configuration file: " + fn);
        return testxml;
    }

    private static void parseConfigFile(String fn) {
        int index = fn.indexOf(".xml");
        if (index == -1) {
            String s = "Not an XML file: " + fn;
            throw new IllegalArgumentException(s);
        }
        Vector<BatteryTestConfig.Property> pv = new Vector<BatteryTestConfig.Property>();
        String propFileName = fn.substring(0, index) + ".prop";
        try {
            FileInputStream fis = new FileInputStream(propFileName);
            Properties p = new Properties();
            p.load(fis);
            Enumeration<?> names = p.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                pv.add(new BatteryTestConfig.Property(name, p.getProperty(name)));
            }
        }
        catch (FileNotFoundException fis) {
        }
        catch (IOException e) {
            String s = "Unable to load test properties from " + propFileName;
            throw new HydraConfigException(s);
        }
        NativeClientConfigParser.log().info("Parsing native client test XML file: " + fn + "...");
        String result = null;
        try {
            result = NativeClientConfigParser.parseFile(fn, pv);
        }
        catch (FileNotFoundException e) {
            String s = "Native client xml file not found: " + fn;
            throw new HydraConfigException(s, e);
        }
        System.out.println(result);
    }

    public static void main(String[] args) {
        Log.createLogWriter("parser", "fine");
        if (args.length != 1) {
            String s = "Usage: batterytest.NativeClientConfigParser <xmlFile>";
            throw new HydraRuntimeException(s);
        }
        String fn = args[0];
        NativeClientConfigParser.parseConfigFile(fn);
    }
}

