/*
 * Decompiled with CFR 0.152.
 */
package asyncMsg;

import asyncMsg.BurstListenerPrms;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionEvent;
import hydra.Log;
import hydra.TestConfig;
import java.util.Vector;
import util.AbstractListener;
import util.TestException;
import util.TestHelper;

public class BurstListener
extends AbstractListener
implements CacheListener {
    static Vector sleepTimeMillis = null;
    static long beginTime = 0L;
    static int vecIndex = 0;
    static int durationMillis = 0;
    static long lastInvocationTime = 0L;
    static boolean burstBehaviorEnabled = true;

    private void sleep() {
        if (beginTime == 0L) {
            beginTime = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - beginTime > (long)durationMillis) {
            beginTime = System.currentTimeMillis();
            vecIndex = (vecIndex + 1) % sleepTimeMillis.size();
        }
        int sleepValue = new Integer((String)sleepTimeMillis.get(vecIndex));
        try {
            Log.getLogWriter().info("In BurstListener, sleeping for " + sleepValue + " ms");
            Thread.sleep(sleepValue);
        }
        catch (InterruptedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static long getLastInvocationTime() {
        return lastInvocationTime;
    }

    public static void enableBurstBehavior(boolean aBool) {
        burstBehaviorEnabled = aBool;
    }

    public void afterCreate(EntryEvent event) {
        lastInvocationTime = System.currentTimeMillis();
        this.logCall("afterCreate", (CacheEvent)event);
        if (burstBehaviorEnabled) {
            this.sleep();
        }
    }

    public void afterUpdate(EntryEvent event) {
        lastInvocationTime = System.currentTimeMillis();
        this.logCall("afterUpdate", (CacheEvent)event);
        if (burstBehaviorEnabled) {
            this.sleep();
        }
    }

    public void afterInvalidate(EntryEvent event) {
        lastInvocationTime = System.currentTimeMillis();
        this.logCall("afterInvalidate", (CacheEvent)event);
        if (burstBehaviorEnabled) {
            this.sleep();
        }
    }

    public void afterDestroy(EntryEvent event) {
        lastInvocationTime = System.currentTimeMillis();
        this.logCall("afterDestroy", (CacheEvent)event);
        if (burstBehaviorEnabled) {
            this.sleep();
        }
    }

    public void afterRegionInvalidate(RegionEvent event) {
        lastInvocationTime = System.currentTimeMillis();
        this.logCall("afterRegionInvalidate", (CacheEvent)event);
        if (burstBehaviorEnabled) {
            this.sleep();
        }
    }

    public void afterRegionClear(RegionEvent event) {
        lastInvocationTime = System.currentTimeMillis();
        this.logCall("afterRegionClear", (CacheEvent)event);
    }

    public void afterRegionCreate(RegionEvent event) {
        lastInvocationTime = System.currentTimeMillis();
        this.logCall("afterRegionCreate", (CacheEvent)event);
    }

    public void afterRegionLive(RegionEvent event) {
        lastInvocationTime = System.currentTimeMillis();
        this.logCall("afterRegionLive", (CacheEvent)event);
    }

    public void afterRegionDestroy(RegionEvent event) {
        lastInvocationTime = System.currentTimeMillis();
        this.logCall("afterRegionDestroy", (CacheEvent)event);
        if (burstBehaviorEnabled) {
            this.sleep();
        }
    }

    public void close() {
        lastInvocationTime = System.currentTimeMillis();
        this.logCall("close", null);
        if (burstBehaviorEnabled) {
            this.sleep();
        }
    }

    static {
        sleepTimeMillis = TestConfig.tab().vecAt(BurstListenerPrms.sleepTimeMillis);
        durationMillis = TestConfig.tab().intAt(BurstListenerPrms.durationSec) * 1000;
    }
}

