/*
 * Decompiled with CFR 0.152.
 */
package admin;

import admin.AbstractListener;
import admin.AdminBB;
import com.gemstone.gemfire.admin.SystemMembershipEvent;
import com.gemstone.gemfire.admin.SystemMembershipListener;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.Log;
import hydra.blackboard.SharedCounters;
import java.util.List;

public class ActiveMemberListener
extends AbstractListener
implements SystemMembershipListener {
    public void memberJoined(SystemMembershipEvent event) {
        this.logCall("memberJoined", event);
        SharedCounters sc = AdminBB.getInstance().getSharedCounters();
        if (sc.read(AdminBB.recycleRequests) > 0L) {
            sc.increment(AdminBB.joinedNotifications);
        }
        AdminBB.getInstance().printSharedCounters();
        List activeMembers = (List)AdminBB.getInstance().getSharedMap().get(AdminBB.activeMembers);
        DistributedMember dm = event.getDistributedMember();
        if (activeMembers.contains(dm)) {
            ActiveMemberListener.throwException("BUG 34517?  Received memberJoin event, but member " + dm.toString() + " is already in active members list: " + activeMembers);
        }
        activeMembers.add(dm);
        Log.getLogWriter().info("Putting updated list of active members to BB: " + activeMembers);
        AdminBB.getInstance().getSharedMap().put(AdminBB.activeMembers, activeMembers);
    }

    public void memberLeft(SystemMembershipEvent event) {
        this.logCall("memberLeft", event);
        SharedCounters sc = AdminBB.getInstance().getSharedCounters();
        sc.increment(AdminBB.departedNotifications);
        AdminBB.getInstance().printSharedCounters();
        List activeMembers = (List)AdminBB.getInstance().getSharedMap().get(AdminBB.activeMembers);
        DistributedMember dm = event.getDistributedMember();
        if (!activeMembers.contains(dm)) {
            ActiveMemberListener.throwException("Received memberLeft event, but member " + dm.toString() + " was no longer in active members list: " + activeMembers);
        }
        activeMembers.remove(dm);
        Log.getLogWriter().info("Putting updated list of active members to BB: " + activeMembers);
        AdminBB.getInstance().getSharedMap().put(AdminBB.activeMembers, activeMembers);
    }

    public void memberCrashed(SystemMembershipEvent event) {
        this.logCall("memberCrashed", event);
        List activeMembers = (List)AdminBB.getInstance().getSharedMap().get(AdminBB.activeMembers);
        DistributedMember dm = event.getDistributedMember();
        if (!activeMembers.contains(dm)) {
            ActiveMemberListener.throwException("Received memberCrashed event, but member " + dm.toString() + " was no longer in active members list: " + activeMembers);
        }
        activeMembers.remove(dm);
        Log.getLogWriter().info("Putting updated list of active members to BB: " + activeMembers);
        AdminBB.getInstance().getSharedMap().put(AdminBB.activeMembers, activeMembers);
    }

    public void memberInfo(SystemMembershipEvent event) {
        this.logCall("memberInfo", event);
    }
}

