/*
 * Copyright (c) 2010-2015 Pivotal Software, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You
 * may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License. See accompanying
 * LICENSE file.
 */
package dunit.eclipse;

import hydra.*;

import java.rmi.Naming;

import com.gemstone.gemfire.LogWriter;

import dunit.eclipse.DUnitLauncher.MasterRemote;

/**
 * @author dsmith
 *
 */
public class ChildVM {
  
  public static void main(String[] args) throws Throwable {
    try {
      int namingPort = Integer.getInteger(DUnitLauncher.RMI_PORT_PARAM).intValue();
      int vmNum = Integer.getInteger(DUnitLauncher.VM_NUM_PARAM).intValue();
      LogWriter log = Log.createLogWriter("dunit-vm-" + vmNum, DUnitLauncher.LOG_LEVEL);
      System.out.println("VM" + vmNum + " is launching");
      DUnitLauncher.initSystemProperties(log);
      MasterRemote holder = (MasterRemote) Naming.lookup("//localhost:" + namingPort + "/" + DUnitLauncher.MASTER_PARAM);
      RemoteTestModule.Master = new FakeMaster();
      DUnitLauncher.locatorPort = holder.getLocatorPort();
      Naming.bind("//localhost:" + namingPort + "/vm" + vmNum, new FakeRemoteTestModule(log));
      holder.signalVMReady();
      //This loop is here so this VM will die even if the master is mean killed.
      while(true) {
        holder.ping();
        Thread.sleep(1000);
      }
    } catch (Throwable t) {
      t.printStackTrace();
      System.exit(1);
    }
  }

}
