/*
 * Decompiled with CFR 0.152.
 */
package wan;

import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import getInitialImage.InitImagePrms;
import hydra.CacheHelper;
import hydra.CachePrms;
import hydra.DiskStoreHelper;
import hydra.GsRandom;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.TestConfig;
import objects.ObjectHelper;
import pdx.PdxTest;
import util.BaseValueHolder;
import util.NameFactory;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.TxHelper;
import wan.CacheClientPrms;
import wan.WANBlackboard;
import wan.WANClient;

public class WANClientVersionHelper {
    protected static final String REGION_NAME = NameFactory.REGION_NAME_PREFIX + "GlobalVillage";
    static GsRandom rand = new GsRandom();
    static RandomValues rv = new RandomValues();
    protected static final int ITERATIONS = CacheClientPrms.getIterations();

    public static void putSequentialKeysTask(WANClient client) throws Exception {
        PdxTest.initClassLoader();
        int putAllOps = 5;
        client.startNoKillZone();
        Region region = RegionHelper.getRegion(REGION_NAME);
        int sleepMs = CacheClientPrms.getSleepSec() * 1000;
        String objectType = CacheClientPrms.getObjectType();
        boolean useTransactions = InitImagePrms.useTransactions();
        for (int j = 0; j < CacheClientPrms.getBatchSize(); ++j) {
            boolean rolledback = false;
            if (useTransactions) {
                TxHelper.begin();
            }
            try {
                int doPutAll = rand.nextInt(putAllOps);
                if (doPutAll == 1) {
                    WANClient.putSequentialKeyUsingPutAll(region, sleepMs);
                } else {
                    String key = "" + WANBlackboard.getInstance().getSharedCounters().incrementAndRead(WANBlackboard.currentEntry);
                    for (int i = 1; i <= ITERATIONS; ++i) {
                        MasterController.sleepForMs(sleepMs);
                        if (objectType == null) {
                            region.put((Object)key, (Object)new Integer(i));
                            continue;
                        }
                        if (objectType.equals("util.PdxVersionedValueHolder") || objectType.equals("util.VersionedValueHolder")) {
                            BaseValueHolder vh = PdxTest.getVersionedValueHolder(objectType, new Integer(i), rv);
                            region.put((Object)key, (Object)vh);
                            continue;
                        }
                        Object val = ObjectHelper.createObject(objectType, i);
                        if (TestConfig.tab().getRandGen().nextBoolean()) {
                            region.put((Object)key, val);
                            continue;
                        }
                        Object v = region.replace((Object)key, val);
                        if (v != null) continue;
                        region.put((Object)key, val);
                    }
                }
            }
            catch (TransactionDataNodeHasDepartedException e) {
                if (!useTransactions) {
                    throw new TestException("Unexpected TransactionDataNodeHasDepartedException " + TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
                Log.getLogWriter().info("Rolling back transaction.");
                try {
                    TxHelper.rollback();
                    Log.getLogWriter().info("Done Rolling back Transaction");
                }
                catch (TransactionException te) {
                    Log.getLogWriter().info("Caught exception " + (Object)((Object)te) + " on rollback() after catching TransactionDataNodeHasDeparted during tx ops.  Expected, continuing test.");
                }
                rolledback = true;
            }
            if (!useTransactions || rolledback) continue;
            try {
                TxHelper.commit();
                continue;
            }
            catch (TransactionDataNodeHasDepartedException e) {
                Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
                continue;
            }
            catch (TransactionInDoubtException e) {
                Log.getLogWriter().info("Caught TransactionInDoubtException.  Expected with concurrent execution, continuing test.");
                continue;
            }
            catch (CommitConflictException e) {
                throw new TestException("Unexpected CommitConflictException " + (Object)((Object)e) + " " + TestHelper.getStackTrace(e));
            }
        }
        client.endNoKillZone();
    }

    protected static void initPdxDiskStore() {
        String pdxDiskStoreName;
        if (CacheHelper.getCache().getPdxPersistent() && (pdxDiskStoreName = TestConfig.tab().stringAt(CachePrms.pdxDiskStoreName, null)) != null && CacheHelper.getCache().findDiskStore(pdxDiskStoreName) == null) {
            DiskStoreHelper.createDiskStore(pdxDiskStoreName);
        }
    }

    protected static void updateEntry(Region aRegion, Object key, Object value) {
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            aRegion.put(key, value);
        } else {
            Object v = aRegion.replace(key, value);
            if (v == null) {
                aRegion.put(key, value);
            }
        }
    }
}

