/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.cache.Region;
import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.Set;
import util.BaseValueHolder;
import util.CacheBB;
import util.CachePrms;
import util.CacheUtil;
import util.NameFactory;
import util.TestException;
import util.TestHelper;

public class Validator {
    public static final long VALIDATE_ALL = Long.MAX_VALUE;
    public static final int POSITIVE = 0;
    public static final int NEGATIVE = 1;
    public static final int BOTH = 2;
    public static final int NONE = 3;
    public static final int IF_HAS_VALUE = 4;
    public static final int ALWAYS = 5;
    public static final int NEVER = 7;
    public static final int SOMETIMES = 8;
    public static final int DONT_CHECK = 9;
    protected int containsKeyCategory = -1;
    protected int containsValueForKeyCategory = -1;
    protected int doGetStrategy = -1;
    protected int valueShouldBeNull = -1;
    protected boolean stableKeys = true;
    protected boolean waitForContainsKey = true;
    protected boolean waitForContainsValueForKey = true;
    protected boolean throwOnFirstError = true;
    protected CacheBB blackboard = null;
    protected long maxNumberToValidate = Long.MAX_VALUE;
    protected long timeLimitMS = TestConfig.tab().intAt(Prms.maxResultWaitSec) * 1000 - 60000;
    private Set keySet = null;
    private int numKeysPresent = 0;
    private int numValuesPresent = 0;
    private SharedCounters sharedCounters = null;
    private StringBuffer errStr = null;

    public void setContainsKeyCategory(int containsKeyCategory) {
        boolean valid;
        boolean bl = valid = containsKeyCategory == 0 || containsKeyCategory == 1 || containsKeyCategory == 2 || containsKeyCategory == 3 || containsKeyCategory == 9;
        if (!valid) {
            throw new TestException("Invalid containsKeyCategory " + containsKeyCategory);
        }
        this.containsKeyCategory = containsKeyCategory;
    }

    public void setContainsValueForKeyCategory(int containsValueForKeyCategory) {
        boolean valid;
        boolean bl = valid = containsValueForKeyCategory == 0 || containsValueForKeyCategory == 1 || containsValueForKeyCategory == 2 || containsValueForKeyCategory == 3 || containsValueForKeyCategory == 9;
        if (!valid) {
            throw new TestException("Invalid containsValueForKeyCategory " + containsValueForKeyCategory);
        }
        this.containsValueForKeyCategory = containsValueForKeyCategory;
    }

    public void setDoGetStrategy(int doGetStrategy) {
        boolean valid;
        boolean bl = valid = doGetStrategy == 4 || doGetStrategy == 5;
        if (!valid) {
            throw new TestException("Invalid doGetStrategy " + doGetStrategy);
        }
        this.doGetStrategy = doGetStrategy;
    }

    public void setValueShouldBeNull(int valueShouldBeNull) {
        boolean valid;
        boolean bl = valid = valueShouldBeNull == 5 || valueShouldBeNull == 7 || valueShouldBeNull == 8;
        if (!valid) {
            throw new TestException("Invalid valueShouldBeNull " + valueShouldBeNull);
        }
        this.valueShouldBeNull = valueShouldBeNull;
    }

    public void setStableKeys(boolean stableKeys) {
        this.stableKeys = stableKeys;
    }

    public void setWaitForContainsKey(boolean waitForContainsKey) {
        this.waitForContainsKey = waitForContainsKey;
    }

    public void setWaitForContainsValueForKey(boolean waitForContainsValueForKey) {
        this.waitForContainsValueForKey = waitForContainsValueForKey;
    }

    public void setThrowOnFirstError(boolean throwOnFirstError) {
        this.throwOnFirstError = throwOnFirstError;
    }

    public void setBlackboard(CacheBB bb) {
        this.blackboard = bb;
        this.sharedCounters = bb.getSharedCounters();
    }

    public void setMaxNumberToValidate(long maxNumberToValidate) {
        this.maxNumberToValidate = maxNumberToValidate;
    }

    public void setTimeLimitMS(long timeLimitMS) {
        this.timeLimitMS = timeLimitMS;
    }

    public Object[] validateRegionContents(Region aRegion) {
        Log.getLogWriter().info("In validateRegionContents with Validator: " + this);
        this.numKeysPresent = 0;
        this.numValuesPresent = 0;
        this.keySet = aRegion.keys();
        int beforeKeySetSize = this.keySet.size();
        long positiveCounter = NameFactory.getPositiveNameCounter();
        long negativeCounter = NameFactory.getNegativeNameCounter();
        this.errStr = new StringBuffer();
        this.logMessage("validateRegionContents: positiveCounter = " + positiveCounter + ", negativeCounter = " + negativeCounter);
        long valCount = 0L;
        boolean endedEarly = false;
        long startTime = System.currentTimeMillis();
        for (long i = negativeCounter; i <= positiveCounter; ++i) {
            if (i == 0L) continue;
            String name = NameFactory.getObjectNameForCounter(i);
            this.validateKey(aRegion, name);
            if (++valCount >= this.maxNumberToValidate) {
                this.logMessage("Ending validation because maxNumberToValidate " + this.maxNumberToValidate + " has been reached.");
                endedEarly = true;
                break;
            }
            if (System.currentTimeMillis() - startTime < this.timeLimitMS) continue;
            this.logMessage("Ending validation because time limit has been reached: " + this.timeLimitMS + " millis");
            endedEarly = true;
            break;
        }
        this.keySet = aRegion.keys();
        int afterKeySetSize = this.keySet.size();
        this.logMessage("Key set size at beginning of validation: " + beforeKeySetSize + ", after validation: " + afterKeySetSize);
        if (!endedEarly) {
            if (this.stableKeys) {
                if (this.numKeysPresent != afterKeySetSize) {
                    this.logError("In validateRegionContents, expected key set size to be " + this.numKeysPresent + " but it was " + afterKeySetSize + "\n" + this.getKeySetDiscrepancies(aRegion, this.keySet));
                }
            } else if (this.numKeysPresent > afterKeySetSize) {
                this.logError("In validateRegionContents, expected key set size to be >= " + this.numKeysPresent + " but it was " + afterKeySetSize + "\n");
            }
        }
        if (this.errStr.length() > 0) {
            throw new TestException(this.errStr.toString());
        }
        Log.getLogWriter().info("No errors detected by Validator");
        return new Object[]{new Integer(this.numKeysPresent), new Integer(this.numValuesPresent)};
    }

    void validateKey(Region aRegion, String key) {
        String logStr;
        long waitTime = TestConfig.tab().longAt(CachePrms.keyValueWaitTime) * 1000L;
        SharedCounters counters = this.blackboard.getSharedCounters();
        long nameCounter = NameFactory.getCounterForName(key);
        boolean containsKey = aRegion.containsKey((Object)key);
        boolean containsValue = aRegion.containsValueForKey((Object)key);
        this.logMessage("validateKey: containsKey(" + key + ")=" + containsKey + ", containsValueforKey(" + key + ")=" + containsValue);
        if (this.containsKeyCategory == 9) {
            this.logMessage("Not checking containsKey because containsKeyCategory = " + this.containsKeyCategoryToString());
        } else {
            boolean expectedContainsKey = this.containsKeyCategory == 2 || nameCounter > 0L && this.containsKeyCategory == 0 || nameCounter < 0L && this.containsKeyCategory == 1;
            this.logMessage("validateKey: For key " + key + ", expectedContainsKey = " + expectedContainsKey);
            if (this.waitForContainsKey) {
                try {
                    logStr = TestHelper.waitForContainsKey(aRegion, key, expectedContainsKey, waitTime, false);
                    this.logMessage(logStr);
                }
                catch (TestException e) {
                    this.logError(e + TestHelper.getStackTrace(e));
                }
            } else if (expectedContainsKey && !containsKey) {
                logStr = "Expected containsKey for key " + key + " to be true, but it is " + containsKey;
                this.logError(logStr);
            }
        }
        containsKey = aRegion.containsKey((Object)key);
        containsValue = aRegion.containsValueForKey((Object)key);
        if (this.containsValueForKeyCategory == 9) {
            this.logMessage("Not checking containsValueForKey because containsValueForKeyCategory = " + this.containsValueForKeyCategoryToString());
        } else {
            boolean expectedContainsValueForKey;
            boolean bl = expectedContainsValueForKey = containsKey && (this.containsValueForKeyCategory == 2 || nameCounter > 0L && this.containsValueForKeyCategory == 0 || nameCounter < 0L && this.containsValueForKeyCategory == 1);
            if (this.waitForContainsValueForKey) {
                this.logMessage("validateKey: For key " + key + ", expectedContainsValueForKey = " + expectedContainsValueForKey + "; containsKey = " + containsKey + ", containsValueForKeyCategory = " + this.containsValueForKeyCategory + ", nameCounter = " + nameCounter);
                try {
                    logStr = TestHelper.waitForContainsValueForKey(aRegion, key, expectedContainsValueForKey, waitTime, false);
                    this.logMessage(logStr);
                }
                catch (TestException e) {
                    this.logError(e + TestHelper.getStackTrace(e));
                }
            }
        }
        containsKey = aRegion.containsKey((Object)key);
        containsValue = aRegion.containsValueForKey((Object)key);
        if (containsKey) {
            boolean contains = this.keySet.contains(key);
            if (!contains) {
                this.logMessage("key " + key + " not found in key set; getting key set again");
                this.keySet = aRegion.keys();
                contains = this.keySet.contains(key);
            }
            if (!contains) {
                this.logError("key " + key + " is not contained in key set\n");
            }
        }
        if (containsKey) {
            ++this.numKeysPresent;
        }
        if (containsValue) {
            ++this.numValuesPresent;
        }
        if (this.doGetStrategy == 5 || this.doGetStrategy == 4 && containsValue) {
            Object value = CacheUtil.get(aRegion, key);
            this.checkNameAndValue(key, value);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void checkNameAndValue(String key, Object value) {
        if (this.valueShouldBeNull == 8) {
            return;
        }
        this.logMessage("Checking key " + key + ", value " + value);
        if (this.valueShouldBeNull == 5) {
            if (value == null) {
                return;
            }
            this.logError("Expected value for key " + key + " to be null, but it was " + value + "\n");
            return;
        }
        BaseValueHolder vh = null;
        Long aLong = null;
        if (value instanceof BaseValueHolder) {
            vh = (BaseValueHolder)value;
            long longValue = 0L;
            if (!(vh.myValue instanceof Long)) {
                this.logError("Expected value for key " + key + " to contain a Long, but it is " + TestHelper.toString(value) + "\n");
                return;
            }
            aLong = (Long)vh.myValue;
            longValue = aLong;
        } else {
            this.logError("Expected value for key " + key + " to be a ValueHolder, but it is " + TestHelper.toString(value) + "\n");
        }
        Long nameCounter = new Long(NameFactory.getCounterForName(key));
        if (!nameCounter.equals(aLong)) {
            this.logError("key " + key + " and value " + TestHelper.toString(value) + " are not correct\n");
            return;
        }
    }

    private String containsKeyCategoryToString() {
        if (this.containsKeyCategory == 1) {
            return "NEGATIVE";
        }
        if (this.containsKeyCategory == 0) {
            return "POSITIVE";
        }
        if (this.containsKeyCategory == 2) {
            return "BOTH";
        }
        if (this.containsKeyCategory == 3) {
            return "NONE";
        }
        if (this.containsKeyCategory == 9) {
            return "DONT_CHECK";
        }
        throw new TestException("unknown containsKeyCategory " + this.containsKeyCategory);
    }

    private String containsValueForKeyCategoryToString() {
        if (this.containsValueForKeyCategory == 1) {
            return "NEGATIVE";
        }
        if (this.containsValueForKeyCategory == 0) {
            return "POSITIVE";
        }
        if (this.containsValueForKeyCategory == 2) {
            return "BOTH";
        }
        if (this.containsValueForKeyCategory == 3) {
            return "NONE";
        }
        if (this.containsValueForKeyCategory == 9) {
            return "DONT_CHECK";
        }
        throw new TestException("unknown containsValueForKeyCategory " + this.containsValueForKeyCategory);
    }

    private String doGetStrategyToString() {
        if (this.doGetStrategy == 4) {
            return "IF_HAS_VALUE";
        }
        if (this.doGetStrategy == 5) {
            return "ALWAYS";
        }
        throw new TestException("unknown doGetStrategy " + this.doGetStrategy);
    }

    private String valueShouldBeNullToString() {
        if (this.valueShouldBeNull == 5) {
            return "ALWAYS";
        }
        if (this.valueShouldBeNull == 7) {
            return "NEVER";
        }
        if (this.valueShouldBeNull == 8) {
            return "SOMETIMES";
        }
        throw new TestException("unknown valueShouldBeNull " + this.valueShouldBeNull);
    }

    public String toString() {
        StringBuffer aStr = new StringBuffer();
        aStr.append("containsKeyCategory: " + this.containsKeyCategoryToString() + "\n");
        aStr.append("containsValueForKeyCategory: " + this.containsValueForKeyCategoryToString() + "\n");
        aStr.append("doGetStrategy: " + this.doGetStrategyToString() + "\n");
        aStr.append("valueShouldBeNull: " + this.valueShouldBeNullToString() + "\n");
        aStr.append("stableKeys: " + this.stableKeys + "\n");
        aStr.append("waitForContainsKey: " + this.waitForContainsKey + "\n");
        aStr.append("waitForContainsValueForKey: " + this.waitForContainsValueForKey + "\n");
        aStr.append("throwOnFirstError: " + this.throwOnFirstError + "\n");
        aStr.append("blackboard: " + this.blackboard + "\n");
        aStr.append("maxNumberToValidate: " + this.maxNumberToValidate + "\n");
        aStr.append("timeLimitMS: " + this.timeLimitMS + "\n");
        return aStr.toString();
    }

    private void logError(String aStr) {
        this.errStr.append(aStr + "\n");
        Log.getLogWriter().info(aStr);
        if (this.throwOnFirstError) {
            throw new TestException(this.errStr.toString());
        }
    }

    protected void logMessage(String aStr) {
        Log.getLogWriter().info(aStr);
    }

    private String getKeySetDiscrepancies(Region aRegion, Set keySet) {
        if (this.doGetStrategy != 5) {
            return "";
        }
        if (this.valueShouldBeNull != 7) {
            return "";
        }
        if (!this.stableKeys) {
            return "";
        }
        long posCounter = 0L;
        if (this.containsValueForKeyCategory == 0 || this.containsValueForKeyCategory == 2) {
            posCounter = NameFactory.getPositiveNameCounter();
        }
        long negCounter = 0L;
        if (this.containsValueForKeyCategory == 1 || this.containsValueForKeyCategory == 2) {
            negCounter = NameFactory.getNegativeNameCounter();
        }
        return NameFactory.getKeySetDiscrepancies(aRegion, keySet, (int)posCounter, (int)negCounter);
    }
}

