/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.LogWriter;
import hydra.ClientDescription;
import hydra.Log;
import hydra.TestConfig;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;
import util.StatTasksBB;
import util.TestException;

public class StatTasks {
    public static void ensureTxOccurredTask() {
        PerfStatValue psv;
        int numCommitSuccesses = 0;
        int numCommitFailures = 0;
        int numRollbacks = 0;
        String spec = "* CachePerfStats cachePerfStats txCommits filter=none combine=combineAcrossArchives ops=max trimspec=untrimmed";
        List psvs = PerfStatMgr.getInstance().readStatistics(spec);
        if (psvs == null) {
            StatTasks.log().info("There was no statistic for txCommits");
        } else {
            psv = (PerfStatValue)psvs.get(0);
            numCommitSuccesses = (int)psv.getMax();
        }
        spec = "* CachePerfStats cachePerfStats txFailures filter=none combine=combineAcrossArchives ops=max trimspec=untrimmed";
        psvs = PerfStatMgr.getInstance().readStatistics(spec);
        if (psvs == null) {
            StatTasks.log().info("There was no statistic for txFailures");
        } else {
            psv = (PerfStatValue)psvs.get(0);
            numCommitFailures = (int)psv.getMax();
        }
        spec = "* CachePerfStats cachePerfStats txRollbacks filter=none combine=combineAcrossArchives ops=max trimspec=untrimmed";
        psvs = PerfStatMgr.getInstance().readStatistics(spec);
        if (psvs == null) {
            StatTasks.log().info("There was no statistic for txRollbacks");
        } else {
            psv = (PerfStatValue)psvs.get(0);
            numRollbacks = (int)psv.getMax();
        }
        int totalTx = numCommitSuccesses + numCommitFailures + numRollbacks;
        String aStr = "Number of commit successes: " + numCommitSuccesses + ", Number of commit failures: " + numCommitFailures + ", Number of rollbacks: " + numRollbacks;
        Log.getLogWriter().info(aStr);
        if (totalTx <= 0) {
            throw new TestException("Expected transactions, but none occurred; " + aStr);
        }
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }

    public static List<PerfStatValue> getStatFromArchive(String archiveID, String statType, String statName, String individStatName, String statKind) {
        String statId = StatTasks.getStatId(statType, statName, individStatName);
        String clientName = System.getProperty("clientName");
        ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
        String spec = archiveID + " " + statType + " " + statName + " " + individStatName + " " + "filter" + "=" + "none" + " " + "combine" + "=" + "raw" + " " + "ops" + "=" + statKind;
        Log.getLogWriter().info("Stat spec: " + spec);
        List statList = PerfStatMgr.getInstance().readStatistics(spec);
        Log.getLogWriter().info("Stat list for " + statId + ": " + statList);
        return statList;
    }

    private static String getStatId(String statType, String statName, String individStatName) {
        return statType + "." + statName + "." + individStatName;
    }

    public static void ensureStatIsNonNegative(String archiveID, String statType, String statName, String individStatName, String statKind) {
        List<PerfStatValue> aList = StatTasks.getStatFromArchive(archiveID, statType, statName, individStatName, statKind);
        String statID = StatTasks.getStatId(statType, statName, individStatName);
        if (aList != null) {
            for (PerfStatValue psv : aList) {
                Log.getLogWriter().info("Retrieved " + psv);
                double value = 0.0;
                if (statKind.equals("min")) {
                    value = psv.getMin();
                } else if (statKind.equals("max")) {
                    value = psv.getMax();
                } else {
                    throw new TestException("Test problem: unable to process statKind " + statKind);
                }
                if (!(value < 0.0)) continue;
                throw new TestException("Expected " + statID + " " + statKind + " to be >= 0, but it is " + value + ", stat retrieved from archive: " + psv);
            }
        }
    }

    public static void validateStats() {
        long leader = StatTasksBB.getBB().getSharedCounters().incrementAndRead(StatTasksBB.leader);
        if (leader == 1L) {
            String currDirPath = System.getProperty("user.dir");
            File currDir = new File(currDirPath);
            File[] contents = currDir.listFiles();
            HashSet<String> archiveIdSet = new HashSet<String>();
            for (File aFile : contents) {
                String[] subDirContents;
                List<String> aList;
                if (!aFile.isDirectory() || !(aList = Arrays.asList(subDirContents = aFile.list())).toString().contains(".gfs")) continue;
                String dirName = aFile.getName();
                int index = dirName.indexOf("_");
                if (index < 0) {
                    throw new TestException("Unable to get archive base name from " + dirName);
                }
                String archiveID = dirName.substring(0, index);
                archiveIdSet.add(archiveID);
            }
            for (String archiveID : archiveIdSet) {
                StatTasks.ensureStatIsNonNegative(archiveID, "MemLRUStatistics", "*", "byteCount", "min");
                StatTasks.ensureStatIsNonNegative(archiveID, "LRUStatistics", "*", "entryCount", "min");
            }
        }
    }
}

