/*
 * Decompiled with CFR 0.152.
 */
package util;

import hydra.Log;
import hydra.TestConfig;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import util.GenericComparator;
import util.RandomValuesPrms;
import util.TestException;
import util.TestHelper;

public class RandomValues
implements Serializable {
    private static char[] printableChars;
    private static Class[] factoryClasses;
    public boolean createDebug = false;
    public boolean modifyDebug = true;
    public boolean logProgress = false;
    final int NORMAL_CASE = 0;
    final int BORDER_CASE_MIN_VALUE = 1;
    final int BORDER_CASE_MAX_VALUE = 2;
    final int BORDER_CASE_ALT_VALUE = 3;
    Vector objectTypeVec;
    Vector keyTypeVec;
    Vector valueTypeVec;
    Vector setElementVec;

    public RandomValues() {
        this.initialize();
    }

    public RandomValues(Long objectType_paramKey) {
        this.initialize();
        this.objectTypeVec = TestConfig.tab().vecAt(objectType_paramKey);
    }

    public static void setPrintableChars(boolean lettersAndDigitsOnly) {
        int i;
        char[] otherchars = null;
        otherchars = lettersAndDigitsOnly ? new char[]{} : new char[]{'!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '-', '_', '=', '+', '\\', '|', '`', '~', '{', '[', ']', ';', ':', '\'', '\"', '<', ',', '>', '.', '?', '/'};
        int printableCharsLength = 62 + otherchars.length;
        printableChars = new char[printableCharsLength];
        int index = 0;
        for (i = 48; i <= 57; ++i) {
            RandomValues.printableChars[index++] = (char)i;
        }
        for (i = 65; i <= 90; ++i) {
            RandomValues.printableChars[index++] = (char)i;
        }
        for (i = 97; i <= 122; ++i) {
            RandomValues.printableChars[index++] = (char)i;
        }
        for (i = 0; i < otherchars.length; ++i) {
            RandomValues.printableChars[index++] = otherchars[i];
        }
        if (index != printableCharsLength) {
            throw new TestException("expected index " + index + " to be " + printableCharsLength);
        }
    }

    void initialize() {
        this.objectTypeVec = TestConfig.tab().vecAt(RandomValuesPrms.objectType, null);
        this.keyTypeVec = TestConfig.tab().vecAt(RandomValuesPrms.keyType, null);
        this.valueTypeVec = TestConfig.tab().vecAt(RandomValuesPrms.valueType, null);
        this.setElementVec = TestConfig.tab().vecAt(RandomValuesPrms.setElementType, null);
    }

    public Object getRandomObject() {
        String objectType = this.getRandomStringFromVec(this.getObjectTypeVec());
        Object anObj = this.getRandomObjectForType(objectType);
        return anObj;
    }

    public Object getRandomObject(Object extraObj) {
        String objectType = this.getRandomStringFromVec(this.getObjectTypeVec());
        Object anObj = this.getRandomObjectForType(objectType, extraObj);
        return anObj;
    }

    public Object getRandomObjectGraph() {
        String objectType = this.getRandomStringFromVec(this.getObjectTypeVec());
        Object anObj = this.getRandomObjectForType(objectType);
        this.createDepth(anObj);
        return anObj;
    }

    public Object getRandomObjectGraph(Object extraObj) {
        String objectType = this.getRandomStringFromVec(this.getObjectTypeVec());
        Object anObj = this.getRandomObjectForType(objectType, extraObj);
        this.createDepth(anObj);
        return anObj;
    }

    public Object getRandomObject(String className) {
        return this.getRandomObjectForType(className);
    }

    public Object getRandomObjectGraph(String className) {
        Object anObj = this.getRandomObjectForType(className);
        this.createDepth(anObj);
        return anObj;
    }

    Object getRandomObjectForType(String dataTypeName, Object extraObj) {
        Object returnObject = null;
        returnObject = dataTypeName.equals("this") ? extraObj : this.getRandomObjectForType(dataTypeName);
        return returnObject;
    }

    Object getRandomObjectForType(String dataTypeName) {
        Object returnObject = null;
        if (dataTypeName.equals(Integer.class.getName()) || dataTypeName.equals("int")) {
            returnObject = new Integer(this.getRandom_int());
        } else if (dataTypeName.equals(String.class.getName())) {
            returnObject = this.getRandom_String();
        } else if (dataTypeName.equals(Long.class.getName()) || dataTypeName.equals("long")) {
            returnObject = new Long(this.getRandom_long());
        } else if (dataTypeName.equals(Double.class.getName()) || dataTypeName.equals("double")) {
            returnObject = new Double(this.getRandom_double());
        } else if (dataTypeName.equals(Boolean.class.getName()) || dataTypeName.equals("boolean")) {
            returnObject = new Boolean(this.getRandom_boolean());
        } else if (dataTypeName.equals(Byte.class.getName()) || dataTypeName.equals("byte")) {
            returnObject = new Byte(this.getRandom_byte());
        } else if (dataTypeName.equals(Character.class.getName()) || dataTypeName.equals("char")) {
            returnObject = new Character(this.getRandom_char());
        } else if (dataTypeName.equals(Float.class.getName()) || dataTypeName.equals("float")) {
            returnObject = new Float(this.getRandom_float());
        } else if (dataTypeName.equals(Short.class.getName()) || dataTypeName.equals("short")) {
            returnObject = new Short(this.getRandom_short());
        } else if (dataTypeName.equals(BigInteger.class.getName())) {
            returnObject = this.getRandom_BigInteger();
        } else if (dataTypeName.equals(BigDecimal.class.getName())) {
            returnObject = this.getRandom_BigDecimal();
        } else if (dataTypeName.equals(StringBuffer.class.getName())) {
            returnObject = this.getRandom_StringBuffer();
        } else if (dataTypeName.equals("null")) {
            returnObject = null;
        } else {
            if (dataTypeName.equals("this")) {
                throw new TestException("Problem in test: dataTypeName is this, but no extra object supplied");
            }
            returnObject = dataTypeName.endsWith("[]") ? this.getRandom_array(dataTypeName) : this.getRandom_Object(dataTypeName);
        }
        return returnObject;
    }

    public int getRandom_int() {
        if (TestHelper.borderCase(RandomValuesPrms.borderCasePercentage)) {
            return this.getRandom_intBorderCase();
        }
        return TestConfig.tab().getRandGen().nextInt();
    }

    public int getRandom_intBorderCase() {
        int[] anArr = new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 0};
        return anArr[TestConfig.tab().getRandGen().nextInt(anArr.length - 1)];
    }

    public float getRandom_float() {
        if (TestHelper.borderCase(RandomValuesPrms.borderCasePercentage)) {
            return this.getRandom_floatBorderCase();
        }
        return TestConfig.tab().getRandGen().nextFloat();
    }

    public float getRandom_floatBorderCase() {
        float[] anArr = new float[]{Float.MIN_VALUE, Float.MAX_VALUE, -1.4E-45f, -3.4028235E38f, Float.NaN, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, 0.0f};
        return anArr[TestConfig.tab().getRandGen().nextInt(anArr.length - 1)];
    }

    public double getRandom_double() {
        if (TestHelper.borderCase(RandomValuesPrms.borderCasePercentage)) {
            return this.getRandom_doubleBorderCase();
        }
        return TestConfig.tab().getRandGen().nextDouble();
    }

    public double getRandom_doubleBorderCase() {
        double[] anArr = new double[]{Double.MIN_VALUE, Double.MAX_VALUE, -4.9E-324, -1.7976931348623157E308, Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0};
        return anArr[TestConfig.tab().getRandGen().nextInt(anArr.length - 1)];
    }

    public boolean getRandom_boolean() {
        return TestConfig.tab().getRandGen().nextBoolean();
    }

    public byte getRandom_byte() {
        if (TestHelper.borderCase(RandomValuesPrms.borderCasePercentage)) {
            return this.getRandom_byteBorderCase();
        }
        byte[] byteArr = new byte[1];
        TestConfig.tab().getRandGen().nextBytes(byteArr);
        return byteArr[0];
    }

    public byte getRandom_byteBorderCase() {
        byte[] anArr = new byte[]{-128, 127, 0};
        return anArr[TestConfig.tab().getRandGen().nextInt(anArr.length - 1)];
    }

    public byte[] getRandom_arrayOfBytes() {
        int arraySize = TestConfig.tasktab().intAt(RandomValuesPrms.elementSize, TestConfig.tab().intAt(RandomValuesPrms.elementSize));
        byte[] byteArr = new byte[arraySize];
        return byteArr;
    }

    public char getRandom_char() {
        if (TestHelper.borderCase(RandomValuesPrms.borderCasePercentage)) {
            return this.getRandom_charBorderCase();
        }
        return TestConfig.tab().getRandGen().nextChar();
    }

    public char getRandom_charBorderCase() {
        char[] anArr = new char[]{'\u0000', '\uffff'};
        return anArr[TestConfig.tab().getRandGen().nextInt(anArr.length - 1)];
    }

    public long getRandom_long() {
        if (TestHelper.borderCase(RandomValuesPrms.borderCasePercentage)) {
            return this.getRandom_longBorderCase();
        }
        return TestConfig.tab().getRandGen().nextLong();
    }

    public long getRandom_longBorderCase() {
        long[] anArr = new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 0L};
        return anArr[TestConfig.tab().getRandGen().nextInt(anArr.length - 1)];
    }

    public short getRandom_short() {
        if (TestHelper.borderCase(RandomValuesPrms.borderCasePercentage)) {
            return this.getRandom_shortBorderCase();
        }
        return (short)this.getRandom_int();
    }

    public short getRandom_shortBorderCase() {
        short[] anArr = new short[]{Short.MIN_VALUE, Short.MAX_VALUE, 0};
        return anArr[TestConfig.tab().getRandGen().nextInt(anArr.length - 1)];
    }

    public String getRandom_String(char doubleChar, int size) {
        return this.getRandom_String(doubleChar, (long)size);
    }

    public String getRandom_String(char doubleChar, long size) {
        int whichCase = 0;
        if (TestHelper.borderCase(RandomValuesPrms.borderCasePercentage)) {
            int[] anArr = new int[]{1, 2, 3};
            whichCase = anArr[TestConfig.tab().getRandGen().nextInt(anArr.length - 1)];
        }
        return this.getRandomString(whichCase, new Character(doubleChar), size);
    }

    public String getRandom_String() {
        int whichCase = 0;
        if (TestHelper.borderCase(RandomValuesPrms.borderCasePercentage)) {
            int[] anArr = new int[]{1, 2, 3};
            whichCase = anArr[TestConfig.tab().getRandGen().nextInt(anArr.length - 1)];
        }
        return this.getRandomString(whichCase, null, -1L);
    }

    public String getRandom_StringBorderCase() {
        int[] anArr = new int[]{1, 2, 3};
        int whichCase = anArr[TestConfig.tab().getRandGen().nextInt(anArr.length - 1)];
        return this.getRandomString(whichCase, null, -1L);
    }

    protected String getRandomString(int whichCase, Character doubleChar, long size) {
        StringBuffer aStr = new StringBuffer();
        long stringSize = size;
        if (stringSize == -1L) {
            stringSize = TestConfig.tab().intAt(RandomValuesPrms.stringSize);
        }
        while ((long)aStr.length() < stringSize) {
            if (whichCase == 0) {
                char aChar = printableChars[TestConfig.tab().getRandGen().nextInt(printableChars.length - 1)];
                if (doubleChar != null && aChar == doubleChar.charValue()) {
                    aStr.append(aChar);
                }
                aStr.append(aChar);
                continue;
            }
            if (whichCase == 1) {
                aStr.append('\u0000');
                continue;
            }
            if (whichCase == 2) {
                aStr.append('\uffff');
                continue;
            }
            if (aStr.length() % 2 == 0) {
                aStr.append('\u0000');
                continue;
            }
            aStr.append('\uffff');
        }
        return aStr.toString();
    }

    public StringBuffer getRandom_StringBuffer() {
        return new StringBuffer(this.getRandom_String());
    }

    public BigInteger getRandom_BigInteger() {
        BigInteger bigInt;
        int MAX_BITS = 50;
        if (TestHelper.borderCase(RandomValuesPrms.borderCasePercentage)) {
            BigInteger[] anArr = new BigInteger[]{BigInteger.ZERO, BigInteger.ONE, new BigInteger(50, TestConfig.tab().getRandGen())};
            bigInt = anArr[TestConfig.tab().getRandGen().nextInt(anArr.length - 1)];
        } else {
            bigInt = new BigInteger(TestConfig.tab().getRandGen().nextInt(1, 50), TestConfig.tab().getRandGen());
        }
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            bigInt = new BigInteger("-" + bigInt);
        }
        return bigInt;
    }

    public BigDecimal getRandom_BigDecimal() {
        BigInteger bigInt = this.getRandom_BigInteger();
        String bigIntStr = bigInt.toString();
        int[] scalArr = new int[]{0, bigIntStr.length(), bigIntStr.length() - 1, bigIntStr.length() + 1, TestConfig.tab().getRandGen().nextInt(1, 2 * bigIntStr.length())};
        int scale = scalArr[TestConfig.tab().getRandGen().nextInt(scalArr.length - 1)];
        BigDecimal bigDec = new BigDecimal(bigInt, scale);
        return bigDec;
    }

    public Object getRandom_Object(String dataTypeName) {
        Class<?> aClass = null;
        try {
            aClass = Class.forName(dataTypeName);
        }
        catch (ClassNotFoundException anExcept) {
            throw new TestException("Class name " + dataTypeName + " " + anExcept.toString());
        }
        if (Set.class.isAssignableFrom(aClass)) {
            return this.getRandom_Set(aClass);
        }
        if (Map.class.isAssignableFrom(aClass)) {
            return this.getRandom_Map(aClass);
        }
        if (List.class.isAssignableFrom(aClass)) {
            return this.getRandom_List(aClass);
        }
        try {
            Object anObj = aClass.newInstance();
            return anObj;
        }
        catch (InstantiationException anExcept) {
            Constructor<?> constructor = null;
            try {
                constructor = aClass.getDeclaredConstructor(Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new TestException("Could not find a constructor for " + dataTypeName);
            }
            int length = TestConfig.tab().intAt(RandomValuesPrms.elementSize);
            try {
                Object anObj = constructor.newInstance(new Integer(length));
                return anObj;
            }
            catch (InstantiationException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (IllegalAccessException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (InvocationTargetException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        catch (IllegalAccessException anExcept) {
            throw new TestException(TestHelper.getStackTrace(anExcept));
        }
        catch (Exception anExcept) {
            throw new TestException(TestHelper.getStackTrace(anExcept));
        }
    }

    public Set getRandom_Set(Class aClass) {
        TreeSet aSet = null;
        boolean syncWrapper = false;
        aSet = aClass == TreeSet.class ? new TreeSet(new GenericComparator()) : (TreeSet)this.createInstance(aClass);
        return aSet;
    }

    public Map getRandom_Map(Class aClass) {
        Map aMap = null;
        boolean syncWrapper = false;
        if (aClass == TreeMap.class) {
            aMap = new TreeMap(new GenericComparator());
        } else if (aClass == HashMap.class) {
            HashMap aHM;
            String constructor = TestConfig.tab().stringAt(RandomValuesPrms.HashMap_constructor);
            if (constructor.equalsIgnoreCase("default")) {
                if (this.logProgress) {
                    Log.getLogWriter().info("Creating instance with constructor: new HashMap()...");
                }
                aHM = new HashMap();
                if (this.logProgress) {
                    Log.getLogWriter().info("Finished call to constructor: " + TestHelper.toString(aHM));
                }
            } else if (constructor.equalsIgnoreCase("initialCapacity")) {
                int initialCapacity = TestConfig.tab().intAt(RandomValuesPrms.HashMap_initialCapacity);
                if (this.logProgress) {
                    Log.getLogWriter().info("Creating instance with constructor: new HashMap(" + initialCapacity + ")...");
                }
                aHM = new HashMap(initialCapacity);
                if (this.logProgress) {
                    Log.getLogWriter().info("Finished call to constructor: " + TestHelper.toString(aHM));
                }
            } else if (constructor.equalsIgnoreCase("initialCapacity_loadFactor")) {
                int initialCapacity = TestConfig.tab().intAt(RandomValuesPrms.HashMap_initialCapacity);
                float loadFactor = (float)TestConfig.tab().doubleAt(RandomValuesPrms.HashMap_loadFactor);
                if (this.logProgress) {
                    Log.getLogWriter().info("Creating instance with constructor: new HashMap(" + initialCapacity + ", " + loadFactor + ")...");
                }
                aHM = new HashMap(initialCapacity, loadFactor);
                if (this.logProgress) {
                    Log.getLogWriter().info("Finished call to constructor: " + TestHelper.toString(aHM));
                }
            } else {
                throw new TestException("Unknown constructor " + constructor);
            }
            syncWrapper = TestConfig.tab().booleanAt(RandomValuesPrms.HashMap_syncWrapper);
            aMap = aHM;
        } else if (aClass == Hashtable.class) {
            Hashtable aHT;
            String constructor = TestConfig.tab().stringAt(RandomValuesPrms.Hashtable_constructor);
            if (constructor.equalsIgnoreCase("default")) {
                if (this.logProgress) {
                    Log.getLogWriter().info("Creating instance with constructor: new Hashtable()...");
                }
                aHT = new Hashtable();
                if (this.logProgress) {
                    Log.getLogWriter().info("Finished call to constructor: " + TestHelper.toString(aHT));
                }
            } else if (constructor.equalsIgnoreCase("initialCapacity")) {
                int initialCapacity = TestConfig.tab().intAt(RandomValuesPrms.Hashtable_initialCapacity);
                if (this.logProgress) {
                    Log.getLogWriter().info("Creating instance with constructor: new Hashtable(" + initialCapacity + ")...");
                }
                aHT = new Hashtable(initialCapacity);
                if (this.logProgress) {
                    Log.getLogWriter().info("Finished call to constructor: " + TestHelper.toString(aHT));
                }
            } else if (constructor.equalsIgnoreCase("initialCapacity_loadFactor")) {
                int initialCapacity = TestConfig.tab().intAt(RandomValuesPrms.Hashtable_initialCapacity);
                float loadFactor = (float)TestConfig.tab().doubleAt(RandomValuesPrms.Hashtable_loadFactor);
                if (this.logProgress) {
                    Log.getLogWriter().info("Creating instance with constructor: new Hashtable(" + initialCapacity + ", " + loadFactor + ")...");
                }
                aHT = new Hashtable(initialCapacity, loadFactor);
                if (this.logProgress) {
                    Log.getLogWriter().info("Finished call to constructor: " + TestHelper.toString(aHT));
                }
            } else {
                throw new TestException("Unknown constructor " + constructor);
            }
            syncWrapper = TestConfig.tab().booleanAt(RandomValuesPrms.Hashtable_syncWrapper);
            aMap = aHT;
        } else {
            aMap = (Map)this.createInstance(aClass);
        }
        return aMap;
    }

    public List getRandom_List(Class aClass) {
        AbstractList aList = null;
        boolean syncWrapper = false;
        if (aClass == ArrayList.class) {
            String constructor = TestConfig.tab().stringAt(RandomValuesPrms.ArrayList_constructor);
            if (constructor.equalsIgnoreCase("default")) {
                if (this.logProgress) {
                    Log.getLogWriter().info("Creating instance with constructor: new ArrayList()...");
                }
                aList = new ArrayList();
                if (this.logProgress) {
                    Log.getLogWriter().info("Finished call to constructor: " + TestHelper.toString(aList));
                }
            } else if (constructor.equalsIgnoreCase("initialCapacity")) {
                int initialCapacity = TestConfig.tab().intAt(RandomValuesPrms.ArrayList_initialCapacity);
                if (this.logProgress) {
                    Log.getLogWriter().info("Creating instance with constructor: new ArrayList(" + initialCapacity + ")...");
                }
                aList = new ArrayList(initialCapacity);
                if (this.logProgress) {
                    Log.getLogWriter().info("Finished call to constructor: " + TestHelper.toString(aList));
                }
            } else {
                throw new TestException("Unknown constructor " + constructor);
            }
            syncWrapper = TestConfig.tab().booleanAt(RandomValuesPrms.ArrayList_syncWrapper);
        } else if (aClass == LinkedList.class) {
            String constructor = TestConfig.tab().stringAt(RandomValuesPrms.LinkedList_constructor);
            if (constructor.equalsIgnoreCase("default")) {
                if (this.logProgress) {
                    Log.getLogWriter().info("Creating instance with constructor: new LinkedList()...");
                }
                aList = new LinkedList();
                if (this.logProgress) {
                    Log.getLogWriter().info("Finished call to constructor: " + TestHelper.toString(aList));
                }
            } else {
                throw new TestException("Unknown constructor " + constructor);
            }
            syncWrapper = TestConfig.tab().booleanAt(RandomValuesPrms.LinkedList_syncWrapper);
        } else if (aClass == Vector.class) {
            String constructor = TestConfig.tab().stringAt(RandomValuesPrms.Vector_constructor);
            if (constructor.equalsIgnoreCase("default")) {
                if (this.logProgress) {
                    Log.getLogWriter().info("Creating instance with constructor: new Vector()...");
                }
                aList = new Vector();
                if (this.logProgress) {
                    Log.getLogWriter().info("Finished call to constructor: " + TestHelper.toString(aList));
                }
            } else if (constructor.equalsIgnoreCase("initialCapacity")) {
                int initialCapacity = TestConfig.tab().intAt(RandomValuesPrms.Vector_initialCapacity);
                if (this.logProgress) {
                    Log.getLogWriter().info("Creating instance with constructor: new Vector(" + initialCapacity + ")...");
                }
                aList = new Vector(initialCapacity);
                if (this.logProgress) {
                    Log.getLogWriter().info("Finished call to constructor: " + TestHelper.toString(aList));
                }
            } else if (constructor.equalsIgnoreCase("initialCapacity_capacityIncrement")) {
                int initialCapacity = TestConfig.tab().intAt(RandomValuesPrms.Vector_initialCapacity);
                int capacityIncrement = TestConfig.tab().intAt(RandomValuesPrms.Vector_capacityIncrement);
                if (this.logProgress) {
                    Log.getLogWriter().info("Creating instance with constructor: new Vector(" + initialCapacity + ", " + capacityIncrement + ")...");
                }
                aList = new Vector(initialCapacity, capacityIncrement);
                if (this.logProgress) {
                    Log.getLogWriter().info("Finished call to constructor: " + TestHelper.toString(aList));
                }
            } else {
                throw new TestException("Unknown constructor " + constructor);
            }
            syncWrapper = TestConfig.tab().booleanAt(RandomValuesPrms.Vector_syncWrapper);
        } else {
            aList = (ArrayList)this.createInstance(aClass);
        }
        return aList;
    }

    Object createInstance(Class aClass) {
        try {
            Object anObj = aClass.newInstance();
            return anObj;
        }
        catch (InstantiationException anExcept) {
            throw new TestException(TestHelper.getStackTrace(anExcept));
        }
        catch (IllegalAccessException anExcept) {
            throw new TestException(TestHelper.getStackTrace(anExcept));
        }
        catch (Exception anExcept) {
            throw new TestException(TestHelper.getStackTrace(anExcept));
        }
    }

    public Object getRandom_array(String type) {
        if (!type.endsWith("[]")) {
            throw new TestException("Unable to create array of type " + type);
        }
        String baseType = type.substring(0, type.indexOf("[]"));
        int arraySize = TestConfig.tasktab().intAt(RandomValuesPrms.elementSize, TestConfig.tab().intAt(RandomValuesPrms.elementSize));
        if (baseType.equals("int")) {
            return new int[arraySize];
        }
        if (baseType.equals("long")) {
            return new long[arraySize];
        }
        if (baseType.equals("double")) {
            return new double[arraySize];
        }
        if (baseType.equals("boolean")) {
            return new boolean[arraySize];
        }
        if (baseType.equals("byte")) {
            return new byte[arraySize];
        }
        if (baseType.equals("char")) {
            return new char[arraySize];
        }
        if (baseType.equals("float")) {
            return new float[arraySize];
        }
        if (baseType.equals("short")) {
            return new short[arraySize];
        }
        Class<?> aClass = null;
        try {
            aClass = Class.forName(baseType);
        }
        catch (ClassNotFoundException anExcept) {
            throw new TestException(anExcept.toString());
        }
        Object anArr = Array.newInstance(aClass, arraySize);
        return anArr;
    }

    public void createDepth(Object anObj) {
        if (this.createDebug) {
            Log.getLogWriter().info("in top createDepth with " + TestHelper.toString(anObj));
        }
        int objectDepth = TestConfig.tab().intAt(RandomValuesPrms.objectDepth);
        this.createDepth(objectDepth, anObj);
        if (this.createDebug) {
            Log.getLogWriter().info("leaving top createDepth with " + TestHelper.toString(anObj));
        }
    }

    private void createDepth(int currentDepth, Object anObj) {
        if (this.createDebug) {
            if (anObj == null) {
                Log.getLogWriter().info("in createDepth to sort classes with currentDepth " + currentDepth + ", null");
            } else {
                Log.getLogWriter().info("in createDepth to sort classes with currentDepth " + currentDepth + anObj.getClass().getName());
            }
        }
        if (currentDepth <= 0) {
            if (this.createDebug) {
                Log.getLogWriter().info("in createDepth to sort classes, returning because depth is " + currentDepth);
            }
            return;
        }
        if (anObj instanceof Map) {
            Map aMap = (Map)anObj;
            if (this.createDebug) {
                Log.getLogWriter().info("About to call createDepthForMap");
            }
            this.createDepthForMap(currentDepth, aMap);
        } else if (anObj instanceof List) {
            List aList = (List)anObj;
            if (this.createDebug) {
                Log.getLogWriter().info("About to call createDepthForList");
            }
            this.createDepthForList(currentDepth, aList);
        } else if (anObj instanceof Set) {
            Set aSet = (Set)anObj;
            if (this.createDebug) {
                Log.getLogWriter().info("About to call createDepthForSet");
            }
            this.createDepthForSet(currentDepth, aSet);
        } else if (anObj.getClass().isArray()) {
            if (this.createDebug) {
                Log.getLogWriter().info("About to call createDepthForArray");
            }
            this.createDepthForArray(currentDepth, anObj);
        } else if (anObj instanceof BitSet) {
            if (this.createDebug) {
                Log.getLogWriter().info("Creating depth for BitSet");
            }
            BitSet bSet = (BitSet)anObj;
            for (int i = 0; i < bSet.length(); ++i) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    bSet.set(i);
                    continue;
                }
                bSet.clear(i);
            }
        } else {
            if (anObj instanceof Boolean || anObj instanceof Byte || anObj instanceof Character || anObj instanceof Double || anObj instanceof Float || anObj instanceof Integer || anObj instanceof Long || anObj instanceof Short || anObj instanceof String || anObj instanceof BigDecimal || anObj instanceof BigInteger || anObj instanceof StringBuffer) {
                return;
            }
            throw new TestException("Don't know how to create depth for " + anObj.getClass().getName());
        }
    }

    private void createDepthForMap(int currentDepth, Map aMap) {
        if (this.createDebug) {
            Log.getLogWriter().info("in createDepthForMap currentDepth " + currentDepth + ", " + TestHelper.toString(aMap));
        }
        int elementSize = TestConfig.tab().intAt(RandomValuesPrms.elementSize);
        if (this.createDebug) {
            Log.getLogWriter().info("elementSize is " + elementSize);
        }
        while (aMap.size() < elementSize) {
            if (this.createDebug) {
                Log.getLogWriter().info("top of loop");
            }
            Object key = this.getRandomObject(this.getKeyTypeVec(), aMap);
            if (this.createDebug) {
                Log.getLogWriter().info("key is " + key);
            }
            Object value = this.getRandomObject(this.getValueTypeVec(), aMap);
            if (this.createDebug) {
                Log.getLogWriter().info("value is " + value.getClass().getName());
            }
            aMap.put(key, value);
            if (this.createDebug) {
                Log.getLogWriter().info("in createDepthForMap putting key " + TestHelper.toString(key) + ", value " + TestHelper.toString(value));
            }
            if (this.createDebug) {
                Log.getLogWriter().info("calling createdepth for key");
            }
            this.createDepth(currentDepth - 1, key);
            if (this.createDebug) {
                Log.getLogWriter().info("calling createdepth for value");
            }
            this.createDepth(currentDepth - 1, value);
            if (!this.createDebug) continue;
            Log.getLogWriter().info("at end of loop");
        }
        if (this.createDebug) {
            Log.getLogWriter().info("outside of loop");
        }
    }

    private void createDepthForList(int currentDepth, List aList) {
        if (this.createDebug) {
            Log.getLogWriter().info("in createDepthForList currentDepth " + currentDepth + ", " + TestHelper.toString(aList));
        }
        int elementSize = TestConfig.tab().intAt(RandomValuesPrms.elementSize);
        while (aList.size() < elementSize) {
            Object anObj = this.getRandomObject(this.getObjectTypeVec());
            aList.add(anObj);
            if (this.createDebug) {
                Log.getLogWriter().info("in createDepthForList putting ele " + TestHelper.toString(anObj));
            }
            this.createDepth(currentDepth - 1, anObj);
        }
    }

    private void createDepthForSet(int currentDepth, Set aSet) {
        int elementSize = TestConfig.tab().intAt(RandomValuesPrms.elementSize);
        while (aSet.size() < elementSize) {
            Object anObj = this.getRandomObject(this.getSetElementTypeVec());
            aSet.add(anObj);
            this.createDepth(currentDepth - 1, anObj);
        }
    }

    private void createDepthForArray(int currentDepth, Object anArr) {
        Class<?> aClass = anArr.getClass();
        Class<?> componentType = aClass.getComponentType();
        if (componentType == Byte.TYPE) {
            TestConfig.tab().getRandGen().nextBytes((byte[])anArr);
        }
        int arraySize = Array.getLength(anArr);
        Vector<String> aVec = new Vector<String>();
        aVec.add(componentType.toString());
        for (int i = 0; i < arraySize; ++i) {
            Object anObj = this.getRandomObject(aVec);
            Array.set(anArr, i, anObj);
            this.createDepth(currentDepth - 1, anObj);
        }
    }

    public boolean modify(Object anObj) {
        Log.getLogWriter().info("RandomValues: Modifying " + TestHelper.toString(anObj));
        int objectDepth = TestConfig.tab().intAt(RandomValuesPrms.objectDepth);
        objectDepth = TestConfig.tab().getRandGen().nextInt(0, objectDepth);
        boolean result = this.modify(anObj, 0, objectDepth);
        Log.getLogWriter().info("RandomValues, finished attempt at modify, object was modified: " + result + ", object is " + TestHelper.toString(anObj));
        return result;
    }

    boolean modify(Object anObj, int currentDepth, int maxDepth) {
        if (anObj == null) {
            Log.getLogWriter().info("Unable to modify: null");
            return false;
        }
        if (anObj instanceof Map) {
            Map aMap = (Map)anObj;
            if (currentDepth == maxDepth || aMap.size() == 0) {
                this.randomModify(aMap);
                return true;
            }
            Object key = TestHelper.getRandomKeyInMap(aMap);
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                return this.modify(key, currentDepth + 1, maxDepth);
            }
            return this.modify(aMap.get(key), currentDepth + 1, maxDepth);
        }
        if (anObj instanceof List) {
            List aList = (List)anObj;
            if (currentDepth == maxDepth || aList.size() == 0) {
                this.randomModify(aList);
                return true;
            }
            int randInt = TestConfig.tab().getRandGen().nextInt(1, aList.size() - 1);
            return this.modify(aList.get(randInt), currentDepth + 1, maxDepth);
        }
        if (anObj instanceof Set) {
            Set aSet = (Set)anObj;
            if (currentDepth == maxDepth || aSet.size() == 0) {
                this.randomModify(aSet);
                return true;
            }
            Object element = TestHelper.getRandomElementInSet(aSet);
            return this.modify(element, currentDepth + 1, maxDepth);
        }
        if (anObj instanceof BitSet) {
            BitSet bSet = (BitSet)anObj;
            for (int i = 0; i < bSet.length(); ++i) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    bSet.set(i);
                    continue;
                }
                bSet.clear(i);
            }
            Log.getLogWriter().info("Modified " + TestHelper.toString(anObj));
            return true;
        }
        if (anObj instanceof StringBuffer) {
            StringBuffer aStr = (StringBuffer)anObj;
            Log.getLogWriter().info("Modify: Changing " + TestHelper.toString(aStr));
            int index = TestConfig.tab().getRandGen().nextInt(0, aStr.length());
            StringBuffer xstr = this.getRandom_StringBuffer();
            aStr.insert(index, xstr);
            int newSize = Math.min(TestConfig.tab().intAt(RandomValuesPrms.stringSize), aStr.length());
            aStr.setLength(newSize);
            Log.getLogWriter().info("Modify: After change: " + TestHelper.toString(aStr));
            return true;
        }
        if (anObj instanceof Boolean || anObj instanceof Byte || anObj instanceof Character || anObj instanceof Double || anObj instanceof Float || anObj instanceof Integer || anObj instanceof Long || anObj instanceof Short || anObj instanceof String || anObj instanceof BigDecimal || anObj instanceof BigInteger) {
            Log.getLogWriter().info("Unable to modify immutable object : " + TestHelper.toString(anObj));
            return false;
        }
        throw new TestException("Do not know how to modify " + anObj.getClass().getName());
    }

    void randomModify(Map aMap) {
        int[] nArray;
        boolean ADD_NEW_KEY = false;
        boolean USE_EXISTING_KEY = true;
        int REMOVE = 2;
        if (aMap.size() == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray = nArray3;
            nArray3[2] = 0;
        }
        int[] choices = nArray;
        int choice = choices[TestConfig.tab().getRandGen().nextInt(0, choices.length - 1)];
        switch (choice) {
            case 0: {
                Object key = this.getRandomObject(this.getKeyTypeVec());
                Object value = this.getRandomObject(this.getValueTypeVec());
                Log.getLogWriter().info("Modify: Adding new key: " + TestHelper.toString(aMap) + ".put(" + TestHelper.toString(key) + ", " + TestHelper.toString(value));
                aMap.put(key, value);
                break;
            }
            case 1: {
                Object key = TestHelper.getRandomKeyInMap(aMap);
                Object value = this.getRandomObject(this.getValueTypeVec());
                Log.getLogWriter().info("Modify: Putting existing key: " + TestHelper.toString(aMap) + ".put(" + TestHelper.toString(key) + ", " + TestHelper.toString(value));
                aMap.put(key, value);
                break;
            }
            case 2: {
                Object key = TestHelper.getRandomKeyInMap(aMap);
                Log.getLogWriter().info("Modify: " + TestHelper.toString(aMap) + ".remove(" + TestHelper.toString(key));
                aMap.remove(key);
                break;
            }
            default: {
                throw new TestException("Unknown choice " + choice);
            }
        }
    }

    void randomModify(List aList) {
        int[] nArray;
        boolean ADD = false;
        int REMOVE = 2;
        if (aList.size() == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = 2;
        }
        int[] choices = nArray;
        int choice = choices[TestConfig.tab().getRandGen().nextInt(0, choices.length - 1)];
        switch (choice) {
            case 0: {
                Object element = this.getRandomObject(this.getObjectTypeVec());
                Log.getLogWriter().info("Modify: Adding: " + TestHelper.toString(aList) + ".add(" + TestHelper.toString(element) + ")");
                aList.add(element);
                break;
            }
            case 2: {
                int index = TestConfig.tab().getRandGen().nextInt(0, aList.size() - 1);
                Log.getLogWriter().info("Modify: " + TestHelper.toString(aList) + ".remove(" + index + ")");
                aList.remove(index);
                break;
            }
            default: {
                throw new TestException("Unknown choice " + choice);
            }
        }
    }

    void randomModify(Set aSet) {
        int[] nArray;
        boolean ADD = false;
        boolean REMOVE = true;
        if (aSet.size() == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = 1;
        }
        int[] choices = nArray;
        int choice = choices[TestConfig.tab().getRandGen().nextInt(0, choices.length - 1)];
        switch (choice) {
            case 0: {
                Object element = this.getRandomObject(this.getSetElementTypeVec());
                Log.getLogWriter().info("Modify: Adding: " + TestHelper.toString(aSet) + ".add(" + TestHelper.toString(element) + ")");
                aSet.add(element);
                break;
            }
            case 1: {
                Object element = TestHelper.getRandomElementInSet(aSet);
                Log.getLogWriter().info("Modify: " + TestHelper.toString(aSet) + ".remove(" + TestHelper.toString(element));
                aSet.remove(element);
                break;
            }
            default: {
                throw new TestException("Unknown choice " + choice);
            }
        }
    }

    private Object getRandomObject(Vector dataTypeVec) {
        int randInt = TestConfig.tab().getRandGen().nextInt(0, dataTypeVec.size() - 1);
        String objectType = (String)dataTypeVec.elementAt(randInt);
        Object anObj = this.getRandomObjectForType(objectType);
        return anObj;
    }

    private Object getRandomObject(Vector dataTypeVec, Object extraObj) {
        int randInt = TestConfig.tab().getRandGen().nextInt(0, dataTypeVec.size() - 1);
        String objectType = (String)dataTypeVec.elementAt(randInt);
        Object anObj = this.getRandomObjectForType(objectType, extraObj);
        return anObj;
    }

    private Vector getObjectTypeVec() {
        return this.objectTypeVec;
    }

    private Vector getKeyTypeVec() {
        return this.keyTypeVec;
    }

    private Vector getValueTypeVec() {
        return this.valueTypeVec;
    }

    private Vector getSetElementTypeVec() {
        return this.setElementVec;
    }

    private String getRandomStringFromVec(Vector aVec) {
        int randInt = TestConfig.tab().getRandGen().nextInt(0, aVec.size() - 1);
        String result = (String)aVec.elementAt(randInt);
        return result;
    }

    static {
        RandomValues.setPrintableChars(false);
    }
}

