/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.management.ManagementException;
import hydra.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import resultsUtil.FileLineReader;
import util.LogCheckerBB;
import util.TestException;
import util.TestHelper;

public class LogChecker {
    private static List<String> suspectStrings = null;
    private static List<String> excludeStrings = null;

    public static void HydraTask_checkLogs() {
        long leader = LogCheckerBB.getBB().getSharedCounters().incrementAndRead(LogCheckerBB.leader);
        if (leader != 1L) {
            return;
        }
        Log.getLogWriter().info("Checking the logs...");
        List<File> logsToCheck = LogChecker.getLogs();
        for (File aFile : logsToCheck) {
            FileLineReader reader;
            Log.getLogWriter().info("Checking " + aFile.getAbsolutePath());
            try {
                reader = new FileLineReader(aFile);
            }
            catch (FileNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            String line = reader.readNextLine();
            while (line != null) {
                if (LogChecker.contains(suspectStrings, line) && !LogChecker.contains(excludeStrings, line)) {
                    throw new TestException(aFile.getAbsolutePath() + " contains " + line);
                }
                line = reader.readNextLine();
            }
        }
    }

    private static boolean contains(List<String> targetStrs, String aStr) {
        for (String target : targetStrs) {
            if (!aStr.contains(target)) continue;
            return true;
        }
        return false;
    }

    private static List<File> getLogs() {
        String baseTestDir = LogChecker.getBaseTestDir();
        if (baseTestDir == null) {
            throw new TestException("Test problem: Could not find base test directory");
        }
        File currentDir = new File(baseTestDir);
        ArrayList<File> logList = new ArrayList<File>();
        LogChecker.getLogs(currentDir, logList);
        return logList;
    }

    private static String getBaseTestDir() {
        String currentDirPath = System.getProperty("user.dir");
        return LogChecker._getBaseTestDir(currentDirPath);
    }

    private static String _getBaseTestDir(String fileName) {
        if (fileName == null) {
            return null;
        }
        File currentDir = new File(fileName);
        if (currentDir.isDirectory()) {
            String[] dirContents;
            for (String name : dirContents = currentDir.list()) {
                if (!name.startsWith("Master") || !name.endsWith(".log")) continue;
                return currentDir.getAbsolutePath();
            }
        }
        return LogChecker._getBaseTestDir(currentDir.getParent());
    }

    private static void getLogs(File currentDir, List<File> logs) {
        File[] dirContents;
        for (File aFile : dirContents = currentDir.listFiles()) {
            if (aFile.isDirectory()) {
                LogChecker.getLogs(aFile, logs);
                continue;
            }
            String fileName = aFile.getName();
            if (fileName.startsWith("system") && fileName.endsWith(".log")) {
                logs.add(aFile);
                continue;
            }
            if (fileName.startsWith("bgexec") && fileName.endsWith(".log")) {
                logs.add(aFile);
                continue;
            }
            if (!fileName.startsWith("gfsh") || fileName.indexOf(".log") < 0) continue;
            logs.add(aFile);
        }
    }

    static {
        suspectStrings = new ArrayList<String>();
        suspectStrings.add(ClassCastException.class.getName());
        suspectStrings.add(NullPointerException.class.getName());
        suspectStrings.add("java.io.IOException: Resource deadlock avoided");
        suspectStrings.add("java.nio.channels.OverlappingFileLockException");
        suspectStrings.add("java.io.IOException: Bad file number");
        suspectStrings.add(InternalGemFireError.class.getName());
        suspectStrings.add(ManagementException.class.getName());
        suspectStrings.add("Could not start jmx manager");
        suspectStrings.add("java.lang.Exception");
        excludeStrings = new ArrayList<String>();
        excludeStrings.add("[fine");
        excludeStrings.add("Cannot have overlapping ranges");
    }
}

