/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.LogWriter;
import hydra.ClientDescription;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.TestConfig;
import java.util.List;
import java.util.Vector;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;
import perffmwk.TrimSpec;
import util.CpuLoadPrms;
import util.RandomValues;
import util.TestException;

public class CpuLoad {
    protected static HydraThreadLocal numWorkThreads = new HydraThreadLocal();
    protected static CpuLoad cpuLoad;
    protected static final long workThreadSleepTime;

    public static void initNonGemFireWorkTask() {
        if (CpuLoadPrms.doWorkTask() && cpuLoad == null) {
            cpuLoad = new CpuLoad();
            cpuLoad.initNonGemFireWork();
        }
    }

    protected void initNonGemFireWork() {
        double meanCpuLoad = 0.0;
        int minReqdCpuLoad = CpuLoadPrms.getCpuLoadMin();
        int maxReqdCpuLoad = CpuLoadPrms.getCpuLoadMax();
        Vector<Thread> workThreads = new Vector<Thread>();
        boolean metReqdLoad = false;
        long startTime = System.currentTimeMillis();
        long elapsedTime = 0L;
        while (!metReqdLoad) {
            if (meanCpuLoad < (double)minReqdCpuLoad) {
                Thread workThread = this.getWorkerThread();
                workThreads.add(workThread);
                CpuLoad.log().fine("#### Starting work thread: " + workThread.getName());
                ((Thread)workThreads.lastElement()).start();
                long t1 = System.currentTimeMillis();
                MasterController.sleepForMs(10000);
                long t2 = System.currentTimeMillis();
                meanCpuLoad = CpuLoad.getMeanCpuActive(t1, t2);
                CpuLoad.log().info("Mean CPU Active: " + meanCpuLoad);
                elapsedTime = System.currentTimeMillis() - startTime;
                continue;
            }
            if (meanCpuLoad > (double)maxReqdCpuLoad) {
                throw new TestException("Test exceeded non-GemFire cpu load target: " + maxReqdCpuLoad + ", mean cpu active: " + meanCpuLoad);
            }
            metReqdLoad = true;
            break;
        }
        numWorkThreads.set(new Integer(workThreads.size()));
        CpuLoad.log().info("### Met required CPU Load: " + metReqdLoad + ", mean cpu active: " + meanCpuLoad);
        for (int i = 0; i < workThreads.size(); ++i) {
            ((Thread)workThreads.get(i)).interrupt();
        }
    }

    public static void doNonGemFireWorkTask() {
        if (CpuLoadPrms.doWorkTask()) {
            cpuLoad.doNonGemFireWork();
        }
    }

    public void doNonGemFireWork() {
        long workSec = CpuLoadPrms.getWorkSec();
        long workMs = workSec * 1000L;
        Vector<Thread> workThreads = new Vector<Thread>();
        long startTime = System.currentTimeMillis();
        long elapsedTime = 0L;
        Integer numThreadsToStart = (Integer)numWorkThreads.get();
        CpuLoad.log().info("Number of work threads to start for NonGemFireWork: " + numThreadsToStart);
        for (int i = 0; i < numThreadsToStart; ++i) {
            Thread workThread = this.getWorkerThread();
            workThreads.add(workThread);
            ((Thread)workThreads.lastElement()).start();
            CpuLoad.log().info("start worker thread: " + i);
        }
        CpuLoad.log().fine("duration of work task will be: " + workSec);
        elapsedTime = System.currentTimeMillis() - startTime;
        CpuLoad.log().fine("elaspsed time after starting worker threads:  " + elapsedTime);
        long timeUntilEnd = workMs - elapsedTime;
        if (timeUntilEnd > 0L) {
            CpuLoad.log().info("Non-GemFire work running until end of test in: " + timeUntilEnd + " ms");
            MasterController.sleepForMs((int)timeUntilEnd);
        }
        elapsedTime = System.currentTimeMillis() - startTime;
        CpuLoad.log().fine("#### Stopping CPU work task");
        CpuLoad.log().fine("Elapsed time: " + elapsedTime);
        for (int i = 0; i < workThreads.size(); ++i) {
            ((Thread)workThreads.get(i)).interrupt();
        }
    }

    private Thread getWorkerThread() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    RandomValues randVals = new RandomValues();
                    while (true) {
                        String str = randVals.getRandom_String();
                        int i = str.indexOf("str2");
                        Thread.sleep(workThreadSleepTime);
                    }
                }
                catch (InterruptedException e) {
                    CpuLoad.log().fine("Non-GemFire work thread interrupted");
                    return;
                }
            }
        });
        return workThread;
    }

    public static double getMeanCpuActive(long startTime, long endTime) {
        String specType;
        String clientName = System.getProperty("clientName");
        ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
        String archive = cd.getGemFireDescription().getName() + "*";
        String osName = System.getProperty("os.name");
        if (osName.equals("SunOS")) {
            specType = "SolarisSystemStats ";
        } else if (osName.startsWith("Windows")) {
            specType = "WindowsSystemStats ";
        } else if (osName.startsWith("Linux")) {
            specType = "LinuxSystemStats ";
        } else {
            throw new TestException("Unable to generate average CPU active:  Unsupported OS in \"" + osName + "\". Supported OSs are: SunOS(sparc Solaris), Linux(x86) and Windows.");
        }
        TrimSpec trim = new TrimSpec("runtime_MeanCpuActive");
        trim.start(startTime);
        trim.end(endTime);
        CpuLoad.log().fine("HEY: trim is " + trim);
        String spec = archive + " " + specType + "* cpuActive " + "filter" + "=" + "none" + " " + "combine" + "=" + "raw" + " " + "ops" + "=" + "mean";
        CpuLoad.log().fine("HEY: spec is " + spec);
        List psvs = PerfStatMgr.getInstance().readStatistics(spec, trim);
        CpuLoad.log().fine("HEY: psvs are " + psvs);
        PerfStatValue psv = (PerfStatValue)psvs.get(0);
        double mean = psv.getMean();
        CpuLoad.log().fine("HEY: mean cpu active is " + mean + " for trim " + trim);
        return mean;
    }

    protected static LogWriter log() {
        return Log.getLogWriter();
    }

    static {
        workThreadSleepTime = CpuLoadPrms.getSleepMsNonGemFire();
    }
}

