/*
 * Decompiled with CFR 0.152.
 */
package util;

import hydra.TestConfig;
import java.math.BigInteger;
import util.NameFactory;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.ValueHolder;
import util.ValueHolderIF;
import util.ValueHolderPrms;

public abstract class BaseValueHolder
implements ValueHolderIF {
    public String myVersion;
    public Object myValue = null;
    public Object extraObject = null;
    public Integer modVal = null;

    public BaseValueHolder() {
    }

    public BaseValueHolder(Object anObj, RandomValues randomValues) {
        this.myValue = anObj;
        if (TestConfig.tab().booleanAt(ValueHolderPrms.useExtraObject)) {
            this.extraObject = randomValues.getRandomObjectGraph();
        }
    }

    public BaseValueHolder(RandomValues randomValues) {
        this.myValue = randomValues.getRandomObjectGraph();
        if (TestConfig.tab().booleanAt(ValueHolderPrms.useExtraObject)) {
            this.extraObject = randomValues.getRandomObjectGraph();
        }
    }

    public BaseValueHolder(String nameFactoryName, RandomValues randomValues) {
        this.myValue = new Long(NameFactory.getCounterForName(nameFactoryName));
        if (TestConfig.tab().booleanAt(ValueHolderPrms.useExtraObject)) {
            this.extraObject = randomValues.getRandomObjectGraph();
        }
    }

    public BaseValueHolder(Object anObj, RandomValues randomValues, Integer initModVal) {
        this.myValue = anObj;
        this.modVal = initModVal;
        if (TestConfig.tab().booleanAt(ValueHolderPrms.useExtraObject)) {
            this.extraObject = randomValues.getRandomObjectGraph();
        }
    }

    public BaseValueHolder(String nameFactoryName, RandomValues randomValues, Integer initModVal) {
        this.myValue = new Long(NameFactory.getCounterForName(nameFactoryName));
        this.modVal = initModVal;
        if (TestConfig.tab().booleanAt(ValueHolderPrms.useExtraObject)) {
            this.extraObject = randomValues.getRandomObjectGraph();
        }
    }

    @Override
    public Object getMyValue() {
        return this.myValue;
    }

    @Override
    public Object getExtraObject() {
        return this.extraObject;
    }

    @Override
    public Integer getModVal() {
        return this.modVal;
    }

    public void setModVal(Integer val) {
        this.modVal = val;
    }

    public void incrementModVal(Integer val) {
        this.modVal = new Integer(this.modVal + 1);
    }

    public String toString() {
        return this.getClass().getName() + " [myVersion=" + this.myVersion + ", myValue=" + TestHelper.toString(this.myValue) + ", extraObject=" + TestHelper.toString(this.extraObject) + ", modVal=" + this.modVal + "]";
    }

    public BaseValueHolder getAlternateValueHolder(RandomValues randomValues) {
        ValueHolder vh = new ValueHolder();
        if (this.myValue instanceof Long) {
            vh.myValue = this.myValue.toString();
        } else if (this.myValue instanceof String) {
            vh.myValue = new Integer((String)this.myValue);
        } else if (this.myValue instanceof Integer) {
            vh.myValue = new BigInteger(this.myValue.toString());
        } else if (this.myValue instanceof BigInteger) {
            vh.myValue = new Long(this.myValue.toString());
        } else {
            throw new TestException("Cannot get replace value for myValue in " + TestHelper.toString(vh));
        }
        if (TestConfig.tab().booleanAt(ValueHolderPrms.useExtraObject)) {
            vh.extraObject = randomValues.getRandomObjectGraph();
        }
        return vh;
    }

    public void verifyMyFields(long base) {
    }

    public void verifyMyFields(String string, long base) {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.toString().hashCode());
        return result;
    }

    public boolean equals(Object anObj) {
        if (anObj == null) {
            return false;
        }
        if (anObj.getClass().getName().equals(this.getClass().getName())) {
            BaseValueHolder vh = (BaseValueHolder)anObj;
            if (vh.myValue == null && this.myValue != null) {
                return false;
            }
            if (!vh.myValue.equals(this.myValue)) {
                return false;
            }
            if (vh.extraObject == null && this.extraObject != null) {
                return false;
            }
            return !(vh.modVal == null ? this.modVal != null : !vh.modVal.equals(this.modVal));
        }
        return false;
    }
}

