/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.AlertListener;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.SystemMemberCacheListener;
import com.gemstone.gemfire.admin.SystemMembershipListener;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.AgentHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.GemFireDescription;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.Prms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.Properties;
import splitBrain.SplitBrainPrms;
import util.AdminHelperPrms;
import util.AdminTestDistributedSystemFactory;
import util.AdminTestException;

public class AdminHelper {
    private static AdminDistributedSystem adminDS = null;

    public static AdminDistributedSystem getAdminDistributedSystem() {
        return adminDS;
    }

    public static synchronized void HydraTask_initializeAdminDS() {
        if (adminDS == null) {
            adminDS = AdminHelper.initializeAdminDS();
        }
    }

    public static synchronized void HydraEndTask_waitForReconnect() {
        String losingPartition = TestConfig.tab().stringAt(SplitBrainPrms.losingPartition);
        if (losingPartition.equalsIgnoreCase("host1") || losingPartition.equalsIgnoreCase("host2")) {
            String losingSideHost = TestConfig.getInstance().getHostDescription(losingPartition).getHostName();
            if (RemoteTestModule.getMyHost().equalsIgnoreCase(losingSideHost)) {
                try {
                    while (DistributedSystemHelper.getDistributedSystem() == null) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    public static AdminDistributedSystem initializeAdminDS() {
        AlertListener aListener;
        SystemMemberCacheListener systemMemberCacheListener;
        SystemMembershipListener systemMembershipListener;
        DistributedSystemConfig dsConfig;
        Log.getLogWriter().info("Creating an admin DistributedSystem...");
        boolean adminInDsVm = AdminHelperPrms.adminInDsVm();
        if (!adminInDsVm) {
            AdminDistributedSystemFactory.setEnableAdministrationOnly((boolean)true);
            String gemfireName = System.getProperty("gemfireName");
            GemFireDescription gfd = TestConfig.getInstance().getGemFireDescription(gemfireName);
            Integer mcastPort = gfd.getMcastPort();
            String mcastAddress = gfd.getMcastAddress();
            Boolean disableTcp = gfd.getDisableTcp();
            Boolean disableAutoReconnect = gfd.getDisableAutoReconnect();
            Properties p = gfd.getDistributedSystemProperties();
            String locatorPortString = p.getProperty("locators");
            Log.getLogWriter().info("locatorPortString = " + locatorPortString);
            dsConfig = AdminDistributedSystemFactory.defineDistributedSystem();
            dsConfig.setLocators(locatorPortString);
            if (TestConfig.tab().booleanAt(Prms.useIPv6)) {
                String ipv6 = HostHelper.getHostAddress(HostHelper.getIPv6Address());
                if (ipv6 == null) {
                    String host = gfd.getHostDescription().getHostName();
                    String s = "IPv6 address is not available for host " + host;
                    throw new HydraRuntimeException(s);
                }
                dsConfig.setBindAddress(ipv6);
            }
            dsConfig.setMcastPort(mcastPort.intValue());
            dsConfig.setMcastAddress(mcastAddress);
            dsConfig.setDisableTcp(disableTcp.booleanValue());
            if (disableAutoReconnect != null) {
                dsConfig.setDisableAutoReconnect(disableAutoReconnect.booleanValue());
            }
            dsConfig.setLogFile(gfd.getSysDirName() + "/system.log");
            dsConfig.setLogLevel(gfd.getLogLevel());
        } else {
            Cache cache = CacheHelper.getCache();
            DistributedSystem thisVmDs = cache.getDistributedSystem();
            try {
                dsConfig = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)thisVmDs, null);
            }
            catch (AdminException ae) {
                String s = "Problem getting config for ds to which VM is currently connected";
                throw new AdminTestException(s, (Exception)((Object)ae));
            }
        }
        AdminDistributedSystem adminDS = AdminTestDistributedSystemFactory.getDistributedSystem(dsConfig);
        if (adminDS == null) {
            throw new HydraRuntimeException("Could not getDistributedSystem");
        }
        Log.getLogWriter().fine("getDistributedSystem returned " + adminDS.toString());
        if (AdminHelperPrms.getAdminInterface() == 0 && (systemMembershipListener = AdminHelperPrms.getSystemMembershipListener()) != null) {
            adminDS.addMembershipListener(systemMembershipListener);
        }
        if (AdminHelperPrms.getAdminInterface() == 0 && (systemMemberCacheListener = AdminHelperPrms.getSystemMemberCacheListener()) != null) {
            adminDS.addCacheListener(systemMemberCacheListener);
        }
        if (AdminHelperPrms.getAdminInterface() == 0 && (aListener = AdminHelperPrms.getAlertListener()) != null) {
            adminDS.addAlertListener(aListener);
        }
        adminDS.connect();
        try {
            adminDS.waitToBeConnected(3000L);
        }
        catch (InterruptedException ie) {
            Log.getLogWriter().warning("Interrupted while waiting to connect", (Throwable)ie);
        }
        dsConfig = adminDS.getConfig();
        while (!adminDS.isRunning()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                Log.getLogWriter().warning("Interrupted while sleeping", (Throwable)ex);
            }
        }
        Log.getLogWriter().fine("getConfig returns " + dsConfig.toString());
        String runningStatus = new String(adminDS.isRunning() ? " is " : " is not ");
        Log.getLogWriter().info("DistributedSystem " + adminDS.getName() + ":" + adminDS.getId() + runningStatus + "running");
        Log.getLogWriter().info("Exiting initializeAdminDS()");
        return adminDS;
    }

    public static void startAgentTask() {
        String agentConfig = ConfigPrms.getAgentConfig();
        AgentHelper.createAgent(agentConfig);
        AgentHelper.startAgent();
    }

    public static synchronized void waitForSystemMembersTask() {
        AdminHelper.waitForSystemMembers();
    }

    /*
     * Exception decompiling
     */
    protected static void waitForSystemMembers() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

