/*
 * Decompiled with CFR 0.152.
 */
package tx.capCon;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import event.LogListener;
import hydra.GsRandom;
import hydra.HydraVector;
import hydra.Log;
import hydra.TestConfig;
import tx.TxLoader;
import tx.TxPrms;
import tx.TxUtil;
import util.CacheUtil;
import util.RegionDefinition;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;

public abstract class NoConflictTest {
    public static NoConflictTest testInstance = null;
    protected static final String REGION_NAME = "capConRegion";
    protected Region aRegion;

    protected abstract void verifyCapacity();

    protected abstract void fill();

    protected void initialize() {
        RegionDefinition regDef = RegionDefinition.createRegionDefinition();
        Log.getLogWriter().info("Using RegionDefinition " + regDef + " to create region");
        this.aRegion = regDef.createRootRegion(CacheUtil.createCache(), REGION_NAME, new LogListener(), new TxLoader(), null);
    }

    public static void HydraTask_fill() {
        testInstance.fill();
    }

    public static void HydraTask_doOpsInTx() {
        testInstance.doOpsInTx();
    }

    public static void HydraTask_addNewEntries() {
        testInstance.addNewEntries();
    }

    protected void doOpsInTx() {
        HydraVector operations = TestConfig.tab().vecAt(TxPrms.operations);
        int numOps = TestConfig.tab().intAt(TxPrms.numOps);
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In txThread, doing random operations for " + timeToRunSec + " seconds");
        long startTime = System.currentTimeMillis();
        do {
            TxHelper.begin();
            int numOpsCompleted = 0;
            while (numOpsCompleted != numOps) {
                try {
                    TxUtil.txUtilInstance.doOperations(operations, 1);
                    ++numOpsCompleted;
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Throwable e) {
                    String errStr = e.toString();
                    if (errStr.indexOf(EntryNotFoundException.class.getName()) >= 0) {
                        Log.getLogWriter().info("Caught " + errStr + "; continuing test");
                        continue;
                    }
                    throw new TestException(TestHelper.getStackTrace(e));
                }
            }
            TxHelper.commitExpectSuccess();
            this.verifyCapacity();
        } while (System.currentTimeMillis() - startTime < timeToRunMS);
        Log.getLogWriter().info("In doOpsInTx, done running for " + timeToRunSec + " seconds");
    }

    protected void addNewEntries() {
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In addNewEntries, creating new entries for " + timeToRunSec + " seconds");
        long startTime = System.currentTimeMillis();
        GsRandom rand = TestConfig.tab().getRandGen();
        do {
            if (rand.nextBoolean()) {
                TxUtil.txUtilInstance.createEntry(this.aRegion, false);
                continue;
            }
            TxUtil.txUtilInstance.getEntryWithNewKey(this.aRegion);
        } while (System.currentTimeMillis() - startTime < timeToRunMS);
        Log.getLogWriter().info("In addEntries, done running for " + timeToRunSec + " seconds");
    }
}

