/*
 * Decompiled with CFR 0.152.
 */
package tx;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.RegionHelper;
import hydra.TestConfig;
import tx.TxUtil;
import util.CacheUtil;
import util.TestException;
import util.TxHelper;

public class ConflictCheck {
    public static ConflictCheck testInstance = null;
    private final String KEY = "key";
    private HydraThreadLocal txState = new HydraThreadLocal();
    private Region aRegion;
    private boolean hasCommitted = false;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new ConflictCheck();
        }
        testInstance.initialize();
    }

    protected void initialize() {
        Cache aCache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
        CacheUtil.setCache(aCache);
        this.aRegion = RegionHelper.createRegion(ConfigPrms.getRegionConfig());
        this.aRegion.put((Object)"key", (Object)new Integer(0));
    }

    public static void HydraTask_txOnlyConflictCheck() {
        testInstance.txOnlyConflictCheck();
    }

    protected void txOnlyConflictCheck() {
        boolean threadOne = TxUtil.logRoundRobinNumber();
        TxUtil.logExecutionNumber();
        long rrNumber = TxUtil.getRoundRobinNumber();
        long whichRound = rrNumber % 3L;
        if (whichRound == 1L) {
            Log.getLogWriter().info("In round " + rrNumber + " to open transactions, threadOne is " + threadOne);
            TxHelper.begin();
            Integer val = (Integer)this.aRegion.get((Object)"key");
            Log.getLogWriter().info("The value in the region is " + val);
            this.txState.set(TxHelper.internalSuspend());
        } else if (whichRound == 2L) {
            if (threadOne) {
                TxHelper.internalResume((TXStateInterface)this.txState.get());
                int val = TestConfig.tab().getRandGen().nextInt(1, 100);
                this.aRegion.put((Object)"key", (Object)new Integer(val));
                this.txState.set(TxHelper.internalSuspend());
                Log.getLogWriter().info("In round " + rrNumber + " threadOne writes, but not commit yet");
            } else {
                TxHelper.internalResume((TXStateInterface)this.txState.get());
                Log.getLogWriter().info("In round " + rrNumber + " to close transactions, threadOne is " + threadOne);
                int val = TestConfig.tab().getRandGen().nextInt(1, 100);
                Integer old = null;
                if (this.aRegion.getAttributes().getPoolName() != null) {
                    old = (Integer)this.aRegion.get((Object)"key");
                    this.aRegion.put((Object)"key", (Object)new Integer(val));
                } else {
                    old = (Integer)this.aRegion.put((Object)"key", (Object)new Integer(val));
                }
                Log.getLogWriter().info("put(key, " + val + ") returns oldValue " + old);
                if (old != 0) {
                    throw new TestException("old was " + old);
                }
                if (this.hasCommitted) {
                    this.hasCommitted = false;
                    Log.getLogWriter().info("original value  before put is " + old + ", so commit should fail");
                    TxHelper.commitExpectFailure();
                } else {
                    Log.getLogWriter().info("original value  before put is " + old + ", so commit should be successful");
                    TxHelper.commitExpectSuccess();
                    this.hasCommitted = true;
                }
            }
        } else if (threadOne) {
            Log.getLogWriter().info("In round " + rrNumber + " threadOne to verify commit failure and restores the value in the region");
            TxHelper.internalResume((TXStateInterface)this.txState.get());
            TxHelper.commitExpectFailure();
            this.aRegion.put((Object)"key", (Object)new Integer(0));
        }
    }
}

