/*
 * Decompiled with CFR 0.152.
 */
package swarm;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import swarm.DUnitTestMethodDetail;
import swarm.Swarm;

public class DUnitClassRun
implements Comparable<DUnitClassRun> {
    private final int runId;
    private final int classId;
    private final Date time;
    List<DUnitTestMethodDetail> fails = null;
    List<DUnitTestMethodDetail> passes = null;
    List<DUnitTestMethodDetail> all = null;

    @Override
    public int compareTo(DUnitClassRun du) {
        return this.getTime().compareTo(du.getTime());
    }

    public DUnitClassRun(int runId, int classId, Date time) {
        this.runId = runId;
        this.classId = classId;
        this.time = time;
    }

    public int getClassId() {
        return this.classId;
    }

    public int getRunId() {
        return this.runId;
    }

    public Date getTime() {
        return this.time;
    }

    public String getTimeString() {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
        return sdf.format(this.getTime());
    }

    public List<DUnitTestMethodDetail> getFails() throws SQLException {
        if (this.fails == null) {
            this.fails = new ArrayList<DUnitTestMethodDetail>();
            for (DUnitTestMethodDetail du : this.getAllMethodDetails()) {
                if (!du.isFail()) continue;
                this.fails.add(du);
            }
        }
        return this.fails;
    }

    public List<DUnitTestMethodDetail> getPasses() throws SQLException {
        if (this.passes == null) {
            this.passes = new ArrayList<DUnitTestMethodDetail>();
            for (DUnitTestMethodDetail du : this.getAllMethodDetails()) {
                if (du.isFail()) continue;
                this.passes.add(du);
            }
        }
        return this.passes;
    }

    public List<DUnitTestMethodDetail> getAllMethodDetails() throws SQLException {
        if (this.all == null) {
            this.all = Swarm.getAllForClassRun(this.getRunId(), this.getClassId());
        }
        return this.all;
    }

    public int getPassCount() throws SQLException {
        return this.getPasses().size();
    }

    public int getFailCount() throws SQLException {
        return this.getFails().size();
    }
}

