/*
 * Decompiled with CFR 0.152.
 */
package splitBrain.gii;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import getInitialImage.GiiListener;
import getInitialImage.InitImageBB;
import getInitialImage.InitImagePrms;
import hydra.CacheHelper;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.util.Set;
import java.util.StringTokenizer;
import splitBrain.ControllerBB;
import splitBrain.MembershipNotifierHook;
import splitBrain.SBUtil;
import splitBrain.SplitBrainBB;
import util.BaseValueHolder;
import util.CachePrms;
import util.CacheUtil;
import util.NameBB;
import util.NameFactory;
import util.RandomValues;
import util.RegionDefPrms;
import util.RegionDefinition;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.ValueHolder;

public class FDInitImageTest {
    protected static FDInitImageTest testInstance;
    protected static final String REGION_NAME = "TestRegion";
    protected int numKeys = 0;
    protected RandomValues randomValues = null;
    protected Region aRegion;
    protected Region FDRegion = null;
    protected long createRegionDurationMS = 0L;
    protected long giiDurationMS = 0L;
    protected final long LOG_INTERVAL_MILLIS = 10000L;
    protected static int verifyRegionContentsIndex;
    protected static StringBuffer verifyRegionContentsErrStr;
    protected static boolean verifyRegionContentsCompleted;
    protected static long verifyRegionContentsAccumulatedTime;
    private static int keyIndex;

    protected static synchronized void initializeRegion(DataPolicy dataPolicy) {
        if (testInstance == null) {
            testInstance = new FDInitImageTest();
            testInstance.initRegion(dataPolicy);
            testInstance.initInstance();
        }
    }

    protected static synchronized void initializeInstance() {
        if (testInstance == null) {
            testInstance = new FDInitImageTest();
            testInstance.initInstance();
        }
    }

    protected void initRegion(DataPolicy dataPolicy) {
        RegionDefinition regDef = RegionDefinition.createRegionDefinition();
        regDef.setDataPolicy(dataPolicy);
        Log.getLogWriter().info("Using RegionDefinition " + regDef + " to create region");
        this.aRegion = regDef.createRootRegion(CacheUtil.createCache(), REGION_NAME, null, null, null);
    }

    protected void initInstance() {
        this.randomValues = new RandomValues();
        String OsName = System.getProperty("os.name");
        this.numKeys = OsName.indexOf("Linux") >= 0 ? 200000 : 50000;
        Log.getLogWriter().info("numKeys for this run is " + this.numKeys);
    }

    public static synchronized void StartTask_initialize() {
        String giiSourceDataPolicy = TestConfig.tab().stringAt(InitImagePrms.giiSourceDataPolicy);
        StringTokenizer tokenizer = new StringTokenizer(giiSourceDataPolicy, "-");
        int numTokens = tokenizer.countTokens();
        if (numTokens != 2) {
            throw new TestException("Unable to get two dataPolicy attributes from InitImagePrms.giiSourceDataPolicy" + giiSourceDataPolicy);
        }
        String dataPolicy1 = tokenizer.nextToken();
        String dataPolicy2 = tokenizer.nextToken();
        InitImageBB.getBB().getSharedMap().put(InitImageBB.DATAPOLICY1_ATTR, dataPolicy1);
        InitImageBB.getBB().getSharedMap().put(InitImageBB.DATAPOLICY2_ATTR, dataPolicy2);
    }

    public static synchronized void HydraTask_createFDRegion() {
        FDInitImageTest instance = testInstance;
        if (instance.FDRegion == null) {
            RegionDefinition regDef = RegionDefinition.createRegionDefinition(RegionDefPrms.regionSpecs, "FDRegion");
            instance.FDRegion = regDef.createRootRegion(CacheUtil.getCache(), null, null, null, null);
            Log.getLogWriter().info("Installing MembershipNotifierHook");
            SBUtil.addMembershipHook(new MembershipNotifierHook());
        }
    }

    public static void HydraTask_verifyPossiblePartialGII() {
        testInstance.verifyPossiblePartialGII();
    }

    protected void verifyPossiblePartialGII() {
        Log.getLogWriter().info(FDInitImageTest.testInstance.aRegion.getFullPath() + " is size " + FDInitImageTest.testInstance.aRegion.size() + "; complete gii would expect " + this.numKeys);
        if (this.aRegion.size() != this.numKeys) {
            if (this.aRegion.size() > this.numKeys) {
                throw new TestException(this.aRegion.getFullPath() + " is size " + this.aRegion.size() + " and has more keys than the expected " + this.numKeys);
            }
            String aStr = "GII received a partial image of " + this.aRegion.size() + " keys out of " + this.numKeys;
            Log.getLogWriter().info(aStr);
            throw new StopSchedulingTaskOnClientOrder(aStr);
        }
        FDInitImageTest.HydraTask_verifyRegionContents();
    }

    public static void HydraTask_verifyRegionSize() {
        int size = FDInitImageTest.testInstance.aRegion.size();
        if (size != FDInitImageTest.testInstance.numKeys) {
            StringBuffer aStr = new StringBuffer();
            for (int i = 1; i <= FDInitImageTest.testInstance.numKeys; ++i) {
                String key = NameFactory.getObjectNameForCounter(i);
                if (FDInitImageTest.testInstance.aRegion.containsKey((Object)key)) continue;
                aStr.append(key + " is missing from " + FDInitImageTest.testInstance.aRegion.getFullPath() + "\n");
            }
            throw new TestException("Expected region to be of size " + FDInitImageTest.testInstance.numKeys + " but it is " + size + "; missing entries are:\n" + aStr.toString());
        }
    }

    public static void HydraTask_putFDRegion() {
        long metCounter;
        int counter = 0;
        FDInitImageTest.waitForAnyGiiToBegin();
        do {
            Log.getLogWriter().info("Putting into " + FDInitImageTest.testInstance.FDRegion.getFullPath() + " until forced disconnect has occurred in another vm");
            FDInitImageTest.testInstance.FDRegion.put((Object)new Integer(++counter), (Object)"whatever");
            MasterController.sleepForMs(1000);
        } while ((metCounter = ControllerBB.getBB().getSharedCounters().read(ControllerBB.metCounter)) < 2L);
        throw new StopSchedulingTaskOnClientOrder(metCounter + " members recognized a forced disconnect");
    }

    public static void HydraTask_becomeDead() {
        boolean isUnion = InitImageBB.getBB().getSharedMap().get(InitImageBB.DATAPOLICY1_ATTR).equals("normal") && InitImageBB.getBB().getSharedMap().get(InitImageBB.DATAPOLICY2_ATTR).equals("normal");
        FDInitImageTest.waitForAnyGiiToBegin();
        MasterController.sleepForMs(5000);
        ControllerBB.checkForError();
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        Cache theCache = CacheHelper.getCache();
        ControllerBB.enablePlayDead();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            ControllerBB.enableSlowListener();
        } else {
            ControllerBB.enableSickness();
        }
        ControllerBB.checkForError();
        FDInitImageTest.waitForForcedDiscConditions(ds, theCache);
        ControllerBB.waitMembershipFailureComplete();
        if (isUnion && !FDInitImageTest.isAnyGiiInProgress()) {
            throw new TestException("Gii did not run long enough to complete a forced disconnect; test might need tuning");
        }
        ControllerBB.checkForError();
    }

    public static void HydraTask_initRegion() {
        String dataPolicyStr = TestConfig.tasktab().stringAt(CachePrms.dataPolicyAttribute, null);
        if (dataPolicyStr != null) {
            throw new TestException("This task must get its dataPolicy attribute from InitimageBB.giiSourceDataPolicy, but the task attribute also specified dataPolicy " + dataPolicyStr);
        }
        dataPolicyStr = SplitBrainBB.getBB().getSharedCounters().incrementAndRead(SplitBrainBB.ReadyToBegin) == 1L ? (String)InitImageBB.getBB().getSharedMap().get(InitImageBB.DATAPOLICY1_ATTR) : (String)InitImageBB.getBB().getSharedMap().get(InitImageBB.DATAPOLICY2_ATTR);
        DataPolicy dataPolicyAttr = TestHelper.getDataPolicy(dataPolicyStr);
        FDInitImageTest.initializeRegion(dataPolicyAttr);
    }

    public static void HydraTask_loadRegion() {
        testInstance.loadRegion();
    }

    public static void HydraTask_loadRegionWithGets() {
        DataPolicy dataPolicyAttr = FDInitImageTest.testInstance.aRegion.getAttributes().getDataPolicy();
        if (dataPolicyAttr.withReplication()) {
            long expectedNumKeys;
            int regionSize = FDInitImageTest.testInstance.aRegion.size();
            if ((long)regionSize != (expectedNumKeys = NameFactory.getPositiveNameCounter())) {
                throw new TestException("DataPolicy is withReplication, expected region size to be " + expectedNumKeys + ", but it is " + regionSize);
            }
            String aStr = "Not getting keys/values because dataPolicy is withReplication and region has " + regionSize + " keys";
            Log.getLogWriter().info(aStr);
            throw new StopSchedulingTaskOnClientOrder(aStr);
        }
        testInstance.loadRegionWithGets();
    }

    public static void HydraTask_doGetInitImage() {
        FDInitImageTest.initializeInstance();
        testInstance.doGetInitImage();
    }

    public static void HydraTask_blockedGetRegion() {
        FDInitImageTest.initializeInstance();
        testInstance.blockedGetRegion();
    }

    public static void HydraTask_verifyRegionContents() {
        testInstance.verifyRegionContents();
    }

    public static synchronized void HydraTask_initCache() {
        if (testInstance == null) {
            testInstance = new FDInitImageTest();
            testInstance.initInstance();
            CacheUtil.createCache();
        }
    }

    protected void doGetInitImage() {
        final StringBuffer errStr = new StringBuffer();
        Thread monitorThread = new Thread(new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        monitorThread.start();
        long begin = 0L;
        long end = 0L;
        Cache aCache = CacheUtil.createCache();
        RegionDefinition regDef = RegionDefinition.createRegionDefinition();
        boolean useTransactions = InitImagePrms.useTransactions();
        regDef.setDataPolicy(TestHelper.getDataPolicy(TestConfig.tasktab().stringAt(CachePrms.dataPolicyAttribute)));
        RegionAttributes attr = regDef.getRegionAttributes(new GiiListener(), null, null);
        try {
            Log.getLogWriter().info("In doGetinitImage, creating VM region TestRegion with " + TestHelper.regionAttributesToString(attr));
            begin = System.currentTimeMillis();
            this.aRegion = aCache.createVMRegion(REGION_NAME, attr);
            end = System.currentTimeMillis();
            Log.getLogWriter().info("In doGetinitImage, done creating VM region TestRegion");
            int nbrOfGiiInProgress = TestHelper.getStat_getInitialImagesInProgress(REGION_NAME);
            Log.getLogWriter().info("In doGetinitImage, checking TestRegion for in progress: nbrOfGiiInProgress=" + nbrOfGiiInProgress);
            if (nbrOfGiiInProgress > 0) {
                throw new TestException("After creating region, GII is still in progress ");
            }
        }
        catch (RegionExistsException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        this.createRegionDurationMS = end - begin;
        int regionSize = this.aRegion.keys().size();
        Log.getLogWriter().info("In doGetInitImage, creating region took " + this.createRegionDurationMS + " millis, current region size is " + regionSize);
        FDInitImageTest.waitForLocalGiiCompleted();
        try {
            monitorThread.join(30000L);
        }
        catch (InterruptedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        if (errStr.length() != 0) {
            throw new TestException(errStr);
        }
    }

    protected void blockedGetRegion() {
        float blockPercent;
        int numCompletedBefore = TestHelper.getStat_getInitialImagesCompleted(REGION_NAME);
        Cache aCache = CacheUtil.createCache();
        FDInitImageTest.waitForLocalGiiToBegin();
        Log.getLogWriter().info("In blockedGetRegion, getting region TestRegion");
        long start = System.currentTimeMillis();
        Region myRegion = aCache.getRegion(REGION_NAME);
        long end = System.currentTimeMillis();
        Log.getLogWriter().info("In blockedGetRegion, done getting region TestRegion");
        long duration = end - start;
        Log.getLogWriter().info("In blockedGetRegion, region creation took " + duration + " millis");
        int numCompleted = TestHelper.getStat_getInitialImagesCompleted(REGION_NAME);
        numCompleted = numCompletedBefore;
        Log.getLogWriter().info("In blockedGetRegion, numCompleted=" + numCompleted);
        if (numCompleted > 1) {
            throw new TestException("Expected only 1 getInitialImage to be completed, but num completed is " + numCompleted);
        }
        Log.getLogWriter().info("In blockedGetRegion, giiDurationMS=" + this.giiDurationMS);
        if (this.giiDurationMS == 0L) {
            long giiTime = TestHelper.getStat_getInitialImageTime(REGION_NAME) / 1000000L;
            Log.getLogWriter().info("In blockedGetRegion, giiTime=" + giiTime);
            blockPercent = (float)duration / (float)giiTime * 100.0f;
        } else {
            blockPercent = (float)duration / (float)this.giiDurationMS * 100.0f;
        }
        Log.getLogWriter().info("In blockedGetRegion, blockPercent=" + blockPercent);
        if (blockPercent < 75.0f) {
            throw new TestException("Expected the thread that blocked on getInitialImage to have a similar time to the thread that did the getInitialImage, blocked thread millis: " + duration + ", getInitialImage time: " + this.giiDurationMS);
        }
    }

    public void loadRegion() {
        long LOG_INTERVAL_MILLIS = 10000L;
        long lastLogTime = System.currentTimeMillis();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, -1L);
        long minTaskGranularityMS = -1L;
        if (minTaskGranularitySec != -1L) {
            minTaskGranularityMS = minTaskGranularitySec * 1000L;
        }
        long startTime = System.currentTimeMillis();
        do {
            long shouldAddCount;
            if ((shouldAddCount = InitImageBB.getBB().getSharedCounters().incrementAndRead(InitImageBB.SHOULD_ADD_COUNT)) > (long)this.numKeys) {
                String aStr = "In loadRegion, shouldAddCount is " + shouldAddCount + ", numOriginalKeysCreated is " + InitImageBB.getBB().getSharedCounters().read(InitImageBB.NUM_ORIGINAL_KEYS_CREATED) + ", numKeys is " + this.numKeys + ", region size (in this vm) is " + this.aRegion.size();
                Log.getLogWriter().info(aStr);
                NameBB.getBB().printSharedCounters();
                throw new StopSchedulingTaskOnClientOrder(aStr);
            }
            String key = NameFactory.getNextPositiveObjectName();
            try {
                Object value = this.getValueToAdd(key);
                this.aRegion.put((Object)key, value);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Added " + NameFactory.getPositiveNameCounter() + " out of " + this.numKeys + " entries (across all vms) into " + TestHelper.regionToString(this.aRegion, false));
            lastLogTime = System.currentTimeMillis();
        } while (minTaskGranularitySec == -1L || System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void loadRegionWithGets() {
        long LOG_INTERVAL_MILLIS = 10000L;
        long maxKey = NameFactory.getPositiveNameCounter();
        long lastLogTime = System.currentTimeMillis();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, -1L);
        long minTaskGranularityMS = -1L;
        if (minTaskGranularitySec != -1L) {
            minTaskGranularityMS = minTaskGranularitySec * 1000L;
        }
        long startTime = System.currentTimeMillis();
        do {
            int keyIndexToGet = 0;
            Class<FDInitImageTest> clazz = FDInitImageTest.class;
            // MONITORENTER : splitBrain.gii.FDInitImageTest.class
            keyIndexToGet = ++keyIndex;
            // MONITOREXIT : clazz
            if ((long)keyIndexToGet > maxKey) {
                String aStr = "loadRegionWithGets, regionSize is " + this.aRegion.size();
                Log.getLogWriter().info(aStr);
                throw new StopSchedulingTaskOnClientOrder(aStr);
            }
            String key = NameFactory.getObjectNameForCounter(keyIndexToGet);
            try {
                Object aValue = this.aRegion.get((Object)key);
                if (aValue == null) {
                    throw new TestException("Unexpected value " + aValue + " from getting key " + key);
                }
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Got " + keyIndexToGet + " out of " + maxKey + " entries into " + TestHelper.regionToString(this.aRegion, false));
            lastLogTime = System.currentTimeMillis();
        } while (minTaskGranularitySec == -1L || System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    public void verifyRegionContents() {
        if (verifyRegionContentsCompleted) {
            throw new TestException("Test configuration problem; already verified region contents, cannot call this task again without resetting batch variables");
        }
        long totalNumKeys = NameFactory.getPositiveNameCounter();
        if (verifyRegionContentsIndex == 0) {
            long size = this.aRegion.size();
            if (totalNumKeys != size) {
                String tmpStr = "Expected " + totalNumKeys + " keys, but there are " + size;
                Log.getLogWriter().info(tmpStr);
                verifyRegionContentsErrStr.append(tmpStr + "\n");
            }
            Log.getLogWriter().info("In verifyRegionContents, region has " + size + " keys");
        }
        long lastLogTime = System.currentTimeMillis();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, -1L);
        long minTaskGranularityMS = -1L;
        if (minTaskGranularitySec != -1L) {
            minTaskGranularityMS = minTaskGranularitySec * 1000L;
        }
        long startTime = System.currentTimeMillis();
        while ((long)verifyRegionContentsIndex < totalNumKeys) {
            String key = NameFactory.getObjectNameForCounter(++verifyRegionContentsIndex);
            this.checkContainsKey(key, true);
            this.checkContainsValueForKey(key, true);
            Object value = this.aRegion.get((Object)key);
            this.checkValue(key, value);
            if (System.currentTimeMillis() - lastLogTime > 10000L) {
                Log.getLogWriter().info("Verified key " + verifyRegionContentsIndex + " out of " + totalNumKeys);
                lastLogTime = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - startTime < minTaskGranularityMS) continue;
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            verifyRegionContentsAccumulatedTime += duration;
            Log.getLogWriter().info("In verifyRegionContents, returning before completing verify because of task granularity (this task must be batched to complete); last key verified is " + key);
            return;
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        verifyRegionContentsAccumulatedTime += duration;
        if (verifyRegionContentsErrStr.length() > 0) {
            throw new TestException(verifyRegionContentsErrStr.toString());
        }
        String aStr = "In verifyRegionContents, verified " + verifyRegionContentsIndex + " keys/values in " + verifyRegionContentsAccumulatedTime + " millis";
        Log.getLogWriter().info(aStr);
        throw new StopSchedulingTaskOnClientOrder(aStr);
    }

    protected void checkContainsKey(Object key, boolean expected) {
        boolean containsKey = this.aRegion.containsKey(key);
        if (containsKey != expected) {
            throw new TestException("Expected containsKey(" + key + ") to be " + expected + ", but it was " + containsKey);
        }
    }

    protected void checkContainsValueForKey(Object key, boolean expected) {
        boolean containsValue = this.aRegion.containsValueForKey(key);
        if (containsValue != expected) {
            throw new TestException("Expected containsValueForKey(" + key + ") to be " + expected + ", but it was " + containsValue);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkValue(Object key, Object value) {
        if (!(value instanceof BaseValueHolder)) throw new TestException("For key " + key + ", expected value " + TestHelper.toString(value) + " to be a ValueHolder");
        BaseValueHolder vh = (BaseValueHolder)value;
        long keyCounter = NameFactory.getCounterForName(key);
        if (!(vh.myValue instanceof Long)) throw new TestException("Expected ValueHolder.myValue for key " + key + " to be a Long for " + TestHelper.toString(vh));
        Long aLong = (Long)vh.myValue;
        long longValue = aLong;
        if (keyCounter == longValue) return;
        throw new TestException("Inconsistent ValueHolder.myValue for key " + key + ":" + TestHelper.toString(vh));
    }

    protected Object getValueToAdd(Object key) {
        return new ValueHolder((String)key, this.randomValues);
    }

    protected Set getRegionKeySet(Region aRegion) {
        return aRegion.keys();
    }

    protected static boolean isLocalGiiInProgress() {
        int inProgress = TestHelper.getStat_getInitialImagesInProgress(REGION_NAME);
        if (inProgress > 1) {
            throw new TestException("Expected local gii in progress to always be 0 or 1, but it is " + inProgress);
        }
        return inProgress > 0;
    }

    protected static boolean isLocalGiiInProgress(Region aRegion) {
        if (aRegion == null) {
            return false;
        }
        boolean inProgress = !((LocalRegion)aRegion).isInitialized();
        return inProgress;
    }

    protected static boolean hasLocalGiiCompleted() {
        return TestHelper.getStat_getInitialImagesCompleted(REGION_NAME) > 0;
    }

    protected static boolean isAnyGiiInProgress() {
        return InitImageBB.getBB().getSharedCounters().read(InitImageBB.GII_IN_PROGRESS) > 0L;
    }

    public static void waitForAnyGiiToBegin() {
        Log.getLogWriter().info("Waiting for getInitialImage to begin in any VM...");
        while (!FDInitImageTest.isAnyGiiInProgress()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        Log.getLogWriter().info("Done waiting for getInitialImage to begin in any VM");
    }

    protected static void waitForAllGiiToComplete() {
        Log.getLogWriter().info("Waiting for getInitialImage to complete in all VMs...");
        while (FDInitImageTest.isAnyGiiInProgress()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        Log.getLogWriter().info("Done waiting for getInitialImage to complete in all VMs");
    }

    protected static void waitForLocalGiiToBegin() {
        long MAX_WAIT_MILLIS = 300000L;
        Log.getLogWriter().info("Waiting 300000 millis for getIntialImage to begin...");
        long start = System.currentTimeMillis();
        int inProgress = TestHelper.getStat_getInitialImagesInProgress(REGION_NAME);
        while (inProgress <= 0 && System.currentTimeMillis() - start < 300000L) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            inProgress = TestHelper.getStat_getInitialImagesInProgress(REGION_NAME);
        }
        Log.getLogWriter().info("Done waiting 300000 millis for getIntialImage to begin, inProgress is " + inProgress);
        if (inProgress <= 0) {
            throw new TestException("Waited 300000 for getInitialImage to begin, but inProgress is " + inProgress);
        }
    }

    protected static void waitForLocalGiiCompleted() {
        long giiOngoing;
        long MAX_WAIT_MILLIS = 300000L;
        Log.getLogWriter().info("Waiting 300000 millis for getIntialImage to complete...");
        long start = System.currentTimeMillis();
        while ((giiOngoing = (long)TestHelper.getStat_getInitialImagesInProgress(REGION_NAME)) > 0L && System.currentTimeMillis() - start < 300000L) {
        }
        Log.getLogWriter().info("Done waiting 300000 millis for getIntialImage to complete, giiOngoing is " + giiOngoing);
        if (giiOngoing > 0L) {
            throw new TestException("Waited 300000 for getInitialImage to complete, but giiOngoing is " + giiOngoing);
        }
    }

    public static void waitForForcedDiscConditions(DistributedSystem ds, Cache theCache) {
        long startTime = System.currentTimeMillis();
        Log.getLogWriter().info("Waiting for a forced disconnect to occur...");
        boolean isUnion = InitImageBB.getBB().getSharedMap().get(InitImageBB.DATAPOLICY1_ATTR).equals("normal") && InitImageBB.getBB().getSharedMap().get(InitImageBB.DATAPOLICY2_ATTR).equals("normal");
        while (true) {
            boolean isConnected = ds.isConnected();
            boolean cacheClosed = theCache.isClosed();
            int forcedDiscEventCount = ControllerBB.getMapCounter("NumForcedDiscEvents_");
            boolean membershipFailureComplete = ControllerBB.isMembershipFailureComplete();
            Log.getLogWriter().info("Waiting for forced disconnect conditions,\nis connected (looking for false): " + isConnected + "\nafterRegionDestroyedEvent count (looking for 1): " + forcedDiscEventCount + "\nmembership failure complete (looking for true): " + membershipFailureComplete + "\ncacheClosed (looking for true): " + cacheClosed);
            if (forcedDiscEventCount == 1 && !isConnected && cacheClosed && membershipFailureComplete) {
                Log.getLogWriter().info("Forced disconnect conditions have been met");
                ControllerBB.getBB().getSharedCounters().incrementAndRead(ControllerBB.metCounter);
                if (!isUnion || FDInitImageTest.isAnyGiiInProgress()) break;
                long gaveUpTime = System.currentTimeMillis();
                long waitTime = gaveUpTime - startTime;
                throw new TestException("Giving up waiting for a forced disconnect after " + waitTime + " millis, all giis have already completed");
            }
            if (forcedDiscEventCount > 1) {
                String errStr = "Error occurred in vm_" + RemoteTestModule.getMyVmid() + "; Number of forced disconnect events for this vm is " + forcedDiscEventCount + ", expected 1";
                Log.getLogWriter().info(errStr);
                ControllerBB.getBB().getSharedMap().put("Error", errStr);
                continue;
            }
            if (!isUnion) continue;
            if (!FDInitImageTest.isAnyGiiInProgress()) {
                long gaveUpTime = System.currentTimeMillis();
                long waitTime = gaveUpTime - startTime;
                throw new TestException("Giving up waiting for a forced disconnect after " + waitTime + " millis, all giis have already completed");
            }
            MasterController.sleepForMs(1500);
        }
        Log.getLogWriter().info("Done waiting for forced disconnect conditions...");
        startTime = ControllerBB.getMembershipFailureStartTime();
        long endTime = ControllerBB.getMembershipFailureCompletionTime();
        long duration = endTime - startTime;
        String aStr = "It took " + duration + " ms to complete membership failure (time between MembershipNotifyHook.beforeMembershipFailure and MembershipNotifyHook.afterMembershipFailure.";
        Log.getLogWriter().info(aStr);
        if (duration > 60000L) {
            throw new TestException(aStr);
        }
    }

    static {
        verifyRegionContentsIndex = 0;
        verifyRegionContentsErrStr = new StringBuffer();
        verifyRegionContentsCompleted = false;
        verifyRegionContentsAccumulatedTime = 0L;
        keyIndex = 0;
    }
}

