/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.cache.Region;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.HydraSubthread;
import hydra.Log;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.List;
import splitBrain.ControllerBB;
import splitBrain.ListenerBB;
import splitBrain.SplitBrainPrms;
import util.StopStartPrms;
import util.TestException;
import util.TestHelper;

public class UnhealthyUtil {
    public static void causeUnhealthiness(List vmList, final Region controllerRegion) {
        int i;
        Log.getLogWriter().info("In UnhealthyUtil.causeUnhealthiness, targeting " + vmList.size() + " vm(s) to become unhealthy...");
        ArrayList<String> unhealthinessList = new ArrayList<String>();
        ArrayList<Boolean> playDeadList = new ArrayList<Boolean>();
        for (int i2 = 1; i2 <= vmList.size(); ++i2) {
            int randInt = TestConfig.tab().getRandGen().nextInt(0, vmList.size() - 1);
            unhealthinessList.add(TestConfig.tab().stringAt(SplitBrainPrms.unhealthiness));
            playDeadList.add(new Boolean(TestConfig.tab().booleanAt(SplitBrainPrms.playDead)));
        }
        ArrayList<HydraSubthread> threadList = new ArrayList<HydraSubthread>();
        for (i = 0; i < vmList.size(); ++i) {
            final ClientVmInfo info = (ClientVmInfo)vmList.get(i);
            final String unhealthiness = (String)unhealthinessList.get(i);
            final boolean playDead = (Boolean)playDeadList.get(i);
            HydraSubthread aThread = new HydraSubthread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Log.getLogWriter().info("In thread to cause unhealthiness");
                        UnhealthyUtil.causeUnhealthiness(info, unhealthiness, playDead, controllerRegion);
                        Log.getLogWriter().info("Done in thread to cause unhealthiness");
                    }
                    catch (Exception e) {
                        String errStr = TestHelper.getStackTrace(e);
                        Log.getLogWriter().info(errStr);
                        ControllerBB.getBB().getSharedMap().put("Error", errStr);
                    }
                }
            });
            aThread.start();
            threadList.add(aThread);
        }
        Log.getLogWriter().info("Joining unhealthiness threads");
        for (i = 0; i < threadList.size(); ++i) {
            Thread aThread = (Thread)threadList.get(i);
            try {
                ControllerBB.checkForError();
                aThread.join();
                Log.getLogWriter().info("Done with join for thread " + aThread.getName());
                continue;
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        ControllerBB.checkForError();
        Log.getLogWriter().info("Done joining unhealthiness threads");
    }

    protected static void causeUnhealthiness(ClientVmInfo targetVM, String unhealthiness, boolean playDead, Region controllerRegion) {
        if (unhealthiness.equalsIgnoreCase("slow")) {
            if (playDead) {
                UnhealthyUtil.slowAndDeadUnhealthiness(targetVM, controllerRegion);
            } else {
                UnhealthyUtil.slowOnlyUnhealthiness(targetVM, controllerRegion);
            }
        } else if (unhealthiness.equalsIgnoreCase("sick")) {
            if (playDead) {
                UnhealthyUtil.sickAndDeadUnhealthiness(targetVM, controllerRegion);
            } else {
                UnhealthyUtil.sickOnlyUnhealthiness(targetVM, controllerRegion);
            }
        } else {
            throw new TestException("Unknown " + unhealthiness);
        }
        ControllerBB.checkForError();
    }

    protected static void slowOnlyUnhealthiness(ClientVmInfo targetVM, Region controllerRegion) {
        int vmid = targetVM.getVmid();
        ControllerBB.enableSlowListener(vmid);
        Log.getLogWriter().info("Calling put to cause slowness in vm " + vmid);
        controllerRegion.put((Object)new Long(System.currentTimeMillis()), (Object)"");
        Log.getLogWriter().info("Done calling put to cause slowness in vm " + vmid);
        try {
            ClientVmMgr.stop("Stopping vm " + vmid + " because the system received alerts that it is not healthy", ClientVmMgr.toStopMode(TestConfig.tab().stringAt(StopStartPrms.stopModes)), -31, targetVM);
            ClientVmMgr.start("Restarting vm " + vmid + " after it became unhealthy", targetVM);
            ControllerBB.signalInitIsComplete(vmid);
            ListenerBB.checkAfterRemoteRegionCrashEvents();
            ListenerBB.getBB().getSharedCounters().zero(ListenerBB.numAfterRemoteRegionCrashEvents);
        }
        catch (ClientVmNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        ControllerBB.checkForError();
    }

    protected static void sickOnlyUnhealthiness(ClientVmInfo targetVM, final Region controllerRegion) {
        final int vmid = targetVM.getVmid();
        ControllerBB.enableSickness(vmid);
        String threadName = Thread.currentThread().getName();
        Thread aThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Log.getLogWriter().info("Calling put to cause sickness in vm " + vmid);
                controllerRegion.put((Object)new Long(System.currentTimeMillis()), (Object)"");
                Log.getLogWriter().info("Done calling put to cause sickness in vm " + vmid);
                Log.getLogWriter().info("Calling put to encounter sickness in vm " + vmid);
                controllerRegion.put((Object)new Long(System.currentTimeMillis()), (Object)"");
                Log.getLogWriter().info("Done calling put to encounter sickness in vm " + vmid);
            }
        }, "PutThreadFor_" + threadName);
        aThread.start();
        ControllerBB.waitForSevereAlert(vmid);
        try {
            ClientVmMgr.stop("Stopping vm " + vmid + " because the system received alerts that it is not healthy", ClientVmMgr.toStopMode(TestConfig.tab().stringAt(StopStartPrms.stopModes)), -31, targetVM);
            try {
                Log.getLogWriter().info("Waiting for put to complete since vm with id " + vmid + " has been stopped");
                aThread.join();
                Log.getLogWriter().info("Done waiting for put to complete since vm with id " + vmid + " has been stopped");
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            ClientVmMgr.start("Restarting vm " + vmid + " after it became unhealthy", targetVM);
            ControllerBB.signalInitIsComplete(vmid);
            ListenerBB.checkAfterRemoteRegionCrashEvents();
            ListenerBB.getBB().getSharedCounters().zero(ListenerBB.numAfterRemoteRegionCrashEvents);
        }
        catch (ClientVmNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        ControllerBB.checkForError();
    }

    protected static void slowAndDeadUnhealthiness(ClientVmInfo targetVM, Region controllerRegion) {
        int vmid = targetVM.getVmid();
        ControllerBB.enableSlowListener(vmid);
        ControllerBB.enablePlayDead(vmid);
        Log.getLogWriter().info("Calling put to cause slowness and play dead in vm " + vmid);
        controllerRegion.put((Object)new Long(System.currentTimeMillis()), (Object)"");
        Log.getLogWriter().info("Done calling put to cause slowness and play dead in vm " + vmid);
        ControllerBB.checkForError();
        ControllerBB.checkForError();
        ControllerBB.signalReadyForInit(vmid);
        ControllerBB.waitForInitialization(vmid);
        ListenerBB.checkAfterRemoteRegionCrashEvents();
        ListenerBB.getBB().getSharedCounters().zero(ListenerBB.numAfterRemoteRegionCrashEvents);
        ControllerBB.checkForError();
    }

    protected static void sickAndDeadUnhealthiness(ClientVmInfo targetVM, Region controllerRegion) {
        int vmid = targetVM.getVmid();
        ControllerBB.enableSickness(vmid);
        ControllerBB.enablePlayDead(vmid);
        Log.getLogWriter().info("Calling put to cause sickness and play dead in vm " + vmid);
        controllerRegion.put((Object)new Long(System.currentTimeMillis()), (Object)"");
        Log.getLogWriter().info("Done calling put to cause sickness and play dead in vm " + vmid);
        Log.getLogWriter().info("Calling put to encounter sickness and play dead in vm " + vmid);
        controllerRegion.put((Object)new Long(System.currentTimeMillis()), (Object)"");
        Log.getLogWriter().info("Done calling put to encounter sickness and play dead in vm " + vmid);
        ControllerBB.signalReadyForInit(vmid);
        ControllerBB.waitForInitialization(vmid);
        ListenerBB.checkAfterRemoteRegionCrashEvents();
        ListenerBB.getBB().getSharedCounters().zero(ListenerBB.numAfterRemoteRegionCrashEvents);
        ControllerBB.checkForError();
    }
}

