/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.util.BridgeWriterException;
import com.gemstone.gemfire.distributed.LockServiceDestroyedException;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import memscale.MemScaleBB;
import parReg.ParRegBB;
import parReg.ParRegTest;
import parReg.ParRegUtil;
import splitBrain.ControllerBB;
import splitBrain.MembershipNotifierHook;
import splitBrain.SBUtil;
import splitBrain.SplitBrainBB;
import splitBrain.UnhealthyUtil;
import util.MethodCoordinator;
import util.PRObserver;
import util.SilenceListener;
import util.StopStartBB;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class SBParRegTest
extends ParRegTest {
    protected static String IsDataStoreVmStr = "IsDataStoreVM_";
    protected Region controllerRegion;
    protected List vmList = new ArrayList();

    public static synchronized void HydraTask_HA_initializeAccessor() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new SBParRegTest();
            testInstance.initializeRegion("accessorRegion");
            testInstance.initializeInstance();
            SBParRegTest.testInstance.isDataStore = false;
            if (SBParRegTest.testInstance.isBridgeConfiguration) {
                SBParRegTest.testInstance.isBridgeClient = true;
                ParRegUtil.registerInterest(SBParRegTest.testInstance.aRegion);
            } else {
                Log.getLogWriter().info("Installing MembershipNotifierHook");
                SBUtil.addMembershipHook(new MembershipNotifierHook());
            }
            ((SBParRegTest)SBParRegTest.testInstance).controllerRegion = RegionHelper.createRegion("accessorControllerRegion");
            SplitBrainBB.getBB().getSharedMap().put(IsDataStoreVmStr + RemoteTestModule.getMyVmid(), new Boolean(false));
            ControllerBB.getBB().getSharedMap().put("" + ProcessMgr.getProcessId(), new Integer(RemoteTestModule.getMyVmid()));
            SplitBrainBB.getBB().getSharedCounters().increment(SplitBrainBB.NumVMsInDS);
            ControllerBB.getBB().getSharedMap().put("" + ProcessMgr.getProcessId(), new Integer(RemoteTestModule.getMyVmid()));
        }
        SBParRegTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_HA_initializeDataStore() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new SBParRegTest();
            SBParRegTest.testInstance.isDataStore = true;
            testInstance.initializeRegion("dataStoreRegion");
            testInstance.initializeInstance();
            RegionAttributes attr = SBParRegTest.testInstance.aRegion.getAttributes();
            PartitionAttributes prAttr = attr.getPartitionAttributes();
            long recoveryDelay = prAttr.getRecoveryDelay();
            long startupRecoveryDelay = prAttr.getStartupRecoveryDelay();
            ParRegBB.getBB().getSharedMap().put("recoveryDelay", new Long(recoveryDelay));
            ParRegBB.getBB().getSharedMap().put("startupRecoveryDelay", new Long(startupRecoveryDelay));
            if (SBParRegTest.testInstance.isBridgeConfiguration) {
                SBParRegTest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
            ((SBParRegTest)SBParRegTest.testInstance).controllerRegion = RegionHelper.createRegion("dataStoreControllerRegion");
            SplitBrainBB.getBB().getSharedMap().put(IsDataStoreVmStr + RemoteTestModule.getMyVmid(), new Boolean(true));
            ControllerBB.getBB().getSharedMap().put("" + ProcessMgr.getProcessId(), new Integer(RemoteTestModule.getMyVmid()));
            Log.getLogWriter().info("Installing MembershipNotifierHook");
            SBUtil.addMembershipHook(new MembershipNotifierHook());
            SplitBrainBB.getBB().getSharedCounters().increment(SplitBrainBB.NumVMsInDS);
            ControllerBB.getBB().getSharedMap().put("" + ProcessMgr.getProcessId(), new Integer(RemoteTestModule.getMyVmid()));
        }
        SBParRegTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static void initAccessorAfterForcedDisconnect() {
        testInstance.HA_reinitializeRegion();
        ((SBParRegTest)SBParRegTest.testInstance).controllerRegion = RegionHelper.createRegion("accessorControllerRegion");
        SBParRegTest.testInstance.isDataStore = false;
        if (SBParRegTest.testInstance.isBridgeConfiguration) {
            SBParRegTest.testInstance.isBridgeClient = true;
            ParRegUtil.registerInterest(SBParRegTest.testInstance.aRegion);
        }
    }

    public static void initDataStoreAfterForcedDisconnect() {
        PRObserver.initialize(RemoteTestModule.getMyVmid());
        testInstance.HA_reinitializeRegion();
        ((SBParRegTest)SBParRegTest.testInstance).controllerRegion = RegionHelper.createRegion("dataStoreControllerRegion");
        SBParRegTest.testInstance.isDataStore = true;
        if (SBParRegTest.testInstance.isBridgeConfiguration) {
            SBParRegTest.testInstance.isBridgeClient = false;
            BridgeHelper.startBridgeServer("bridge");
        }
    }

    public static synchronized void HydraTask_HA_reinitializeAccessor() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new SBParRegTest();
            testInstance.HA_reinitializeRegion();
            ((SBParRegTest)SBParRegTest.testInstance).controllerRegion = RegionHelper.createRegion("accessorControllerRegion");
            testInstance.initializeInstance();
            SBParRegTest.testInstance.isDataStore = false;
            if (SBParRegTest.testInstance.isBridgeConfiguration) {
                SBParRegTest.testInstance.isBridgeClient = true;
                ParRegUtil.registerInterest(SBParRegTest.testInstance.aRegion);
            }
        }
        ControllerBB.getBB().getSharedMap().put("" + ProcessMgr.getProcessId(), new Integer(RemoteTestModule.getMyVmid()));
        SBParRegTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_HA_reinitializeDataStore() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            PRObserver.initialize(RemoteTestModule.getMyVmid());
            testInstance = new SBParRegTest();
            testInstance.HA_reinitializeRegion();
            ((SBParRegTest)SBParRegTest.testInstance).controllerRegion = RegionHelper.createRegion("dataStoreControllerRegion");
            testInstance.initializeInstance();
            SBParRegTest.testInstance.isDataStore = true;
            if (SBParRegTest.testInstance.isBridgeConfiguration) {
                SBParRegTest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
        }
        ControllerBB.getBB().getSharedMap().put("" + ProcessMgr.getProcessId(), new Integer(RemoteTestModule.getMyVmid()));
        SBParRegTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static void HydraTask_waitForStartupRecovery() {
        ArrayList startupVMs = new ArrayList(StopStartBB.getBB().getSharedMap().getMap().values());
        List vmsExpectingRecovery = StopStartVMs.getMatchVMs(startupVMs, "dataStore");
        vmsExpectingRecovery.addAll(StopStartVMs.getMatchVMs(startupVMs, "bridge"));
        if (vmsExpectingRecovery.size() == 0) {
            throw new TestException("No startup vms to wait for");
        }
        long startupRecoveryDelay = (Long)ParRegBB.getBB().getSharedMap().get("startupRecoveryDelay");
        if (startupRecoveryDelay >= 0L) {
            ArrayList<String> prNames = new ArrayList<String>();
            prNames.add("/partitionedRegion");
            prNames.add("/controllerReg");
            PRObserver.waitForRebalRecov(vmsExpectingRecovery, 1, 2, prNames, null, false);
        }
    }

    @Override
    protected void HAController() {
        SBParRegTest.logExecutionNumber();
        this.offHeapVerifyTargetCount = this.getOffHeapVerifyTargetCount();
        registerInterestCoordinator = new MethodCoordinator(ParRegTest.class.getName(), "registerInterest");
        this.checkForLastIteration();
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.ExceptionCounter);
        ControllerBB.getBB().getSharedCounters().zero(ControllerBB.ExceptionCounter);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.ConcurrentLeader);
        this.cycleVms();
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.Reinitialized);
        this.numThreadsInClients = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        Log.getLogWriter().info("numThreadsInClients = " + this.numThreadsInClients);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.SnapshotWritten);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.FinishedVerify);
        MemScaleBB.getBB().getSharedCounters().zero(MemScaleBB.finishedMemCheck);
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.Pausing);
        TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.Pausing", ParRegBB.Pausing, this.numThreadsInClients, true, -1L, 5000L);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.rebalanceCompleted);
        this.reset();
        if (this.isBridgeConfiguration) {
            SilenceListener.waitForSilence(30L, 5000L);
        }
        if (this.isBridgeClient && this.bridgeOrderingWorkaround.equalsIgnoreCase("registerInterest")) {
            registerInterestCoordinator.executeOnce(this, new Object[0]);
            if (!registerInterestCoordinator.methodWasExecuted()) {
                throw new TestException("Test problem: RegisterInterest did not execute");
            }
        }
        this.concVerify();
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.FinishedVerify);
        TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.FinishedVerify", ParRegBB.FinishedVerify, this.numThreadsInClients, true, -1L, 5000L);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.Pausing);
        ParRegUtil.doRebalance();
        this.verifyFromSnapshot();
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.rebalanceCompleted);
        long counter = ParRegBB.getBB().getSharedCounters().read(ParRegBB.TimeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num HAController executions is " + ParRegBB.getBB().getSharedCounters().read(ParRegBB.ExecutionNumber));
        }
    }

    protected void reset() {
        for (int i = 0; i < this.vmList.size(); ++i) {
            ClientVmInfo info = (ClientVmInfo)this.vmList.get(i);
            int vmid = info.getVmid();
            ControllerBB.reset(vmid);
        }
    }

    @Override
    public void doRROpsAndVerify() {
        super.doRROpsAndVerify();
        this.reset();
    }

    protected void cycleVmsNoWait() {
        Log.getLogWriter().info("Cycling vms by causing alerts followed by stop start or forced disconnects...");
        PRObserver.initialize();
        Object[] tmp = StopStartVMs.getOtherVMsWithExclude(this.numVMsToStop, "admin");
        this.vmList = (List)tmp[0];
        this.cycleVMs_notChosenVMs = (List)tmp[2];
        SplitBrainBB.getBB().getSharedCounters().zero(SplitBrainBB.NumVMsStopped);
        SplitBrainBB.getBB().getSharedCounters().add(SplitBrainBB.NumVMsStopped, this.numVMsToStop);
        UnhealthyUtil.causeUnhealthiness(this.vmList, this.controllerRegion);
        ControllerBB.checkForError();
        ControllerBB.checkEventCounters("NumForcedDiscEvents_", this.vmList, 1);
        Log.getLogWriter().info("Done cycling vms");
    }

    @Override
    protected void waitForRecoveryAfterCycleVMs() {
        List dataStoreNotChosen = StopStartVMs.getMatchVMs(this.cycleVMs_notChosenVMs, "dataStore");
        dataStoreNotChosen.addAll(StopStartVMs.getMatchVMs(this.cycleVMs_notChosenVMs, "bridge"));
        List dataStoreTargetVMs = StopStartVMs.getMatchVMs(this.vmList, "dataStore");
        dataStoreTargetVMs.addAll(StopStartVMs.getMatchVMs(this.vmList, "bridge"));
        long recoveryDelay = (Long)ParRegBB.getBB().getSharedMap().get("recoveryDelay");
        long startupRecoveryDelay = (Long)ParRegBB.getBB().getSharedMap().get("startupRecoveryDelay");
        ArrayList<String> prNames = new ArrayList<String>();
        prNames.add("partitionedRegion");
        prNames.add("controllerReg");
        PRObserver.waitForRecovery(recoveryDelay, startupRecoveryDelay, dataStoreTargetVMs, dataStoreNotChosen, this.numVMsToStop, 2, prNames, null);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.ExceptionCounter);
        for (int i = 0; i < this.vmList.size(); ++i) {
            ClientVmInfo info = (ClientVmInfo)this.vmList.get(i);
            int vmid = info.getVmid();
            ControllerBB.waitForInitialization(vmid);
        }
        Log.getLogWriter().info("Done waiting for recovery");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void handleException(Exception anExcept) {
        boolean disconnectError;
        boolean thisVMReceivedForcedDisc = ControllerBB.isPlayDeadEnabled();
        String errStr = anExcept.toString();
        boolean bl = disconnectError = errStr.indexOf("This connection to a distributed system has been disconnected") >= 0 || errStr.indexOf("System is disconnecting") >= 0;
        if (anExcept instanceof CancelException) {
            if (!(thisVMReceivedForcedDisc || this.cacheIsClosed || this.disconnected)) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else if (anExcept instanceof LockServiceDestroyedException) {
            if (!(this.lockOperations && thisVMReceivedForcedDisc || this.lockOperations && this.disconnected || this.lockOperations && this.cacheIsClosed)) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else if (anExcept instanceof IllegalStateException) {
            if (!disconnectError) throw new TestException(TestHelper.getStackTrace(anExcept));
            if (!this.disconnected && !thisVMReceivedForcedDisc) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else if (anExcept instanceof CacheLoaderException) {
            if (!(this.isBridgeConfiguration && (thisVMReceivedForcedDisc || this.regionLocallyDestroyed || this.disconnected || this.cacheIsClosed))) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else if (anExcept instanceof BridgeWriterException) {
            if (!(this.isBridgeConfiguration && (thisVMReceivedForcedDisc || this.regionLocallyDestroyed || this.disconnected || this.cacheIsClosed))) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else {
            if (!(anExcept instanceof RegionDestroyedException)) throw new TestException("Got unexpected exception " + TestHelper.getStackTrace(anExcept));
            if (!this.regionLocallyDestroyed) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        }
        Log.getLogWriter().info("Caught " + anExcept + "; expected, continuing test");
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.ExceptionCounter);
        long counter = ControllerBB.getBB().getSharedCounters().incrementAndRead(ControllerBB.ExceptionCounter);
        Log.getLogWriter().info("ControllerBB.ExceptionCounter is now " + counter);
        ControllerBB.waitForInitialization();
    }

    @Override
    public String HA_reinitializeRegion() {
        PRObserver.installObserverHook();
        PRObserver.initialize(RemoteTestModule.getMyVmid());
        String regionConfigName = super.HA_reinitializeRegion();
        boolean isDataStore = (Boolean)SplitBrainBB.getBB().getSharedMap().get(IsDataStoreVmStr + RemoteTestModule.getMyVmid());
        ((SBParRegTest)SBParRegTest.testInstance).controllerRegion = isDataStore ? RegionHelper.createRegion("dataStoreControllerRegion") : RegionHelper.createRegion("accessorControllerRegion");
        Log.getLogWriter().info("Installing MembershipNotifierHook");
        SBUtil.addMembershipHook(new MembershipNotifierHook());
        return regionConfigName;
    }

    protected void loseAndRecreatePR() {
        Object[] choices = new Object[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3)};
        if (this.isBridgeConfiguration && !this.isBridgeClient) {
            choices = new Object[]{new Integer(0), new Integer(1)};
        }
        List<Object> aList = Arrays.asList(choices);
        ArrayList otherVMs = new ArrayList(ClientVmMgr.getOtherClientVmids());
        for (int i = 0; i < aList.size(); ++i) {
            Collections.swap(aList, i, TestConfig.tab().getRandGen().nextInt(0, aList.size() - 1));
        }
        int numPRsToRecover = 0;
        for (int i = 0; i < aList.size(); ++i) {
            numPRsToRecover = 2;
            PRObserver.initialize(RemoteTestModule.getMyVmid());
            int choice = (Integer)aList.get(i);
            if (choice == 0) {
                Log.getLogWriter().info("Losing PR by closing the cache...");
                CacheHelper.closeCache();
            } else if (choice == 1) {
                Log.getLogWriter().info("Losing PR by disconnecting from the distributed system...");
                DistributedSystemHelper.disconnect();
            } else if (choice == 2) {
                Log.getLogWriter().info("Losing PR by locally destroying the partitioned region...");
                this.aRegion.localDestroyRegion();
                numPRsToRecover = 1;
            } else if (choice == 3) {
                Log.getLogWriter().info("Losing PR by closing the partitioned region...");
                this.aRegion.close();
                numPRsToRecover = 1;
            }
            Log.getLogWriter().info("Recreating the partitioned region...");
            this.HA_reinitializeRegion();
            Log.getLogWriter().info("Done recreating the partitioned region...");
            if (this.isBridgeConfiguration) {
                if (SBParRegTest.testInstance.isBridgeClient) {
                    ParRegUtil.registerInterest(SBParRegTest.testInstance.aRegion);
                } else {
                    BridgeHelper.startBridgeServer("bridge");
                }
            }
            if (this.isDataStore) {
                RegionAttributes attr = this.aRegion.getAttributes();
                PartitionAttributes prAttr = attr.getPartitionAttributes();
                PRObserver.waitForRecovery(prAttr.getRecoveryDelay(), prAttr.getStartupRecoveryDelay(), new Integer(RemoteTestModule.getMyVmid()), otherVMs, 1, numPRsToRecover, null, null);
            }
            this.verifyFromSnapshot();
        }
    }

    @Override
    public int getOffHeapVerifyTargetCount() {
        return TestHelper.getNumThreads() - 1;
    }

    @Override
    public void initializeInstance() {
        super.initializeInstance();
        SBParRegTest.testInstance.offHeapVerifyTargetCount = this.getOffHeapVerifyTargetCount();
    }
}

