/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.admin.Alert;
import com.gemstone.gemfire.admin.AlertLevel;
import com.gemstone.gemfire.admin.AlertListener;
import hydra.GemFirePrms;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import splitBrain.ControllerBB;
import util.TestHelper;

public class AckAlertListener
implements AlertListener {
    public void alert(Alert alert) {
        try {
            Log.getLogWriter().info(this.getAlertString(alert));
            this.detectDesiredAlert(alert);
        }
        catch (Exception e) {
            String errStr = "Error occurred in vm_" + RemoteTestModule.getMyVmid() + " " + TestHelper.getStackTrace(e);
            Log.getLogWriter().info(errStr);
            ControllerBB.getBB().getSharedMap().put("Error", errStr);
        }
    }

    private void detectDesiredAlert(Alert alert) {
        if (alert.getLevel().equals((Object)AlertLevel.SEVERE)) {
            String msg = alert.getMessage();
            String waitingForRepliesStr = " seconds have elapsed while waiting for replies";
            String waitingForResponseStr = " seconds have elapsed waiting for a response from ";
            String unableToFormConnStr = "Unable to form a TCP/IP connection to ";
            if (msg.indexOf(waitingForRepliesStr) >= 0) {
                this.processWaitingForReplies(alert, waitingForRepliesStr);
            } else if (msg.indexOf(waitingForResponseStr) >= 0) {
                this.processWaitingForResponse(alert, waitingForResponseStr);
            } else if (msg.indexOf(unableToFormConnStr) >= 0) {
                this.processUnableToFormConn(alert, unableToFormConnStr);
            }
        }
    }

    private void processWaitingForReplies(Alert alert, String waitingForRepliesStr) {
        String msg = alert.getMessage();
        int index = msg.indexOf(waitingForRepliesStr);
        String seconds = msg.substring(0, index);
        this.validateSevereAlert(alert, seconds);
    }

    private void processWaitingForResponse(Alert alert, String waitingForResponseStr) {
        String msg = alert.getMessage();
        int index = msg.indexOf(waitingForResponseStr);
        String seconds = msg.substring(0, index);
        String whiteSpaceDelim = "[\\s]+";
        String[] tokenArr = seconds.split(whiteSpaceDelim);
        seconds = tokenArr[tokenArr.length - 1];
        this.validateSevereAlert(alert, seconds);
    }

    private void processUnableToFormConn(Alert alert, String unableToFormConnStr) {
        String msg = alert.getMessage();
        String beforeSecondsStr = " in over ";
        String afterSecondsStr = " seconds";
        int index1 = msg.indexOf(beforeSecondsStr) + beforeSecondsStr.length();
        int index2 = msg.indexOf(afterSecondsStr);
        String seconds = msg.substring(index1, index2);
        this.validateSevereAlert(alert, seconds);
    }

    protected void validateSevereAlert(Alert alert, String seconds) {
        String msg = alert.getMessage();
        int msgInt = 0;
        try {
            msgInt = Integer.valueOf(seconds);
        }
        catch (NumberFormatException e) {
            String errStr = "Test expected " + msg + " to have a different format";
            Log.getLogWriter().info(errStr);
            ControllerBB.getBB().getSharedMap().put("Error", errStr);
            return;
        }
        int index1 = msg.indexOf("(");
        int index2 = msg.indexOf(")");
        String msgPID = msg.substring(index1 + 1, index2);
        index1 = msgPID.indexOf(":");
        msgPID = msgPID.substring(index1 + 1);
        int msgVmid = ControllerBB.getVmIdForPid(Integer.valueOf(msgPID));
        if (ControllerBB.isAlertEnabled(msgVmid)) {
            String errStr = this.checkWaitTime(msgInt, msg);
            if (errStr != null) {
                Log.getLogWriter().info(errStr);
                ControllerBB.getBB().getSharedMap().put("Error", errStr);
                return;
            }
            ControllerBB.signalSevereAlert(msgVmid);
            Log.getLogWriter().info("Found alert to target vm " + msgVmid + ": " + this.getAlertString(alert));
        } else {
            Log.getLogWriter().info("This alert is targeting a healthy vm " + msgVmid + ": " + this.getAlertString(alert));
        }
    }

    protected String getAlertString(Alert alert) {
        int myPID = ProcessMgr.getProcessId();
        StringBuffer aStr = new StringBuffer();
        aStr.append("Invoked " + this.getClass().getName() + " in client with vmID " + RemoteTestModule.getMyVmid() + ", pid " + myPID + "\n");
        aStr.append("   alert.getConnectionName(): " + alert.getConnectionName() + "\n");
        aStr.append("   alert.getDate(): " + alert.getDate() + "\n");
        aStr.append("   alert.getLevel(): " + alert.getLevel() + "\n");
        aStr.append("   alert.getMessage(): " + alert.getMessage() + "\n");
        aStr.append("   alert.getSourceId(): " + alert.getSourceId() + "\n");
        aStr.append("   alert.getSystemMember(): " + alert.getSystemMember());
        return aStr.toString();
    }

    protected String checkWaitTime(int waitTimeInMessage, String msg) {
        int ackSevereAlertThreshold = TestConfig.tab().intAt(GemFirePrms.ackSevereAlertThreshold);
        int ackWaitThreshold = TestConfig.tab().intAt(GemFirePrms.ackWaitThreshold);
        int sum = ackWaitThreshold + ackSevereAlertThreshold;
        if (waitTimeInMessage < sum) {
            String errStr = "ackWaitThreshold is " + ackWaitThreshold + ", ackSevereAlertThreshold is " + ackSevereAlertThreshold + ", sum is " + sum + ", expected " + msg + " to wait at least " + sum + " seconds";
            return errStr;
        }
        return null;
    }
}

