/*
 * Decompiled with CFR 0.152.
 */
package security;

import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryTestListener;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.security.NotAuthorizedException;
import cq.CQUtil;
import cq.CQUtilPrms;
import hydra.HydraThread;
import hydra.Log;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import parReg.execute.ArrayListResultCollector;
import query.QueryPrms;
import security.PerUserRequestSecurityTest;
import security.SecurityClientBB;
import security.SecurityClientsPrms;
import security.SecurityFunction;
import util.TestException;
import util.TxHelper;

public class EntryOperations {
    static final int PUT_KEY_RANGE = TestConfig.tab().intAt(SecurityClientsPrms.numKeyRangePerThread);
    static final String regionName = TestConfig.tab().stringAt(SecurityClientsPrms.regionName);
    protected static final String NON_SECURE_REGION_NAME = "nonSecureRegion";
    protected static final String KEY_SET = "KEY_SET";
    static int numOfRegion = 1;
    private static volatile Integer totalOperation;
    private static volatile Integer notAuthzCount;
    public static Map operationsMap;
    public static Map exceptionMap;
    public static Map<String, Map> userOperationMap;
    public static Map<String, Map> userExceptionMap;
    static AtomicInteger cqCounter;
    private static ThreadLocal thrId;

    public static synchronized void doPut() {
        Region region = null;
        if (PoolHelper.getPool("brloader").getMultiuserAuthentication()) {
            for (String userName : PerUserRequestSecurityTest.proxyRegionMap.keySet()) {
                region = PerUserRequestSecurityTest.proxyRegionMap.get(userName);
                EntryOperations.updateKeysInRegion(region);
            }
        } else {
            region = RegionHelper.getRegion(regionName);
            EntryOperations.updateKeysInRegion(region);
        }
    }

    public static void updateKeysInRegion(Region aRegion) {
        long thrdNum = SecurityClientBB.getBB().getSharedCounters().incrementAndRead(SecurityClientBB.threadCount);
        for (int keyRng = 0; keyRng < PUT_KEY_RANGE; ++keyRng) {
            String Key3 = EntryOperations.getKeyForOperation();
            String Value3 = Key3 + "_VALUE";
            Log.getLogWriter().info("key is: " + Key3);
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                aRegion.put((Object)Key3, (Object)Value3);
                continue;
            }
            Object v = aRegion.putIfAbsent((Object)Key3, (Object)Value3);
            if (v == null) continue;
            aRegion.replace((Object)Key3, v, (Object)Value3);
        }
    }

    public static synchronized void doInitialFeed() {
        Boolean putOpFoundInOpList = false;
        Region region = null;
        String userName = null;
        if (PoolHelper.getPool("brloader").getMultiuserAuthentication()) {
            Iterator<String> iter = PerUserRequestSecurityTest.proxyRegionMap.keySet().iterator();
            while (iter.hasNext()) {
                putOpFoundInOpList = false;
                userName = iter.next();
                Map<String, ArrayList<String>> userRoleOpMap = PerUserRequestSecurityTest.userToRolesMap.get(userName);
                for (String roleName : userRoleOpMap.keySet()) {
                    ArrayList<String> roleOpNames = userRoleOpMap.get(roleName);
                    for (int i = 0; i < roleOpNames.size(); ++i) {
                        if (!roleOpNames.get(i).equalsIgnoreCase("PUT")) continue;
                        putOpFoundInOpList = true;
                    }
                    if (!putOpFoundInOpList.booleanValue()) continue;
                    break;
                }
                if (!putOpFoundInOpList.booleanValue()) continue;
                break;
            }
            if (putOpFoundInOpList.booleanValue()) {
                region = PerUserRequestSecurityTest.proxyRegionMap.get(userName);
                Log.getLogWriter().info("Got the proxyRegion for user :: " + userName);
            } else {
                Log.getLogWriter().info("No user found with PUT permission.");
            }
        } else {
            region = RegionHelper.getRegion(regionName);
        }
        for (int keyRng = 0; keyRng < PUT_KEY_RANGE; ++keyRng) {
            String Key3 = EntryOperations.getKeyForOperation();
            Long Value3 = new Long(1L);
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                region.put((Object)Key3, (Object)Value3);
                continue;
            }
            Object v = region.putIfAbsent((Object)Key3, (Object)Value3);
            if (v == null) continue;
            region.replace((Object)Key3, (Object)Value3);
        }
    }

    public static void putKeysInBB() {
        Region region = RegionHelper.getRegion(regionName);
        HashSet keySet = new HashSet(region.keySet());
        if (SecurityClientBB.getBB().getSharedMap().get(KEY_SET) == null) {
            SecurityClientBB.getBB().getSharedMap().put(KEY_SET, keySet);
        }
    }

    public static synchronized void putAllKeysInRange() {
        Region region = RegionHelper.getRegion(regionName);
        for (int keyRng = 0; keyRng < PUT_KEY_RANGE; ++keyRng) {
            String Key3 = "KEY-" + keyRng;
            String Value3 = Key3 + "_VALUE";
            Log.getLogWriter().info("key is: " + Key3);
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                region.put((Object)Key3, (Object)Value3);
                continue;
            }
            Object v = region.putIfAbsent((Object)Key3, (Object)Value3);
            if (v == null) continue;
            region.replace((Object)Key3, (Object)Value3);
        }
    }

    public static synchronized void populateNonSecureRegion() {
        Region nonSecureRegion = RegionHelper.getRegion(NON_SECURE_REGION_NAME);
        if (nonSecureRegion == null) {
            return;
        }
        for (int keyRng = 0; keyRng < PUT_KEY_RANGE; ++keyRng) {
            String Key3 = "KEY-" + keyRng;
            String Value3 = Key3 + "_VALUE";
            Log.getLogWriter().info("key is: " + Key3);
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                nonSecureRegion.put((Object)Key3, (Object)Value3);
                continue;
            }
            Object v = nonSecureRegion.putIfAbsent((Object)Key3, (Object)Value3);
            if (v == null) continue;
            nonSecureRegion.replace((Object)Key3, (Object)Value3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startQueryExecuteOperationForMultiUserMode() {
        Region region = null;
        Map[] maps = new HashMap[2];
        for (String userName : PerUserRequestSecurityTest.proxyRegionMap.keySet()) {
            region = PerUserRequestSecurityTest.proxyRegionMap.get(userName);
            Map<String, Map> map = userOperationMap;
            synchronized (map) {
                if (userOperationMap.get(userName) == null) {
                    userOperationMap.put(userName, new HashMap());
                }
            }
            map = userExceptionMap;
            synchronized (map) {
                if (userExceptionMap.get(userName) == null) {
                    userExceptionMap.put(userName, new HashMap());
                }
            }
            maps[0] = userOperationMap.get(userName);
            maps[1] = userExceptionMap.get(userName);
            EntryOperations.doQueryExecute(region, userName, maps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doQueryExecute(Region region, String userName, Map[] maps) {
        block23: {
            Object tmpTotalOperation;
            Map opMap = maps[0];
            Map exMap = maps[1];
            String key = EntryOperations.getKeyForOperation();
            boolean doAddOperation = true;
            String operation = "executeQuery";
            try {
                String queryString = "SELECT DISTINCT * FROM " + region.getFullPath();
                Query query = PerUserRequestSecurityTest.proxyAuthenticatedCacheMap.get(userName).getQueryService().newQuery(queryString);
                SelectResults selectResults = (SelectResults)query.execute();
            }
            catch (Exception ex) {
                if ((ex instanceof CacheLoaderException || ex instanceof CacheWriterException || ex instanceof ServerConnectivityException || ex instanceof QueryInvocationTargetException || ex instanceof ServerOperationException) && ex.getCause() instanceof NotAuthorizedException) {
                    Log.getLogWriter().info("Got expected NotAuthorizedException when doing " + operation + " operation for " + userName + " : " + ex.getCause());
                    tmpTotalOperation = exMap;
                    synchronized (tmpTotalOperation) {
                        Integer tmpNotAuthzCount = (Integer)exMap.get(operation);
                        if (tmpNotAuthzCount == null) {
                            exMap.put(operation, new Integer(1));
                        } else {
                            exMap.put(operation, new Integer(tmpNotAuthzCount + 1));
                        }
                        break block23;
                    }
                }
                doAddOperation = false;
                throw new TestException("Exception while Query Operation for user : " + userName, ex);
            }
            finally {
                Map map = opMap;
                synchronized (map) {
                    if (doAddOperation) {
                        tmpTotalOperation = (Integer)opMap.get(operation);
                        if (tmpTotalOperation == null) {
                            opMap.put(operation, new Integer(1));
                        } else {
                            opMap.put(operation, new Integer((Integer)tmpTotalOperation + 1));
                        }
                    }
                    Log.getLogWriter().fine("For user :: " + userName + " operation : " + operation + " operation count is " + (Integer)opMap.get(operation) + " And Exception count is :: " + (Integer)exMap.get(operation) + " key is " + key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCQTask(Boolean isDurable) {
        Region region = null;
        Map[] maps = new HashMap[2];
        Iterator<String> iter = PerUserRequestSecurityTest.proxyRegionMap.keySet().iterator();
        CqQueryTestListener.usedForUnitTests = false;
        while (iter.hasNext()) {
            String userName = iter.next();
            region = PerUserRequestSecurityTest.proxyRegionMap.get(userName);
            Map<String, Map> map = userOperationMap;
            synchronized (map) {
                if (userOperationMap.get(userName) == null) {
                    userOperationMap.put(userName, new HashMap());
                }
            }
            map = userExceptionMap;
            synchronized (map) {
                if (userExceptionMap.get(userName) == null) {
                    userExceptionMap.put(userName, new HashMap());
                }
            }
            maps[0] = userOperationMap.get(userName);
            maps[1] = userExceptionMap.get(userName);
            EntryOperations.doExecuteCQ(region, userName, maps, isDurable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doExecuteCQ(Region region, String userName, Map[] maps, Boolean isDurable) {
        block23: {
            Object tmpTotalOperation;
            Map opMap = maps[0];
            Map exMap = maps[1];
            String key = EntryOperations.getKeyForOperation();
            boolean doAddOperation = true;
            String operation = "EXECUTE_CQ";
            String cqName1 = "CQ1_" + userName;
            String cqName2 = "CQ2_" + userName;
            CqResults cqResults = null;
            String queryString = "SELECT * FROM " + region.getFullPath();
            QueryService qs = PerUserRequestSecurityTest.proxyAuthenticatedCacheMap.get(userName).getQueryService();
            try {
                Object cqf = new CqAttributesFactory();
                CqListener[] cqListeners1 = new CqListener[]{new CqQueryTestListener(Log.getLogWriter())};
                ((CqQueryTestListener)cqListeners1[0]).cqName = cqName1;
                ((CqQueryTestListener)cqListeners1[0]).userName = userName;
                cqf.initCqListeners(cqListeners1);
                CqAttributes cqAttributes = cqf.create();
                CqQuery cq1 = qs.newCq(cqName1, queryString, cqAttributes, isDurable.booleanValue());
                cq1.execute();
                CqListener[] cqListeners2 = new CqListener[]{new CqQueryTestListener(Log.getLogWriter())};
                ((CqQueryTestListener)cqListeners2[0]).cqName = cqName2;
                ((CqQueryTestListener)cqListeners2[0]).userName = userName;
                cqf.initCqListeners(cqListeners2);
                cqAttributes = cqf.create();
                CqQuery cq2 = qs.newCq(cqName2, queryString, cqAttributes, isDurable.booleanValue());
                cqResults = cq2.executeWithInitialResults();
            }
            catch (Exception ex) {
                if (ex instanceof CacheLoaderException || ex instanceof CacheWriterException || ex instanceof ServerConnectivityException && ex.getCause() instanceof NotAuthorizedException || ex instanceof CqException && ex.getCause() instanceof NotAuthorizedException || ex instanceof ServerOperationException && ex.getCause() instanceof NotAuthorizedException) {
                    Log.getLogWriter().info("Got expected NotAuthorizedException when doing " + operation + " operation for " + userName + " : " + ex.getCause());
                    tmpTotalOperation = exMap;
                    synchronized (tmpTotalOperation) {
                        Integer tmpNotAuthzCount = (Integer)exMap.get(operation);
                        if (tmpNotAuthzCount == null) {
                            exMap.put(operation, new Integer(1));
                        } else {
                            exMap.put(operation, new Integer(tmpNotAuthzCount + 1));
                        }
                        break block23;
                    }
                }
                doAddOperation = false;
                throw new TestException("Exception while CQ Operation for user :" + userName + " ", ex);
            }
            finally {
                Map map = opMap;
                synchronized (map) {
                    if (doAddOperation) {
                        tmpTotalOperation = (Integer)opMap.get(operation);
                        if (tmpTotalOperation == null) {
                            opMap.put(operation, new Integer(1));
                        } else {
                            opMap.put(operation, new Integer((Integer)tmpTotalOperation + 1));
                        }
                    }
                    Log.getLogWriter().fine("For user :: " + userName + " operation : " + operation + " operation count is " + (Integer)opMap.get(operation) + " And Exception count is :: " + (Integer)exMap.get(operation) + " key is " + key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startFunctionExecuteOperationForMultiUserMode() {
        Region region = null;
        Map[] maps = new HashMap[2];
        for (String userName : PerUserRequestSecurityTest.proxyRegionMap.keySet()) {
            region = PerUserRequestSecurityTest.proxyRegionMap.get(userName);
            Map<String, Map> map = userOperationMap;
            synchronized (map) {
                if (userOperationMap.get(userName) == null) {
                    userOperationMap.put(userName, new HashMap());
                }
            }
            map = userExceptionMap;
            synchronized (map) {
                if (userExceptionMap.get(userName) == null) {
                    userExceptionMap.put(userName, new HashMap());
                }
            }
            maps[0] = userOperationMap.get(userName);
            maps[1] = userExceptionMap.get(userName);
            SecurityFunction function = new SecurityFunction(PerUserRequestSecurityTest.isFailOver);
            Random randomGen = new Random();
            int randomInt = randomGen.nextInt(3);
            if (PerUserRequestSecurityTest.isFailOver.booleanValue() || randomInt == 0) {
                EntryOperations.doFunctionExecute(region, userName, maps, (Function)function, "region");
                continue;
            }
            if (randomInt == 1) {
                EntryOperations.doFunctionExecute(region, userName, maps, (Function)function, "server");
                continue;
            }
            if (randomInt != 2) continue;
            EntryOperations.doFunctionExecute(region, userName, maps, (Function)function, "servers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doFunctionExecute(Region region, String userName, Map[] maps, Function function, String method) {
        block29: {
            Object tmpTotalOperation;
            Map opMap = maps[0];
            Map exMap = maps[1];
            String key = EntryOperations.getKeyForOperation();
            String operation = "EXECUTE_FUNCTION";
            Execution dataSet = null;
            boolean doAddOperation = true;
            FunctionService.registerFunction((Function)function);
            try {
                Object cache;
                Object pool = PoolHelper.getPool("brloader");
                if (pool == null) {
                    pool = PoolHelper.createPool("brloader");
                }
                if ("servers".equals(method)) {
                    cache = PerUserRequestSecurityTest.proxyAuthenticatedCacheMap.get(userName);
                    dataSet = FunctionService.onServers((RegionService)cache).withCollector((ResultCollector)new ArrayListResultCollector());
                } else if ("server".equals(method)) {
                    cache = PerUserRequestSecurityTest.proxyAuthenticatedCacheMap.get(userName);
                    dataSet = FunctionService.onServer((RegionService)cache).withCollector((ResultCollector)new ArrayListResultCollector());
                } else if ("region".equals(method)) {
                    dataSet = FunctionService.onRegion((Region)region).withCollector((ResultCollector)new ArrayListResultCollector());
                }
                cache = (ArrayList)dataSet.execute(function).getResult();
            }
            catch (Exception ex) {
                if ((ex instanceof CacheLoaderException || ex instanceof CacheWriterException || ex instanceof ServerConnectivityException) && ex.getCause() instanceof NotAuthorizedException || ex instanceof ServerOperationException && ex.getCause() instanceof NotAuthorizedException || ex instanceof FunctionException && ex.getCause() instanceof ServerOperationException && ex.getCause().getCause() instanceof NotAuthorizedException || ex instanceof ServerOperationException && ex.getCause() instanceof FunctionException && ex.getCause().getCause() instanceof NotAuthorizedException) {
                    Log.getLogWriter().info("Got expected NotAuthorizedException when doing " + operation + "." + method + "() operation for " + userName + " : " + ex.getCause());
                    tmpTotalOperation = exMap;
                    synchronized (tmpTotalOperation) {
                        Integer tmpNotAuthzCount = (Integer)exMap.get(operation);
                        if (tmpNotAuthzCount == null) {
                            exMap.put(operation, new Integer(1));
                        } else {
                            exMap.put(operation, new Integer(tmpNotAuthzCount + 1));
                        }
                        break block29;
                    }
                }
                doAddOperation = false;
                Log.getLogWriter().info("Exception while Function Execution for method " + method + " :" + ex.getCause() + " for " + userName);
                throw new TestException("Exception while Function Execution:", ex);
            }
            finally {
                Map map = opMap;
                synchronized (map) {
                    if (doAddOperation) {
                        tmpTotalOperation = (Integer)opMap.get(operation);
                        if (tmpTotalOperation == null) {
                            opMap.put(operation, new Integer(1));
                        } else {
                            opMap.put(operation, new Integer((Integer)tmpTotalOperation + 1));
                        }
                    }
                    Log.getLogWriter().fine("For user :: " + userName + " operation : " + operation + " operation count is " + (Integer)opMap.get(operation) + " And Exception count is :: " + (Integer)exMap.get(operation) + " key is " + key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startRandomOperationsForMultiUserMode() {
        Region region = null;
        Map[] maps = new HashMap[2];
        for (String userName : PerUserRequestSecurityTest.proxyRegionMap.keySet()) {
            region = PerUserRequestSecurityTest.proxyRegionMap.get(userName);
            Map<String, Map> map = userOperationMap;
            synchronized (map) {
                if (userOperationMap.get(userName) == null) {
                    userOperationMap.put(userName, new HashMap());
                }
            }
            map = userExceptionMap;
            synchronized (map) {
                if (userExceptionMap.get(userName) == null) {
                    userExceptionMap.put(userName, new HashMap());
                }
            }
            maps[0] = userOperationMap.get(userName);
            maps[1] = userExceptionMap.get(userName);
            EntryOperations.startRandomOperationsOnRegion(region, userName, maps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startRandomOperationsOnRegion(Region region, String userName, Map[] maps) {
        block59: {
            Object tmpTotalOperation;
            Map opMap = maps[0];
            Map exMap = maps[1];
            String key = EntryOperations.getKeyForOperation();
            String operation = TestConfig.tab().stringAt(SecurityClientsPrms.entryOperations, "put");
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().info("Operation :" + operation + " and Key " + key);
            }
            boolean doAddOperation = true;
            try {
                Object v;
                if (operation.equals("create")) {
                    try {
                        if (TestConfig.tab().getRandGen().nextBoolean()) {
                            region.create((Object)key, (Object)(key + "_VALUE"));
                        } else {
                            Object v2 = region.putIfAbsent((Object)key, (Object)(key + "_VALUE"));
                            if (v2 != null) {
                                doAddOperation = false;
                            }
                        }
                        break block59;
                    }
                    catch (EntryExistsException ex) {
                        doAddOperation = false;
                    }
                    break block59;
                }
                if (operation.equals("put")) {
                    if (!PerUserRequestSecurityTest.writeToBB.booleanValue()) {
                        if (TestConfig.tab().getRandGen().nextBoolean()) {
                            region.put((Object)key, (Object)(key + "_Value"));
                        } else {
                            Object v3 = region.putIfAbsent((Object)key, (Object)(key + "_VALUE"));
                            if (v3 != null) {
                                region.replace((Object)key, (Object)(key + "_VALUE"));
                            }
                        }
                    } else if (SecurityClientBB.getBB().getSharedMap().containsKey(key)) {
                        Long valueFromBB = (Long)SecurityClientBB.getBB().getSharedMap().get(key);
                        if (TestConfig.tab().getRandGen().nextBoolean()) {
                            region.put((Object)key, (Object)(valueFromBB + 1L));
                        } else {
                            v = region.putIfAbsent((Object)key, (Object)(valueFromBB + 1L));
                            if (v != null) {
                                region.replace((Object)key, (Object)(valueFromBB + 1L));
                            }
                        }
                    } else {
                        if (TestConfig.tab().getRandGen().nextBoolean()) {
                            region.put((Object)key, (Object)1L);
                        } else {
                            region.putIfAbsent((Object)key, (Object)1L);
                        }
                        SecurityClientBB.getBB().getSharedMap().put(key, 1L);
                    }
                    break block59;
                }
                if (operation.equals("update")) {
                    if (TestConfig.tab().getRandGen().nextBoolean()) {
                        region.put((Object)key, (Object)(key + "_VALUE"));
                    } else {
                        Object v4 = region.putIfAbsent((Object)key, (Object)(key + "_VALUE"));
                        if (v4 != null) {
                            region.replace((Object)key, (Object)(key + "_VALUE"));
                        }
                    }
                    break block59;
                }
                if (operation.equals("putAll")) {
                    HashMap aMap = EntryOperations.getMapForPutAll();
                    Log.getLogWriter().info("Putting into region with mapSize " + aMap.size());
                    region.putAll((Map)aMap);
                    break block59;
                }
                if (operation.equals("invalidate")) {
                    region.invalidate((Object)key);
                    break block59;
                }
                if (operation.equals("destroy")) {
                    try {
                        if (TestConfig.tab().getRandGen().nextBoolean()) {
                            region.destroy((Object)key);
                        } else {
                            boolean removed = region.remove((Object)key, (Object)(key + "_VALUE"));
                            if (!removed) {
                                doAddOperation = false;
                            }
                        }
                        break block59;
                    }
                    catch (EntryNotFoundException ex) {
                        doAddOperation = false;
                    }
                    break block59;
                }
                if (operation.equals("get")) {
                    region.get((Object)key);
                    break block59;
                }
                if (operation.equals("query")) {
                    String querystring = "select distinct * from " + region.getFullPath() + " where FALSE";
                    v = region.query(querystring);
                    break block59;
                }
                throw new TestException("Unknown entry operation: " + operation);
            }
            catch (Exception ex) {
                if ((ex instanceof CacheLoaderException || ex instanceof CacheWriterException || ex instanceof ServerConnectivityException || ex instanceof QueryInvocationTargetException) && ex.getCause() instanceof NotAuthorizedException || ex instanceof ServerOperationException && ex.getCause() instanceof NotAuthorizedException) {
                    Log.getLogWriter().info("Got expected NotAuthorizedException when doing " + operation + " operation :" + ex.getCause());
                    tmpTotalOperation = exMap;
                    synchronized (tmpTotalOperation) {
                        Integer tmpNotAuthzCount = (Integer)exMap.get(operation);
                        if (tmpNotAuthzCount == null) {
                            exMap.put(operation, new Integer(1));
                        } else {
                            exMap.put(operation, new Integer(tmpNotAuthzCount + 1));
                        }
                        break block59;
                    }
                }
                if (ex instanceof QueryInvocationTargetException) {
                    if (QueryPrms.allowQueryInvocationTargetException()) {
                        Log.getLogWriter().info("Caught " + ex + " (expected with concurrent execution); continuing with test");
                        break block59;
                    }
                    doAddOperation = false;
                    throw new TestException("Exception while EntryOperation:", ex);
                }
                doAddOperation = false;
                throw new TestException("Exception while EntryOperation " + operation + " for user : " + userName + " : ", ex);
            }
            finally {
                Map map = opMap;
                synchronized (map) {
                    if (doAddOperation) {
                        tmpTotalOperation = (Integer)opMap.get(operation);
                        if (tmpTotalOperation == null) {
                            opMap.put(operation, new Integer(1));
                        } else {
                            opMap.put(operation, new Integer((Integer)tmpTotalOperation + 1));
                        }
                    }
                    Log.getLogWriter().info("For user :: " + userName + " operation : " + operation + " operation count is " + (Integer)opMap.get(operation) + " And Exception count is :: " + (Integer)exMap.get(operation) + " key is " + key);
                }
            }
        }
    }

    private static boolean isEntryOp(String op) {
        boolean entryOp = false;
        if (op.equals("create") || op.equals("put") || op.equals("update") || op.equals("invalidate") || op.equals("destroy") || op.equals("get") || op.equals("putAll")) {
            entryOp = true;
        }
        return entryOp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void startRandomOperations() {
        block87: {
            Region region = RegionHelper.getRegion(regionName);
            String key = EntryOperations.getKeyForOperation();
            String operation = TestConfig.tab().stringAt(SecurityClientsPrms.entryOperations, "put");
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().info("Operation :" + operation + " and Key " + key);
            }
            boolean doAddOperation = true;
            boolean useTransactions = SecurityClientsPrms.useTransactions();
            try {
                if (useTransactions && EntryOperations.isEntryOp(operation)) {
                    TxHelper.begin();
                }
                if (operation.equals("create")) {
                    try {
                        if (TestConfig.tab().getRandGen().nextBoolean()) {
                            region.create((Object)key, (Object)(key + "_VALUE"));
                        } else {
                            Object v = region.putIfAbsent((Object)key, (Object)(key + "_VALUE"));
                            if (v != null) {
                                doAddOperation = false;
                            }
                        }
                        break block87;
                    }
                    catch (EntryExistsException ex) {
                        doAddOperation = false;
                    }
                    catch (TransactionDataNodeHasDepartedException e) {
                        Log.getLogWriter().info("Caught " + (Object)((Object)e) + ".  Expected, continuing test");
                        doAddOperation = false;
                    }
                    break block87;
                }
                if (operation.equals("put")) {
                    if (TestConfig.tab().getRandGen().nextBoolean()) {
                        region.put((Object)key, (Object)(key + "_VALUE"));
                    } else {
                        Object v = region.putIfAbsent((Object)key, (Object)(key + "_VALUE"));
                        if (v != null) {
                            region.replace((Object)key, (Object)(key + "_VALUE"));
                        }
                    }
                    break block87;
                }
                if (operation.equals("update")) {
                    if (TestConfig.tab().getRandGen().nextBoolean()) {
                        region.put((Object)key, (Object)(key + "_VALUE"));
                    } else {
                        Object v = region.putIfAbsent((Object)key, (Object)(key + "_VALUE"));
                        if (v != null) {
                            region.replace((Object)key, (Object)(key + "_VALUE"));
                        }
                    }
                    break block87;
                }
                if (operation.equals("putAll")) {
                    HashMap aMap = EntryOperations.getMapForPutAll();
                    Log.getLogWriter().info("Putting into region with mapSize " + aMap.size());
                    region.putAll((Map)aMap);
                    break block87;
                }
                if (operation.equals("invalidate")) {
                    region.invalidate((Object)key);
                    break block87;
                }
                if (operation.equals("destroy")) {
                    try {
                        if (TestConfig.tab().getRandGen().nextBoolean()) {
                            region.destroy((Object)key);
                        } else {
                            boolean removed = region.remove((Object)key, (Object)(key + "_VALUE"));
                            if (!removed) {
                                doAddOperation = false;
                            }
                        }
                        break block87;
                    }
                    catch (EntryNotFoundException ex) {
                        doAddOperation = false;
                    }
                    catch (TransactionDataNodeHasDepartedException e) {
                        Log.getLogWriter().info("Caught " + (Object)((Object)e) + ".  Expected, continuing test");
                        doAddOperation = false;
                    }
                    break block87;
                }
                if (operation.equals("get")) {
                    if (useTransactions) {
                        region.get((Object)key);
                    } else {
                        LocalRegion lregion = (LocalRegion)region;
                        LoaderHelper lhelper = lregion.createLoaderHelper((Object)key, null, false, true, null);
                        lregion.getServerProxy().get((Object)key, null, null);
                    }
                    break block87;
                }
                if (operation.equals("regNUnregInterest")) {
                    region.registerInterest((Object)key);
                    region.unregisterInterest((Object)key);
                    break block87;
                }
                if (operation.equals("query")) {
                    String querystring = "select distinct * from " + region.getFullPath() + " where FALSE";
                    SelectResults lhelper = region.query(querystring);
                    break block87;
                }
                if (operation.equals("cq")) {
                    String querystring = "SELECT * FROM " + region.getFullPath();
                    String cqName = "cq" + cqCounter.incrementAndGet() + "_" + key;
                    CQUtil.registerAndCloseCQ(cqName, querystring, region);
                    break block87;
                }
                if (operation.equals("serverFunctionExecute")) {
                    SecurityFunction function = new SecurityFunction();
                    Pool pool = PoolHelper.getPool("brloader");
                    if (pool == null) {
                        Log.getLogWriter().info("Pool is null");
                        pool = PoolHelper.createPool("brloader");
                    }
                    Execution dataSet = TestConfig.tab().getRandGen().nextBoolean() ? FunctionService.onServers((Pool)pool).withCollector((ResultCollector)new ArrayListResultCollector()) : FunctionService.onServer((Pool)pool).withCollector((ResultCollector)new ArrayListResultCollector());
                    ArrayList arrayList = (ArrayList)dataSet.execute((Function)function).getResult();
                    break block87;
                }
                if (operation.equals("serverExecuteWrongFunction")) {
                    SecurityFunction function = new SecurityFunction();
                    Pool pool = PoolHelper.getPool("brloader");
                    if (pool == null) {
                        Log.getLogWriter().info("Pool is null");
                        pool = PoolHelper.createPool("brloader");
                    }
                    Execution dataSet = TestConfig.tab().getRandGen().nextBoolean() ? FunctionService.onServers((Pool)pool).withCollector((ResultCollector)new ArrayListResultCollector()) : FunctionService.onServer((Pool)pool).withCollector((ResultCollector)new ArrayListResultCollector());
                    ArrayList arrayList = (ArrayList)dataSet.execute((Function)new FunctionAdapter(){

                        public void execute(FunctionContext context) {
                            DistributionConfig dc = InternalDistributedSystem.getAnyInstance().getConfig();
                            ArrayList<Object> list = new ArrayList<Object>();
                            list.add(dc.getCacheXmlFile());
                            list.add(dc.getName());
                            context.getResultSender().lastResult(list);
                        }

                        public String getId() {
                            return "NonSecureFunction";
                        }
                    }).getResult();
                    break block87;
                }
                if (operation.equals("serverExecuteWrongPostAuthz")) {
                    SecurityFunction function = new SecurityFunction();
                    Pool pool = PoolHelper.getPool("brloader");
                    if (pool == null) {
                        Log.getLogWriter().info("Pool is null");
                        pool = PoolHelper.createPool("brloader");
                    }
                    Execution dataSet = TestConfig.tab().getRandGen().nextBoolean() ? FunctionService.onServers((Pool)pool).withArgs((Object)"Args").withCollector((ResultCollector)new ArrayListResultCollector()) : FunctionService.onServer((Pool)pool).withArgs((Object)"Args").withCollector((ResultCollector)new ArrayListResultCollector());
                    ArrayList arrayList = (ArrayList)dataSet.execute((Function)function).getResult();
                    break block87;
                }
                if (operation.equals("functionExecute")) {
                    SecurityFunction function = new SecurityFunction();
                    Set keySet = (Set)SecurityClientBB.getBB().getSharedMap().get(KEY_SET);
                    if (keySet == null || keySet.size() == 0) {
                        throw new TestException("Test issue: keySet for filter cannot be null");
                    }
                    HashSet<String> args = new HashSet<String>();
                    args.add("KEY-0");
                    args.add("KEY-1");
                    keySet.removeAll(args);
                    Execution dataSet = FunctionService.onRegion((Region)region).withFilter(keySet).withArgs(args).withCollector((ResultCollector)new ArrayListResultCollector());
                    ArrayList arrayList = (ArrayList)dataSet.execute((Function)function).getResult();
                    break block87;
                }
                if (operation.equals("executeWrongFilter")) {
                    SecurityFunction function = new SecurityFunction();
                    Set keySet = region.keySet();
                    HashSet<String> args = new HashSet<String>();
                    args.add("KEY-0");
                    args.add("KEY-1");
                    Execution dataSet = FunctionService.onRegion((Region)region).withFilter(keySet).withArgs(args).withCollector((ResultCollector)new ArrayListResultCollector());
                    ArrayList arrayList = (ArrayList)dataSet.execute((Function)function).getResult();
                    break block87;
                }
                if (operation.equals("executeWrongPostAuthz")) {
                    SecurityFunction function = new SecurityFunction();
                    Execution dataSet = FunctionService.onRegion((Region)region).withCollector((ResultCollector)new ArrayListResultCollector());
                    ArrayList args = (ArrayList)dataSet.execute((Function)function).getResult();
                    break block87;
                }
                if (operation.equals("executeWrongRegion")) {
                    SecurityFunction function = new SecurityFunction();
                    HashSet<String> args = new HashSet<String>();
                    args.add("KEY-0");
                    args.add("KEY-1");
                    Region nonSecureRegion = RegionHelper.getRegion(NON_SECURE_REGION_NAME);
                    Execution dataSet = FunctionService.onRegion((Region)nonSecureRegion).withArgs(args).withCollector((ResultCollector)new ArrayListResultCollector());
                    ArrayList arrayList = (ArrayList)dataSet.execute((Function)function).getResult();
                    break block87;
                }
                if (operation.equals("executeWrongFunction")) {
                    HashSet<String> args = new HashSet<String>();
                    args.add("KEY-0");
                    args.add("KEY-1");
                    Execution dataSet = FunctionService.onRegion((Region)region).withArgs(args).withCollector((ResultCollector)new ArrayListResultCollector());
                    ArrayList arrayList = (ArrayList)dataSet.execute((Function)new FunctionAdapter(){

                        public void execute(FunctionContext context) {
                            boolean isRegionContext = context instanceof RegionFunctionContext;
                            RegionFunctionContext regionContext = null;
                            if (isRegionContext) {
                                regionContext = (RegionFunctionContext)context;
                            }
                            Region region = regionContext.getDataSet();
                            ArrayList list = new ArrayList();
                            Set keys = region.keySet();
                            Iterator iterator = keys.iterator();
                            while (iterator.hasNext()) {
                                list.add(iterator.next());
                            }
                            if (regionContext.getArguments() != null) {
                                HashSet args = (HashSet)regionContext.getArguments();
                                list.removeAll(args);
                            }
                            context.getResultSender().lastResult(list);
                        }

                        public boolean hasResult() {
                            return true;
                        }

                        public String getId() {
                            return "NonSecureFunction";
                        }
                    }).getResult();
                    break block87;
                }
                if (operation.equals("executeWrongOptimization")) {
                    HashSet<String> args = new HashSet<String>();
                    args.add("KEY-0");
                    args.add("KEY-1");
                    Execution dataSet = FunctionService.onRegion((Region)region).withArgs(args).withCollector((ResultCollector)new ArrayListResultCollector());
                    ArrayList arrayList = (ArrayList)dataSet.execute((Function)new FunctionAdapter(){

                        public void execute(FunctionContext context) {
                            boolean isRegionContext = context instanceof RegionFunctionContext;
                            RegionFunctionContext regionContext = null;
                            if (isRegionContext) {
                                regionContext = (RegionFunctionContext)context;
                            }
                            Region region = regionContext.getDataSet();
                            ArrayList list = new ArrayList();
                            Set keys = region.keySet();
                            Iterator iterator = keys.iterator();
                            while (iterator.hasNext()) {
                                list.add(iterator.next());
                            }
                            if (regionContext.getArguments() != null) {
                                HashSet args = (HashSet)regionContext.getArguments();
                                list.removeAll(args);
                            }
                            context.getResultSender().lastResult(list);
                        }

                        public String getId() {
                            return "OptimizationFunction";
                        }

                        public boolean hasResult() {
                            return true;
                        }

                        public boolean optimizeForWrite() {
                            return true;
                        }
                    }).getResult();
                    break block87;
                }
                throw new TestException("Unknown entry operation: " + operation);
            }
            catch (Exception ex) {
                if ((ex instanceof CacheLoaderException || ex instanceof CacheWriterException || ex instanceof ServerConnectivityException || ex instanceof QueryInvocationTargetException || ex instanceof CqException) && ex.getCause() instanceof NotAuthorizedException || ex instanceof ServerOperationException && ex.getCause() instanceof NotAuthorizedException || ex instanceof FunctionException && ex.getCause() instanceof ServerOperationException && ex.getCause().getCause() instanceof NotAuthorizedException || ex instanceof ServerOperationException && ex.getCause() instanceof FunctionException && ex.getCause().getCause() instanceof NotAuthorizedException) {
                    Log.getLogWriter().info("Got expected NotAuthorizedException when doing " + operation + " operation :" + ex.getCause());
                    Map map = exceptionMap;
                    synchronized (map) {
                        notAuthzCount = (Integer)exceptionMap.get(operation);
                        if (notAuthzCount == null) {
                            exceptionMap.put(operation, new Integer(1));
                        } else {
                            exceptionMap.put(operation, new Integer(notAuthzCount + 1));
                        }
                        break block87;
                    }
                }
                if (ex instanceof CqException) {
                    doAddOperation = false;
                    break block87;
                }
                if (ex instanceof QueryInvocationTargetException) {
                    if (QueryPrms.allowQueryInvocationTargetException()) {
                        Log.getLogWriter().info("Caught " + ex + " (expected with concurrent execution); continuing with test");
                        break block87;
                    }
                    doAddOperation = false;
                    throw new TestException("Exception while EntryOperation:", ex);
                }
                if (ex instanceof TransactionDataRebalancedException) {
                    Log.getLogWriter().info("Caught " + ex + "  (expected with concurrent execution); continuing with test");
                    doAddOperation = false;
                    break block87;
                }
                if (ex instanceof TransactionDataNodeHasDepartedException) {
                    Log.getLogWriter().info("Caught " + ex + "  (expected with concurrent execution); continuing with test");
                    doAddOperation = false;
                    break block87;
                }
                doAddOperation = false;
                throw new TestException("Exception while EntryOperation:", ex);
            }
            finally {
                try {
                    if (useTransactions && EntryOperations.isEntryOp(operation)) {
                        TxHelper.commit();
                    }
                }
                catch (TransactionDataNodeHasDepartedException e) {
                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + "  (expected with concurrent execution); continuing with test");
                    doAddOperation = true;
                }
                catch (TransactionDataRebalancedException e) {
                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + "  (expected with concurrent execution); continuing with test");
                    doAddOperation = true;
                }
                catch (TransactionInDoubtException e) {
                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + "  (expected with concurrent execution); continuing with test");
                    doAddOperation = true;
                }
                Map map = operationsMap;
                synchronized (map) {
                    if (doAddOperation) {
                        totalOperation = (Integer)operationsMap.get(operation);
                        if (totalOperation == null) {
                            operationsMap.put(operation, new Integer(1));
                        } else {
                            operationsMap.put(operation, new Integer(totalOperation + 1));
                        }
                    }
                    if (Log.getLogWriter().fineEnabled()) {
                        Log.getLogWriter().fine("For operation : " + operation + " operation count is " + (Integer)operationsMap.get(operation) + " Exception count is " + (Integer)exceptionMap.get(operation) + " key is " + key);
                    }
                }
            }
        }
    }

    protected static HashMap getMapForPutAll() {
        HashMap<String, String> aMap = new HashMap<String, String>();
        int mapSize = TestConfig.tab().intAt(SecurityClientsPrms.putAllMapSize, 100);
        for (int i = 0; i < mapSize; ++i) {
            String key = EntryOperations.getKeyForOperation();
            String value = key + "_VALUE";
            aMap.put(key, value);
            Log.getLogWriter().info("Putting into putAll mpa for Key " + key);
        }
        return aMap;
    }

    private static CqAttributes getCQAttributes() {
        CqAttributesFactory factory = new CqAttributesFactory();
        factory.addCqListener(CQUtilPrms.getCQListener());
        CqAttributes cqAttrs = factory.create();
        return cqAttrs;
    }

    private static String getKeyForOperation() {
        Random r = new Random();
        int randint = r.nextInt(PUT_KEY_RANGE);
        long numOfThread = SecurityClientBB.getBB().getSharedCounters().read(SecurityClientBB.threadCount);
        int randint2 = r.nextInt(PUT_KEY_RANGE);
        Integer randthrdId = (Integer)thrId.get();
        if (randthrdId == null) {
            thrId.set(EntryOperations.getUniqueThreadId());
            randthrdId = (Integer)thrId.get();
        }
        String Key3 = "KEY-" + randthrdId + "-" + randint + "-" + randint2;
        return Key3;
    }

    private static synchronized Integer getUniqueThreadId() {
        String thrName = HydraThread.currentThread().getName();
        int startIndex = thrName.indexOf("thr") + 4;
        int endIndex = thrName.indexOf("_", startIndex);
        String thrId = thrName.substring(startIndex, endIndex);
        return new Integer(thrId);
    }

    static {
        operationsMap = new HashMap();
        exceptionMap = new HashMap();
        userOperationMap = new HashMap<String, Map>();
        userExceptionMap = new HashMap<String, Map>();
        cqCounter = new AtomicInteger(0);
        thrId = new ThreadLocal();
    }
}

