/*
 * Decompiled with CFR 0.152.
 */
package security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import security.LdapUserCredentialGenerator;
import security.PKCSCredentialGenerator;

public abstract class CredentialGenerator {
    private Properties sysProps = null;
    protected Properties javaProps = null;

    public static CredentialGenerator create(ClassCode classCode) {
        switch (classCode.classType) {
            case 2: {
                return new LdapUserCredentialGenerator();
            }
            case 3: {
                return new PKCSCredentialGenerator();
            }
        }
        return null;
    }

    public void init() throws IllegalArgumentException {
        this.sysProps = this.initialize();
    }

    protected abstract Properties initialize() throws IllegalArgumentException;

    public Properties getSystemProperties() {
        return this.sysProps;
    }

    public Properties getJavaProperties() {
        return this.javaProps;
    }

    public abstract ClassCode classCode();

    public abstract String getAuthInit();

    public abstract String getAuthenticator();

    public abstract Properties getValidCredentials(int var1);

    public abstract Properties getValidCredentials(Principal var1);

    public abstract Properties getInvalidCredentials(int var1);

    public static final class ClassCode {
        private static final byte ID_DUMMY = 1;
        private static final byte ID_LDAP = 2;
        private static final byte ID_PKCS = 3;
        private static final byte ID_SSL = 4;
        private static byte nextOrdinal = 0;
        private static final ClassCode[] VALUES = new ClassCode[10];
        private static final Map CodeNameMap = new HashMap();
        public static final ClassCode DUMMY = new ClassCode("templates.security.DummyAuthenticator.create", 1);
        public static final ClassCode LDAP = new ClassCode("templates.security.LdapUserAuthenticator.create", 2);
        public static final ClassCode PKCS = new ClassCode("templates.security.PKCSAuthenticator.create", 3);
        public static final ClassCode SSL = new ClassCode("SSL", 4);
        private final String name;
        private final byte ordinal;
        private final byte classType;

        private ClassCode(String name, byte classType) {
            this.name = name;
            this.classType = classType;
            byte by = nextOrdinal;
            nextOrdinal = (byte)(by + 1);
            this.ordinal = by;
            ClassCode.VALUES[this.ordinal] = this;
            CodeNameMap.put(name, this);
        }

        public boolean isDummy() {
            return this.classType == 1;
        }

        public boolean isLDAP() {
            return this.classType == 2;
        }

        public boolean isPKCS() {
            return this.classType == 3;
        }

        public boolean isSSL() {
            return this.classType == 4;
        }

        public static ClassCode fromOrdinal(byte ordinal) {
            return VALUES[ordinal];
        }

        public static ClassCode parse(String operationName) {
            return (ClassCode)CodeNameMap.get(operationName);
        }

        public static List getAll() {
            ArrayList codes = new ArrayList();
            Iterator iter = CodeNameMap.values().iterator();
            while (iter.hasNext()) {
                codes.add(iter.next());
            }
            return codes;
        }

        public byte toOrdinal() {
            return this.ordinal;
        }

        public final String toString() {
            return this.name;
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ClassCode)) {
                return false;
            }
            ClassCode other = (ClassCode)obj;
            return other.ordinal == this.ordinal;
        }

        public final boolean equals(ClassCode opCode) {
            return opCode != null && opCode.ordinal == this.ordinal;
        }

        public final int hashCode() {
            return this.ordinal;
        }
    }
}

