/*
 * Decompiled with CFR 0.152.
 */
package resumeTx;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.partition.PartitionRegionInfo;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.DistributedSystemHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import parReg.ParRegUtil;
import pdx.PdxTestVersionHelper;
import resumeTx.KnownKeysFcn;
import resumeTx.ResumeTxBB;
import resumeTx.ResumeTxPrms;
import resumeTx.RtxUtilVersionHelper;
import util.BaseValueHolder;
import util.KeyIntervals;
import util.NameFactory;
import util.RandomValues;
import util.SummaryLogListener;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.ValueHolder;

public class ResumableKnownKeysTest {
    static ResumableKnownKeysTest testInstance = null;
    private boolean isBridgeConfiguration = false;
    private boolean isBridgeClient = false;
    protected KeyIntervals keyIntervals;
    protected int numNewKeys;
    private static volatile boolean verifyRegionsInProgress = false;
    private static volatile boolean verifyLoadInProgress = false;
    protected static final String txListKey = "txListForVmId_";

    public static synchronized void HydraTask_initializeClient() {
        if (testInstance == null) {
            testInstance = new ResumableKnownKeysTest();
            testInstance.initializeInstance();
            Vector configNames = ResumeTxPrms.getRegionConfigNames();
            testInstance.createRegions(configNames);
            if (ResumableKnownKeysTest.testInstance.isBridgeConfiguration) {
                ResumableKnownKeysTest.testInstance.isBridgeClient = true;
                ResumableKnownKeysTest.registerInterest();
            }
            testInstance.intializeIntervals();
        }
    }

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new ResumableKnownKeysTest();
            testInstance.initializeInstance();
            Vector configNames = ResumeTxPrms.getRegionConfigNames();
            testInstance.createRegions(configNames);
            if (ResumableKnownKeysTest.testInstance.isBridgeConfiguration) {
                ResumableKnownKeysTest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
            ResumableKnownKeysTest.initializeBlackboard();
            testInstance.intializeIntervals();
        }
    }

    public static void HydraTask_loadRegions() {
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            testInstance.loadRegionsWithPut();
        } else {
            testInstance.loadRegionsWithPutAll();
        }
    }

    public static void HydraTask_logRegionSizes() {
        Log.getLogWriter().info(ResumableKnownKeysTest.regionSizesToString());
    }

    public static synchronized void HydraTask_verifyLoad() {
        if (!verifyLoadInProgress) {
            verifyLoadInProgress = true;
            Log.getLogWriter().info("Verifying load for all regions...");
            int numKeysInIntervals = ResumableKnownKeysTest.testInstance.keyIntervals.getNumKeys();
            long nameCounter = NameFactory.getPositiveNameCounter();
            if (nameCounter != (long)numKeysInIntervals) {
                throw new TestException("Expected NameFactory counter " + nameCounter + " to be the same as keyIntervals " + numKeysInIntervals);
            }
            StringBuffer aStr = new StringBuffer();
            for (Region aRegion : CacheHelper.getCache().rootRegions()) {
                int regionSize = aRegion.size();
                if ((long)regionSize == nameCounter) continue;
                aStr.append(aRegion.getFullPath() + " is size " + regionSize + " but expected it to be " + nameCounter + "\n");
                int keyIndex = 1;
                while ((long)keyIndex <= nameCounter) {
                    String key = NameFactory.getObjectNameForCounter(keyIndex);
                    if (!aRegion.containsKey((Object)key)) {
                        aStr.append(aRegion.getFullPath() + " does not contain expected key " + key + "\n");
                    }
                    ++keyIndex;
                }
            }
            if (aStr.length() > 0) {
                throw new TestException(aStr.toString());
            }
            Log.getLogWriter().info("Done verifying load for " + CacheHelper.getCache().rootRegions());
        }
    }

    public static void HydraTask_waitForSilence() {
        SummaryLogListener.waitForSilence(30L, 5000L);
    }

    public static void HydraTask_initFunction() {
        ArrayList<String> aList = new ArrayList<String>();
        aList.add(ResumableKnownKeysTest.getClientIdString());
        aList.add("initialize");
        Execution exe = null;
        exe = ResumableKnownKeysTest.testInstance.isBridgeConfiguration ? FunctionService.onServers((Pool)PoolManager.find((String)"edgePool")).withArgs(aList) : FunctionService.onMembers((DistributedSystem)DistributedSystemHelper.getDistributedSystem()).withArgs(aList);
        ResultCollector rc = exe.execute((Function)new KnownKeysFcn());
        Log.getLogWriter().info("result is " + rc.getResult());
    }

    public static synchronized void HydraTask_verifyRegions() {
        if (!verifyRegionsInProgress) {
            verifyRegionsInProgress = true;
            testInstance.verifyRegions();
        }
    }

    private void initializeInstance() {
        this.isBridgeConfiguration = TestConfig.tab().vecAt(BridgePrms.names, null) != null;
    }

    private static void initializeBlackboard() {
        PartitionRegionInfo info = PartitionRegionHelper.getPartitionRegionInfo((Region)CacheHelper.getCache().getRegion("region1"));
        int numDataStores = info.getPartitionMemberInfo().size();
        ResumeTxBB.getBB().getSharedMap().put(ResumeTxBB.NUM_DATASTORES, numDataStores);
        Log.getLogWriter().info("Num dataStores is " + numDataStores);
    }

    private void intializeIntervals() {
        int numIntervalKeys = ResumeTxPrms.getNumIntervalKeys();
        this.numNewKeys = ResumeTxPrms.getNumNewKeys();
        this.keyIntervals = new KeyIntervals(new int[]{1000, 1001, 1003, 1005, 1006}, numIntervalKeys);
        Log.getLogWriter().info(this.keyIntervals.toString());
        Log.getLogWriter().info("numNewKeys is " + this.numNewKeys);
    }

    private static void registerInterest() {
        for (Region aRegion : CacheHelper.getCache().rootRegions()) {
            ParRegUtil.registerInterest(aRegion);
        }
    }

    private void createRegions(Vector regionConfigNames) {
        CacheHelper.createCache("cache1");
        HydraVector availableNames = TestConfig.tab().vecAt(RegionPrms.names);
        for (String regionConfigName : availableNames) {
            if (!regionConfigNames.contains(regionConfigName)) continue;
            Log.getLogWriter().info("Creating region " + regionConfigName);
            RegionHelper.createRegion(regionConfigName);
        }
    }

    public void loadRegionsWithPutAll() {
        long LOG_INTERVAL_MILLIS = 10000L;
        int numKeysToCreate = this.keyIntervals.getNumKeys();
        long lastLogTime = System.currentTimeMillis();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, -1L);
        long minTaskGranularityMS = -1L;
        if (minTaskGranularitySec != -1L) {
            minTaskGranularityMS = minTaskGranularitySec * 1000L;
        }
        long startTime = System.currentTimeMillis();
        RandomValues rv = new RandomValues();
        HashMap<String, ValueHolder> putAllMap = new HashMap<String, ValueHolder>();
        SharedCounters sc = ResumeTxBB.getBB().getSharedCounters();
        do {
            long loadController;
            if ((loadController = sc.incrementAndRead(ResumeTxBB.loadController)) <= (long)numKeysToCreate) {
                String key = NameFactory.getNextPositiveObjectName();
                ValueHolder value = new ValueHolder(key, rv);
                putAllMap.put(key, value);
                if (putAllMap.size() == 100) {
                    this.putToAllRegions(putAllMap);
                    putAllMap = new HashMap();
                }
            } else {
                if (putAllMap.size() > 0) {
                    this.putToAllRegions(putAllMap);
                }
                String aStr = "In loadRegion, name counter is " + NameFactory.getPositiveNameCounter() + "; done with load";
                Log.getLogWriter().info(aStr);
                throw new StopSchedulingTaskOnClientOrder(aStr);
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("In load, current region sizes: " + ResumableKnownKeysTest.regionSizesToString());
            lastLogTime = System.currentTimeMillis();
        } while (minTaskGranularitySec == -1L || System.currentTimeMillis() - startTime < minTaskGranularityMS);
        if (putAllMap.size() > 0) {
            this.putToAllRegions(putAllMap);
        }
    }

    public void loadRegionsWithPut() {
        long LOG_INTERVAL_MILLIS = 10000L;
        int numKeysToCreate = this.keyIntervals.getNumKeys();
        long lastLogTime = System.currentTimeMillis();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, -1L);
        long minTaskGranularityMS = -1L;
        if (minTaskGranularitySec != -1L) {
            minTaskGranularityMS = minTaskGranularitySec * 1000L;
        }
        long startTime = System.currentTimeMillis();
        RandomValues rv = new RandomValues();
        SharedCounters sc = ResumeTxBB.getBB().getSharedCounters();
        do {
            long loadController;
            if ((loadController = sc.incrementAndRead(ResumeTxBB.loadController)) <= (long)numKeysToCreate) {
                String key = NameFactory.getNextPositiveObjectName();
                ValueHolder value = new ValueHolder(key, rv);
                for (Region aRegion : CacheHelper.getCache().rootRegions()) {
                    aRegion.put((Object)key, (Object)value);
                }
            } else {
                String aStr = "In loadRegion, name counter is " + NameFactory.getPositiveNameCounter() + "; done with load";
                Log.getLogWriter().info(aStr);
                throw new StopSchedulingTaskOnClientOrder(aStr);
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("In load, current region sizes: " + ResumableKnownKeysTest.regionSizesToString());
            lastLogTime = System.currentTimeMillis();
        } while (minTaskGranularitySec == -1L || System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    private static String regionSizesToString() {
        StringBuffer aStr = new StringBuffer();
        for (Region aRegion : CacheHelper.getCache().rootRegions()) {
            aStr.append(aRegion.getFullPath() + " is size " + aRegion.size() + ";");
        }
        return aStr.toString();
    }

    private void putToAllRegions(Map putAllMap) {
        for (Region aRegion : CacheHelper.getCache().rootRegions()) {
            aRegion.putAll(putAllMap);
        }
    }

    private void verifyRegions() {
        int i;
        int numKeys = this.keyIntervals.getNumKeys();
        HashSet<String> expectedKeys = new HashSet<String>();
        for (i = 1; i <= numKeys; ++i) {
            expectedKeys.add(NameFactory.getObjectNameForCounter(i));
        }
        for (i = this.keyIntervals.getFirstKey(1003); i <= this.keyIntervals.getLastKey(1003); ++i) {
            expectedKeys.remove(NameFactory.getObjectNameForCounter(i));
        }
        for (i = this.keyIntervals.getFirstKey(1004); i <= this.keyIntervals.getLastKey(1004); ++i) {
            expectedKeys.remove(NameFactory.getObjectNameForCounter(i));
        }
        for (i = numKeys + 1; i <= numKeys + this.numNewKeys; ++i) {
            expectedKeys.add(NameFactory.getObjectNameForCounter(i));
        }
        for (Region aRegion : CacheHelper.getCache().rootRegions()) {
            this.verifyRegion(aRegion, expectedKeys);
        }
    }

    private void verifyRegion(Region aRegion, Set expectedKeys) {
        Log.getLogWriter().info("Verifying " + aRegion.getFullPath() + " of size " + aRegion.size());
        int logIntervalMs = 10000;
        StringBuffer errStr = new StringBuffer();
        int regionSize = aRegion.size();
        int expectedSize = expectedKeys.size();
        long start = System.currentTimeMillis();
        HashSet regionKeys = new HashSet(aRegion.keySet());
        long duration = System.currentTimeMillis() - start;
        Log.getLogWriter().info(duration + " ms to get regionKeys for " + aRegion.getFullPath());
        start = System.currentTimeMillis();
        HashSet missing = new HashSet(expectedKeys);
        missing.removeAll(regionKeys);
        duration = System.currentTimeMillis() - start;
        Log.getLogWriter().info(duration + " ms to get missing set for " + aRegion.getFullPath());
        start = System.currentTimeMillis();
        HashSet unexpected = new HashSet(regionKeys);
        unexpected.removeAll(expectedKeys);
        duration = System.currentTimeMillis() - start;
        Log.getLogWriter().info(duration + " ms to get unexpected set for " + aRegion.getFullPath());
        if (regionSize != expectedSize) {
            errStr.append("Expected " + aRegion.getFullPath() + " to have size" + expectedSize + " but it is size " + regionSize + "\n");
        }
        if (missing.size() > 0) {
            errStr.append("The following keys were missing in " + aRegion.getFullPath() + ": " + missing + "\n");
        }
        if (unexpected.size() > 0) {
            errStr.append("The following keys were unexpected in " + aRegion.getFullPath() + ": " + unexpected + "\n");
        }
        start = System.currentTimeMillis();
        long lastLogTime = System.currentTimeMillis();
        int lastKeyToCheck = this.keyIntervals.getNumKeys() + this.numNewKeys;
        for (int i = 1; i <= lastKeyToCheck; ++i) {
            String key = NameFactory.getObjectNameForCounter(i);
            try {
                Object value;
                if (i >= this.keyIntervals.getFirstKey(1000) && i <= this.keyIntervals.getLastKey(1000) || i >= this.keyIntervals.getFirstKey(1006) && i <= this.keyIntervals.getLastKey(1006)) {
                    this.checkContainsKey(aRegion, key, true, "key was untouched");
                    this.checkContainsValueForKey(aRegion, key, true, "key was untouched");
                    value = aRegion.get((Object)key);
                    this.checkValue(aRegion, key, value);
                } else if (i >= this.keyIntervals.getFirstKey(1001) && i <= this.keyIntervals.getLastKey(1001)) {
                    this.checkContainsKey(aRegion, key, true, "key was invalidated");
                    this.checkContainsValueForKey(aRegion, key, false, "key was invalidated");
                } else if (i >= this.keyIntervals.getFirstKey(1002) && i <= this.keyIntervals.getLastKey(1002)) {
                    this.checkContainsKey(aRegion, key, true, "key was locally invalidated");
                    this.checkContainsValueForKey(aRegion, key, true, "key was locally invalidated");
                    value = aRegion.get((Object)key);
                    this.checkValue(aRegion, key, value);
                } else if (i >= this.keyIntervals.getFirstKey(1003) && i <= this.keyIntervals.getLastKey(1003)) {
                    this.checkContainsKey(aRegion, key, false, "key was destroyed");
                    this.checkContainsValueForKey(aRegion, key, false, "key was destroyed");
                } else if (i >= this.keyIntervals.getFirstKey(1004) && i <= this.keyIntervals.getLastKey(1004)) {
                    this.checkContainsKey(aRegion, key, true, "key was locally destroyed");
                    this.checkContainsValueForKey(aRegion, key, true, "key was locally destroyed");
                    value = aRegion.get((Object)key);
                    this.checkValue(aRegion, key, value);
                } else if (i >= this.keyIntervals.getFirstKey(1005) && i <= this.keyIntervals.getLastKey(1005)) {
                    this.checkContainsKey(aRegion, key, true, "key was updated");
                    this.checkContainsValueForKey(aRegion, key, true, "key was updated");
                    value = aRegion.get((Object)key);
                    this.checkUpdatedValue(aRegion, key, value);
                } else if (i > this.keyIntervals.getNumKeys()) {
                    this.checkContainsKey(aRegion, key, true, "key was new");
                    this.checkContainsValueForKey(aRegion, key, true, "key was new");
                    value = aRegion.get((Object)key);
                    this.checkValue(aRegion, key, value);
                }
            }
            catch (TestException e) {
                Log.getLogWriter().info(TestHelper.getStackTrace(e));
                errStr.append(e.getMessage() + "\n");
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Verified key " + i + " out of " + lastKeyToCheck + " in " + aRegion.getFullPath());
            lastLogTime = System.currentTimeMillis();
        }
        duration = System.currentTimeMillis() - start;
        Log.getLogWriter().info(duration + " ms to iterate " + aRegion.getFullPath());
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    protected void checkContainsKey(Region aRegion, Object key, boolean expected, String logStr) {
        boolean containsKey = aRegion.containsKey(key);
        if (containsKey != expected) {
            throw new TestException("Expected containsKey(" + key + ") to be " + expected + ", but it was " + containsKey + ": " + logStr);
        }
    }

    protected void checkContainsValueForKey(Region aRegion, Object key, boolean expected, String logStr) {
        boolean containsValue = aRegion.containsValueForKey(key);
        if (containsValue != expected) {
            throw new TestException("Expected containsValueForKey(" + key + ") to be " + expected + ", but it was " + containsValue + ": " + logStr);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkValue(Region aRegion, Object key, Object value) {
        if (!(value instanceof BaseValueHolder)) throw new TestException("For key " + key + ", expected value " + TestHelper.toString(value) + " to be a ValueHolder");
        BaseValueHolder vh = (BaseValueHolder)value;
        long keyCounter = NameFactory.getCounterForName(key);
        if (!(vh.myValue instanceof Long)) throw new TestException("Expected ValueHolder.myValue for key " + key + " to be a Long for " + TestHelper.toString(vh));
        Long aLong = (Long)vh.myValue;
        long longValue = aLong;
        if (keyCounter == longValue) return;
        throw new TestException("Inconsistent ValueHolder.myValue for key " + key + ":" + TestHelper.toString(vh));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkUpdatedValue(Region aRegion, Object key, Object value) {
        Object baseObject = PdxTestVersionHelper.toBaseObject(value);
        if (!(baseObject instanceof BaseValueHolder)) throw new TestException("Expected value " + TestHelper.toString(baseObject) + " to be a ValueHolder");
        BaseValueHolder vh = (BaseValueHolder)baseObject;
        long keyCounter = NameFactory.getCounterForName(key);
        if (!(vh.myValue instanceof String)) throw new TestException("Expected ValueHolder.myValue for key " + key + " to be a String indicating it was updated, but the value for this key is " + TestHelper.toString(vh));
        String aStr = (String)vh.myValue;
        String expectedStr = "updated_" + keyCounter;
        if (aStr.equals(expectedStr)) return;
        throw new TestException("Inconsistent ValueHolder.myValue for key " + key + ":" + TestHelper.toString(vh));
    }

    private static TransactionId getRandomTxId() throws Exception {
        Set<TransactionId> serverTxIds = ResumableKnownKeysTest.getCurrentTransactions();
        if (serverTxIds.size() == 0) {
            return null;
        }
        ArrayList<TransactionId> serverTxIdList = new ArrayList<TransactionId>(serverTxIds);
        int randInt = TestConfig.tab().getRandGen().nextInt(0, serverTxIdList.size() - 1);
        return (TransactionId)serverTxIdList.get(randInt);
    }

    private static Set<TransactionId> getCurrentTransactions() throws Exception {
        HashSet<TransactionId> serverTxIds = new HashSet<TransactionId>();
        Map aMap = ResumeTxBB.getBB().getSharedMap().getMap();
        for (Object key : aMap.keySet()) {
            if (!(key instanceof String) || !((String)key).startsWith(txListKey)) continue;
            serverTxIds.addAll(RtxUtilVersionHelper.convertByteArrayListToTransactionIDList((List)aMap.get(key)));
        }
        return serverTxIds;
    }

    private static String getClientIdString() {
        return "vm_" + RemoteTestModule.getMyVmid() + "_thr_" + RemoteTestModule.getCurrentThread().getThreadId();
    }
}

