/*
 * Decompiled with CFR 0.152.
 */
package resumeTx;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.GsRandom;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import parReg.ParRegUtil;
import resumeTx.ResumeTxBB;
import tx.TxUtil;
import util.NameFactory;
import util.SummaryLogListener;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;

public class ConcResumableTxTest {
    static ConcResumableTxTest testInstance = null;
    private boolean isBridgeConfiguration;
    private boolean isBridgeClient;
    private TxUtil txUtilInstance = new TxUtil();
    private int numVMsInTest = 0;
    private List<TransactionId> txIdList = null;
    private List<TransactionId> resumed = null;
    private List<Integer> resumeCount = null;
    private List<Set> txKeySetList = null;
    private static final int REGION_SIZE = 100;
    private static final int NUM_OPS = 10;
    private static final int MIN_RESUME_COUNT = 50;
    private static final int MAX_RESUME_COUNT = 100;
    private static final String snapshotKey = "snapshot";

    public static synchronized void HydraTask_initializeClient() {
        if (testInstance == null) {
            testInstance = new ConcResumableTxTest();
            testInstance.initializeInstance();
            testInstance.createRegions(true);
            if (ConcResumableTxTest.testInstance.isBridgeConfiguration) {
                ConcResumableTxTest.testInstance.isBridgeClient = true;
                ConcResumableTxTest.registerInterest();
            }
        }
    }

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new ConcResumableTxTest();
            testInstance.initializeInstance();
            testInstance.createRegions(false);
            if (ConcResumableTxTest.testInstance.isBridgeConfiguration) {
                ConcResumableTxTest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
        }
    }

    public static void HydraTask_concSuspendResumeTx() {
        testInstance.concSuspendResumeTx();
    }

    public static synchronized void HydraTask_beginTxns() {
        if (ConcResumableTxTest.testInstance.txIdList == null) {
            int i;
            ConcResumableTxTest.testInstance.txIdList = Collections.synchronizedList(new ArrayList());
            ConcResumableTxTest.testInstance.resumed = Collections.synchronizedList(new ArrayList());
            ConcResumableTxTest.testInstance.resumeCount = Collections.synchronizedList(new ArrayList());
            ConcResumableTxTest.testInstance.txKeySetList = Collections.synchronizedList(new ArrayList());
            CacheTransactionManager ctm = CacheHelper.getCache().getCacheTransactionManager();
            int NUM_TXNS = 10;
            for (i = 1; i <= NUM_TXNS; ++i) {
                TxHelper.begin();
                TransactionId beginId = CacheHelper.getCache().getCacheTransactionManager().getTransactionId();
                ResumeTxBB.getBB().getSharedCounters().increment(ResumeTxBB.numBegins);
                if (!ctm.exists()) {
                    throw new TestException("Began " + beginId + " but exists() returned false");
                }
                TransactionId suspendId = TxHelper.suspend();
                Log.getLogWriter().info("Suspended " + suspendId);
                if (!beginId.equals(suspendId)) {
                    throw new TestException("beginId " + beginId + " does not equal suspendId " + suspendId);
                }
                ConcResumableTxTest.testInstance.txIdList.add(suspendId);
                if (!ctm.exists()) continue;
                throw new TestException("Suspended " + beginId + " but exists() returned true");
            }
            for (i = 0; i < ConcResumableTxTest.testInstance.txIdList.size(); ++i) {
                ConcResumableTxTest.testInstance.resumed.add(null);
                ConcResumableTxTest.testInstance.resumeCount.add(0);
                ConcResumableTxTest.testInstance.txKeySetList.add(new HashSet());
            }
        }
    }

    public static void HydraTask_populateRegions() {
        for (Region aRegion : CacheHelper.getCache().rootRegions()) {
            while (aRegion.size() < 100) {
                String key = NameFactory.getNextPositiveObjectName();
                Long value = NameFactory.getCounterForName(key);
                aRegion.put((Object)key, (Object)value);
            }
        }
        ConcResumableTxTest.logRegionSizes();
    }

    public static void HydraTask_checkCounters() {
        ConcResumableTxTest.logRegionSizes();
        SharedCounters sc = ResumeTxBB.getBB().getSharedCounters();
        long numBegins = sc.read(ResumeTxBB.numBegins);
        long numCompletedTxns = sc.read(ResumeTxBB.numCompletedTxns);
        long numCommits = sc.read(ResumeTxBB.numCommits);
        long numFailedCommits = sc.read(ResumeTxBB.numFailedCommits);
        long numSuccessfulCommits = sc.read(ResumeTxBB.numSuccessfulCommits);
        long numRollbacks = sc.read(ResumeTxBB.numRollbacks);
        long numResumes = sc.read(ResumeTxBB.numResumes);
        long numResumesAtCompletion = sc.read(ResumeTxBB.numResumesAtCompletion);
        long numFailedTries = sc.read(ResumeTxBB.numFailedTries);
        double avgResumesPerTx = (double)numResumesAtCompletion / (double)numCompletedTxns;
        StringBuffer aStr = new StringBuffer();
        aStr.append("numBegins: " + numBegins + "\nnumCompletedTxns: " + numCompletedTxns + "\nnumCommits: " + numCommits + "\nnumFailedCommits: " + numFailedCommits + "\nnumSuccessfulCommits: " + numSuccessfulCommits + "\nnumRollbacks: " + numRollbacks + "\nnumResumes: " + numResumes + "\nnumResumesAtCompletion: " + numResumesAtCompletion + "\nnumFailedTries: " + numFailedTries + "\naverage resumes per tx: " + avgResumesPerTx);
        Log.getLogWriter().info(aStr.toString());
        long total = numCommits + numRollbacks;
        if (total != numBegins) {
            throw new TestException("numCommits " + numCommits + " + numRollbacks " + numRollbacks + " should be numBegins " + numBegins + " but it is " + total);
        }
        if (numBegins != numCompletedTxns) {
            throw new TestException("numBegins " + numBegins + " should be equal to numCompletedTxns " + numCompletedTxns);
        }
        if (numCompletedTxns == 0L) {
            throw new TestException("Test did not complete any transactions");
        }
    }

    public static void HydraTask_completeTxns() {
        CacheTransactionManager ctm = CacheHelper.getCache().getCacheTransactionManager();
        SharedCounters sc = ResumeTxBB.getBB().getSharedCounters();
        for (int txIdIndex = 0; txIdIndex < ConcResumableTxTest.testInstance.txIdList.size(); ++txIdIndex) {
            TransactionId txId = ConcResumableTxTest.testInstance.txIdList.get(txIdIndex);
            boolean result = ctm.tryResume(txId);
            if (!result) continue;
            try {
                TxHelper.commit();
                sc.increment(ResumeTxBB.numSuccessfulCommits);
            }
            catch (CommitConflictException e) {
                sc.increment(ResumeTxBB.numFailedCommits);
            }
            sc.increment(ResumeTxBB.numCommits);
            sc.increment(ResumeTxBB.numCompletedTxns);
            sc.add(ResumeTxBB.numResumesAtCompletion, ConcResumableTxTest.testInstance.resumeCount.get(txIdIndex) + 1);
        }
        for (TransactionId txId : ConcResumableTxTest.testInstance.txIdList) {
            if (!ctm.isSuspended(txId)) continue;
            throw new TestException("After completing all transactions, " + txId + " is suspended");
        }
    }

    public static void HydraTask_takeSnapshot() {
        HashMap masterMap = new HashMap();
        for (Region aRegion : CacheHelper.getCache().rootRegions()) {
            HashMap snapshot = new HashMap();
            for (Object key : aRegion.keySet()) {
                snapshot.put(key, aRegion.get(key));
            }
            masterMap.put(aRegion.getFullPath(), snapshot);
            Log.getLogWriter().info("Created snapshot for " + aRegion.getFullPath() + " of size " + snapshot.size());
        }
        ResumeTxBB.getBB().getSharedMap().put(snapshotKey, masterMap);
        Log.getLogWriter().info("Snapshots for " + masterMap.keySet() + " have been written to the blackboard");
    }

    public static void HydraTask_verifyFromSnapshot() {
        Map masterMap = (Map)ResumeTxBB.getBB().getSharedMap().get(snapshotKey);
        for (String regionName : masterMap.keySet()) {
            Region aRegion = CacheHelper.getCache().getRegion(regionName);
            if (aRegion == null) {
                throw new TestException("Could not get region with name " + regionName);
            }
            ConcResumableTxTest.verifyFromSnapshot(aRegion, (Map)masterMap.get(regionName));
        }
    }

    public static void HydraTask_waitForSilence() {
        SummaryLogListener.waitForSilence(30L, 5000L);
    }

    private static void verifyFromSnapshot(Region aRegion, Map expectedMap) {
        Log.getLogWriter().info("Verifying " + aRegion.getFullPath() + " against snapshot of size " + expectedMap.size());
        StringBuffer aStr = new StringBuffer();
        int regionSize = aRegion.size();
        int expectedSize = expectedMap.size();
        if (regionSize != expectedSize) {
            aStr.append(aRegion.getFullPath() + " size is " + regionSize + " but expected it to be " + expectedSize + "\n");
        }
        HashSet expectedKeys = new HashSet(expectedMap.keySet());
        HashSet actualKeys = new HashSet(aRegion.keySet());
        HashSet missingKeys = new HashSet(expectedKeys);
        missingKeys.removeAll(actualKeys);
        HashSet extraKeys = new HashSet(actualKeys);
        extraKeys.removeAll(expectedKeys);
        if (missingKeys.size() > 0) {
            aStr.append("The following " + missingKeys.size() + " expected keys were missing from " + aRegion.getFullPath() + ": " + missingKeys + "\n");
        }
        if (extraKeys.size() > 0) {
            aStr.append("The following " + extraKeys.size() + " extra keys were found in " + aRegion.getFullPath() + ": " + extraKeys + "\n");
        }
        for (Object key : aRegion.keySet()) {
            Object value = aRegion.get(key);
            if (!expectedMap.containsKey(key)) continue;
            Object expectedValue = expectedMap.get(key);
            if (value == null || expectedValue == null) {
                aStr.append("For key " + key + ", expectedValue is " + expectedValue + " and value in region is " + value + ", but did not expect null values\n");
                continue;
            }
            if (value.equals(expectedValue)) continue;
            aStr.append("Expected value for key " + key + " to be " + expectedValue + " but it is " + value + "\n");
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
    }

    private static void logRegionSizes() {
        for (Region aRegion : CacheHelper.getCache().rootRegions()) {
            Log.getLogWriter().info("Region " + aRegion.getFullPath() + " is size " + aRegion.size());
        }
    }

    private void initializeInstance() {
        this.isBridgeConfiguration = TestConfig.tab().vecAt(BridgePrms.names, null) != null;
        this.numVMsInTest = TestHelper.getNumVMs();
    }

    private void createRegions(boolean edgeRegions) {
        CacheHelper.createCache("cache1");
        HydraVector aVec = TestConfig.tab().vecAt(RegionPrms.names);
        for (String regionConfigName : aVec) {
            if (regionConfigName.startsWith("edge") != edgeRegions) continue;
            Log.getLogWriter().info("Creating region " + regionConfigName);
            RegionHelper.createRegion(regionConfigName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void concSuspendResumeTx() {
        Cache theCache = CacheHelper.getCache();
        CacheTransactionManager ctm = theCache.getCacheTransactionManager();
        ArrayList<Region> regions = new ArrayList<Region>(theCache.rootRegions());
        GsRandom rand = TestConfig.tab().getRandGen();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, 60L);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        SharedCounters sc = ResumeTxBB.getBB().getSharedCounters();
        do {
            int txIdIndex;
            TransactionId txId;
            boolean successfulResume;
            if (successfulResume = ctm.tryResume(txId = this.txIdList.get(txIdIndex = rand.nextInt(0, this.txIdList.size() - 1)))) {
                Log.getLogWriter().info("Successfully resumed " + txId);
                TransactionId currentlyResumed = this.resumed.get(txIdIndex);
                if (currentlyResumed != null) {
                    throw new TestException("Test was able to resume txId " + txId + ", but it was already resumed by " + currentlyResumed);
                }
                if (ctm.isSuspended(txId)) {
                    throw new TestException("Just resumed tx " + txId + ", but isSuspended returned true");
                }
                if (!ctm.exists()) {
                    throw new TestException("Just resumed tx " + txId + ", but exists() returned false");
                }
                sc.increment(ResumeTxBB.numResumes);
                int count = this.resumeCount.get(txIdIndex) + 1;
                this.resumeCount.set(txIdIndex, count);
                Log.getLogWriter().info(txId + " has been resumed " + count + " times");
                Log.getLogWriter().info("Putting into regions after resuming " + txId);
                this.doOpsInRandomRegions(regions, rand, true);
                this.resumed.set(txIdIndex, null);
                int desiredResumeCount = rand.nextInt(50, 100);
                Log.getLogWriter().info("Desired resume count is " + desiredResumeCount + " actual resume count is " + count);
                if (count < desiredResumeCount) {
                    TxHelper.suspend();
                    continue;
                }
                int randInt = rand.nextInt(1, 100);
                if (randInt <= 75) {
                    try {
                        TxHelper.commit();
                        sc.increment(ResumeTxBB.numSuccessfulCommits);
                    }
                    catch (CommitConflictException e) {
                        sc.increment(ResumeTxBB.numFailedCommits);
                    }
                    sc.increment(ResumeTxBB.numCommits);
                } else {
                    TxHelper.rollback();
                    sc.increment(ResumeTxBB.numRollbacks);
                }
                sc.increment(ResumeTxBB.numCompletedTxns);
                MasterController.sleepForMs(5000);
                TxHelper.begin();
                sc.increment(ResumeTxBB.numBegins);
                sc.add(ResumeTxBB.numResumesAtCompletion, count);
                Log.getLogWriter().info("Successfully began new transaction " + ctm.getTransactionId());
                this.resumeCount.set(txIdIndex, 0);
                List<Set> list = this.txKeySetList;
                synchronized (list) {
                    this.txKeySetList.set(txIdIndex, new HashSet());
                    this.txIdList.set(txIdIndex, ctm.suspend());
                }
            }
            Log.getLogWriter().info("tryResume returned false, this thread was unable to resume " + txId);
            sc.increment(ResumeTxBB.numFailedTries);
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
        ConcResumableTxTest.logRegionSizes();
    }

    private void doOpsInRandomRegions(List<Region> regions, GsRandom rand, boolean useLocalKeys) {
        Log.getLogWriter().info("Doing 10 operations with useLocalKeys " + useLocalKeys);
        TransactionId txId = CacheHelper.getCache().getCacheTransactionManager().getTransactionId();
        for (int j = 1; j <= 10; ++j) {
            Long value;
            Object key;
            Region aRegion = regions.get(rand.nextInt(0, regions.size() - 1));
            if (aRegion.size() >= 100) {
                key = this.getExistingKey((Region<Object, Object>)aRegion, useLocalKeys);
                if (key == null) continue;
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    value = ResumeTxBB.getBB().getSharedCounters().incrementAndRead(ResumeTxBB.valueCounter);
                    Log.getLogWriter().info("Operation for key " + key + ", updating in region " + aRegion.getFullPath() + ", transactionID " + txId + ", value is " + TestHelper.toString(value));
                    aRegion.put(key, (Object)value);
                    continue;
                }
                Log.getLogWriter().info("Operation for key " + key + ", destroying in region " + aRegion.getFullPath() + ", transactionID " + txId);
                try {
                    aRegion.destroy(key);
                }
                catch (EntryNotFoundException e) {
                    if (txId != null) {
                        throw e;
                    }
                    Log.getLogWriter().info("Caught expected " + (Object)((Object)e) + " while outside a tx");
                }
                continue;
            }
            key = this.getNewKey((Region<Object, Object>)aRegion, useLocalKeys);
            value = ResumeTxBB.getBB().getSharedCounters().incrementAndRead(ResumeTxBB.valueCounter);
            Log.getLogWriter().info("Operation for key " + key + ", creating new entry in region " + aRegion.getFullPath() + ", transactionId " + txId + ", value is " + TestHelper.toString(value));
            aRegion.put(key, (Object)value);
        }
    }

    private void doNewKeyPutsInRandomRegions(List<Region> regions, GsRandom rand, boolean useLocalKeys) {
        Log.getLogWriter().info("Doing 10 new key puts with useLocalKeys " + useLocalKeys);
        TransactionId txId = CacheHelper.getCache().getCacheTransactionManager().getTransactionId();
        for (int j = 1; j <= 10; ++j) {
            Region aRegion = regions.get(rand.nextInt(0, regions.size() - 1));
            String key = (String)this.getNewKey((Region<Object, Object>)aRegion, useLocalKeys);
            Long value = ResumeTxBB.getBB().getSharedCounters().incrementAndRead(ResumeTxBB.valueCounter);
            Log.getLogWriter().info("Operation for key " + key + ", creating new entry in region " + aRegion.getFullPath() + ", transactionId " + txId + ", value is " + TestHelper.toString(value));
            aRegion.put((Object)key, (Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getNewKey(Region<Object, Object> aRegion, boolean useLocalKeys) {
        Object key;
        TransactionId txId = CacheHelper.getCache().getCacheTransactionManager().getTransactionId();
        if (useLocalKeys) {
            List<Set> list = this.txKeySetList;
            synchronized (list) {
                key = this.txUtilInstance.getNewKey(aRegion);
                int index = this.txIdList.indexOf(txId);
                this.txKeySetList.get(index).add(key);
            }
        } else {
            key = NameFactory.getNextPositiveObjectName();
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getExistingKey(Region<Object, Object> aRegion, boolean useLocalKeys) {
        CacheTransactionManager ctm = CacheHelper.getCache().getCacheTransactionManager();
        TransactionId txId = ctm.getTransactionId();
        Set aSet = null;
        if (useLocalKeys) {
            aSet = PartitionRegionHelper.isPartitionedRegion(aRegion) ? PartitionRegionHelper.getLocalPrimaryData(aRegion).keySet() : new HashSet(aRegion.keySet());
        } else {
            aSet = new HashSet(aRegion.keySet());
            try {
                return aSet.iterator().next();
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
        List<Set> list = this.txKeySetList;
        synchronized (list) {
            int myVmId = RemoteTestModule.getMyVmid();
            HashSet masterSet = new HashSet();
            int index = this.txIdList.indexOf(txId);
            for (int i = 0; i < this.txKeySetList.size(); ++i) {
                if (i == index) continue;
                masterSet.addAll(this.txKeySetList.get(i));
            }
            for (Object key : aSet) {
                long keyIndex;
                if (masterSet.contains(key) || (keyIndex = NameFactory.getCounterForName(key)) % (long)this.numVMsInTest != (long)myVmId) continue;
                this.txKeySetList.get(index).add(key);
                return key;
            }
        }
        return null;
    }

    private static void registerInterest() {
        for (Region aRegion : CacheHelper.getCache().rootRegions()) {
            ParRegUtil.registerInterest(aRegion);
        }
    }
}

