/*
 * Decompiled with CFR 0.152.
 */
package rebalance;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.partition.PartitionMemberInfo;
import com.gemstone.gemfire.cache.partition.PartitionRebalanceInfo;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.partition.PartitionRegionInfo;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import hydra.CacheHelper;
import hydra.DistributedSystemHelper;
import hydra.GsRandom;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parReg.ParRegPrms;
import parReg.ParRegUtil;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;
import rebalance.PartitionState;
import rebalance.RebalanceBB;
import rebalance.RebalancePrms;
import recovDelay.BucketState;
import util.TestException;
import util.TestHelper;

public class RebalanceUtil {
    private static GsRandom rand = TestConfig.tab().getRandGen();
    protected static ParRegUtil parRegUtilInstance = new ParRegUtil();

    public static void primariesBalanced() {
        Cache myCache = CacheHelper.getCache();
        if (myCache == null) {
            throw new TestException("primariesRebalanced() expects hydra client to have created cache and PR via initialization tasks");
        }
        RebalanceUtil.waitForRecovery();
        ResourceManager rm = myCache.getResourceManager();
        RebalanceFactory factory = rm.createRebalanceFactory();
        Set prdSet = PartitionRegionHelper.getPartitionRegionInfo((Cache)myCache);
        for (PartitionRegionInfo prd : prdSet) {
            Log.getLogWriter().info(RebalanceUtil.partitionedRegionDetailsToString(prd));
        }
        StringBuffer aStr = new StringBuffer();
        for (PartitionRegionInfo prd : prdSet) {
            String balanceDetails = RebalanceUtil.primariesBalanced(prd);
            aStr.append("Primaries for region " + RebalanceUtil.getRegionName(prd) + " are balanced \n" + balanceDetails);
        }
        Log.getLogWriter().info("Primaries are balanced \n" + aStr.toString());
    }

    public static void waitForRecovery() {
        if (ParRegPrms.getResourceObserver() == null && RebalancePrms.getResourceObserver() == null) {
            return;
        }
        int numRegions = RebalancePrms.getNumRegions();
        Log.getLogWriter().info("Waiting for recovery of " + numRegions + " regions");
        SharedCounters counters = RebalanceBB.getBB().getSharedCounters();
        long recoveryRegionCount = counters.read(RebalanceBB.recoveryRegionCount);
        do {
            MasterController.sleepForMs(5000);
            recoveryRegionCount = counters.read(RebalanceBB.recoveryRegionCount);
            Log.getLogWriter().info("recoveryRegionCount = " + recoveryRegionCount);
        } while (recoveryRegionCount < (long)numRegions);
        Log.getLogWriter().info(recoveryRegionCount + " regions have been recovered");
    }

    protected static String primariesBalanced(PartitionRegionInfo prd) {
        String regionName = RebalanceUtil.getRegionName(prd);
        StringBuffer aStr = new StringBuffer();
        aStr.append("For region named " + regionName + "\n");
        Set pmdSet = prd.getPartitionMemberInfo();
        double primaries = 0.0;
        int bucketCount = 0;
        for (PartitionMemberInfo pmd : pmdSet) {
            primaries += (double)pmd.getPrimaryCount();
            bucketCount = pmd.getBucketCount();
            aStr.append("   member (" + pmd.getDistributedMember() + "): number of primaries = " + pmd.getPrimaryCount() + "\n");
        }
        double average = primaries / (double)pmdSet.size();
        double allowableDifference = average / 10.0 * 2.0;
        for (PartitionMemberInfo pmd : pmdSet) {
            double difference = Math.abs((double)pmd.getPrimaryCount() - average);
            if (pmd.getPrimaryCount() == 0) {
                throw new TestException(aStr.toString() + "For region " + regionName + " and member " + pmd.getDistributedMember() + " primaryCount is 0!");
            }
            if (!(difference > allowableDifference)) continue;
            throw new TestException(aStr.toString() + "For region " + regionName + " and member " + pmd.getDistributedMember() + " difference (" + difference + ") between the primaryCount (" + pmd.getPrimaryCount() + ") and the average number of primaries (" + average + ") is greater than expected (" + allowableDifference + ")");
        }
        return aStr.toString();
    }

    public static void isBalanceImproved(RebalanceResults results, boolean stableSystem) {
        Set prdSet = results.getPartitionRebalanceDetails();
        for (PartitionRebalanceInfo prd : prdSet) {
            String regionName = RebalanceUtil.getRegionName(prd);
            Set before = prd.getPartitionMemberDetailsBefore();
            Set after = prd.getPartitionMemberDetailsAfter();
            try {
                RebalanceUtil.isBalanceImproved(regionName, before, after);
            }
            catch (TestException e) {
                throw new TestException(e.getMessage() + "\n\n" + RebalanceUtil.RebalanceResultsToString(results, "rebalance"));
            }
        }
        RebalanceUtil.checkRebalancingActivity(results);
        if (stableSystem) {
            RebalanceUtil.checkResultsWithRegion(prdSet);
        }
    }

    public static void isBalanceImproved(RebalanceResults results) {
        RebalanceUtil.isBalanceImproved(results, true);
    }

    public static void isBalanceImproved(String regionName, Set<PartitionMemberInfo> before, Set<PartitionMemberInfo> after) {
        double heapUtilBefore = RebalanceUtil.getHeapUtilizationStdDev(before);
        double heapUtilAfter = RebalanceUtil.getHeapUtilizationStdDev(after);
        if (heapUtilAfter > heapUtilBefore) {
            throw new TestException("For region " + regionName + " the standard deviation of HeapUtilization increased during rebalance from " + heapUtilBefore + " to " + heapUtilAfter);
        }
        PartitionState psBefore = new PartitionState(before);
        PartitionState psAfter = new PartitionState(after);
        RebalanceUtil.isBalanceImproved(regionName, psBefore, psAfter);
    }

    private static void isBalanceImproved(String regionName, PartitionState before, PartitionState after) {
        if (!after.isRedundancySatisfied()) {
            Log.getLogWriter().warning("For region " + regionName + " redundancy has not been satisfied\n");
        }
        if (!after.isLocalMaxMemoryHonored()) {
            Log.getLogWriter().warning("For region " + regionName + " localMaxMemory has not been honored\n");
        }
    }

    public static boolean isLocalMaxMemoryHonored(Set<PartitionMemberInfo> pmd) {
        boolean honored = true;
        for (PartitionMemberInfo memberDetails : pmd) {
            if (memberDetails.getSize() <= memberDetails.getConfiguredMaxMemory()) continue;
            honored = false;
            break;
        }
        return honored;
    }

    public static boolean isRedundancySatisfied(PartitionRegionInfo prd) {
        boolean satisfied = true;
        if (prd.getActualRedundantCopies() < prd.getConfiguredRedundantCopies()) {
            satisfied = false;
        }
        if (prd.getLowRedundancyBucketCount() > 0) {
            satisfied = false;
        }
        return satisfied;
    }

    public static double getAverageHeapUtilization(Set<PartitionMemberInfo> pmd) {
        double heapUtilization = 0.0;
        if (pmd.isEmpty()) {
            return 0.0;
        }
        for (PartitionMemberInfo memberDetails : pmd) {
            long localMaxMemory = memberDetails.getConfiguredMaxMemory();
            long size = memberDetails.getSize();
            double inUse = (double)size / (double)localMaxMemory;
            heapUtilization += inUse * 100.0;
        }
        Log.getLogWriter().fine("Average heapUtilization = " + heapUtilization / (double)pmd.size());
        return heapUtilization / (double)pmd.size();
    }

    public static double getAverageBucketCount(Set<PartitionMemberInfo> pmd) {
        int bucketCount = 0;
        if (pmd.isEmpty()) {
            return 0.0;
        }
        for (PartitionMemberInfo memberDetails : pmd) {
            bucketCount += memberDetails.getBucketCount();
        }
        Log.getLogWriter().fine("Average bucketCount = " + (double)bucketCount / (double)pmd.size());
        return (double)bucketCount / (double)pmd.size();
    }

    public static double getAveragePrimaryCount(Set<PartitionMemberInfo> pmd) {
        int primaryCount = 0;
        if (pmd.isEmpty()) {
            return 0.0;
        }
        for (PartitionMemberInfo memberDetails : pmd) {
            primaryCount += memberDetails.getPrimaryCount();
        }
        Log.getLogWriter().fine("Average primaryCount = " + (double)primaryCount / (double)pmd.size());
        return (double)primaryCount / (double)pmd.size();
    }

    public static double getHeapUtilizationStdDev(Set<PartitionMemberInfo> pmdSet) {
        double dev;
        StringBuffer aStr = new StringBuffer();
        double average = RebalanceUtil.getAverageHeapUtilization(pmdSet);
        aStr.append("average = " + average + "\n");
        double total = 0.0;
        for (PartitionMemberInfo pmd : pmdSet) {
            long localMaxMemory = pmd.getConfiguredMaxMemory();
            long size = pmd.getSize();
            double heapUtilization = (double)size / (double)localMaxMemory;
            dev = heapUtilization * 100.0 - average;
            aStr.append(" maxMem = " + localMaxMemory + ", size = " + size + ", heapUtil = " + heapUtilization * 100.0 + ", dev = " + dev + ", subTotal = " + (total += Math.pow(dev, 2.0)) + "\n");
        }
        double variance = total / (double)(pmdSet.size() - 1);
        dev = Math.sqrt(variance);
        Log.getLogWriter().fine(aStr.toString() + "total = " + total + ", variance = " + variance + ", heapStdDev = " + dev);
        return dev;
    }

    public static double getPrimaryCountStdDev(Set<PartitionMemberInfo> pmdSet) {
        double dev;
        StringBuffer aStr = new StringBuffer();
        double average = RebalanceUtil.getAveragePrimaryCount(pmdSet);
        aStr.append("average = " + average + "\n");
        double total = 0.0;
        for (PartitionMemberInfo pmd : pmdSet) {
            long count = pmd.getPrimaryCount();
            dev = (double)count - average;
            aStr.append("  count = " + count + ", dev = " + dev + ", subTotal = " + (total += Math.pow(dev, 2.0)) + "\n");
        }
        double variance = total / (double)(pmdSet.size() - 1);
        dev = Math.sqrt(variance);
        Log.getLogWriter().fine(aStr.toString() + "total = " + total + ", variance = " + variance + ", primaryCountStdDev = " + dev);
        return dev;
    }

    public static void HydraTask_displayStats() {
        Cache myCache = CacheHelper.getCache();
        if (myCache == null) {
            throw new TestException("displayStats() expects hydra client to have created cache and PR via initialization tasks");
        }
        ResourceManager rm = myCache.getResourceManager();
        RebalanceFactory factory = rm.createRebalanceFactory();
        Set prdSet = PartitionRegionHelper.getPartitionRegionInfo((Cache)myCache);
        String regionName = null;
        for (PartitionRegionInfo prd : prdSet) {
            regionName = RebalanceUtil.getRegionName(prd);
            long entries = RebalanceUtil.getPRLocalSize(regionName);
            Log.getLogWriter().info("entries in PartitionedRegion(" + regionName + ") = " + entries);
        }
    }

    protected static long getPRLocalSize(String regionName) {
        Cache myCache = CacheHelper.getCache();
        if (myCache == null) {
            throw new TestException("getPRLocalSize() expects hydra client to have created cache and PR via initialization tasks");
        }
        Region aRegion = myCache.getRegion(regionName);
        long entries = ((PartitionedRegion)aRegion).getLocalSize();
        return entries;
    }

    public static synchronized void HydraTask_logLocalSize() {
        Cache myCache = CacheHelper.getCache();
        Set rootRegions = myCache.rootRegions();
        for (Region aRegion : rootRegions) {
            if (!(aRegion instanceof PartitionedRegion)) continue;
            Log.getLogWriter().info("Number of entries in this dataStore for region" + aRegion.getName() + " : " + ParRegUtil.getLocalSize(aRegion));
        }
    }

    public static void HydraTask_verifyPRMetaData() {
        Cache myCache = CacheHelper.getCache();
        Set rootRegions = myCache.rootRegions();
        for (Region aRegion : rootRegions) {
            if (!(aRegion instanceof PartitionedRegion)) continue;
            try {
                ParRegUtil.verifyPRMetaData(aRegion);
            }
            catch (Exception e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
    }

    public static void HydraTask_verifyPrimaries() {
        Cache myCache = CacheHelper.getCache();
        Set rootRegions = myCache.rootRegions();
        boolean highAvailability = TestConfig.tab().booleanAt(ParRegPrms.highAvailability, false);
        for (Region aRegion : rootRegions) {
            if (!(aRegion instanceof PartitionedRegion)) continue;
            try {
                RegionAttributes attr = aRegion.getAttributes();
                PartitionAttributes prAttr = attr.getPartitionAttributes();
                int redundantCopies = 0;
                if (prAttr != null) {
                    redundantCopies = prAttr.getRedundantCopies();
                }
                if (highAvailability) {
                    ParRegUtil.verifyPrimariesWithWait(aRegion, redundantCopies);
                    continue;
                }
                ParRegUtil.verifyPrimaries(aRegion, redundantCopies);
            }
            catch (Exception e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
    }

    public static void HydraTask_verifyBucketCopiesBatched() {
        Cache myCache = CacheHelper.getCache();
        Set rootRegions = myCache.rootRegions();
        for (Region aRegion : rootRegions) {
            if (!(aRegion instanceof PartitionedRegion)) continue;
            try {
                RegionAttributes attr = aRegion.getAttributes();
                PartitionAttributes prAttr = attr.getPartitionAttributes();
                int redundantCopies = 0;
                if (prAttr != null) {
                    redundantCopies = prAttr.getRedundantCopies();
                }
                parRegUtilInstance.verifyBucketCopiesBatched(aRegion, redundantCopies);
            }
            catch (TestException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
    }

    public static String RebalanceResultsToString(RebalanceResults results, String title) {
        if (results == null) {
            return "null";
        }
        StringBuffer aStr = new StringBuffer();
        aStr.append("Rebalance results (" + title + ") totalTime: " + results.getTotalTime() + "\n");
        aStr.append("totalBucketCreatesCompleted: " + results.getTotalBucketCreatesCompleted());
        aStr.append(" totalBucketCreateBytes: " + results.getTotalBucketCreateBytes());
        aStr.append(" totalBucketCreateTime: " + results.getTotalBucketCreateTime() + "\n");
        aStr.append("totalBucketTransfersCompleted: " + results.getTotalBucketTransfersCompleted());
        aStr.append(" totalBucketTransferBytes: " + results.getTotalBucketTransferBytes());
        aStr.append(" totalBucketTransferTime: " + results.getTotalBucketTransferTime() + "\n");
        aStr.append("totalPrimaryTransfersCompleted: " + results.getTotalPrimaryTransfersCompleted());
        aStr.append(" totalPrimaryTransferTime: " + results.getTotalPrimaryTransferTime() + "\n");
        Set prdSet = results.getPartitionRebalanceDetails();
        for (PartitionRebalanceInfo prd : prdSet) {
            aStr.append(RebalanceUtil.partitionRebalanceDetailsToString(prd));
        }
        aStr.append("total time (ms): " + results.getTotalTime());
        return aStr.toString();
    }

    public static String partitionRebalanceDetailsToString(PartitionRebalanceInfo details) {
        if (details == null) {
            return "null\n";
        }
        StringBuffer aStr = new StringBuffer();
        aStr.append("PartitionedRegionDetails for region named " + RebalanceUtil.getRegionName(details) + " time: " + details.getTime() + "\n");
        aStr.append("bucketCreatesCompleted: " + details.getBucketCreatesCompleted());
        aStr.append(" bucketCreateBytes: " + details.getBucketCreateBytes());
        aStr.append(" bucketCreateTime: " + details.getBucketCreateTime() + "\n");
        aStr.append("bucketTransfersCompleted: " + details.getBucketTransfersCompleted());
        aStr.append(" bucketTransferBytes: " + details.getBucketTransferBytes());
        aStr.append(" bucketTransferTime: " + details.getBucketTransferTime() + "\n");
        aStr.append("PrimaryTransfersCompleted: " + details.getPrimaryTransfersCompleted());
        aStr.append(" PrimaryTransferTime: " + details.getPrimaryTransferTime() + "\n");
        aStr.append("PartitionedMemberDetails (before)\n");
        Set pmdSet = details.getPartitionMemberDetailsBefore();
        for (PartitionMemberInfo pmd : pmdSet) {
            aStr.append(RebalanceUtil.partitionMemberDetailsToString(pmd));
        }
        aStr.append("PartitionedMemberDetails (after)\n");
        pmdSet = details.getPartitionMemberDetailsAfter();
        for (PartitionMemberInfo pmd : pmdSet) {
            aStr.append(RebalanceUtil.partitionMemberDetailsToString(pmd));
        }
        return aStr.toString();
    }

    public static String partitionedRegionDetailsToString(PartitionRegionInfo prd) {
        if (prd == null) {
            return "null\n";
        }
        StringBuffer aStr = new StringBuffer();
        aStr.append("PartitionedRegionDetails for region named " + RebalanceUtil.getRegionName(prd) + "\n");
        aStr.append("  configuredBucketCount: " + prd.getConfiguredBucketCount() + "\n");
        aStr.append("  createdBucketCount: " + prd.getCreatedBucketCount() + "\n");
        aStr.append("  lowRedundancyBucketCount: " + prd.getLowRedundancyBucketCount() + "\n");
        aStr.append("  configuredRedundantCopies: " + prd.getConfiguredRedundantCopies() + "\n");
        aStr.append("  actualRedundantCopies: " + prd.getActualRedundantCopies() + "\n");
        Set pmd = prd.getPartitionMemberInfo();
        for (PartitionMemberInfo memberDetails : pmd) {
            aStr.append(RebalanceUtil.partitionMemberDetailsToString(memberDetails));
        }
        String colocatedWith = prd.getColocatedWith();
        aStr.append("  colocatedWith: " + colocatedWith + "\n");
        return aStr.toString();
    }

    public static String partitionMemberDetailsToString(PartitionMemberInfo pmd) {
        StringBuffer aStr = new StringBuffer();
        long localMaxMemory = pmd.getConfiguredMaxMemory();
        long size = pmd.getSize();
        aStr.append("    Member Details for: " + pmd.getDistributedMember() + "\n");
        aStr.append("      configuredMaxMemory: " + localMaxMemory);
        double inUse = (double)size / (double)localMaxMemory;
        double heapUtilization = inUse * 100.0;
        aStr.append(" size: " + size + " (" + heapUtilization + "%)");
        aStr.append(" bucketCount: " + pmd.getBucketCount());
        aStr.append(" primaryCount: " + pmd.getPrimaryCount() + "\n");
        return aStr.toString();
    }

    public static String getRegionName(PartitionRegionInfo prd) {
        return prd.getRegionPath().substring(1);
    }

    public static String getRegionName(PartitionRebalanceInfo prd) {
        return prd.getRegionPath().substring(1);
    }

    public static void checkSimulateAgainstRebalance(RebalanceResults simulateResults, RebalanceResults rebalanceResults) {
        Log.getLogWriter().info("Checking simulate results against rebalance results...");
        StringBuffer aStr = new StringBuffer();
        if (simulateResults.getTotalBucketCreateBytes() != rebalanceResults.getTotalBucketCreateBytes()) {
            aStr.append("simulate totalBucketCreateBytes is " + simulateResults.getTotalBucketCreateBytes() + " but rebalance totalBucketCreateBytes is " + rebalanceResults.getTotalBucketCreateBytes() + "\n");
        }
        if (simulateResults.getTotalBucketCreatesCompleted() != rebalanceResults.getTotalBucketCreatesCompleted()) {
            aStr.append("simulate totalBucketCreatesCompleted is " + simulateResults.getTotalBucketCreatesCompleted() + " but rebalance totalBucketCreatesCompleted is " + rebalanceResults.getTotalBucketCreatesCompleted() + "\n");
        }
        if (simulateResults.getTotalBucketTransferBytes() != rebalanceResults.getTotalBucketTransferBytes()) {
            aStr.append("simulate totalBucketTransferBytes is " + simulateResults.getTotalBucketTransferBytes() + " but rebalance totalBucketTransferBytes is " + rebalanceResults.getTotalBucketTransferBytes() + "\n");
        }
        if (simulateResults.getTotalBucketTransfersCompleted() != rebalanceResults.getTotalBucketTransfersCompleted()) {
            aStr.append("simulate totalBucketTransfersCompleted is " + simulateResults.getTotalBucketTransfersCompleted() + " but rebalance totalBucketTransfersCompleted is " + rebalanceResults.getTotalBucketTransfersCompleted() + "\n");
        }
        if (simulateResults.getTotalPrimaryTransfersCompleted() != rebalanceResults.getTotalPrimaryTransfersCompleted()) {
            aStr.append("simulate totalPrimaryTransfersCompleted is " + simulateResults.getTotalPrimaryTransfersCompleted() + " but rebalance totalPrimaryTransfersCompleted is " + rebalanceResults.getTotalPrimaryTransfersCompleted() + "\n");
        }
        Set simSet = simulateResults.getPartitionRebalanceDetails();
        HashMap<String, PartitionRebalanceInfo> simMap = new HashMap<String, PartitionRebalanceInfo>();
        for (PartitionRebalanceInfo detail : simSet) {
            simMap.put(detail.getRegionPath(), detail);
        }
        Set rebSet = rebalanceResults.getPartitionRebalanceDetails();
        HashMap<String, PartitionRebalanceInfo> rebMap = new HashMap<String, PartitionRebalanceInfo>();
        for (PartitionRebalanceInfo detail : rebSet) {
            rebMap.put(detail.getRegionPath(), detail);
        }
        Set simKeys = simMap.keySet();
        Set rebKeys = rebMap.keySet();
        HashSet inRebButNotSim = new HashSet(rebKeys);
        inRebButNotSim.removeAll(simKeys);
        if (inRebButNotSim.size() > 0) {
            aStr.append("The regions " + inRebButNotSim + " were present in rebalance, but not in rebalance simulation\n");
        }
        for (String regionName : simMap.keySet()) {
            Object memDetail2;
            PartitionRebalanceInfo simRebalanceDetails = (PartitionRebalanceInfo)simMap.get(regionName);
            PartitionRebalanceInfo rebRebalanceDetails = (PartitionRebalanceInfo)rebMap.get(regionName);
            if (rebRebalanceDetails == null) {
                aStr.append("The region " + regionName + " was present in rebalance simulation, but is not in rebalance details\n");
                continue;
            }
            Set simMemDetailsSet = simRebalanceDetails.getPartitionMemberDetailsAfter();
            Set rebMemDetailsSet = rebRebalanceDetails.getPartitionMemberDetailsAfter();
            HashMap<String, Object> simMemMap = new HashMap<String, Object>();
            for (Object memDetail2 : simMemDetailsSet) {
                simMemMap.put(memDetail2.getDistributedMember().toString(), memDetail2);
            }
            HashMap<String, PartitionMemberInfo> rebMemMap = new HashMap<String, PartitionMemberInfo>();
            memDetail2 = rebMemDetailsSet.iterator();
            while (memDetail2.hasNext()) {
                PartitionMemberInfo memDetail3 = (PartitionMemberInfo)memDetail2.next();
                rebMemMap.put(memDetail3.getDistributedMember().toString(), memDetail3);
            }
            Set simMemKeys = simMemMap.keySet();
            Set rebMemKeys = rebMemMap.keySet();
            inRebButNotSim = new HashSet(rebMemKeys);
            inRebButNotSim.removeAll(simMemKeys);
            if (inRebButNotSim.size() > 0) {
                aStr.append("For " + regionName + " the members " + inRebButNotSim + " were present in rebalance, but not in rebalance simulation\n");
            }
            for (String memberStr : simMemMap.keySet()) {
                int rebPrimaryCount;
                int simPrimaryCount;
                int rebBucketCount;
                PartitionMemberInfo simDetails = (PartitionMemberInfo)simMemMap.get(memberStr);
                PartitionMemberInfo rebDetails = (PartitionMemberInfo)rebMemMap.get(memberStr);
                if (rebDetails == null) {
                    aStr.append("For " + regionName + " the member " + memberStr + " was present in rebalance simulation, but is not in rebalance details\n");
                    continue;
                }
                int simBucketCount = simDetails.getBucketCount();
                if (simBucketCount != (rebBucketCount = rebDetails.getBucketCount())) {
                    aStr.append("For " + regionName + " simulated bucket count for member " + memberStr + " is " + simBucketCount + ", but after rebalance the bucket count is " + rebBucketCount + "\n");
                }
                if ((simPrimaryCount = simDetails.getPrimaryCount()) == (rebPrimaryCount = rebDetails.getPrimaryCount())) continue;
                aStr.append("For " + regionName + " simulated primary count for member " + memberStr + " is " + simPrimaryCount + ", but after rebalance the primary count is " + rebPrimaryCount + "\n");
            }
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
        Log.getLogWriter().info("Done checking simulate results against rebalance results; results are the same");
    }

    public static void checkRebalancingActivity(RebalanceResults results) {
        boolean actionRequired = TestConfig.tasktab().booleanAt(RebalancePrms.actionRequired, TestConfig.tab().booleanAt(RebalancePrms.actionRequired, false));
        boolean actionTaken = false;
        if (results.getTotalBucketCreatesCompleted() > 0 || results.getTotalBucketTransfersCompleted() > 0 || results.getTotalPrimaryTransfersCompleted() > 0) {
            actionTaken = true;
        }
        if (!actionTaken) {
            String s = "Rebalancing did not result in any bucket creates, bucket transfers or primary transfers";
            if (actionRequired) {
                throw new TestException(s);
            }
            Log.getLogWriter().warning(s);
        }
    }

    public static void checkResultsWithRegion(Set<PartitionRebalanceInfo> detailSet) {
        StringBuffer errStr = new StringBuffer();
        for (PartitionRebalanceInfo prd : detailSet) {
            String regionName = prd.getRegionPath();
            Region aRegion = CacheHelper.getCache().getRegion(regionName);
            Map[] mapArr = BucketState.getBucketMaps(aRegion);
            Map primaryMap = mapArr[0];
            Map bucketMap = mapArr[1];
            Log.getLogWriter().info("Checking rebalance details with current state of region " + regionName + ", primaries: " + primaryMap + ", buckets: " + bucketMap);
            Set memberDetails = prd.getPartitionMemberDetailsAfter();
            StringBuffer aStr = new StringBuffer();
            for (PartitionMemberInfo memDetail : memberDetails) {
                int hookNumPrimaries;
                int hookNumBuckets;
                DistributedMember detailMember = memDetail.getDistributedMember();
                int detailBucketCount = memDetail.getBucketCount();
                int detailPrimaryCount = memDetail.getPrimaryCount();
                Integer vmIdForMember = null;
                try {
                    vmIdForMember = RemoteTestModule.Master.getVmid(detailMember.getHost(), detailMember.getProcessId());
                }
                catch (RemoteException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                Integer anInt = (Integer)bucketMap.get(vmIdForMember);
                if (anInt == null) {
                    anInt = new Integer(0);
                }
                if ((hookNumBuckets = anInt.intValue()) != detailBucketCount) {
                    aStr.append("For member " + detailMember + ", rebalance details has " + detailBucketCount + " buckets but testing hook shows " + hookNumBuckets + " buckets\n");
                }
                if ((anInt = (Integer)primaryMap.get(vmIdForMember)) == null) {
                    anInt = new Integer(0);
                }
                if ((hookNumPrimaries = anInt.intValue()) == detailPrimaryCount) continue;
                aStr.append("For member " + detailMember + ", rebalance details shows " + detailPrimaryCount + " primaries but testing hook shows " + hookNumPrimaries + " primaries\n");
            }
            if (aStr.length() <= 0) continue;
            aStr.append("primary state from hook: " + primaryMap + "\nbucket state from hook: " + bucketMap);
            errStr.append(aStr);
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    public static void HydraTask_verifyEviction() {
        double numEvictions = 0.0;
        Cache myCache = CacheHelper.getCache();
        Set regions = myCache.rootRegions();
        for (Region aRegion : regions) {
            EvictionAlgorithm ea = aRegion.getAttributes().getEvictionAttributes().getAlgorithm();
            if (ea.isLRUEntry()) {
                numEvictions = TestHelper.getNumLRUEvictions();
                continue;
            }
            if (ea.isLRUMemory()) {
                numEvictions = RebalanceUtil.getNumMemLRUEvictions();
                continue;
            }
            if (ea.isLRUHeap()) {
                numEvictions = TestHelper.getNumHeapLRUEvictions();
                continue;
            }
            throw new TestException("TestConfig issue: verifyEviction requires that the region have eviction enabled");
        }
        if (!(numEvictions > 0.0)) {
            throw new TestException("Tuning required: no evictions recorded");
        }
        Log.getLogWriter().info("Total evictions = " + numEvictions);
    }

    public static double getNumMemLRUEvictions() {
        String spec = "* MemLRUStatistics * lruEvictions filter=none combine=combineAcrossArchives ops=max";
        List aList = PerfStatMgr.getInstance().readStatistics(spec);
        if (aList == null) {
            Log.getLogWriter().info("Getting stats for spec " + spec + " returned null");
            return 0.0;
        }
        double totalEvictions = 0.0;
        for (int i = 0; i < aList.size(); ++i) {
            PerfStatValue stat = (PerfStatValue)aList.get(i);
            totalEvictions += stat.getMax();
        }
        return totalEvictions;
    }

    public static void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static void startAndConnectLocatorTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void stopLocatorTask() {
        DistributedSystemHelper.stopLocator();
    }
}

