/*
 * Decompiled with CFR 0.152.
 */
package rebalance;

import com.gemstone.gemfire.cache.partition.PartitionMemberInfo;
import com.gemstone.gemfire.cache.partition.PartitionRegionInfo;
import hydra.GsRandom;
import hydra.TestConfig;
import java.util.HashSet;
import java.util.Set;
import rebalance.MemberState;
import rebalance.RebalanceUtil;

public class PartitionState {
    GsRandom rand = TestConfig.tab().getRandGen();
    private boolean redundancySatisfied = true;
    private boolean localMaxMemoryHonored = true;
    private Set<MemberState> memberState;

    public PartitionState(PartitionRegionInfo prd) {
        this.redundancySatisfied = RebalanceUtil.isRedundancySatisfied(prd);
        Set pmDetails = prd.getPartitionMemberInfo();
        this.localMaxMemoryHonored = RebalanceUtil.isLocalMaxMemoryHonored(pmDetails);
        this.memberState = this.createMemberState(pmDetails);
    }

    public PartitionState(Set<PartitionMemberInfo> pmDetails) {
        this.localMaxMemoryHonored = RebalanceUtil.isLocalMaxMemoryHonored(pmDetails);
        this.memberState = this.createMemberState(pmDetails);
    }

    public Set<MemberState> createMemberState(Set<PartitionMemberInfo> pmd) {
        HashSet<MemberState> memberState = new HashSet<MemberState>();
        double averageHeapUtilization = RebalanceUtil.getAverageHeapUtilization(pmd);
        double averageBucketCount = RebalanceUtil.getAverageBucketCount(pmd);
        double averagePrimaryCount = RebalanceUtil.getAveragePrimaryCount(pmd);
        for (PartitionMemberInfo memberDetails : pmd) {
            long localMaxMemory = memberDetails.getConfiguredMaxMemory();
            long size = memberDetails.getSize();
            double heapUtilization = (double)size / (double)localMaxMemory;
            double heapUtilizationDev = Math.abs(heapUtilization * 100.0 - averageHeapUtilization);
            double bucketCountDev = Math.abs((double)memberDetails.getBucketCount() - averageBucketCount);
            double primaryCountDev = Math.abs((double)memberDetails.getPrimaryCount() - averagePrimaryCount);
            memberState.add(new MemberState(memberDetails.getDistributedMember(), heapUtilizationDev, bucketCountDev, primaryCountDev));
        }
        return memberState;
    }

    public PartitionState(boolean redundancySatisfied, boolean localMaxMemoryHonored, Set<MemberState> memberState) {
        this.redundancySatisfied = redundancySatisfied;
        this.localMaxMemoryHonored = localMaxMemoryHonored;
        this.memberState = memberState;
    }

    public boolean isRedundancySatisfied() {
        return this.redundancySatisfied;
    }

    public boolean isLocalMaxMemoryHonored() {
        return this.localMaxMemoryHonored;
    }

    public Set<MemberState> getMemberState() {
        return this.memberState;
    }

    public String toString() {
        StringBuffer aStr = new StringBuffer();
        aStr.append("   redundancySatisfied: " + this.redundancySatisfied + "\n");
        aStr.append("   localMaxMemoryHonored: " + this.localMaxMemoryHonored + "\n");
        for (MemberState ms : this.memberState) {
            aStr.append(ms.toString());
        }
        return aStr.toString();
    }
}

