/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.AvailablePort;
import java.io.IOException;
import java.util.Properties;
import junit.framework.TestCase;
import quickstart.GoldenComparator;
import quickstart.ProcessWrapper;
import quickstart.RegexGoldenComparator;

public abstract class QuickstartTestCase
extends TestCase {
    private final int mcastPort = AvailablePort.getRandomAvailablePort((int)1);

    public QuickstartTestCase(String name) {
        super(name);
        if (ProcessWrapper.ENABLE_TRACING) {
            QuickstartTestCase.getLogWriter().info("quickstart.test.ENABLE_TRACING is " + ProcessWrapper.ENABLE_TRACING);
        }
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    protected GoldenComparator createGoldenComparator() {
        return new RegexGoldenComparator(this.expectedProblemLines());
    }

    protected String[] expectedProblemLines() {
        return null;
    }

    protected void assertOutputMatchesGoldenFile(String actualOutput, String goldenFileName) throws IOException {
        GoldenComparator comparator = this.createGoldenComparator();
        comparator.assertOutputMatchesGoldenFile(actualOutput, goldenFileName);
    }

    protected final void assertOutputMatchesGoldenFile(ProcessWrapper process, String goldenFileName) throws IOException {
        GoldenComparator comparator = this.createGoldenComparator();
        comparator.assertOutputMatchesGoldenFile(process.getOutput(), goldenFileName);
    }

    protected static LogWriter getLogWriter() {
        return ProcessWrapper.getLogWriter();
    }

    protected static void trace(String message) {
        ProcessWrapper.trace((String)message);
    }

    protected Properties createProperties() {
        Properties properties = new Properties();
        properties.setProperty("gemfire.mcast-port", String.valueOf(this.mcastPort));
        properties.setProperty("gemfire.log-level", "warning");
        properties.setProperty("file.encoding", "UTF-8");
        return properties;
    }

    protected final int getMcastPort() {
        return this.mcastPort;
    }

    protected final void sleep(long millis) throws InterruptedException {
        Thread.sleep(millis);
    }

    protected final void printProcessOutput(ProcessWrapper process) {
        this.innerPrintOutput(process.getOutput(), "OUTPUT");
    }

    protected final void printProcessOutput(ProcessWrapper process, String banner) {
        this.innerPrintOutput(process.getOutput(), banner);
    }

    protected final void innerPrintOutput(String output, String title) {
        System.out.println("------------------ BEGIN " + title + " ------------------");
        System.out.println(output);
        System.out.println("------------------- END " + title + " -------------------");
    }
}

