/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import quickstart.ProcessWrapper;
import quickstart.PushConsumer;
import quickstart.PushProducer;
import quickstart.QuickstartTestCase;

public class PushTest
extends QuickstartTestCase {
    protected ProcessWrapper consumer;
    protected ProcessWrapper producer;

    public PushTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.consumer != null) {
            this.consumer.destroy();
        }
        if (this.producer != null) {
            this.producer.destroy();
        }
    }

    public void testPush() throws Exception {
        PushTest.getLogWriter().info("[testPush] start up PushConsumer");
        this.consumer = new ProcessWrapper(PushConsumer.class);
        this.consumer.execute(this.createProperties());
        this.consumer.waitForOutputToMatch("Please start the PushProducer\\.");
        PushTest.getLogWriter().info("[testPush] start up PushProducer");
        this.producer = new ProcessWrapper(PushProducer.class);
        this.producer.execute(this.createProperties());
        this.producer.waitForOutputToMatch("Please press Enter in the PushConsumer\\.");
        this.consumer.sendInput();
        PushTest.getLogWriter().info("[testPush] joining to PushConsumer");
        this.consumer.waitFor();
        this.printProcessOutput(this.consumer, "CONSUMER");
        PushTest.getLogWriter().info("[testPush] joining to PushProducer");
        this.producer.waitFor();
        this.printProcessOutput(this.producer, "PRODUCER");
        this.assertOutputMatchesGoldenFile(this.producer.getOutput(), "PushProducer.txt");
        this.assertOutputMatchesGoldenFile(this.consumer.getOutput(), "PushConsumer.txt");
    }
}

