/*
 * Decompiled with CFR 0.152.
 */
package query.remote;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.HydraVector;
import hydra.Log;
import hydra.RegionHelper;
import hydra.TestConfig;
import mapregion.MapBB;
import objects.PSTObject;
import objects.Portfolio;
import query.QueryPrms;
import query.remote.DefaultQueryResultsValidator;
import query.remote.QueryResultsValidator;
import util.TestException;
import util.TestHelper;

public class RemoteQueryTest {
    protected static String bridgeRegionName;
    protected static String edgeRegionName;
    protected static final int MAX_PUT = 50;
    protected static final int MAX_PUT_CACHE_SCALABILITY = 10000;
    protected static final int NUM_OF_PUTS = 100;
    protected static final int MAX_PUT_EVICTION_OVERFLOW = 3000;
    private static volatile Query[] queries;
    private static volatile long putKeyInt;
    private static volatile long destroyKeyInt;
    private static volatile QueryResultsValidator rv;

    public static void initServerRegion() {
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        String regionName = RegionHelper.getRegionDescription(ConfigPrms.getRegionConfig()).getRegionName();
        AttributesFactory attr = RegionHelper.getAttributesFactory(ConfigPrms.getRegionConfig());
        attr.setDataPolicy(DataPolicy.PRELOADED);
        Region reg = RegionHelper.createRegion(regionName, attr);
        bridgeRegionName = reg.getName();
        Log.getLogWriter().info("created cache and region in bridge");
        BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
        Log.getLogWriter().info("started bridge server");
    }

    public static void initServerRegion_WithReplicate() {
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        String regionName = RegionHelper.getRegionDescription(ConfigPrms.getRegionConfig()).getRegionName();
        AttributesFactory attr = RegionHelper.getAttributesFactory(ConfigPrms.getRegionConfig());
        attr.setDataPolicy(DataPolicy.REPLICATE);
        Region reg = RegionHelper.createRegion(regionName, attr);
        bridgeRegionName = reg.getName();
        Log.getLogWriter().info("created cache and region in bridge");
        BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
        Log.getLogWriter().info("started bridge server");
    }

    public static void initClientRegion() {
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        Region reg = RegionHelper.createRegion(ConfigPrms.getRegionConfig());
        reg.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        edgeRegionName = reg.getName();
        Log.getLogWriter().info("created cache and region in edge");
    }

    public static void initClientRegionWithoutInterest() {
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        Region reg = RegionHelper.createRegion(ConfigPrms.getRegionConfig());
        edgeRegionName = reg.getName();
        Log.getLogWriter().info("created cache and region in edge");
    }

    public static void updateRegionEntries() {
        try {
            Region reg = RegionHelper.getRegion(edgeRegionName);
            putKeyInt = MapBB.getBB().getSharedCounters().read(MapBB.NUM_PUT);
            int i = 0;
            String key = null;
            Portfolio val = null;
            do {
                key = "key" + putKeyInt;
                val = new Portfolio((int)putKeyInt);
                Log.getLogWriter().info("Putting key  : " + key + "    value : " + val);
                reg.put((Object)key, (Object)val);
                putKeyInt = MapBB.incrementCounter("MapBB.NUM_PUT", MapBB.NUM_PUT);
            } while (++i < 50);
            Log.getLogWriter().info("added entries in edge" + reg.size());
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void updateRegionEntries_CacheScalability() {
        try {
            Region reg = RegionHelper.getRegion(edgeRegionName);
            putKeyInt = MapBB.getBB().getSharedCounters().read(MapBB.NUM_PUT);
            int i = 0;
            String key = null;
            Portfolio val = null;
            do {
                key = "key" + putKeyInt;
                val = new Portfolio((int)putKeyInt);
                Log.getLogWriter().info("Putting key  : " + key + "    value : " + val);
                reg.put((Object)key, (Object)val);
                putKeyInt = MapBB.incrementCounter("MapBB.NUM_PUT", MapBB.NUM_PUT);
            } while (++i < 10000);
            Log.getLogWriter().info("added entries in edge" + reg.size());
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void updateRegionEntries_10KPayload() {
        try {
            Region reg = RegionHelper.getRegion(edgeRegionName);
            putKeyInt = MapBB.getBB().getSharedCounters().read(MapBB.NUM_PUT);
            PSTObject payLoad = new PSTObject();
            payLoad.init(Integer.valueOf(String.valueOf(putKeyInt)));
            int i = 0;
            String key = null;
            Object val = null;
            do {
                key = "key" + putKeyInt;
                reg.put((Object)key, (Object)payLoad);
                putKeyInt = MapBB.incrementCounter("MapBB.NUM_PUT", MapBB.NUM_PUT);
            } while (++i < 50);
            Log.getLogWriter().info("added entries in edge" + reg.size());
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void updateRegionEntries_EvictionAndOverflow() {
        try {
            Region reg = RegionHelper.getRegion(edgeRegionName);
            putKeyInt = MapBB.getBB().getSharedCounters().read(MapBB.NUM_PUT);
            byte[] payLoad = new byte[10240];
            int i = 0;
            String key = null;
            Object val = null;
            do {
                key = "key" + putKeyInt;
                reg.put((Object)key, (Object)payLoad);
                putKeyInt = MapBB.incrementCounter("MapBB.NUM_PUT", MapBB.NUM_PUT);
            } while (++i < 3000);
            Log.getLogWriter().info("added entries in edge" + reg.size());
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void putRegionEntries() {
        try {
            Region reg = RegionHelper.getRegion(edgeRegionName);
            String key = null;
            Portfolio val = null;
            for (int i = 0; i < 100; ++i) {
                key = "key" + i;
                val = i < 10 ? new Portfolio(10) : (i < 30 ? new Portfolio(20) : (i < 60 ? new Portfolio(30) : new Portfolio(40)));
                reg.put((Object)key, (Object)val);
            }
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void initQuery() {
        HydraVector hv = TestConfig.tab().vecAt(QueryPrms.queryStrings, null);
        if (hv == null) {
            throw new TestException("No Queries specified ");
        }
        Object[] queryStrings = new String[hv.size()];
        hv.copyInto(queryStrings);
        queries = new Query[queryStrings.length];
        String poolName = RegionHelper.getRegion(edgeRegionName).getAttributes().getPoolName();
        Pool pool = PoolManager.find((String)poolName);
        QueryService qs = null;
        qs = pool.getQueryService();
        Log.getLogWriter().info("Created QuerySevice using Pool.");
        for (int i = 0; i < queryStrings.length; ++i) {
            RemoteQueryTest.queries[i] = qs.newQuery((String)queryStrings[i]);
        }
        String validatorClass = TestConfig.tab().stringAt(QueryPrms.resultsValidator, null);
        try {
            rv = validatorClass != null ? (QueryResultsValidator)Class.forName(validatorClass).newInstance() : new DefaultQueryResultsValidator(queries.length);
        }
        catch (Exception e) {
            throw new TestException("Caught exception during query initialization" + TestHelper.getStackTrace(e));
        }
    }

    public static void performQuery() {
        boolean executeQueryWithParams = false;
        HydraVector hv = TestConfig.tab().vecAt(QueryPrms.queryParametersLength, null);
        Object[][] allQueryParams = null;
        if (hv != null && hv.size() > 0) {
            executeQueryWithParams = true;
            Object[] queryParametersLength = new Object[hv.size()];
            hv.copyInto(queryParametersLength);
            HydraVector hv1 = TestConfig.tab().vecAt(QueryPrms.queryParameters, null);
            Object[] queryParameters = new Object[hv1.size()];
            hv1.copyInto(queryParameters);
            allQueryParams = new Object[queryParametersLength.length][];
            int paramIndex = 0;
            for (int i = 0; i < queryParametersLength.length; ++i) {
                int queryParamLength = Integer.valueOf((String)queryParametersLength[i]);
                Object[] queryParams = new Object[queryParamLength];
                if (queryParamLength > 0) {
                    for (int j = 0; j < queryParamLength; ++j) {
                        String p;
                        queryParams[j] = (p = (String)queryParameters[paramIndex++]).length() > 3 ? p : new Integer(p);
                    }
                }
                allQueryParams[i] = queryParams;
            }
        }
        boolean ok = false;
        try {
            Region reg = RegionHelper.getRegion(edgeRegionName);
            int whichQuery = TestConfig.tab().getRandGen().nextInt(0, queries.length - 1);
            if (whichQuery >= queries.length) {
                Log.getLogWriter().warning("Which Query  :  " + whichQuery + " does not exist as maximum valid which Query index is " + (queries.length - 1));
                return;
            }
            Log.getLogWriter().info("Which Query  :  " + whichQuery + " Query :" + queries[whichQuery].getQueryString() + (executeQueryWithParams ? " params :" + allQueryParams[whichQuery].length : ""));
            Object results = null;
            if (executeQueryWithParams && allQueryParams[whichQuery].length > 0) {
                String params = "";
                for (int i = 0; i < allQueryParams[whichQuery].length; ++i) {
                    params = params + allQueryParams[whichQuery][i] + ",";
                }
                Log.getLogWriter().info("Using params :" + params);
                results = queries[whichQuery].execute(allQueryParams[whichQuery]);
            } else {
                results = queries[whichQuery].execute();
            }
            ok = rv.validateQueryResults((SelectResults)results, whichQuery, queries[whichQuery].getQueryString());
        }
        catch (Exception e) {
            throw new TestException("Caught exception during query execution" + TestHelper.getStackTrace(e));
        }
        String poolName = RegionHelper.getRegion(edgeRegionName).getAttributes().getPoolName();
        Pool pool = PoolManager.find((String)poolName);
        pool.releaseThreadLocalConnection();
        if (!ok) {
            throw new TestException("The validation was not successful");
        }
    }

    public static void performDestroyOperation() {
        Region reg = RegionHelper.getRegion(edgeRegionName);
        destroyKeyInt = MapBB.getBB().getSharedCounters().read(MapBB.NUM_DESTROY);
        String key = "key" + destroyKeyInt;
        try {
            reg.destroy((Object)key);
        }
        catch (EntryNotFoundException entryNotFoundException) {
        }
        catch (Exception ex) {
            throw new TestException("Destroy operation not successful " + ex.getStackTrace());
        }
        Log.getLogWriter().info("Destroying the key : " + key);
        MapBB.add("MapBB.NUM_DESTROY", MapBB.NUM_DESTROY, 2);
    }

    public static void verifyCompiledQueries() {
        Log.getLogWriter().info("Verifying compiled queryies.");
        long compiledQueryCount = 0L;
        for (int i = 0; i < 10 && (compiledQueryCount = CacheClientNotifier.getInstance().getStats().getCompiledQueryCount()) > 0L; ++i) {
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (compiledQueryCount > 0L) {
            throw new TestException("Compiled Queries are not completely cleared. Number of compiled queries present are: " + compiledQueryCount);
        }
    }

    static {
        queries = null;
        rv = null;
    }
}

