/*
 * Decompiled with CFR 0.152.
 */
package query.remote;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import hydra.Log;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import query.remote.QueryExecutorThread;

public class RemoteQueryListener
extends CacheListenerAdapter {
    private static final int MAX_THREADS = 16;
    private volatile boolean isClosed = false;
    private ThreadPoolExecutor queryExecutorPool = null;

    public RemoteQueryListener() {
        final ThreadGroup queryThreadGroup = new ThreadGroup("Query Executor Thread Group");
        ThreadFactory queryThreadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable command) {
                return new Thread(queryThreadGroup, command, queryThreadGroup.getName() + " Query Executor Thread ");
            }
        };
        this.queryExecutorPool = new ThreadPoolExecutor(16, 16, 15L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), queryThreadFactory);
    }

    public void afterDestroy(EntryEvent event) {
        if (!this.isClosed) {
            QueryExecutorThread queryExecutor = new QueryExecutorThread(event);
            this.queryExecutorPool.execute(queryExecutor);
        } else {
            this.queryExecutorPool.shutdownNow();
        }
    }

    public void close() {
        Log.getLogWriter().info("RemoteQueryListener Closing ...");
        this.isClosed = true;
    }
}

