/*
 * Decompiled with CFR 0.152.
 */
package query.remote;

import com.gemstone.gemfire.cache.query.SelectResults;
import hydra.HydraVector;
import hydra.Log;
import hydra.TestConfig;
import query.QueryPrms;
import query.remote.QueryResultsValidator;
import util.TestException;

public class DefaultQueryResultsValidator
implements QueryResultsValidator {
    private int[] expectedResultSet = null;
    private String[] expectedResultType = null;

    public DefaultQueryResultsValidator(int numOfQueries) {
        HydraVector hvSize = TestConfig.tab().vecAt(QueryPrms.expectedResultsSize);
        HydraVector hvType = TestConfig.tab().vecAt(QueryPrms.expectedResultsType);
        Object[] queryResult = new String[hvSize.size()];
        this.expectedResultType = new String[hvType.size()];
        hvSize.copyInto(queryResult);
        hvType.copyInto(this.expectedResultType);
        this.expectedResultSet = new int[queryResult.length];
        if (this.expectedResultType.length != 1 && this.expectedResultSet.length != this.expectedResultType.length) {
            throw new TestException("Size of expectedResultSet and expectedResultType are not same");
        }
        if (this.expectedResultSet.length != numOfQueries) {
            throw new TestException("Size of expectedResultSet is not same as numOfQueries");
        }
        for (int i = 0; i < queryResult.length; ++i) {
            this.expectedResultSet[i] = Integer.parseInt((String)queryResult[i]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validateQueryResults(Object results, int queryIndex, String queryString) {
        boolean validate = false;
        Log.getLogWriter().info("Executed query : " + queryString);
        if (this.expectedResultType.length != 1 || !this.expectedResultType[0].equalsIgnoreCase("SelectResults")) {
            if (!this.expectedResultType[queryIndex].equalsIgnoreCase("SelectResults")) throw new TestException("Test Configuration Issue in setting expected result type and result sizes in the conf");
        }
        if (!(results instanceof SelectResults)) throw new TestException("Query Results not instance of SelectResults");
        if (((SelectResults)results).size() != this.expectedResultSet[queryIndex]) throw new TestException("Size of the results " + ((SelectResults)results).size() + " is not same as the expected size " + this.expectedResultSet[queryIndex]);
        return true;
    }
}

